/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.component;

import com.tangosol.dev.assembler.ClassFile;
import com.tangosol.dev.assembler.CodeAttribute;
import com.tangosol.dev.assembler.Field;
import com.tangosol.dev.assembler.Method;
import com.tangosol.dev.compiler.java.ScriptParser;
import com.tangosol.dev.component.Behavior;
import com.tangosol.dev.component.CompilePlan;
import com.tangosol.dev.component.ComponentException;
import com.tangosol.dev.component.Constants;
import com.tangosol.dev.component.DataType;
import com.tangosol.dev.component.DerivationException;
import com.tangosol.dev.component.Integration;
import com.tangosol.dev.component.Interface;
import com.tangosol.dev.component.Loader;
import com.tangosol.dev.component.NullStorage;
import com.tangosol.dev.component.Property;
import com.tangosol.dev.component.Trait;
import com.tangosol.java.type.ArrayType;
import com.tangosol.java.type.ClassType;
import com.tangosol.java.type.Type;
import com.tangosol.run.xml.SimpleDocument;
import com.tangosol.run.xml.XmlDocument;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.run.xml.XmlSerializable;
import com.tangosol.util.CacheCollator;
import com.tangosol.util.ChainedEnumerator;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ErrorList;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.SimpleEnumerator;
import com.tangosol.util.StringTable;
import com.tangosol.util.UID;
import java.beans.PropertyVetoException;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.Collator;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public class Component
extends Trait
implements Constants,
Cloneable,
XmlSerializable {
    public static final String ATTR_NAME = "Name";
    public static final String ATTR_VISIBLE = "Visible";
    public static final String ATTR_STATIC = "Static";
    public static final String ATTR_ABSTRACT = "Abstract";
    public static final String ATTR_FINAL = "Final";
    public static final String ATTR_DEPRECATED = "Deprecated";
    public static final String ATTR_PERSISTENT = "Persistent";
    public static final String ATTR_REMOTE = "Remote";
    public static final String ATTR_INTEGRATION = "Integration";
    public static final String ATTR_IMPLEMENTS = "Implements";
    public static final String ATTR_DISPATCHES = "Dispatches";
    public static final String ATTR_PROPERTY = "Property";
    public static final String ATTR_BEHAVIOR = "Behavior";
    public static final String ATTR_CATEGORY = "Category";
    public static final String ATTR_CHILD = "Child";
    private static final String CLASS = "Component";
    protected static final String DESCRIPTOR_COMPONENT = "Component";
    protected static final String DESCRIPTOR_COMPLEX = "Complex";
    protected static final String DESCRIPTOR_SIGNATURE = "Signature";
    protected static final int COMPONENT = 0;
    protected static final int COMPLEX = 1;
    protected static final int SIGNATURE = 2;
    private String[] DESCRIPTORS = new String[]{"Component", "Complex", "Signature"};
    private static final int CLASSGEN_FLAGS = 1714736;
    private static final int DEFAULTS = 524336;
    private static final Object BASE_EXISTS = new Object();
    private static final Object BASE_HIDDEN = new Object();
    private static final Object BASE_RESERVED = new Object();
    private static final Object THIS_INSERT = new Object();
    private static final Object THIS_UPDATE = new Object();
    private transient int m_nVersion = 0x4020000;
    private int m_nType;
    private transient boolean m_fReadOnly;
    private String m_sSuper = "";
    private String m_sName;
    private boolean m_fBaseLevel;
    private Integration m_integration;
    private StringTable m_tblImplements;
    private StringTable m_tblDispatches;
    private int m_nFlags;
    private int m_nPrevFlags;
    private StringTable m_tblState;
    private StringTable m_tblBehavior;
    private StringTable m_tblCategories;
    private StringTable m_tblChildren;

    protected Component(Trait parent, int nType, String sName) {
        super(parent, 1);
        boolean fReadOnly = false;
        switch (nType) {
            case 0: {
                if (sName == null || sName.length() == 0) {
                    throw new IllegalArgumentException("Component:  Name required for Components!");
                }
                if (Component.isSimpleNameLegal(sName, true)) break;
                throw new IllegalArgumentException("Component:  Illegal component name (" + sName + ")");
            }
            case 1: {
                if (sName != null && sName.length() != 0) break;
                throw new IllegalArgumentException("Component:  Name required for Complex Components!");
            }
            case 2: {
                if (sName == "") break;
                if (sName == null || sName.length() == 0) {
                    throw new IllegalArgumentException("Component:  Name required for Signatures!");
                }
                if (ClassHelper.isQualifiedNameLegal(sName)) break;
                throw new IllegalArgumentException("Component:  Illegal signature name (" + sName + ")");
            }
            default: {
                throw new IllegalArgumentException("Component:  Invalid component Type (" + nType + ")");
            }
        }
        this.m_nType = nType;
        this.m_fReadOnly = fReadOnly;
        this.m_sName = sName;
        this.createTables();
    }

    public Component createDerivedComponent(String sName, Loader loader) {
        Component cdSuper = this;
        if (cdSuper.getParent() != null) {
            throw new IllegalArgumentException("Component.createDerivedComponent:  Super Component cannot be a child!");
        }
        if (sName == null || sName.length() == 0) {
            throw new IllegalArgumentException("Component.createDerivedComponent:  Component Definition name required!");
        }
        if (cdSuper.isComponent() && !Component.isSimpleNameLegal(sName, true) || cdSuper.isSignature() && !ClassHelper.isQualifiedNameLegal(sName)) {
            throw new IllegalArgumentException("Component.createDerivedComponent:  Illegal Component Definition name! (" + sName + ")");
        }
        Component cdDelta = (Component)cdSuper.getNullDerivedTrait(null, 2);
        cdDelta.m_sSuper = this.getQualifiedName();
        cdDelta.m_sName = sName;
        try {
            ErrorList errlist = new ErrorList();
            Component cdSub = cdSuper.resolve(cdDelta, loader, errlist);
            cdSub.finalizeResolve(loader, errlist);
            if (errlist.isSevere()) {
                errlist.print();
                throw new ComponentException("Component.createDerivedComponent:  Serious errors occurred during resolution!");
            }
            cdSub.validate();
            return cdSub;
        }
        catch (ComponentException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public Component createComplexProperty() {
        Component cdBase = this;
        if (!cdBase.isComponent()) {
            throw new IllegalArgumentException("Component.createComplexProperty:  Can only use Components!");
        }
        if (cdBase.getParent() != null) {
            throw new IllegalArgumentException("Component.createComplexProperty:  Component cannot be a child!");
        }
        Component cdDelta = (Component)cdBase.getNullDerivedTrait(null, 3);
        cdDelta.m_nType = 1;
        cdDelta.assignUID();
        try {
            NullStorage loader = new NullStorage();
            ErrorList errlist = new ErrorList();
            Component cdComplex = (Component)cdBase.resolve(cdDelta, null, loader, errlist);
            cdComplex.finalizeResolve(loader, errlist);
            if (errlist.isSevere()) {
                errlist.print();
                throw new ComponentException("Component.createComplexProperty:  Serious errors occurred during resolution!");
            }
            cdComplex.validate();
            return cdComplex;
        }
        catch (ComponentException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public Component(ClassFile clz) throws ComponentException {
        this(clz, null);
    }

    public Component(ClassFile clz, String sScript) throws ComponentException {
        this(null, 2, clz.getName().replace('/', '.'));
        String sSuper;
        int nFlags = 655362;
        switch (clz.getAccess()) {
            case 1: {
                nFlags |= 0x30;
                break;
            }
            case 4: {
                nFlags |= 0x4000020;
                break;
            }
            case 0: {
                nFlags |= 0x4000010;
                break;
            }
            case 2: {
                nFlags |= 0x4000000;
            }
        }
        nFlags |= clz.isStatic() ? 512 : 0;
        nFlags |= clz.isFinal() ? 8192 : 0;
        nFlags |= clz.isAbstract() ? 2048 : 0;
        nFlags |= clz.isDeprecated() ? 32768 : 0;
        if (this.m_sName.equals("java.lang.Throwable")) {
            nFlags |= Integer.MIN_VALUE;
        }
        sSuper = (sSuper = clz.getSuper()) == null || sSuper.length() == 0 ? "" : sSuper.replace('/', '.');
        if (clz.isInterface()) {
            nFlags |= 0x40000000;
            if (!sSuper.equals("java.lang.Object")) {
                throw new IllegalArgumentException("Component:  Illegal interface class file (" + this.m_sName + ") does not have a super java.lang.Object");
            }
            sSuper = "";
        }
        this.m_sSuper = sSuper;
        Enumeration enmr = clz.getImplements();
        while (enmr.hasMoreElements()) {
            String sIface = ((String)enmr.nextElement()).replace('/', '.');
            Interface iface = new Interface(this, sIface);
            this.m_tblImplements.put(sIface, iface);
        }
        StringTable tblFields = this.m_tblState;
        Enumeration enmr2 = clz.getFields();
        while (enmr2.hasMoreElements()) {
            Field field = (Field)enmr2.nextElement();
            if (field.isSynthetic() || !field.isPublic() && !field.isProtected()) continue;
            Property prop = new Property(this, field);
            prop.setExists(2);
            tblFields.put(prop.getUniqueName(), prop);
        }
        HashMap mapParam = new HashMap();
        if (sScript != null && sScript.length() > 0) {
            ScriptParser parser = new ScriptParser();
            try {
                parser.parse(sScript, mapParam);
            }
            catch (Exception prop) {
                // empty catch block
            }
        }
        StringTable tblMethods = this.m_tblBehavior;
        Enumeration enmr3 = clz.getMethods();
        while (enmr3.hasMoreElements()) {
            Method method = (Method)enmr3.nextElement();
            if (!method.isPublic() && (this.isInterface() || !method.isProtected())) continue;
            Behavior beh = new Behavior(this, method, mapParam);
            String sSig = beh.getUniqueName();
            beh.setExists(2);
            Behavior behPrev = (Behavior)tblMethods.get(sSig);
            if (behPrev != null && (!behPrev.isSynthetic() || beh.isSynthetic())) continue;
            tblMethods.put(sSig, beh);
        }
        this.m_nFlags = nFlags;
        if (this.m_sSuper != "" || clz.isInterface()) {
            this.setMode(2);
        }
    }

    protected Component(Component base, Trait parent, int nMode) {
        super((Trait)base, parent, nMode);
        this.m_nType = base.m_nType;
        this.m_sName = base.m_sName;
        this.m_sSuper = base.m_sSuper;
        this.createTables();
    }

    protected Component(Trait parent, Component that) {
        super(parent, that);
        Interface iface;
        Enumeration enmr;
        StringTable tblThis;
        this.m_nType = that.m_nType;
        this.m_fReadOnly = that.m_fReadOnly;
        this.m_sName = that.m_sName;
        this.m_sSuper = that.m_sSuper;
        this.m_nFlags = that.m_nFlags;
        this.m_nPrevFlags = that.m_nPrevFlags;
        this.m_fBaseLevel = that.m_fBaseLevel;
        if (that.m_integration != null) {
            this.m_integration = new Integration(this, that.m_integration);
        }
        this.createTables();
        StringTable tblThat = that.m_tblImplements;
        if (!tblThat.isEmpty()) {
            tblThis = this.m_tblImplements;
            enmr = tblThat.elements();
            while (enmr.hasMoreElements()) {
                iface = (Interface)enmr.nextElement();
                tblThis.put(iface.getUniqueName(), new Interface(this, iface));
            }
        }
        if (!(tblThat = that.m_tblDispatches).isEmpty()) {
            tblThis = this.m_tblDispatches;
            enmr = tblThat.elements();
            while (enmr.hasMoreElements()) {
                iface = (Interface)enmr.nextElement();
                tblThis.put(iface.getUniqueName(), new Interface(this, iface));
            }
        }
        if (!(tblThat = that.m_tblState).isEmpty()) {
            tblThis = this.m_tblState;
            enmr = tblThat.elements();
            while (enmr.hasMoreElements()) {
                Property prop = (Property)enmr.nextElement();
                tblThis.put(prop.getUniqueName(), new Property(this, prop));
            }
        }
        if (!(tblThat = that.m_tblBehavior).isEmpty()) {
            tblThis = this.m_tblBehavior;
            enmr = tblThat.elements();
            while (enmr.hasMoreElements()) {
                Behavior behavior = (Behavior)enmr.nextElement();
                tblThis.put(behavior.getUniqueName(), new Behavior(this, behavior));
            }
        }
        if (!(tblThat = that.m_tblCategories).isEmpty()) {
            this.m_tblCategories = (StringTable)tblThat.clone();
        }
        if (!(tblThat = that.m_tblChildren).isEmpty()) {
            tblThis = this.m_tblChildren;
            enmr = tblThat.elements();
            while (enmr.hasMoreElements()) {
                Component cd = (Component)enmr.nextElement();
                tblThis.put(cd.getUniqueName(), new Component((Trait)this, cd));
            }
        }
    }

    public Component(DataInput stream) throws IOException {
        this(null, stream, Component.getVersion(stream));
        this.validate();
    }

    protected Component(Trait traitParent, DataInput stream, int nVersion) throws IOException {
        super(traitParent, stream, nVersion);
        Interface iface;
        int i;
        this.m_nVersion = nVersion;
        this.m_nType = stream.readUnsignedByte();
        this.m_sName = Component.readString(stream);
        this.m_sSuper = Component.readString(stream);
        this.m_nFlags = stream.readInt();
        this.m_nPrevFlags = stream.readInt();
        this.m_fBaseLevel = stream.readBoolean();
        this.createTables();
        if (stream.readBoolean()) {
            this.m_integration = new Integration(this, stream, nVersion);
        }
        StringTable tbl = this.m_tblImplements;
        int cItems = stream.readInt();
        for (i = 0; i < cItems; ++i) {
            iface = new Interface(this, stream, nVersion);
            tbl.put(iface.getUniqueName(), iface);
        }
        tbl = this.m_tblDispatches;
        cItems = stream.readInt();
        for (i = 0; i < cItems; ++i) {
            iface = new Interface(this, stream, nVersion);
            tbl.put(iface.getUniqueName(), iface);
        }
        tbl = this.m_tblState;
        cItems = stream.readInt();
        for (i = 0; i < cItems; ++i) {
            Property prop = new Property(this, stream, nVersion);
            tbl.put(prop.getUniqueName(), prop);
        }
        tbl = this.m_tblBehavior;
        cItems = stream.readInt();
        for (i = 0; i < cItems; ++i) {
            Behavior behavior = new Behavior(this, stream, nVersion);
            tbl.put(behavior.getUniqueName(), behavior);
        }
        tbl = this.m_tblCategories;
        cItems = stream.readInt();
        for (i = 0; i < cItems; ++i) {
            tbl.put(stream.readUTF(), Component.toBoolean(stream.readBoolean()));
        }
        tbl = this.m_tblChildren;
        cItems = stream.readInt();
        for (i = 0; i < cItems; ++i) {
            Component cd = new Component((Trait)this, stream, nVersion);
            tbl.put(cd.getUniqueName(), cd);
        }
    }

    public Component(XmlDocument xml) throws IOException {
        this(null, xml, Component.getVersion(xml));
        this.validate();
    }

    protected Component(Trait parent, XmlElement xml, int nVersion) throws IOException {
        super(parent, xml, nVersion);
        XmlElement xmlChildren;
        XmlElement xmlCategories;
        XmlElement xmlBehaviors;
        XmlElement xmlProps;
        XmlElement xmlDispatches;
        XmlElement xmlImplements;
        this.m_nVersion = nVersion;
        String sName = Component.readString(xml.getElement("name"));
        String sType = Component.readString(xml.getElement("type"));
        if (sName == "" || sType == "") {
            throw new IOException("name or type is missing");
        }
        this.m_sName = sName;
        this.m_nType = -1;
        int c = this.DESCRIPTORS.length;
        for (int i = 0; i < c; ++i) {
            if (!this.DESCRIPTORS[i].equalsIgnoreCase(sType)) continue;
            this.m_nType = i;
            break;
        }
        if (this.m_nType < 0) {
            throw new IOException("illegal type: " + sType);
        }
        this.m_sSuper = Component.readString(xml.getElement("super"));
        this.m_nFlags = Component.readFlags(xml, "flags", 0);
        this.m_nPrevFlags = Component.readFlags(xml, "prev-flags", 0);
        this.m_fBaseLevel = Component.readBoolean(xml.getElement("base-level"));
        this.createTables();
        XmlElement xmlIntegration = xml.getElement("integration");
        if (xmlIntegration != null) {
            this.m_integration = new Integration((Trait)this, xmlIntegration, nVersion);
        }
        if ((xmlImplements = xml.getElement("implements")) != null) {
            StringTable tbl = this.m_tblImplements;
            Iterator iter = xmlImplements.getElements("interface");
            while (iter.hasNext()) {
                XmlElement xmlIFace = (XmlElement)iter.next();
                Interface iface = new Interface((Trait)this, xmlIFace, nVersion);
                tbl.put(iface.getUniqueName(), iface);
            }
        }
        if ((xmlDispatches = xml.getElement("dispatches")) != null) {
            StringTable tbl = this.m_tblDispatches;
            Iterator iter = xmlDispatches.getElements("interface");
            while (iter.hasNext()) {
                XmlElement xmlIFace = (XmlElement)iter.next();
                Interface iface = new Interface((Trait)this, xmlIFace, nVersion);
                tbl.put(iface.getUniqueName(), iface);
            }
        }
        if ((xmlProps = xml.getElement("properties")) != null) {
            StringTable tbl = this.m_tblState;
            Iterator iter = xmlProps.getElements("property");
            while (iter.hasNext()) {
                XmlElement xmlProp = (XmlElement)iter.next();
                Property prop = new Property((Trait)this, xmlProp, nVersion);
                tbl.put(prop.getUniqueName(), prop);
            }
        }
        if ((xmlBehaviors = xml.getElement("behaviors")) != null) {
            StringTable tbl = this.m_tblBehavior;
            Iterator iter = xmlBehaviors.getElements("behavior");
            while (iter.hasNext()) {
                XmlElement xmlBehavior = (XmlElement)iter.next();
                Behavior behavior = new Behavior((Trait)this, xmlBehavior, nVersion);
                tbl.put(behavior.getUniqueName(), behavior);
            }
        }
        if ((xmlCategories = xml.getElement("categories")) != null) {
            StringTable tbl = this.m_tblCategories;
            Iterator iter = xmlCategories.getElements("category");
            while (iter.hasNext()) {
                XmlElement xmlCat = (XmlElement)iter.next();
                String sCatName = Component.readString(xmlCat.getElement("name"));
                boolean fCatDecl = Component.readBoolean(xmlCat.getElement("declared"));
                if (sCatName == "") {
                    throw new IOException("category name is missing");
                }
                tbl.put(sCatName, Component.toBoolean(fCatDecl));
            }
        }
        if ((xmlChildren = xml.getElement("children")) != null) {
            StringTable tbl = this.m_tblChildren;
            Iterator iter = xmlChildren.getElements("child");
            while (iter.hasNext()) {
                XmlElement xmlChild = (XmlElement)iter.next();
                Component cd = new Component((Trait)this, xmlChild, nVersion);
                tbl.put(cd.getUniqueName(), cd);
            }
        }
    }

    private void createTables() {
        this.m_tblImplements = new StringTable();
        this.m_tblDispatches = new StringTable();
        this.m_tblCategories = new StringTable();
        if (this.m_nType == 2) {
            this.m_tblState = new StringTable();
            this.m_tblBehavior = new StringTable();
            this.m_tblChildren = new StringTable();
        } else {
            this.m_tblState = new StringTable(INSENS);
            this.m_tblBehavior = new StringTable(INSENS);
            this.m_tblChildren = new StringTable(INSENS);
        }
    }

    @Override
    public synchronized void save(DataOutput stream) throws IOException {
        Trait parent = this.getParentTrait();
        if (parent == null) {
            stream.writeInt(1952542835);
            stream.writeInt(0x4020000);
        }
        super.save(stream);
        stream.writeByte(this.m_nType);
        stream.writeUTF(this.m_sName);
        stream.writeUTF(this.m_sSuper);
        stream.writeInt(this.m_nFlags);
        stream.writeInt(this.m_nPrevFlags);
        stream.writeBoolean(this.m_fBaseLevel);
        Integration integration = this.m_integration;
        boolean fExists = integration != null;
        stream.writeBoolean(fExists);
        if (fExists) {
            integration.save(stream);
        }
        StringTable tbl = this.m_tblImplements;
        stream.writeInt(tbl.getSize());
        Enumeration enmr = tbl.elements();
        while (enmr.hasMoreElements()) {
            ((Interface)enmr.nextElement()).save(stream);
        }
        tbl = this.m_tblDispatches;
        stream.writeInt(tbl.getSize());
        enmr = tbl.elements();
        while (enmr.hasMoreElements()) {
            ((Interface)enmr.nextElement()).save(stream);
        }
        tbl = this.m_tblState;
        stream.writeInt(tbl.getSize());
        enmr = tbl.elements();
        while (enmr.hasMoreElements()) {
            ((Property)enmr.nextElement()).save(stream);
        }
        tbl = this.m_tblBehavior;
        stream.writeInt(tbl.getSize());
        enmr = tbl.elements();
        while (enmr.hasMoreElements()) {
            ((Behavior)enmr.nextElement()).save(stream);
        }
        tbl = this.m_tblCategories;
        stream.writeInt(tbl.getSize());
        enmr = tbl.keys();
        while (enmr.hasMoreElements()) {
            String sCategory = (String)enmr.nextElement();
            boolean fThisLevel = (Boolean)tbl.get(sCategory);
            stream.writeUTF(sCategory);
            stream.writeBoolean(fThisLevel);
        }
        tbl = this.m_tblChildren;
        stream.writeInt(tbl.getSize());
        enmr = tbl.elements();
        while (enmr.hasMoreElements()) {
            ((Component)enmr.nextElement()).save(stream);
        }
    }

    @Override
    public synchronized void save(XmlElement xml) throws IOException {
        Integration integration;
        xml.addElement("type").setString(this.DESCRIPTORS[this.m_nType]);
        xml.addElement("name").setString(this.m_sName);
        xml.addElement("super").setString(this.m_sSuper);
        super.save(xml);
        Component.saveFlags(xml, "flags", this.m_nFlags, 0);
        Component.saveFlags(xml, "prev-flags", this.m_nPrevFlags, 0);
        if (this.isComponent()) {
            xml.addElement("base-level").setBoolean(this.m_fBaseLevel);
        }
        if ((integration = this.m_integration) != null) {
            integration.save(xml.addElement("integration"));
        }
        Component.saveTable(xml, this.m_tblImplements, "implements", "interface");
        Component.saveTable(xml, this.m_tblDispatches, "dispatches", "interface");
        Component.saveTable(xml, this.m_tblState, "properties", "property");
        Component.saveTable(xml, this.m_tblBehavior, "behaviors", "behavior");
        StringTable tblCats = this.m_tblCategories;
        if (!tblCats.isEmpty()) {
            XmlElement xmlCats = xml.addElement("categories");
            Enumeration enmr = tblCats.keys();
            while (enmr.hasMoreElements()) {
                String sCategory = (String)enmr.nextElement();
                boolean fThisLevel = (Boolean)tblCats.get(sCategory);
                XmlElement xmlCat = xmlCats.addElement("category");
                xmlCat.addElement("name").setString(sCategory);
                if (!fThisLevel) continue;
                xmlCat.addElement("declared").setBoolean(true);
            }
        }
        Component.saveTable(xml, this.m_tblChildren, "children", "child");
    }

    protected static int getVersion(DataInput stream) throws IOException {
        if (stream.readInt() != 1952542835) {
            throw new IOException("Component.getVersion:  Stream does not contain a Component Definition");
        }
        int nVersion = stream.readInt();
        switch (nVersion) {
            case 0x4020000: {
                break;
            }
            default: {
                throw new IOException("Component.getVersion:  Stream contains an unsupported version of a Component Definition");
            }
        }
        return nVersion;
    }

    protected static int getVersion(XmlDocument xml) throws IOException {
        int nVersion = xml.getSafeElement("version").getInt();
        switch (nVersion) {
            case 0: {
                throw new IOException("Component.getVersion:  XmlDocument does not contain a valid Component Definition");
            }
            case 0x4020000: {
                break;
            }
            default: {
                throw new IOException("Component.getVersion:  XmlDocument contains an unsupported version of a Component Definition");
            }
        }
        return nVersion;
    }

    @Override
    public XmlElement toXml() {
        SimpleDocument xml = new SimpleDocument("component");
        Trait parent = this.getParentTrait();
        if (parent == null) {
            xml.addElement("version").setInt(0x4020000);
        }
        try {
            this.save(xml);
        }
        catch (IOException e) {
            throw Component.ensureRuntimeException(e);
        }
        return xml;
    }

    @Override
    public void fromXml(XmlElement xml) {
        throw new UnsupportedOperationException();
    }

    public static Component getRootSuper(Loader loader) throws ComponentException {
        Component cdSuper = new Component(null, 0, Component.getRootName());
        cdSuper.m_sName = "";
        cdSuper.m_fReadOnly = true;
        Component cdJCS = loader.loadSignature(DataType.OBJECT.getClassName());
        StringTable tblJCS = cdJCS.m_tblBehavior;
        StringTable tblCD = cdSuper.m_tblBehavior;
        Enumeration enmr = tblJCS.keys();
        while (enmr.hasMoreElements()) {
            Behavior behJCS;
            int nAccess;
            String sSig = (String)enmr.nextElement();
            if (Behavior.isConstructor(sSig) || (nAccess = (behJCS = (Behavior)tblJCS.get(sSig)).getAccess()) != 48 && nAccess != 32) continue;
            Behavior behCD = new Behavior(cdSuper, behJCS.getReturnValue().getDataType(), behJCS.getName(), behJCS.isStatic(), nAccess, behJCS.getParameterTypes(), behJCS.getParameterNames(), null);
            try {
                behCD.setFinal(behJCS.isFinal(), false);
                behCD.setVisible(0x2000000, false);
                behCD.assignUID();
            }
            catch (PropertyVetoException e) {
                throw new IllegalStateException();
            }
            tblCD.put(sSig, behCD);
        }
        cdSuper.validate();
        return cdSuper;
    }

    @Override
    protected Trait getBlankDerivedTrait(Trait parent, int nMode) {
        return new Component(this, parent, nMode);
    }

    @Override
    protected Trait getNullDerivedTrait(Trait parent, int nMode) {
        Component cd = (Component)super.getNullDerivedTrait(parent, nMode);
        cd.setExists(0);
        cd.m_fBaseLevel = nMode != 3;
        return cd;
    }

    public Component resolve(Component cdDelta, Loader loader, ErrorList errlist) throws ComponentException {
        if (cdDelta == null) {
            throw new IllegalArgumentException("Component.resolve:  Delta Component required!");
        }
        if (this.m_nType != 0 && this.m_nType != 2) {
            throw new IllegalArgumentException("Component.resolve:  Base is not a Component or Java Class Signature!");
        }
        if (this.m_nType != cdDelta.m_nType) {
            throw new IllegalArgumentException("Component.resolve:  Base type (" + this.m_nType + ") != Delta type (" + cdDelta.m_nType + ")");
        }
        return (Component)this.resolve(cdDelta, null, loader, errlist);
    }

    @Override
    protected Trait resolve(Trait traitDelta, Trait parent, Loader loader, ErrorList errlist) throws ComponentException {
        Enumeration enmr;
        StringTable tblDefer;
        StringTable tblDeferProperty;
        StringTable tblDeferBehavior;
        Interface ifaceDerived;
        Interface ifaceDelta;
        Enumeration enmr2;
        Component base = this;
        Component delta = (Component)this.resolveDelta(traitDelta, loader, errlist);
        Component derived = (Component)super.resolve(delta, parent, loader, errlist);
        boolean fComponent = delta.m_nType == 0;
        boolean fSignature = delta.m_nType == 2;
        boolean fComplex = delta.m_nType == 1;
        boolean fBaseComplex = base.m_nType == 1;
        int nBaseMode = base.getMode();
        boolean fBaseResolved = nBaseMode == 1;
        int nDeltaMode = delta.getMode();
        if (nDeltaMode == 1) {
            nDeltaMode = delta.getExtractMode(base);
        }
        int nDerivedMode = derived.getMode();
        if (fComplex) {
            if (fBaseComplex) {
                derived.m_sSuper = base.m_sSuper;
                derived.m_sName = base.m_sName;
                derived.m_nFlags = 0;
                derived.m_nPrevFlags = base.m_nFlags;
            } else {
                derived.m_nType = 1;
                derived.m_sName = derived.m_sSuper = base.getQualifiedName();
                derived.m_nFlags = 2;
            }
        } else {
            Interface ifaceBase;
            int nBaseFlags = base.m_nFlags;
            int nDeltaFlags = delta.m_nFlags;
            int nPrevFlags = derived.resolveFlags(nBaseFlags, delta.m_nPrevFlags);
            int nDerivedFlags = derived.resolveFlags(nPrevFlags, nDeltaFlags);
            int nExists = 0;
            if (nDeltaMode == 2) {
                if (base.getParentTrait() == null && delta.getParentTrait() != null) {
                    nExists = 2;
                } else if ((nDeltaFlags & 6) == 4) {
                    nExists = 4;
                }
            } else {
                int nBaseExists = nBaseFlags & 6;
                if (nBaseExists == 2 || nBaseExists == 4) {
                    nExists = nBaseExists;
                }
            }
            nDerivedFlags = nDerivedFlags & 0xFFFFFFF8 | nExists;
            if (nDeltaMode == 2) {
                if (parent != null && nExists == 0) {
                    derived.m_sSuper = base.m_sSuper;
                    derived.m_sName = base.m_sName;
                } else {
                    derived.m_sSuper = base.getQualifiedName();
                    derived.m_sName = delta.m_sName;
                }
                derived.m_fBaseLevel = delta.m_fBaseLevel;
            } else {
                derived.m_sSuper = base.m_sSuper;
                derived.m_sName = base.m_sName;
                derived.m_fBaseLevel = false;
            }
            derived.m_nPrevFlags = nPrevFlags;
            derived.m_nFlags = nDerivedFlags;
            enmr2 = base.m_tblImplements.elements();
            while (enmr2.hasMoreElements()) {
                ifaceBase = (Interface)enmr2.nextElement();
                ifaceDelta = (Interface)ifaceBase.getNullDerivedTrait(delta, nDeltaMode);
                ifaceDerived = (Interface)ifaceBase.resolve(ifaceDelta, derived, loader, errlist);
                derived.m_tblImplements.put(ifaceDerived.getUniqueName(), ifaceDerived);
            }
            enmr2 = base.m_tblDispatches.elements();
            while (enmr2.hasMoreElements()) {
                ifaceBase = (Interface)enmr2.nextElement();
                ifaceDelta = (Interface)ifaceBase.getNullDerivedTrait(delta, nDeltaMode);
                ifaceDerived = (Interface)ifaceBase.resolve(ifaceDelta, derived, loader, errlist);
                derived.m_tblDispatches.put(ifaceDerived.getUniqueName(), ifaceDerived);
            }
        }
        if (fSignature) {
            tblDeferBehavior = new StringTable();
            tblDeferProperty = new StringTable();
        } else {
            tblDeferBehavior = new StringTable(INSENS);
            tblDeferProperty = new StringTable(INSENS);
        }
        if (!fComplex) {
            StringTable tblBase = base.m_tblBehavior;
            StringTable tblDelta = delta.matchBehaviors(base, true, nDeltaMode == 2, errlist);
            StringTable tblDerived = derived.m_tblBehavior;
            tblDefer = tblDeferBehavior;
            enmr = tblDelta.keys();
            while (enmr.hasMoreElements()) {
                String sSig = (String)enmr.nextElement();
                Behavior behBase = (Behavior)tblBase.get(sSig);
                Behavior behDelta = (Behavior)tblDelta.get(sSig);
                Behavior behDerived = null;
                if (behBase != null && nDeltaMode == 2 && (behBase.getAccess() == 0 || behBase.isConstructor())) {
                    behBase = null;
                }
                if (behBase == null) {
                    tblDefer.put(sSig, behDelta);
                    continue;
                }
                if (behDelta != null && behBase.isFinal()) {
                    this.logError("RES-111", 2, new Object[]{behDelta.getSignature(), behDelta.toPathString()}, errlist);
                    behDelta = null;
                }
                if (behDelta == null) {
                    behDelta = (Behavior)behBase.getNullDerivedTrait(delta, nDeltaMode);
                    if (fSignature && nDeltaMode == 2) {
                        behDelta.setExists(6);
                    }
                }
                behDerived = (Behavior)behBase.resolve(behDelta, derived, loader, errlist);
                tblDerived.put(sSig, behDerived);
            }
        }
        StringTable tblBase = base.m_tblState;
        StringTable tblDelta = delta.matchProperties(base, true, nDeltaMode == 2, errlist);
        StringTable tblDerived = derived.m_tblState;
        tblDefer = tblDeferProperty;
        enmr = tblDelta.keys();
        while (enmr.hasMoreElements()) {
            String sProp = (String)enmr.nextElement();
            Property propBase = (Property)tblBase.get(sProp);
            Property propDelta = (Property)tblDelta.get(sProp);
            Property propDerived = null;
            if (propBase != null) {
                if (fComplex && !fBaseComplex) {
                    if (!propBase.isComplexPropertyProperty()) {
                        propBase = null;
                    }
                } else if (nDeltaMode == 2 && !propBase.isDerivedBySub()) {
                    propBase = null;
                }
            }
            if (propBase == null) {
                if (fComplex) {
                    if (propDelta == null) continue;
                    this.logError("RES-104", 2, new Object[]{propDelta.toString(), delta.toPathString()}, errlist);
                    continue;
                }
                tblDefer.put(sProp, propDelta);
                continue;
            }
            if (propDelta != null && nDeltaMode == 2 && propBase.isStatic() && !fSignature) {
                this.logError("RES-112", 2, new Object[]{propDelta.getName(), propDelta.toPathString()}, errlist);
                propDelta = null;
            }
            if (propDelta == null) {
                propDelta = (Property)propBase.getNullDerivedTrait(delta, nDeltaMode);
            }
            propDerived = (Property)propBase.resolve(propDelta, derived, loader, errlist);
            tblDerived.put(sProp, propDerived);
        }
        if (!fComplex && parent == null) {
            Integration integrationBase = base.m_integration;
            Integration integrationDelta = delta.m_integration;
            if (integrationBase != null || integrationDelta != null) {
                Integration integrationDerived;
                if (integrationBase == null) {
                    integrationBase = new Integration(base, (String)null);
                }
                if (integrationDelta == null) {
                    integrationDelta = (Integration)integrationBase.getNullDerivedTrait(delta, nDeltaMode);
                }
                derived.m_integration = integrationDerived = integrationBase.resolve(integrationDelta, derived, derived.m_tblBehavior, derived.m_tblState, tblDeferBehavior, tblDeferProperty, loader, errlist);
            }
        }
        if (!fComplex) {
            Component cdJCS;
            String sIface;
            tblBase = base.m_tblImplements;
            tblDelta = delta.m_tblImplements;
            tblDerived = derived.m_tblImplements;
            enmr2 = tblDelta.keys();
            while (enmr2.hasMoreElements()) {
                sIface = (String)enmr2.nextElement();
                if (tblBase.contains(sIface)) continue;
                ifaceDelta = (Interface)tblDelta.get(sIface);
                ifaceDerived = null;
                if (nDeltaMode == 2) {
                    cdJCS = loader.loadSignature(sIface);
                    if (cdJCS == null) {
                        this.logError("RES-115", 2, new Object[]{sIface, ATTR_IMPLEMENTS, derived.getQualifiedName()}, errlist);
                        continue;
                    }
                    ifaceDerived = new Interface(derived, cdJCS, false);
                    if (ifaceDelta.isFromBase()) {
                        ifaceDerived.setFromBase();
                    }
                    if (derived.isImplementsAddable(ifaceDerived, cdJCS, errlist)) {
                        try {
                            derived.expandInterface(ifaceDerived, cdJCS, tblDeferBehavior, tblDeferProperty, errlist);
                        }
                        catch (PropertyVetoException e) {
                            this.logError("RES-116", 3, new Object[]{sIface, ATTR_IMPLEMENTS, derived.getQualifiedName()}, errlist);
                            throw new DerivationException(e.toString());
                        }
                        tblDerived.put(sIface, ifaceDerived);
                        continue;
                    }
                    this.logError("RES-116", 2, new Object[]{sIface, ATTR_IMPLEMENTS, derived.getQualifiedName()}, errlist);
                    continue;
                }
                ifaceDerived = new Interface(derived, ifaceDelta);
                tblDerived.put(sIface, ifaceDerived);
            }
            tblBase = base.m_tblDispatches;
            tblDelta = delta.m_tblDispatches;
            tblDerived = derived.m_tblDispatches;
            enmr2 = tblDelta.keys();
            while (enmr2.hasMoreElements()) {
                sIface = (String)enmr2.nextElement();
                if (tblBase.contains(sIface)) continue;
                ifaceDelta = (Interface)tblDelta.get(sIface);
                ifaceDerived = null;
                if (nDeltaMode == 2) {
                    cdJCS = loader.loadSignature(sIface);
                    if (cdJCS == null) {
                        this.logError("RES-115", 2, new Object[]{sIface, ATTR_DISPATCHES, derived.getQualifiedName()}, errlist);
                        continue;
                    }
                    ifaceDerived = new Interface(derived, cdJCS, true);
                    if (ifaceDelta.isFromBase()) {
                        ifaceDerived.setFromBase();
                    }
                    if (derived.isDispatchesAddable(ifaceDerived, cdJCS, errlist)) {
                        try {
                            derived.expandInterface(ifaceDerived, cdJCS, tblDeferBehavior, tblDeferProperty, errlist);
                        }
                        catch (PropertyVetoException e) {
                            this.logError("RES-116", 3, new Object[]{sIface, ATTR_DISPATCHES, derived.getQualifiedName()}, errlist);
                            throw new DerivationException(e.toString());
                        }
                        tblDerived.put(sIface, ifaceDerived);
                        continue;
                    }
                    this.logError("RES-116", 2, new Object[]{sIface, ATTR_DISPATCHES, derived.getQualifiedName()}, errlist);
                    continue;
                }
                ifaceDerived = new Interface(derived, ifaceDelta);
                tblDerived.put(sIface, ifaceDerived);
            }
        }
        if (!fComplex) {
            if (!tblDeferBehavior.isEmpty()) {
                tblBase = base.m_tblBehavior;
                tblDelta = tblDeferBehavior;
                tblDerived = derived.m_tblBehavior;
                enmr2 = tblDelta.keys();
                while (enmr2.hasMoreElements()) {
                    String sSig = (String)enmr2.nextElement();
                    Behavior behBase = (Behavior)tblBase.get(sSig);
                    Behavior behDelta = (Behavior)tblDelta.get(sSig);
                    Behavior behDerived = null;
                    if (behBase != null && (nDeltaMode != 2 || behBase.getAccess() != 0 && !behBase.isConstructor())) {
                        throw new IllegalStateException("Component.resolve:  Deferred Behavior has match in base! (" + sSig + ")");
                    }
                    if (tblDerived.contains(sSig) || derived.isBehaviorReserved(sSig)) {
                        this.logError("RES-109", 2, new Object[]{behDelta.getSignature(), behDelta.toPathString()}, errlist);
                        continue;
                    }
                    behDerived = new Behavior(derived, behDelta);
                    tblDerived.put(sSig, behDerived);
                }
            }
            if (!tblDeferProperty.isEmpty()) {
                tblBase = base.m_tblState;
                tblDelta = tblDeferProperty;
                tblDerived = derived.m_tblState;
                enmr2 = tblDelta.keys();
                while (enmr2.hasMoreElements()) {
                    String sProp = (String)enmr2.nextElement();
                    Property propBase = (Property)tblBase.get(sProp);
                    Property propDelta = (Property)tblDelta.get(sProp);
                    Property propDerived = null;
                    if (propBase != null && (nDeltaMode != 2 || propBase.isDerivedBySub())) {
                        throw new IllegalStateException("Component.resolve:  Deferred Property has match in base! (" + sProp + ")");
                    }
                    if (nDeltaMode == 2 && propDelta.getExists() != 2) {
                        this.logError("RES-104", 2, new Object[]{propDelta.toString(), delta.toPathString()}, errlist);
                        continue;
                    }
                    if (Property.isCreatable(derived, propDelta.getDataType(), sProp, propDelta.getIndexed(), propDelta.isStatic(), propDelta.getDirection(), propDelta.isConstant())) {
                        propDerived = new Property(derived, propDelta);
                        tblDerived.put(sProp, propDerived);
                        continue;
                    }
                    this.logError("RES-110", 2, new Object[]{propDelta.getName(), propDelta.toPathString()}, errlist);
                }
            }
        }
        if (!fComplex) {
            StringTable tblCategories = derived.m_tblCategories;
            Boolean TRUE = Boolean.TRUE;
            Enumeration enmr3 = delta.m_tblCategories.keys();
            while (enmr3.hasMoreElements()) {
                tblCategories.put((String)enmr3.nextElement(), TRUE);
            }
            Boolean FALSE = Boolean.FALSE;
            enmr2 = base.m_tblCategories.keys();
            while (enmr2.hasMoreElements()) {
                tblCategories.put((String)enmr2.nextElement(), FALSE);
            }
            StringTable tblBase2 = base.m_tblChildren;
            StringTable tblDelta2 = delta.matchChildren(base, true, errlist);
            StringTable tblDerived2 = derived.m_tblChildren;
            Enumeration enmr4 = tblDelta2.keys();
            while (enmr4.hasMoreElements()) {
                String sChild = (String)enmr4.nextElement();
                Component cdBase = (Component)tblBase2.get(sChild);
                Component cdDelta = (Component)tblDelta2.get(sChild);
                Component cdDerived = null;
                if (cdBase == null && fBaseResolved && cdDelta.getExists() == 2) {
                    cdBase = loader.loadComponent(cdDelta.getSuperName(), true, errlist);
                    if (cdBase == null) {
                        this.logError("RES-106", 2, new Object[]{cdDelta.toString(), delta.toPathString()}, errlist);
                    } else if (cdBase.isFinal()) {
                        this.logError("RES-107", 2, new Object[]{cdDelta.getName(), cdBase.getQualifiedName(), cdDelta.toPathString()}, errlist);
                        cdBase = null;
                    } else if (!derived.isChildSuperLegal(cdBase.getQualifiedName())) {
                        this.logError("RES-108", 2, new Object[]{cdDelta.toString(), cdBase.toString(), delta.toPathString()}, errlist);
                        cdBase = null;
                    }
                }
                if (cdBase == null) {
                    if (fBaseResolved) {
                        this.logError("RES-106", 2, new Object[]{cdDelta.toString(), delta.toPathString()}, errlist);
                    } else {
                        cdDerived = new Component((Trait)derived, cdDelta);
                    }
                } else {
                    int nBaseChildFlags = cdBase.m_nFlags;
                    if (cdDelta != null && (nBaseChildFlags & 0x2000) == 8192 && (cdBase.getMode() == 1 || (nBaseChildFlags & 0x1000) != 0)) {
                        this.logError("RES-113", 2, new Object[]{cdDelta.getName(), cdDelta.toPathString()}, errlist);
                        cdDelta = null;
                    }
                    if ((nBaseChildFlags & 6) == 6 || (nBaseChildFlags & 6) == 4 && nDeltaMode == 2) {
                        cdDerived = (Component)cdBase.getBlankDerivedTrait(derived, cdBase.getMode());
                        cdDerived.setExists(6);
                    } else {
                        if (cdDelta == null) {
                            cdDelta = (Component)cdBase.getNullDerivedTrait(delta, nDeltaMode);
                        }
                        cdDerived = (Component)cdBase.resolve(cdDelta, derived, loader, errlist);
                    }
                }
                if (cdDerived == null) continue;
                tblDerived2.put(sChild, cdDerived);
            }
        }
        return derived;
    }

    protected int resolveFlags(int nBaseFlags, int nDeltaFlags) {
        boolean fBaseResolved;
        boolean fSignature = this.isSignature();
        int nDerivedFlags = nBaseFlags;
        if (nDeltaFlags == 0) {
            return nDerivedFlags;
        }
        boolean bl = fBaseResolved = this.getMode() == 1;
        if ((fBaseResolved || (nBaseFlags & 0x1000) != 0) && (nBaseFlags & 0x2000) == 8192) {
            return nDerivedFlags;
        }
        if ((nDeltaFlags & 0x1000000) != 0) {
            nDerivedFlags = nDerivedFlags & 0xF8FFFFFF | nDeltaFlags & 0x7000000;
        }
        if (fSignature) {
            int nDeltaAccess;
            int nBaseAccess = nBaseFlags & 0x30;
            int nDerivedAccess = nDeltaAccess = nDeltaFlags & 0x30;
            if ((fBaseResolved || (nBaseFlags & 8) != 0) && nDeltaAccess != nBaseAccess) {
                switch (nBaseAccess) {
                    case 0: {
                        break;
                    }
                    case 32: {
                        if (nDeltaAccess == 48) break;
                    }
                    case 48: {
                        nDerivedAccess = nBaseAccess;
                    }
                }
            }
            nDerivedFlags = nDerivedFlags & 0xFFFFFFCF | 8 | nDerivedAccess;
        }
        if ((nDeltaFlags & 0x100) != 0 && (nDeltaFlags & 0x200) == 512) {
            nDerivedFlags = nDerivedFlags & 0xFFFFFCFF | nDeltaFlags & 0x300;
        }
        if (fSignature || (nDeltaFlags & 0x400) != 0) {
            nDerivedFlags = nDerivedFlags & 0xFFFFF3FF | nDeltaFlags & 0xC00;
        }
        if ((fSignature || (nDeltaFlags & 0x1000) != 0) && (nDeltaFlags & 0x2000) == 8192) {
            nDerivedFlags = nDerivedFlags & 0xFFFFCFFF | nDeltaFlags & 0x3000;
        }
        if (fSignature || (nDeltaFlags & 0x4000) != 0) {
            nDerivedFlags = nDerivedFlags & 0xFFFF3FFF | nDeltaFlags & 0xC000;
        }
        if ((nDeltaFlags & 0x10000) != 0) {
            nDerivedFlags = nDerivedFlags & 0xFFFCFFFF | nDeltaFlags & 0x30000;
        }
        if ((nDeltaFlags & 0x40000) != 0 && (nDeltaFlags & 0x180000) == 0x180000) {
            nDerivedFlags = nDerivedFlags & 0xFFE3FFFF | nDeltaFlags & 0x1C0000;
        }
        if ((nDeltaFlags & 0x40000000) != 0) {
            nDerivedFlags |= 0x40000000;
        }
        if ((nDeltaFlags & Integer.MIN_VALUE) != 0) {
            nDerivedFlags |= Integer.MIN_VALUE;
        }
        return nDerivedFlags;
    }

    @Override
    public synchronized void finalizeResolve(Loader loader, ErrorList errlist) throws ComponentException {
        Component cd;
        Behavior behavior;
        Property prop;
        Interface iface;
        super.finalizeResolve(loader, errlist);
        this.m_nFlags &= 0xF6DAAAB6;
        this.m_nPrevFlags &= 0xF6DAAAB6;
        if (this.m_integration != null) {
            this.m_integration.finalizeResolve(loader, errlist);
        }
        Enumeration enmr = this.m_tblImplements.elements();
        while (enmr.hasMoreElements()) {
            iface = (Interface)enmr.nextElement();
            iface.finalizeResolve(loader, errlist);
        }
        enmr = this.m_tblDispatches.elements();
        while (enmr.hasMoreElements()) {
            iface = (Interface)enmr.nextElement();
            iface.finalizeResolve(loader, errlist);
        }
        enmr = this.m_tblState.elements();
        while (enmr.hasMoreElements()) {
            prop = (Property)enmr.nextElement();
            prop.finalizeResolve(loader, errlist);
        }
        enmr = this.m_tblBehavior.elements();
        while (enmr.hasMoreElements()) {
            behavior = (Behavior)enmr.nextElement();
            behavior.finalizeResolve(loader, errlist);
        }
        enmr = this.m_tblChildren.elements();
        while (enmr.hasMoreElements()) {
            cd = (Component)enmr.nextElement();
            cd.finalizeResolve(loader, errlist);
        }
        enmr = this.m_tblState.elements();
        while (enmr.hasMoreElements()) {
            prop = (Property)enmr.nextElement();
            if (!prop.isDiscardable()) continue;
            this.m_tblState.remove(prop.getUniqueName());
            prop.invalidate();
        }
        enmr = this.m_tblBehavior.elements();
        while (enmr.hasMoreElements()) {
            behavior = (Behavior)enmr.nextElement();
            if (!behavior.isDiscardable()) continue;
            this.m_tblBehavior.remove(behavior.getUniqueName());
            behavior.invalidate();
        }
        enmr = this.m_tblChildren.elements();
        while (enmr.hasMoreElements()) {
            cd = (Component)enmr.nextElement();
            if (!cd.isDiscardable()) continue;
            this.m_tblChildren.remove(cd.getUniqueName());
            cd.invalidate();
        }
        if (this.isGlobal() && this.getUID() != null) {
            this.logError("RES-001", 2, new Object[]{this.getName(), "Global UID must be null"}, errlist);
            this.clearUID();
        }
        this.validate();
    }

    @Override
    protected int getExtractMode(Trait traitBase) {
        switch (this.m_nType) {
            case 0: {
                Component base = (Component)traitBase;
                if (base.m_sName.length() == 0) {
                    return this.m_sName.length() == 0 ? 3 : 2;
                }
                if (this.getParent() == null) {
                    return this.m_sSuper.equals(base.m_sSuper) ? 3 : 2;
                }
                if (base.getParent() != null) break;
                return 2;
            }
            case 2: {
                Component base = (Component)traitBase;
                return this.m_sName.equals(base.m_sName) ? 3 : 2;
            }
            case 1: {
                return 3;
            }
        }
        return super.getExtractMode(traitBase);
    }

    public Component extract(Component cdBase, Loader loader, ErrorList errlist) throws ComponentException {
        if (cdBase == null) {
            throw new IllegalArgumentException("Component.extract:  Base Component required!");
        }
        if (this.m_nType != 0 && this.m_nType != 2) {
            throw new IllegalArgumentException("Component.extract:  Derived is not a Component or Java Class Signature!");
        }
        if (this.m_nType != cdBase.m_nType) {
            throw new IllegalArgumentException("Component.extract:  Base type (" + cdBase.m_nType + ") != Derived type (" + this.m_nType + ")");
        }
        return (Component)this.extract(cdBase, null, loader, errlist);
    }

    @Override
    protected Trait extract(Trait traitBase, Trait parent, Loader loader, ErrorList errlist) throws ComponentException {
        boolean fBaseComplex;
        Component derived = this;
        Component base = (Component)traitBase;
        Component delta = (Component)super.extract(base, parent, loader, errlist);
        boolean fBaseResolved = base.getMode() == 1;
        int nDeltaMode = delta.getMode();
        boolean fComplex = derived.m_nType == 1;
        boolean bl = fBaseComplex = base.m_nType == 1;
        if (fComplex) {
            if (fBaseComplex) {
                delta.m_nFlags = 0;
            } else {
                delta.m_nType = 1;
                delta.m_nFlags = 3;
            }
            delta.m_sSuper = derived.m_sSuper;
            delta.m_sName = derived.m_sName;
        } else {
            Interface iface;
            String sIface;
            Enumeration enmr;
            int nBaseFlags = base.m_nFlags;
            int nDerivedFlags = derived.m_nFlags;
            int nDifFlags = nBaseFlags ^ nDerivedFlags;
            int nDeltaFlags = nDerivedFlags & 0xF6DAAAB6;
            int nBaseExists = nBaseFlags & 6;
            int nDerivedExists = nDerivedFlags & 6;
            int nDeltaExists = 0;
            if (base.getParentTrait() == null && derived.getParentTrait() != null) {
                nDeltaExists = 3;
            } else if (nDerivedExists == 4 && (nBaseExists == 2 || nBaseExists == 0)) {
                nDeltaExists = 5;
            }
            nDeltaFlags = nDeltaFlags & 0xFFFFFFF8 | nDeltaExists;
            if ((nDifFlags & 0x6000000) != 0 && (fBaseResolved || (nBaseFlags & 0x1000000) != 0)) {
                nDeltaFlags |= 0x1000000;
            }
            if ((nDifFlags & 0x200) != 0 && (fBaseResolved || (nBaseFlags & 0x100) != 0)) {
                nDeltaFlags |= 0x100;
            }
            if ((nDifFlags & 0x800) != 0 && (fBaseResolved || (nBaseFlags & 0x400) != 0)) {
                nDeltaFlags |= 0x400;
            }
            if ((nDifFlags & 0x2000) != 0 && (fBaseResolved || (nBaseFlags & 0x1000) != 0)) {
                nDeltaFlags |= 0x1000;
            }
            if ((nDifFlags & 0x8000) != 0 && (fBaseResolved || (nBaseFlags & 0x4000) != 0)) {
                nDeltaFlags |= 0x4000;
            }
            if ((nDifFlags & 0x20000) != 0 && (fBaseResolved || (nBaseFlags & 0x10000) != 0)) {
                nDeltaFlags |= 0x10000;
            }
            if ((nDifFlags & 0x180000) != 0 && (fBaseResolved || (nBaseFlags & 0x40000) != 0)) {
                nDeltaFlags |= 0x40000;
            }
            if (nDeltaMode == 2) {
                if (parent == null || nDeltaExists == 3) {
                    delta.m_sSuper = base.getQualifiedName();
                    delta.m_sName = derived.m_sName;
                } else {
                    delta.m_sSuper = base.m_sSuper;
                    delta.m_sName = base.m_sName;
                }
                Integration integrationBase = base.m_integration;
                Integration integrationDerived = derived.m_integration;
                Integration integrationDelta = null;
                if (integrationDerived != null) {
                    integrationDelta = integrationBase == null ? new Integration(base, integrationDerived) : (Integration)integrationDerived.extract(integrationBase, delta, loader, errlist);
                }
                delta.m_integration = integrationDelta;
                delta.m_fBaseLevel = true;
            } else {
                delta.m_sSuper = base.m_sSuper;
                delta.m_sName = base.m_sName;
                delta.m_fBaseLevel = false;
            }
            delta.m_nFlags = nDeltaFlags;
            delta.m_nPrevFlags = 0;
            StringTable tblBase = base.m_tblImplements;
            StringTable tblDerived = derived.m_tblImplements;
            StringTable tblDelta = delta.m_tblImplements;
            if (!tblDerived.isEmpty() && !tblDerived.keysEquals(tblBase)) {
                enmr = tblDerived.keys();
                while (enmr.hasMoreElements()) {
                    sIface = (String)enmr.nextElement();
                    if (tblBase.contains(sIface)) continue;
                    iface = (Interface)tblDerived.get(sIface);
                    tblDelta.put(sIface, new Interface(delta, iface));
                }
            }
            tblBase = base.m_tblDispatches;
            tblDerived = derived.m_tblDispatches;
            tblDelta = delta.m_tblDispatches;
            if (!tblDerived.isEmpty() && !tblDerived.keysEquals(tblBase)) {
                enmr = tblDerived.keys();
                while (enmr.hasMoreElements()) {
                    sIface = (String)enmr.nextElement();
                    if (tblBase.contains(sIface)) continue;
                    iface = (Interface)tblDerived.get(sIface);
                    tblDelta.put(sIface, new Interface(delta, iface));
                }
            }
        }
        StringTable tblBase = base.m_tblState;
        StringTable tblDerived = derived.matchProperties(base, false, nDeltaMode == 2, errlist);
        StringTable tblDelta = delta.m_tblState;
        Enumeration enmr = tblDerived.keys();
        while (enmr.hasMoreElements()) {
            String sProp = (String)enmr.nextElement();
            Property propBase = (Property)tblBase.get(sProp);
            Property propDerived = (Property)tblDerived.get(sProp);
            Property propDelta = null;
            if (propDerived != null && (propDerived.getExists() == 6 || propDerived.getExists() == 4)) continue;
            if (propBase != null) {
                if (fComplex && !fBaseComplex) {
                    if (!propBase.isComplexPropertyProperty()) {
                        propBase = null;
                    }
                } else if (nDeltaMode == 2 && !propBase.isDerivedBySub()) {
                    propBase = null;
                }
            }
            if (propBase == null) {
                if (fComplex) {
                    if (propDelta != null) {
                        this.logError("RES-104", 2, new Object[]{propDelta.toString(), delta.toPathString()}, errlist);
                    }
                } else if (nDeltaMode == 2 && propDerived.getExists() != 2) {
                    this.logError("EXT-104", 2, new Object[]{propDerived.toString(), derived.toPathString()}, errlist);
                } else {
                    propDelta = new Property(delta, propDerived);
                    if (nDeltaMode == 2) {
                        propDelta.initializeExtract(loader, errlist);
                    }
                }
            } else if (!(propDerived == null || nDeltaMode == 2 && propBase.isStatic())) {
                propDelta = (Property)propDerived.extract(propBase, delta, loader, errlist);
            }
            if (propDelta == null) continue;
            tblDelta.put(sProp, propDelta);
        }
        if (!fComplex) {
            tblBase = base.m_tblBehavior;
            tblDerived = derived.matchBehaviors(base, false, nDeltaMode == 2, errlist);
            tblDelta = delta.m_tblBehavior;
            enmr = tblDerived.keys();
            while (enmr.hasMoreElements()) {
                String sSig = (String)enmr.nextElement();
                Behavior behBase = (Behavior)tblBase.get(sSig);
                Behavior behDerived = (Behavior)tblDerived.get(sSig);
                Behavior behDelta = null;
                if (behBase != null && nDeltaMode == 2 && (behBase.getAccess() == 0 || behBase.isConstructor())) {
                    behBase = null;
                }
                if (behBase == null) {
                    if (nDeltaMode == 2 && behDerived.getExists() != 2) {
                        this.logError("EXT-105", 2, new Object[]{behDerived.toString(), derived.toPathString()}, errlist);
                    } else {
                        behDelta = new Behavior(delta, behDerived);
                    }
                } else if (behDerived != null && !behBase.isFinal()) {
                    behDelta = (Behavior)behDerived.extract(behBase, delta, loader, errlist);
                }
                if (behDelta == null) continue;
                tblDelta.put(sSig, behDelta);
            }
        }
        if (!fComplex) {
            tblBase = base.m_tblCategories;
            tblDerived = derived.m_tblCategories;
            tblDelta = delta.m_tblCategories;
            if (!tblDerived.isEmpty() && !tblDerived.keysEquals(tblBase)) {
                Boolean TRUE = Boolean.TRUE;
                Enumeration enmr2 = tblDerived.keys();
                while (enmr2.hasMoreElements()) {
                    String sCat = (String)enmr2.nextElement();
                    if (tblBase.contains(sCat)) continue;
                    tblDelta.put(sCat, TRUE);
                }
            }
            tblBase = base.m_tblChildren;
            tblDerived = derived.matchChildren(base, false, errlist);
            tblDelta = delta.m_tblChildren;
            enmr = tblDerived.keys();
            while (enmr.hasMoreElements()) {
                String sChild = (String)enmr.nextElement();
                Component cdBase = (Component)tblBase.get(sChild);
                Component cdDerived = (Component)tblDerived.get(sChild);
                Component cdDelta = null;
                if (cdBase == null && nDeltaMode == 2 && cdDerived.getExists() == 2) {
                    cdBase = loader.loadComponent(cdDerived.getSuperName(), true, errlist);
                    if (cdBase == null) {
                        this.logError("EXT-106", 2, new Object[]{cdDerived.toString(), derived.toPathString()}, errlist);
                    } else if (cdBase.isFinal()) {
                        this.logError("EXT-107", 2, new Object[]{cdBase.toString(), derived.toPathString()}, errlist);
                        cdBase = null;
                    } else if (!derived.isChildSuperLegal(cdBase.getQualifiedName())) {
                        this.logError("EXT-108", 2, new Object[]{cdDerived.toString(), cdBase.toString(), derived.toPathString()}, errlist);
                        cdBase = null;
                    }
                }
                if (cdBase == null) {
                    if (nDeltaMode == 2) {
                        this.logError("EXT-106", 2, new Object[]{cdDerived.toString(), derived.toPathString()}, errlist);
                    } else {
                        cdDelta = new Component((Trait)delta, cdDerived);
                    }
                } else {
                    if (cdDerived != null) {
                        int nBaseChildFlags = cdBase.m_nFlags;
                        if ((nBaseChildFlags & 0x2000) == 8192 && (cdBase.getMode() == 1 || (nBaseChildFlags & 0x1000) != 0)) {
                            cdDerived = null;
                        } else if ((nBaseChildFlags & 6) == 6 || (nBaseChildFlags & 6) == 4) {
                            cdDerived = null;
                        }
                    }
                    if (cdDerived != null) {
                        cdDelta = (Component)cdDerived.extract(cdBase, delta, loader, errlist);
                    }
                }
                if (cdDelta == null) continue;
                tblDelta.put(sChild, cdDelta);
            }
        }
        return delta;
    }

    @Override
    public synchronized void finalizeExtract(Loader loader, ErrorList errlist) throws ComponentException {
        Component cd;
        Behavior behavior;
        Property prop;
        Interface iface;
        if (this.getMode() == 1 && this.m_sSuper == "") {
            return;
        }
        if (this.isGlobal()) {
            this.clearUID();
        }
        super.finalizeExtract(loader, errlist);
        if (this.m_integration != null) {
            this.m_integration.finalizeExtract(loader, errlist);
        }
        Enumeration enmr = this.m_tblImplements.elements();
        while (enmr.hasMoreElements()) {
            iface = (Interface)enmr.nextElement();
            iface.finalizeExtract(loader, errlist);
        }
        enmr = this.m_tblDispatches.elements();
        while (enmr.hasMoreElements()) {
            iface = (Interface)enmr.nextElement();
            iface.finalizeExtract(loader, errlist);
        }
        enmr = this.m_tblState.elements();
        while (enmr.hasMoreElements()) {
            prop = (Property)enmr.nextElement();
            prop.finalizeExtract(loader, errlist);
        }
        enmr = this.m_tblBehavior.elements();
        while (enmr.hasMoreElements()) {
            behavior = (Behavior)enmr.nextElement();
            behavior.finalizeExtract(loader, errlist);
        }
        enmr = this.m_tblChildren.elements();
        while (enmr.hasMoreElements()) {
            cd = (Component)enmr.nextElement();
            cd.finalizeExtract(loader, errlist);
        }
        enmr = this.m_tblImplements.elements();
        while (enmr.hasMoreElements()) {
            iface = (Interface)enmr.nextElement();
            if (!iface.isDiscardable()) continue;
            this.m_tblImplements.remove(iface.getUniqueName());
            iface.invalidate();
        }
        enmr = this.m_tblDispatches.elements();
        while (enmr.hasMoreElements()) {
            iface = (Interface)enmr.nextElement();
            if (!iface.isDiscardable()) continue;
            this.m_tblDispatches.remove(iface.getUniqueName());
            iface.invalidate();
        }
        enmr = this.m_tblState.elements();
        while (enmr.hasMoreElements()) {
            prop = (Property)enmr.nextElement();
            if (!prop.isDiscardable()) continue;
            this.m_tblState.remove(prop.getUniqueName());
            prop.invalidate();
        }
        enmr = this.m_tblBehavior.elements();
        while (enmr.hasMoreElements()) {
            behavior = (Behavior)enmr.nextElement();
            if (!behavior.isDiscardable()) continue;
            this.m_tblBehavior.remove(behavior.getUniqueName());
            behavior.invalidate();
        }
        enmr = this.m_tblChildren.elements();
        while (enmr.hasMoreElements()) {
            cd = (Component)enmr.nextElement();
            if (!cd.isDiscardable()) continue;
            this.m_tblChildren.remove(cd.getUniqueName());
            cd.invalidate();
        }
    }

    protected StringTable matchProperties(Component base, boolean fResolve, boolean fDerive, ErrorList errlist) throws DerivationException {
        String sProp;
        Property propThis;
        Property propBase;
        UID uid;
        Property prop;
        StringTable tblThis = this.m_tblState;
        StringTable tblBase = base.m_tblState;
        StringTable tblResult = tblThis;
        if (tblThis.keysEquals(tblBase)) {
            return tblResult;
        }
        tblResult = new StringTable();
        if (tblThis.isEmpty()) {
            Enumeration enmr = tblBase.elements();
            while (enmr.hasMoreElements()) {
                Property prop2 = (Property)enmr.nextElement();
                if (fDerive && !prop2.isDerivedBySub()) continue;
                tblResult.put(prop2.getUniqueName(), null);
            }
            return tblResult;
        }
        Hashtable<UID, Property> tblByUID = new Hashtable<UID, Property>();
        StringTable tblByName = new StringTable();
        Enumeration enmr = tblThis.elements();
        while (enmr.hasMoreElements()) {
            prop = (Property)enmr.nextElement();
            uid = prop.getUID();
            if (uid != null) {
                tblByUID.put(uid, prop);
            }
            tblByName.put(prop.getUniqueName(), prop);
        }
        if (!tblByUID.isEmpty()) {
            enmr = tblBase.elements();
            while (enmr.hasMoreElements()) {
                propBase = (Property)enmr.nextElement();
                uid = propBase.getUID();
                if (uid == null || (propThis = (Property)tblByUID.get(uid)) == null || fDerive && !propBase.isDerivedBySub()) continue;
                tblResult.put(propBase.getUniqueName(), propThis);
                tblByName.remove(propThis.getUniqueName());
            }
        }
        enmr = tblBase.elements();
        while (enmr.hasMoreElements()) {
            propBase = (Property)enmr.nextElement();
            if (fDerive && !propBase.isDerivedBySub() || tblResult.contains(sProp = propBase.getUniqueName())) continue;
            propThis = (Property)tblByName.get(sProp);
            tblResult.put(sProp, propThis);
            if (propThis == null) continue;
            tblByName.remove(sProp);
        }
        enmr = tblByName.elements();
        while (enmr.hasMoreElements()) {
            prop = (Property)enmr.nextElement();
            sProp = prop.getUniqueName();
            if (tblResult.contains(sProp)) {
                String sCode = fResolve ? "RES-101" : "EXT-101";
                this.logError(sCode, 2, new Object[]{sProp, this.toPathString()}, errlist);
                continue;
            }
            tblResult.put(sProp, prop);
        }
        return tblResult;
    }

    protected StringTable matchBehaviors(Component base, boolean fResolve, boolean fDerive, ErrorList errlist) throws DerivationException {
        String sSig;
        Behavior behThis;
        Behavior behBase;
        UID uid;
        Behavior behavior;
        StringTable tblThis = this.m_tblBehavior;
        StringTable tblBase = base.m_tblBehavior;
        StringTable tblResult = tblThis;
        if (tblThis.keysEquals(tblBase)) {
            return tblResult;
        }
        tblResult = new StringTable();
        if (tblThis.isEmpty()) {
            Enumeration enmr = tblBase.elements();
            while (enmr.hasMoreElements()) {
                Behavior behavior2 = (Behavior)enmr.nextElement();
                if (fDerive && (behavior2.getAccess() == 0 || behavior2.isConstructor())) continue;
                tblResult.put(behavior2.getUniqueName(), null);
            }
            return tblResult;
        }
        Hashtable<UID, Behavior> tblByUID = new Hashtable<UID, Behavior>();
        StringTable tblByName = new StringTable();
        Enumeration enmr = tblThis.elements();
        while (enmr.hasMoreElements()) {
            behavior = (Behavior)enmr.nextElement();
            uid = behavior.getUID();
            if (uid != null) {
                tblByUID.put(uid, behavior);
            }
            tblByName.put(behavior.getUniqueName(), behavior);
        }
        if (!tblByUID.isEmpty()) {
            enmr = tblBase.elements();
            while (enmr.hasMoreElements()) {
                behBase = (Behavior)enmr.nextElement();
                uid = behBase.getUID();
                if (uid == null || (behThis = (Behavior)tblByUID.get(uid)) == null || fDerive && (behBase.getAccess() == 0 || behBase.isConstructor())) continue;
                tblResult.put(behBase.getUniqueName(), behThis);
                tblByName.remove(behThis.getUniqueName());
            }
        }
        enmr = tblBase.elements();
        while (enmr.hasMoreElements()) {
            behBase = (Behavior)enmr.nextElement();
            if (fDerive && (behBase.getAccess() == 0 || behBase.isConstructor()) || tblResult.contains(sSig = behBase.getUniqueName())) continue;
            behThis = (Behavior)tblByName.get(sSig);
            tblResult.put(sSig, behThis);
            if (behThis == null) continue;
            tblByName.remove(sSig);
        }
        enmr = tblByName.elements();
        while (enmr.hasMoreElements()) {
            behavior = (Behavior)enmr.nextElement();
            sSig = behavior.getUniqueName();
            if (tblResult.contains(sSig)) {
                String sCode = fResolve ? "RES-102" : "EXT-102";
                this.logError(sCode, 2, new Object[]{sSig, this.toPathString()}, errlist);
                continue;
            }
            tblResult.put(sSig, behavior);
        }
        return tblResult;
    }

    protected StringTable matchChildren(Component base, boolean fResolve, ErrorList errlist) throws DerivationException {
        UID uid;
        Component cd;
        StringTable tblThis = this.m_tblChildren;
        StringTable tblBase = base.m_tblChildren;
        StringTable tblResult = tblThis;
        if (tblThis.keysEquals(tblBase)) {
            return tblResult;
        }
        if (tblThis.isEmpty()) {
            tblResult = (StringTable)tblBase.clone();
            Enumeration enmr = tblResult.keys();
            while (enmr.hasMoreElements()) {
                tblResult.put((String)enmr.nextElement(), null);
            }
            return tblResult;
        }
        tblResult = new StringTable();
        Hashtable<UID, Component> tblByUID = new Hashtable<UID, Component>();
        StringTable tblByName = new StringTable();
        Enumeration enmr = tblThis.elements();
        while (enmr.hasMoreElements()) {
            cd = (Component)enmr.nextElement();
            uid = cd.getUID();
            if (uid != null) {
                tblByUID.put(uid, cd);
            }
            tblByName.put(cd.getUniqueName(), cd);
        }
        if (!tblByUID.isEmpty()) {
            enmr = tblBase.elements();
            while (enmr.hasMoreElements()) {
                Component cdThis;
                Component cdBase = (Component)enmr.nextElement();
                uid = cdBase.getUID();
                if (uid == null || (cdThis = (Component)tblByUID.get(uid)) == null) continue;
                tblResult.put(cdBase.getUniqueName(), cdThis);
                tblByName.remove(cdThis.getUniqueName());
            }
        }
        enmr = tblBase.keys();
        while (enmr.hasMoreElements()) {
            String sChild = (String)enmr.nextElement();
            if (tblResult.contains(sChild)) continue;
            Component cd2 = (Component)tblByName.get(sChild);
            tblResult.put(sChild, cd2);
            if (cd2 == null) continue;
            tblByName.remove(sChild);
        }
        enmr = tblByName.elements();
        while (enmr.hasMoreElements()) {
            cd = (Component)enmr.nextElement();
            String sChild = cd.getUniqueName();
            if (tblResult.contains(sChild)) {
                String sCode = fResolve ? "RES-103" : "EXT-103";
                this.logError(sCode, 2, new Object[]{sChild, this.toPathString()}, errlist);
                continue;
            }
            tblResult.put(sChild, cd);
        }
        return tblResult;
    }

    @Override
    protected boolean isDiscardable() {
        int nMode = this.getMode();
        switch (nMode) {
            case 1: {
                return false;
            }
            case 2: 
            case 3: {
                if (!((this.m_nFlags & 0x9255549) != 0 || !this.isComplex() && this.getParent() == null && nMode == 2 || this.m_integration != null && !this.m_integration.isDiscardable() || !this.m_tblImplements.isEmpty()) && this.m_tblDispatches.isEmpty()) break;
                return false;
            }
        }
        return super.isDiscardable();
    }

    @Override
    protected boolean isClassDiscardable(Trait base) {
        int nExistsThat;
        int nExistsThis;
        Component that = (Component)base;
        if (that == null) {
            return false;
        }
        if (this.isGlobal()) {
            return false;
        }
        if (this.isStatic()) {
            for (Component cd = this.getParent(); cd != null; cd = cd.getParent()) {
                if ((cd.m_nFlags & 6) != 2) continue;
                return false;
            }
        }
        if ((nExistsThis = this.m_nFlags & 6) != (nExistsThat = that.m_nFlags & 6)) {
            boolean fThatExists;
            boolean fThisExists = nExistsThis == 2 || nExistsThis == 0;
            boolean bl = fThatExists = nExistsThat == 2 || nExistsThat == 0;
            if (fThisExists != fThatExists) {
                return false;
            }
        }
        if (this.m_integration != null && !this.m_integration.isDiscardable() || !this.m_tblImplements.keysEquals(that.m_tblImplements) || !this.m_tblDispatches.keysEquals(that.m_tblDispatches)) {
            return false;
        }
        if (((this.m_nFlags ^ that.m_nFlags) & 0x1A2A30) != 0) {
            return false;
        }
        StringTable tblStateThis = this.m_tblState;
        StringTable tblStateThat = that.m_tblState;
        Enumeration enmr = tblStateThis.keys();
        while (enmr.hasMoreElements()) {
            Property propThat;
            String s = (String)enmr.nextElement();
            Property propThis = (Property)tblStateThis.get(s);
            if (propThis.isClassDiscardable(propThat = (Property)tblStateThat.get(s))) continue;
            return false;
        }
        StringTable tblBehaviorThis = this.m_tblBehavior;
        StringTable tblBehaviorThat = that.m_tblBehavior;
        Enumeration enmr2 = tblBehaviorThis.keys();
        while (enmr2.hasMoreElements()) {
            Behavior behThat;
            String s = (String)enmr2.nextElement();
            Behavior behThis = (Behavior)tblBehaviorThis.get(s);
            if (behThis.isClassDiscardable(behThat = (Behavior)tblBehaviorThat.get(s))) continue;
            return false;
        }
        if (!this.m_tblCategories.keysEquals(that.m_tblCategories)) {
            return false;
        }
        return super.isClassDiscardable(base);
    }

    @Override
    public boolean isModifiable() {
        if (this.m_fReadOnly) {
            return false;
        }
        if (this.m_nType == 0 && (this.m_nPrevFlags & 0x2000) != 0) {
            return false;
        }
        return super.isModifiable();
    }

    protected void setModifiable(boolean fModifiable) {
        this.m_fReadOnly = !fModifiable;
    }

    @Override
    protected Enumeration getSubTraits() {
        ChainedEnumerator enmr = new ChainedEnumerator();
        if (this.m_integration != null) {
            enmr.addEnumeration(new SimpleEnumerator<Object>(new Object[]{this.m_integration}));
        }
        enmr.addEnumeration(this.m_tblImplements.elements());
        enmr.addEnumeration(this.m_tblDispatches.elements());
        enmr.addEnumeration(this.m_tblState.elements());
        enmr.addEnumeration(this.m_tblBehavior.elements());
        enmr.addEnumeration(this.m_tblChildren.elements());
        return enmr;
    }

    @Override
    protected synchronized void invalidate() {
        super.invalidate();
        this.m_sName = null;
        this.m_sSuper = null;
        this.m_integration = null;
        this.m_tblImplements = null;
        this.m_tblDispatches = null;
        this.m_tblBehavior = null;
        this.m_tblState = null;
        this.m_tblCategories = null;
        this.m_tblChildren = null;
    }

    @Override
    protected String getUniqueName() {
        return this.m_sName;
    }

    @Override
    protected String getUniqueDescription() {
        return this.DESCRIPTORS[this.m_nType] + " " + this.getUniqueName();
    }

    @Override
    public boolean isDeclaredAtThisLevel() {
        Trait trait = this.getParentTrait();
        if (trait != null && trait instanceof Component) {
            return this.getExists() == 2 && this.m_fBaseLevel;
        }
        return super.isDeclaredAtThisLevel();
    }

    @Override
    public boolean isFromBase() {
        Trait trait = this.getParentTrait();
        if (trait != null && trait instanceof Component) {
            return this.getExists() == 2 && !this.m_fBaseLevel;
        }
        return super.isFromBase();
    }

    @Override
    public boolean isFromSuper() {
        Trait trait = this.getParentTrait();
        if (trait != null && trait instanceof Component) {
            return this.getExists() != 2;
        }
        return super.isFromSuper();
    }

    public boolean isComponent() {
        return this.m_nType == 0;
    }

    public boolean isGlobal() {
        return this.getParentTrait() == null;
    }

    public Component getParent() {
        return (Component)this.getParentTrait();
    }

    public Component getGlobalParent() {
        Component cdParent = this;
        while (!cdParent.isGlobal()) {
            cdParent = cdParent.getParent();
        }
        return cdParent;
    }

    public boolean isComplex() {
        return this.m_nType == 1;
    }

    public Property getComplex() {
        return (Property)this.getParentTrait();
    }

    public boolean isSignature() {
        return this.m_nType == 2;
    }

    public boolean isClass() {
        return this.m_nType == 2 && (this.m_nFlags & 0x40000000) == 0;
    }

    public boolean isInterface() {
        return this.m_nType == 2 && (this.m_nFlags & 0x40000000) != 0;
    }

    public boolean isThrowable() {
        return this.m_nType == 2 && (this.m_nFlags & Integer.MIN_VALUE) != 0;
    }

    public String getName() {
        return this.m_sName;
    }

    public String getQualifiedName() {
        String sName = this.m_sName;
        if (this.isComponent()) {
            Component cdParent = this.getParent();
            if (cdParent != null) {
                return new StringBuffer().append(cdParent.getQualifiedName()).append('$').append(sName).toString();
            }
            String sSuper = this.m_sSuper;
            if (sSuper.length() > 0) {
                return new StringBuffer().append(sSuper).append('.').append(sName).toString();
            }
        }
        return sName;
    }

    public String getLocalName() {
        return Component.getLocalName(this.getQualifiedName());
    }

    public String getSuperName() {
        if (this.isComponent() && this.getParent() != null && this.getExists() != 2) {
            return new StringBuffer().append(this.getParent().getSuperName()).append('$').append(this.m_sName).toString();
        }
        return this.m_sSuper;
    }

    public String getGlobalSuperName() {
        return this.m_sSuper;
    }

    public boolean isImpactedBy(String sName) {
        if (Component.isDerivedFrom(this.getGlobalSuperName(), sName)) {
            return true;
        }
        String[] asChildren = this.getChildren();
        for (int i = 0; i < asChildren.length; ++i) {
            Component child = this.getChild(asChildren[i]);
            if (child == null || !child.isImpactedBy(sName)) continue;
            return true;
        }
        return false;
    }

    public boolean isNameSettable() {
        if (!this.isComponent() || !this.isModifiable()) {
            return false;
        }
        if (this.getParent() != null) {
            return this.isDeclaredAtThisLevel();
        }
        return this.m_fBaseLevel;
    }

    public boolean isNameLegal(String sName) {
        if (this.isComponent()) {
            Component cdParent = this.getParent();
            if (cdParent == null) {
                return Component.isSimpleNameLegal(sName, true) && this.m_sSuper != "";
            }
            return Component.isSimpleNameLegal(sName, false) && (sName.equalsIgnoreCase(this.m_sName) || !cdParent.isChild(sName));
        }
        return false;
    }

    public void setName(String sName) throws PropertyVetoException {
        this.setName(sName, true);
    }

    protected synchronized void setName(String sName, boolean fVetoable) throws PropertyVetoException {
        String sPrev = this.m_sName;
        if (sName.equals(sPrev)) {
            return;
        }
        if (fVetoable) {
            if (!this.isNameSettable()) {
                this.readOnlyAttribute(ATTR_NAME, sPrev, sName);
            }
            if (!this.isNameLegal(sName)) {
                this.illegalAttributeValue(ATTR_NAME, sPrev, sName);
            }
            this.fireVetoableChange(ATTR_NAME, sPrev, sName);
        }
        this.m_sName = sName;
        if (this.getParent() != null) {
            this.getParent().renameChild(sPrev, sName);
        }
        this.firePropertyChange(ATTR_NAME, sPrev, sName);
    }

    protected int getExists() {
        return this.m_nFlags & 6;
    }

    protected void setExists(int nExists) {
        this.m_nFlags = this.m_nFlags & 0xFFFFFFF9 | nExists;
    }

    public int getVisible() {
        return this.m_nFlags & 0x6000000;
    }

    public boolean isVisibleSettable() {
        return this.isComponent() && this.isModifiable();
    }

    public boolean isVisibleLegal(int nVis) {
        switch (nVis) {
            case 0: 
            case 0x2000000: 
            case 0x4000000: 
            case 0x6000000: {
                return true;
            }
        }
        return false;
    }

    public void setVisible(int nVis) throws PropertyVetoException {
        this.setVisible(nVis, true);
    }

    protected synchronized void setVisible(int nVis, boolean fVetoable) throws PropertyVetoException {
        int nPrevVis = this.getVisible();
        if (nVis == nPrevVis) {
            return;
        }
        Integer prev = nPrevVis;
        Integer value = nVis;
        if (fVetoable) {
            if (!this.isVisibleSettable()) {
                this.readOnlyAttribute(ATTR_VISIBLE, prev, value);
            }
            if (!this.isVisibleLegal(nVis)) {
                this.illegalAttributeValue(ATTR_VISIBLE, prev, value);
            }
            this.fireVetoableChange(ATTR_VISIBLE, prev, value);
        }
        this.m_nFlags = this.m_nFlags & 0xF9FFFFFF | nVis;
        this.firePropertyChange(ATTR_VISIBLE, prev, value);
    }

    public int getAccess() {
        return this.m_nType == 2 ? this.m_nFlags & 0x30 : 48;
    }

    public boolean isStatic() {
        return (this.m_nFlags & 0x200) == 512;
    }

    public boolean isStaticSettable() {
        if (this.isComponent() && this.isModifiable() && (this.getParent() == null || this.isDeclaredAtThisLevel())) {
            return (this.m_nPrevFlags & 0x200) == 0;
        }
        return false;
    }

    public void setStatic(boolean fStatic) throws PropertyVetoException {
        this.setStatic(fStatic, true);
    }

    protected synchronized void setStatic(boolean fStatic, boolean fVetoable) throws PropertyVetoException {
        boolean fPrevStatic = this.isStatic();
        if (fStatic == fPrevStatic) {
            return;
        }
        Boolean prev = Component.toBoolean(fPrevStatic);
        Boolean value = Component.toBoolean(fStatic);
        if (fVetoable) {
            if (!this.isStaticSettable()) {
                this.readOnlyAttribute(ATTR_STATIC, prev, value);
            }
            this.fireVetoableChange(ATTR_STATIC, prev, value);
        }
        this.m_nFlags = this.m_nFlags & 0xFFFFFDFF | (fStatic ? 512 : 0);
        this.firePropertyChange(ATTR_STATIC, prev, value);
    }

    public boolean isAbstract() {
        return (this.m_nFlags & 0x800) == 2048;
    }

    public boolean isAbstractSettable() {
        return this.isComponent() && this.isModifiable();
    }

    public void setAbstract(boolean fAbstract) throws PropertyVetoException {
        this.setAbstract(fAbstract, true);
    }

    protected synchronized void setAbstract(boolean fAbstract, boolean fVetoable) throws PropertyVetoException {
        boolean fPrevAbstract = this.isAbstract();
        if (fAbstract == fPrevAbstract) {
            return;
        }
        Boolean prev = Component.toBoolean(fPrevAbstract);
        Boolean value = Component.toBoolean(fAbstract);
        if (fVetoable) {
            if (!this.isAbstractSettable()) {
                this.readOnlyAttribute(ATTR_ABSTRACT, prev, value);
            }
            this.fireVetoableChange(ATTR_ABSTRACT, prev, value);
        }
        this.m_nFlags = this.m_nFlags & 0xFFFFF7FF | (fAbstract ? 2048 : 0);
        this.firePropertyChange(ATTR_ABSTRACT, prev, value);
    }

    public boolean isResultAbstract() {
        return this.isAbstract() || this.hasAbstractBehavior() || this.containsAbstractComponent();
    }

    public boolean hasAbstractBehavior() {
        Enumeration enmr = this.m_tblBehavior.elements();
        while (enmr.hasMoreElements()) {
            if (!((Behavior)enmr.nextElement()).isAbstract()) continue;
            return true;
        }
        return false;
    }

    public boolean containsAbstractComponent() {
        Enumeration enmr = this.m_tblChildren.elements();
        while (enmr.hasMoreElements()) {
            if (!((Component)enmr.nextElement()).isResultAbstract()) continue;
            return true;
        }
        return false;
    }

    public boolean isFinal() {
        return (this.m_nFlags & 0x2000) == 8192;
    }

    public boolean isFinalSettable() {
        return this.isComponent() && this.isModifiable();
    }

    public void setFinal(boolean fFinal) throws PropertyVetoException {
        this.setFinal(fFinal, true);
    }

    protected synchronized void setFinal(boolean fFinal, boolean fVetoable) throws PropertyVetoException {
        boolean fPrevFinal = this.isFinal();
        if (fFinal == fPrevFinal) {
            return;
        }
        Boolean prev = Component.toBoolean(fPrevFinal);
        Boolean value = Component.toBoolean(fFinal);
        if (fVetoable) {
            if (!this.isFinalSettable()) {
                this.readOnlyAttribute(ATTR_FINAL, prev, value);
            }
            this.fireVetoableChange(ATTR_FINAL, prev, value);
        }
        this.m_nFlags = this.m_nFlags & 0xFFFFDFFF | (fFinal ? 8192 : 0);
        this.firePropertyChange(ATTR_FINAL, prev, value);
    }

    public boolean isDeprecated() {
        return (this.m_nFlags & 0x8000) == 32768;
    }

    public boolean isDeprecatedSettable() {
        return this.isComponent() && this.isModifiable();
    }

    public void setDeprecated(boolean fDeprecated) throws PropertyVetoException {
        this.setDeprecated(fDeprecated, true);
    }

    protected synchronized void setDeprecated(boolean fDeprecated, boolean fVetoable) throws PropertyVetoException {
        boolean fPrevDeprecated = this.isDeprecated();
        if (fDeprecated == fPrevDeprecated) {
            return;
        }
        Boolean prev = Component.toBoolean(fPrevDeprecated);
        Boolean value = Component.toBoolean(fDeprecated);
        if (fVetoable) {
            if (!this.isDeprecatedSettable()) {
                this.readOnlyAttribute(ATTR_DEPRECATED, prev, value);
            }
            this.fireVetoableChange(ATTR_DEPRECATED, prev, value);
        }
        this.m_nFlags = this.m_nFlags & 0xFFFF7FFF | (fDeprecated ? 32768 : 0);
        this.firePropertyChange(ATTR_DEPRECATED, prev, value);
    }

    public boolean isPersistent() {
        return (this.m_nFlags & 0x20000) == 131072;
    }

    public boolean isPersistentSettable() {
        return this.isComponent() && this.isModifiable();
    }

    public void setPersistent(boolean fPersistent) throws PropertyVetoException {
        this.setPersistent(fPersistent, true);
    }

    protected synchronized void setPersistent(boolean fPersistent, boolean fVetoable) throws PropertyVetoException {
        boolean fPrevPersistent = this.isPersistent();
        if (fPersistent == fPrevPersistent) {
            return;
        }
        Boolean prev = Component.toBoolean(fPrevPersistent);
        Boolean value = Component.toBoolean(fPersistent);
        if (fVetoable) {
            if (!this.isPersistentSettable()) {
                this.readOnlyAttribute(ATTR_PERSISTENT, prev, value);
            }
            this.fireVetoableChange(ATTR_PERSISTENT, prev, value);
        }
        this.m_nFlags = this.m_nFlags & 0xFFFDFFFF | (fPersistent ? 131072 : 0);
        this.firePropertyChange(ATTR_PERSISTENT, prev, value);
    }

    public boolean isRemote() {
        return (this.m_nFlags & 0x180000) == 0x180000;
    }

    public boolean isRemoteSettable() {
        return this.isComponent() && this.isGlobal() && this.isModifiable() && (this.m_nPrevFlags & 0x180000) != 0x180000;
    }

    public void setRemote(boolean fRemote) throws PropertyVetoException {
        this.setRemote(fRemote, true);
    }

    protected synchronized void setRemote(boolean fRemote, boolean fVetoable) throws PropertyVetoException {
        boolean fPrevRemote = this.isRemote();
        if (fRemote == fPrevRemote) {
            return;
        }
        Boolean prev = Component.toBoolean(fPrevRemote);
        Boolean value = Component.toBoolean(fRemote);
        if (fVetoable) {
            if (!this.isRemoteSettable()) {
                this.readOnlyAttribute(ATTR_REMOTE, prev, value);
            }
            this.fireVetoableChange(ATTR_REMOTE, prev, value);
        }
        this.m_nFlags = this.m_nFlags & 0xFFE7FFFF | (fRemote ? 0x180000 : 524288);
        if (fPrevRemote) {
            Enumeration enmr = this.m_tblBehavior.elements();
            while (enmr.hasMoreElements()) {
                ((Behavior)enmr.nextElement()).setRemote(false, false);
            }
        }
        this.firePropertyChange(ATTR_REMOTE, prev, value);
    }

    public Integration getIntegration() {
        return this.m_integration;
    }

    public boolean isIntegrationSettable() {
        return this.isComponent() && this.getParent() == null && this.m_fBaseLevel && this.isModifiable();
    }

    public boolean isIntegrationLegal(Component cdJCS) {
        return this.isIntegrationLegal(cdJCS, null);
    }

    public boolean isIntegrationLegal(Component cdJCS, ErrorList errlist) {
        Integration map = this.m_integration;
        if (map != null) {
            if (cdJCS == null) {
                return map.getPreviousSignature().length() == 0;
            }
            return map.isSignatureLegal(cdJCS.getQualifiedName());
        }
        return true;
    }

    public void setIntegration(Component cdJCS, ErrorList errlist) throws PropertyVetoException {
        this.setIntegration(cdJCS, errlist, true);
    }

    protected synchronized void setIntegration(Component cdJCS, ErrorList errlist, boolean fVetoable) throws PropertyVetoException {
        Integration mapNew;
        Integration mapPrev = this.m_integration;
        if (mapPrev != null && cdJCS != null) {
            mapPrev.setSignature(cdJCS.getQualifiedName(), fVetoable);
            return;
        }
        Integration integration = mapNew = cdJCS == null ? null : new Integration(this, cdJCS.getQualifiedName());
        if (mapNew == null ? mapPrev == null : mapNew.equals(mapPrev)) {
            return;
        }
        if (fVetoable) {
            if (!this.isIntegrationSettable()) {
                this.readOnlyAttribute(ATTR_INTEGRATION, mapPrev, mapNew);
            }
            if (!this.isIntegrationLegal(cdJCS, errlist)) {
                this.illegalAttributeValue(ATTR_INTEGRATION, mapPrev, mapNew);
            }
            this.fireVetoableChange(ATTR_INTEGRATION, mapPrev, mapNew);
        }
        this.m_integration = mapNew;
        if (mapNew != null) {
            mapNew.validate();
        }
        this.firePropertyChange(ATTR_INTEGRATION, mapPrev, mapNew);
        if (mapPrev != null) {
            mapPrev.invalidate();
        }
    }

    public String[] getImplements() {
        return this.m_tblImplements.strings();
    }

    public Interface getImplements(String sIface) {
        return (Interface)this.m_tblImplements.get(sIface);
    }

    public boolean isImplementsAddable(Component cdJCS) {
        return this.isImplementsAddable(cdJCS, null);
    }

    public boolean isImplementsAddable(Component cdJCS, ErrorList errlist) {
        Interface iface;
        try {
            iface = new Interface(this, cdJCS, false);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return this.isImplementsAddable(iface, cdJCS, errlist);
    }

    protected boolean isImplementsAddable(Interface iface, Component cdJCS, ErrorList errlist) {
        if (iface == null) {
            return false;
        }
        if (!this.isModifiable()) {
            return false;
        }
        switch (this.m_nType) {
            case 0: 
            case 2: {
                break;
            }
            default: {
                return false;
            }
        }
        String sIface = iface.getName();
        if (this.m_tblImplements.contains(sIface) || this.m_tblDispatches.contains(sIface)) {
            return true;
        }
        if (!iface.getBehaviors().hasMoreElements()) {
            return true;
        }
        return this.isInterfaceExpandable(iface, cdJCS, errlist);
    }

    public void addImplements(Component cdJCS) throws PropertyVetoException {
        this.addImplements(cdJCS, true);
    }

    protected synchronized void addImplements(Component cdJCS, boolean fVetoable) throws PropertyVetoException {
        String sIface = cdJCS.getName();
        if (this.m_tblImplements.contains(sIface)) {
            return;
        }
        Interface iface = null;
        try {
            iface = new Interface(this, cdJCS, false);
        }
        catch (IllegalArgumentException e) {
            this.subNotAddable(ATTR_IMPLEMENTS, sIface);
        }
        if (fVetoable) {
            if (!this.isImplementsAddable(iface, cdJCS, null)) {
                this.subNotAddable(ATTR_IMPLEMENTS, sIface);
            }
            this.fireVetoableChange(ATTR_IMPLEMENTS, null, iface);
        }
        this.m_tblImplements.put(sIface, iface);
        this.expandInterface(iface, cdJCS, null, null, null);
        iface.validate();
        this.firePropertyChange(ATTR_IMPLEMENTS, null, iface);
    }

    public boolean isImplementsRemovable(String sIface) {
        Interface iface = (Interface)this.m_tblImplements.get(sIface);
        return iface != null && this.isModifiable() && iface.isDeclaredAtThisLevel();
    }

    public void removeImplements(String sIface) throws PropertyVetoException {
        this.removeImplements(sIface, true);
    }

    protected synchronized void removeImplements(String sIface, boolean fVetoable) throws PropertyVetoException {
        Interface iface = (Interface)this.m_tblImplements.get(sIface);
        if (iface == null) {
            return;
        }
        if (fVetoable) {
            if (!this.isImplementsRemovable(sIface)) {
                this.subNotRemovable(ATTR_IMPLEMENTS, iface);
            }
            this.fireVetoableChange(ATTR_IMPLEMENTS, iface, null);
        }
        this.m_tblImplements.remove(sIface);
        Enumeration enmr = iface.getBehaviors();
        while (enmr.hasMoreElements()) {
            String sBehavior = (String)enmr.nextElement();
            Behavior behavior = (Behavior)this.m_tblBehavior.get(sBehavior);
            if (behavior == null) continue;
            behavior.removeOriginTrait(iface);
            if (!behavior.isDiscardable()) continue;
            this.removeBehavior(behavior, false);
        }
        this.firePropertyChange(ATTR_IMPLEMENTS, iface, null);
        iface.invalidate();
    }

    public String[] getDispatches() {
        return this.m_tblDispatches.strings();
    }

    public Interface getDispatches(String sIface) {
        return (Interface)this.m_tblDispatches.get(sIface);
    }

    public boolean isDispatchesAddable(Component cdJCS) {
        return this.isDispatchesAddable(cdJCS, null);
    }

    public boolean isDispatchesAddable(Component cdJCS, ErrorList errlist) {
        Interface iface;
        try {
            iface = new Interface(this, cdJCS, true);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return this.isDispatchesAddable(iface, cdJCS, errlist);
    }

    protected boolean isDispatchesAddable(Interface iface, Component cdJCS, ErrorList errlist) {
        if (iface == null) {
            return false;
        }
        if (!this.isModifiable()) {
            return false;
        }
        switch (this.m_nType) {
            case 0: 
            case 2: {
                break;
            }
            default: {
                return false;
            }
        }
        String sIface = iface.getName();
        if (this.m_tblDispatches.contains(sIface)) {
            return true;
        }
        if (!sIface.endsWith("Listener")) {
            return false;
        }
        String sClass = DataType.getClassType(sIface).getTypeString();
        String sSig = sIface.substring(sIface.lastIndexOf(46) + 1) + "(" + sClass + ")";
        Behavior behAdd = (Behavior)this.m_tblBehavior.get("add" + sSig);
        Behavior behRemove = (Behavior)this.m_tblBehavior.get("remove" + sSig);
        if (behAdd != null && behAdd.isFromSuper() || behRemove != null && behRemove.isFromSuper()) {
            return false;
        }
        return this.isInterfaceExpandable(iface, cdJCS, errlist);
    }

    public void addDispatches(Component cdJCS) throws PropertyVetoException {
        this.addDispatches(cdJCS, true);
    }

    protected synchronized void addDispatches(Component cdJCS, boolean fVetoable) throws PropertyVetoException {
        String sIface = cdJCS.getName();
        if (this.m_tblDispatches.contains(sIface)) {
            return;
        }
        Interface iface = null;
        try {
            iface = new Interface(this, cdJCS, true);
        }
        catch (IllegalArgumentException e) {
            this.subNotAddable(ATTR_DISPATCHES, sIface);
        }
        if (fVetoable) {
            if (!this.isDispatchesAddable(iface, cdJCS, null)) {
                this.subNotAddable(ATTR_DISPATCHES, sIface);
            }
            this.fireVetoableChange(ATTR_DISPATCHES, null, iface);
        }
        this.m_tblDispatches.put(sIface, iface);
        this.expandInterface(iface, cdJCS, null, null, null);
        iface.validate();
        this.firePropertyChange(ATTR_DISPATCHES, null, iface);
    }

    public boolean isDispatchesRemovable(String sIface) {
        Interface iface = (Interface)this.m_tblDispatches.get(sIface);
        return iface != null && this.isModifiable() && iface.isDeclaredAtThisLevel();
    }

    public void removeDispatches(String sIface) throws PropertyVetoException {
        this.removeDispatches(sIface, true);
    }

    protected synchronized void removeDispatches(String sIface, boolean fVetoable) throws PropertyVetoException {
        Interface iface = (Interface)this.m_tblDispatches.get(sIface);
        if (iface == null) {
            return;
        }
        if (fVetoable) {
            if (!this.isDispatchesRemovable(sIface)) {
                this.subNotRemovable(ATTR_DISPATCHES, iface);
            }
            this.fireVetoableChange(ATTR_DISPATCHES, iface, null);
        }
        this.m_tblDispatches.remove(sIface);
        Enumeration enmr = iface.getBehaviors();
        while (enmr.hasMoreElements()) {
            String sBehavior = (String)enmr.nextElement();
            Behavior behavior = (Behavior)this.m_tblBehavior.get(sBehavior);
            behavior.removeOriginTrait(iface);
            if (!behavior.isDiscardable()) continue;
            this.removeBehavior(behavior, false);
        }
        this.firePropertyChange(ATTR_DISPATCHES, iface, null);
        iface.invalidate();
    }

    protected boolean isInterfaceExpandable(Interface iface, Component cdJCS, ErrorList errlist) {
        boolean fExpandable = true;
        String sAttribute = iface.getType() == 2 ? ATTR_DISPATCHES : ATTR_IMPLEMENTS;
        try {
            StringTable tblMethod = cdJCS.m_tblBehavior;
            StringTable tblBehavior = this.m_tblBehavior;
            Enumeration enmr = iface.getBehaviors();
            while (enmr.hasMoreElements()) {
                int nSeverity;
                String sSignature = (String)enmr.nextElement();
                Behavior method = (Behavior)tblMethod.get(sSignature);
                Behavior behavior = (Behavior)tblBehavior.get(sSignature);
                if (behavior == null) {
                    if (!this.isBehaviorReserved(sSignature)) continue;
                    fExpandable = false;
                    this.logError("IFACE-101", 2, new Object[]{sAttribute, iface.getName(), this.getQualifiedName(), sSignature}, errlist);
                    continue;
                }
                DataType dtMethodRet = DataType.VOID;
                String sMethodParamDirs = "I";
                if (method != null) {
                    dtMethodRet = method.getReturnValue().getDataType();
                    sMethodParamDirs = method.getParameterDirections();
                }
                boolean fFixable = !behavior.isFromNonManual();
                int n = nSeverity = fFixable ? 1 : 2;
                if (this.isComponent() && behavior.isStatic()) {
                    fExpandable = fExpandable && fFixable;
                    this.logError("IFACE-102", nSeverity, new Object[]{sAttribute, iface.getName(), this.getQualifiedName(), sSignature}, errlist);
                }
                if (dtMethodRet != behavior.getReturnValue().getDataType() && !this.isSignature()) {
                    fExpandable = fExpandable && fFixable;
                    this.logError("IFACE-103", nSeverity, new Object[]{sAttribute, iface.getName(), this.getQualifiedName(), sSignature, behavior.getReturnValue().getDataType().toString(), dtMethodRet.toString()}, errlist);
                }
                if (!sMethodParamDirs.equals(behavior.getParameterDirections())) {
                    fExpandable = fExpandable && fFixable;
                    this.logError("IFACE-104", nSeverity, new Object[]{sAttribute, iface.getName(), this.getQualifiedName(), sSignature}, errlist);
                }
                if (!this.isComponent() || behavior.getAccess() == 48) continue;
                fExpandable = fExpandable && fFixable;
                this.logError("IFACE-105", nSeverity, new Object[]{sAttribute, iface.getName(), this.getQualifiedName(), sSignature}, errlist);
            }
        }
        catch (DerivationException derivationException) {
            // empty catch block
        }
        return fExpandable;
    }

    protected void expandInterface(Interface iface, Component cdJCS, StringTable tblDeferBehavior, StringTable tblDeferProperty, ErrorList errlist) throws PropertyVetoException {
        StringTable tblMethod = cdJCS.m_tblBehavior;
        StringTable tblBehavior = this.m_tblBehavior;
        Enumeration enmr = iface.getBehaviors();
        while (enmr.hasMoreElements()) {
            String sSig = (String)enmr.nextElement();
            Behavior method = (Behavior)tblMethod.get(sSig);
            Behavior behavior = (Behavior)tblBehavior.get(sSig);
            if (method != null && method.isStatic() && this.isComponent()) continue;
            if (behavior == null && tblDeferBehavior != null && (behavior = (Behavior)tblDeferBehavior.get(sSig)) != null) {
                tblDeferBehavior.remove(sSig);
                behavior = new Behavior(this, behavior);
                behavior.setExists(2);
                tblBehavior.put(sSig, behavior);
            }
            if (behavior == null) {
                behavior = method == null ? new Behavior(this, iface, sSig) : new Behavior(this, iface, method);
                this.addBehavior(behavior, false);
            } else if (method == null || behavior.getReturnValue().getDataType() == method.getReturnValue().getDataType()) {
                behavior.setDeclaredByInterface(iface, method);
            }
            if (!iface.isFromBase() || !behavior.isDeclaredAtThisLevel()) continue;
            behavior.setFromBase();
        }
        if (this.isSignature()) {
            StringTable tblField = cdJCS.m_tblState;
            StringTable tblProperty = this.m_tblState;
            Enumeration enmr2 = iface.getProperties();
            while (enmr2.hasMoreElements()) {
                String sProp = (String)enmr2.nextElement();
                Property field = (Property)tblField.get(sProp);
                Property property = (Property)tblProperty.get(sProp);
                if (property == null && tblDeferProperty != null && (property = (Property)tblDeferProperty.get(sProp)) != null) continue;
                if (property == null) {
                    property = new Property(this, field, iface);
                    this.addProperty(property, false);
                } else if (property.getExists() == 6) {
                    property.mergeJCSFields(field);
                    property.addOriginTrait(iface);
                }
                if (!iface.isFromBase() || !property.isDeclaredAtThisLevel()) continue;
                property.setFromBase();
            }
        }
    }

    public String[] getProperty() {
        return this.m_tblState.strings();
    }

    public Enumeration getProperties() {
        return this.m_tblState.elements();
    }

    public Property getProperty(String sProp) {
        return (Property)this.m_tblState.get(sProp);
    }

    public int getPropertyCount() {
        return this.m_tblState.getSize();
    }

    public boolean isJavaConstantAddable(DataType dt, String sName, int nIndexed, boolean fStatic, int nAccess) {
        return Property.isJavaConstantCreatable(this, dt, sName, nIndexed, fStatic, nAccess);
    }

    public Property addJavaConstant(DataType dt, String sName, int nIndexed, boolean fStatic, int nAccess) throws PropertyVetoException {
        if (!this.isJavaConstantAddable(dt, sName, nIndexed, fStatic, nAccess)) {
            this.subNotAddable(ATTR_PROPERTY, sName);
        }
        Property property = Property.createJavaConstant(this, dt, sName, nIndexed, fStatic, nAccess);
        property.setFromManual();
        this.addProperty(property, true);
        return property;
    }

    public boolean isVirtualConstantAddable(DataType dt, String sName, int nIndexed, int nAccess) {
        return Property.isVirtualConstantCreatable(this, dt, sName, nIndexed, nAccess);
    }

    public Property addVirtualConstant(DataType dt, String sName, int nIndexed, int nAccess) throws PropertyVetoException {
        if (!this.isVirtualConstantAddable(dt, sName, nIndexed, nAccess)) {
            this.subNotAddable(ATTR_PROPERTY, sName);
        }
        Property property = Property.createVirtualConstant(this, dt, sName, nIndexed, nAccess);
        property.setFromManual();
        this.addProperty(property, true);
        return property;
    }

    public boolean isCalculatedPropertyAddable(DataType dt, String sName, int nIndexed, boolean fStatic) {
        return Property.isCalculatedPropertyCreatable(this, dt, sName, nIndexed, fStatic);
    }

    public Property addCalculatedProperty(DataType dt, String sName, int nIndexed, boolean fStatic) throws PropertyVetoException {
        if (!this.isCalculatedPropertyAddable(dt, sName, nIndexed, fStatic)) {
            this.subNotAddable(ATTR_PROPERTY, sName);
        }
        Property property = Property.createCalculatedProperty(this, dt, sName, nIndexed, fStatic);
        property.setFromManual();
        this.addProperty(property, true);
        return property;
    }

    public boolean isFunctionalPropertyAddable(DataType dt, String sName, int nIndexed, boolean fStatic) {
        return Property.isFunctionalPropertyCreatable(this, dt, sName, nIndexed, fStatic);
    }

    public Property addFunctionalProperty(DataType dt, String sName, int nIndexed, boolean fStatic) throws PropertyVetoException {
        if (!this.isFunctionalPropertyAddable(dt, sName, nIndexed, fStatic)) {
            this.subNotAddable(ATTR_PROPERTY, sName);
        }
        Property property = Property.createFunctionalProperty(this, dt, sName, nIndexed, fStatic);
        property.setFromManual();
        this.addProperty(property, true);
        return property;
    }

    public boolean isPropertyAddable(DataType dt, String sName, int nIndexed, boolean fStatic, boolean fPersist) {
        return Property.isPropertyCreatable(this, dt, sName, nIndexed, fStatic, fPersist);
    }

    public Property addProperty(DataType dt, String sName, int nIndexed, boolean fStatic, boolean fPersist) throws PropertyVetoException {
        if (!this.isPropertyAddable(dt, sName, nIndexed, fStatic, fPersist)) {
            this.subNotAddable(ATTR_PROPERTY, sName);
        }
        Property property = Property.createProperty(this, dt, sName, nIndexed, fStatic, fPersist);
        property.setFromManual();
        this.addProperty(property, true);
        return property;
    }

    protected synchronized void addProperty(Property property, boolean fVetoable) throws PropertyVetoException {
        try {
            if (!this.isSignature()) {
                property.assignUID();
            }
            if (fVetoable) {
                this.fireVetoableSubChange(property, 1);
            }
            this.m_tblState.put(property.getName(), property);
            property.validate();
            this.fireSubChange(property, 1);
        }
        catch (PropertyVetoException e) {
            property.invalidate();
            throw e;
        }
    }

    public boolean isPropertyRemovable(String sProp) {
        Property property = this.getProperty(sProp);
        return property != null && property.isDeclaredAtThisLevel() && this.isModifiable() && !property.isFromNonManual();
    }

    public void removeProperty(String sProp) throws PropertyVetoException {
        if (!this.isPropertyRemovable(sProp)) {
            this.subNotRemovable(ATTR_PROPERTY, sProp);
        }
        this.removeProperty(this.getProperty(sProp), true);
    }

    protected synchronized void removeProperty(Property property, boolean fVetoable) throws PropertyVetoException {
        if (fVetoable) {
            this.fireVetoableSubChange(property, 2);
        }
        Behavior[] aBehavior = property.getAccessors();
        int cBehavior = aBehavior.length;
        for (int i = 0; i < cBehavior; ++i) {
            Behavior behavior = aBehavior[i];
            if (behavior == null || !property.isAccessorRemovable(i)) continue;
            property.removeAccessor(i);
        }
        this.m_tblState.remove(property.getName());
        this.fireSubChange(property, 2);
        property.invalidate();
    }

    protected void renameProperty(String sOld, String sNew) {
        this.m_tblState.put(sNew, this.m_tblState.remove(sOld));
    }

    public String[] getBehavior() {
        return this.m_tblBehavior.strings();
    }

    public Enumeration getBehaviors() {
        return this.m_tblBehavior.elements();
    }

    public Behavior getBehavior(String sSig) {
        return (Behavior)this.m_tblBehavior.get(sSig);
    }

    public Enumeration getBehaviors(String sName) {
        StringTable tblBehavior = this.m_tblBehavior;
        String[] asSig = tblBehavior.stringsStartingWith(sName + "(");
        int cSigs = asSig.length;
        if (cSigs == 0) {
            return NullImplementation.getEnumeration();
        }
        Behavior[] aBeh = new Behavior[cSigs];
        for (int i = 0; i < cSigs; ++i) {
            aBeh[i] = (Behavior)tblBehavior.get(asSig[i]);
        }
        return new SimpleEnumerator<Behavior>(aBeh);
    }

    public int getBehaviorCount() {
        return this.m_tblBehavior.getSize();
    }

    public boolean isBehaviorAddable(DataType dtRet, String sName, DataType[] adtParam) {
        String sSig = Behavior.getSignature(sName, adtParam);
        return this.isModifiable() && !this.m_tblBehavior.contains(sSig) && !this.isBehaviorReserved(sSig);
    }

    public Behavior addBehavior(DataType dtRet, String sName, DataType[] adtParam, boolean fStatic, int nAccess) throws PropertyVetoException {
        if (!this.isBehaviorAddable(dtRet, sName, adtParam)) {
            this.subNotAddable(ATTR_BEHAVIOR, sName);
        }
        Behavior behavior = new Behavior(this, dtRet, sName, fStatic, nAccess, adtParam, null, null);
        behavior.setFromManual();
        this.addBehavior(behavior, true);
        return behavior;
    }

    protected synchronized void addBehavior(Behavior behavior, boolean fVetoable) throws PropertyVetoException {
        try {
            if (!this.isSignature()) {
                behavior.assignUID();
            }
            if (fVetoable) {
                this.fireVetoableSubChange(behavior, 1);
            }
            this.m_tblBehavior.put(behavior.getSignature(), behavior);
            behavior.validate();
            this.fireSubChange(behavior, 1);
        }
        catch (PropertyVetoException e) {
            behavior.invalidate();
            throw e;
        }
    }

    public boolean isBehaviorRemovable(String sSig) {
        Behavior behavior = this.getBehavior(sSig);
        return this.isModifiable() && behavior != null && behavior.isDeclaredAtThisLevel() && !behavior.isFromNonManual();
    }

    public synchronized void removeBehavior(String sSig) throws PropertyVetoException {
        if (!this.isBehaviorRemovable(sSig)) {
            this.subNotRemovable(ATTR_BEHAVIOR, sSig);
        }
        this.removeBehavior(this.getBehavior(sSig), true);
    }

    protected synchronized void removeBehavior(Behavior behavior, boolean fVetoable) throws PropertyVetoException {
        if (fVetoable) {
            this.fireVetoableSubChange(behavior, 2);
        }
        this.m_tblBehavior.remove(behavior.getSignature());
        this.fireSubChange(behavior, 2);
        behavior.invalidate();
    }

    protected void renameBehavior(String sOld, String sNew) {
        this.m_tblBehavior.put(sNew, this.m_tblBehavior.remove(sOld));
    }

    protected boolean isBehaviorReserved(String sSig) {
        return Behavior.isSignatureReserved(this, sSig);
    }

    public String[] getCategories() {
        return this.m_tblCategories.strings();
    }

    public boolean isCategory(String sCategory) {
        return this.m_tblCategories.contains(sCategory);
    }

    public boolean isCategoryAddable(String sCategory) {
        return this.isModifiable() && sCategory != null && Component.isGlobalNameLegal(sCategory) && !this.m_tblCategories.contains(sCategory);
    }

    public void addCategory(String sCategory) throws PropertyVetoException {
        this.addCategory(sCategory, true);
    }

    protected synchronized void addCategory(String sCategory, boolean fVetoable) throws PropertyVetoException {
        if (this.m_tblCategories.contains(sCategory)) {
            return;
        }
        if (fVetoable) {
            if (!this.isCategoryAddable(sCategory)) {
                this.subNotAddable(ATTR_CATEGORY, sCategory);
            }
            this.fireVetoableChange(ATTR_CATEGORY, null, sCategory);
        }
        this.m_tblCategories.put(sCategory, Boolean.TRUE);
        this.firePropertyChange(ATTR_CATEGORY, null, sCategory);
    }

    public boolean isCategoryRemovable(String sCategory) {
        return this.isModifiable() && this.m_tblCategories.contains(sCategory) && (Boolean)this.m_tblCategories.get(sCategory) != false;
    }

    public void removeCategory(String sCategory) throws PropertyVetoException {
        this.removeCategory(sCategory, true);
    }

    protected synchronized void removeCategory(String sCategory, boolean fVetoable) throws PropertyVetoException {
        if (!this.m_tblCategories.contains(sCategory)) {
            return;
        }
        if (fVetoable) {
            if (!this.isCategoryRemovable(sCategory)) {
                this.subNotRemovable(ATTR_CATEGORY, sCategory);
            }
            this.fireVetoableChange(ATTR_CATEGORY, sCategory, null);
        }
        this.m_tblCategories.remove(sCategory);
        Enumeration enmr = this.m_tblChildren.elements();
        block0: while (enmr.hasMoreElements()) {
            Component cd = (Component)enmr.nextElement();
            if (!Component.isDerivedFrom(cd.getSuperName(), sCategory)) continue;
            Enumeration enmrCat = this.m_tblCategories.keys();
            while (enmrCat.hasMoreElements()) {
                if (!Component.isDerivedFrom(cd.getSuperName(), (String)enmrCat.nextElement())) continue;
                continue block0;
            }
            if (cd.getExists() != 2 || !cd.m_fBaseLevel) continue;
            this.removeChild(cd, false);
        }
        this.firePropertyChange(ATTR_CATEGORY, sCategory, null);
    }

    public String getCategory() {
        if (this.isGlobal()) {
            throw new IllegalStateException("Component is not child");
        }
        Component cdParent = this.getParent();
        String[] asCategory = cdParent.getCategories();
        for (int i = 0; i < asCategory.length; ++i) {
            String sCategory = asCategory[i];
            if (!this.isDerivedFrom(sCategory)) continue;
            return sCategory;
        }
        throw new IllegalStateException("Missing category for " + this.getQualifiedName());
    }

    public String[] getChildren() {
        return this.m_tblChildren.strings();
    }

    public boolean isChild(String sName) {
        return this.m_tblChildren.contains(sName);
    }

    public Component getChild(String sChild) {
        int nState;
        Component cd = (Component)this.m_tblChildren.get(sChild);
        if (cd != null && ((nState = cd.m_nFlags & 6) == 2 || nState == 0)) {
            return cd;
        }
        return null;
    }

    public Component getLocal(String sLocal) {
        Component cd = this;
        String[] asSimple = Component.parseDelimitedString(sLocal, '$');
        int c = asSimple.length;
        for (int i = 0; i < c && (cd = cd.getChild(asSimple[i])) != null; ++i) {
        }
        return cd;
    }

    public boolean isChildAddable(Component cdSuper, String sChild) {
        return this.isModifiable() && Component.isSimpleNameLegal(sChild, false) && !this.m_tblChildren.contains(sChild) && cdSuper.isGlobal() && !cdSuper.isFinal() && this.isChildSuperLegal(cdSuper.getQualifiedName());
    }

    public boolean isChildSuperLegal(String sSuper) {
        while (!this.m_tblCategories.contains(sSuper)) {
            int ofLastDot = sSuper.lastIndexOf(46);
            if (ofLastDot < 0) {
                return false;
            }
            sSuper = sSuper.substring(0, ofLastDot);
        }
        return true;
    }

    public Component addChild(Component cdSuper, String sChild) throws ComponentException, PropertyVetoException {
        return this.addChild(cdSuper, sChild, true);
    }

    protected Component addChild(Component cdSuper, String sChild, boolean fVetoable) throws ComponentException, PropertyVetoException {
        if (fVetoable && (cdSuper == null || cdSuper.getMode() != 1 || !this.isChildAddable(cdSuper, sChild))) {
            this.subNotAddable(ATTR_CHILD, sChild);
        }
        Component cdDelta = (Component)cdSuper.getNullDerivedTrait(this, 2);
        cdDelta.m_sSuper = cdSuper.getQualifiedName();
        cdDelta.m_sName = sChild;
        cdDelta.setExists(2);
        cdDelta.assignUID();
        NullStorage loader = new NullStorage();
        ErrorList errlist = new ErrorList();
        Component cdChild = (Component)cdSuper.resolve(cdDelta, this, loader, errlist);
        cdChild.finalizeResolve(loader, errlist);
        if (errlist.isSevere()) {
            errlist.print();
            throw new ComponentException("Component.addChild:  Serious errors occurred during resolution!");
        }
        return this.addChild(cdChild, fVetoable);
    }

    protected synchronized Component addChild(Component cdChild, boolean fVetoable) throws ComponentException, PropertyVetoException {
        try {
            cdChild.assignUID();
            if (fVetoable) {
                this.fireVetoableSubChange(cdChild, 1);
            }
            this.m_tblChildren.put(cdChild.getName(), cdChild);
            cdChild.validate();
            this.fireSubChange(cdChild, 1);
        }
        catch (PropertyVetoException e) {
            cdChild.invalidate();
            throw e;
        }
        return cdChild;
    }

    public boolean isChildRemovable(String sChild) {
        int nState;
        Component cd = (Component)this.m_tblChildren.get(sChild);
        return this.isModifiable() && cd != null && ((nState = cd.m_nFlags & 6) == 2 || nState == 0);
    }

    public void removeChild(String sChild) throws PropertyVetoException {
        if (!this.isChildRemovable(sChild)) {
            this.subNotRemovable(ATTR_CHILD, sChild);
        }
        this.removeChild((Component)this.m_tblChildren.get(sChild), true);
    }

    protected synchronized void removeChild(Component cd, boolean fVetoable) throws PropertyVetoException {
        boolean fDestroy;
        if (fVetoable) {
            this.fireVetoableSubChange(cd, 2);
        }
        if (fDestroy = cd.isDeclaredAtThisLevel()) {
            this.m_tblChildren.remove(cd.getName());
        } else {
            cd.m_nFlags = cd.m_nFlags & 0xFFFFFFF9 | 4;
        }
        this.fireSubChange(cd, 2);
        if (fDestroy) {
            cd.invalidate();
        }
    }

    public boolean isRelative(Component that) {
        return this.getGlobalParent() == that.getGlobalParent();
    }

    public boolean isChildCopyable(Component cdSuper, String sChild, Component cdChild) {
        if (cdSuper == null || sChild == null || cdChild == null) {
            return false;
        }
        if (!cdChild.isDerivedFrom(cdSuper.getQualifiedName())) {
            return false;
        }
        return this.isChildAddable(cdSuper, sChild);
    }

    public Component copyChild(Component cdSuper, String sChild, Component cdChild, Loader loader, ErrorList errlist) throws ComponentException, PropertyVetoException {
        return this.copyChild(cdSuper, sChild, cdChild, loader, errlist, true);
    }

    protected Component copyChild(Component cdSuper, String sChild, Component cdChild, Loader loader, ErrorList errlist, boolean fVetoable) throws ComponentException, PropertyVetoException {
        if (fVetoable && !this.isChildCopyable(cdSuper, sChild, cdChild)) {
            this.subNotAddable(ATTR_CHILD, sChild);
        }
        if (errlist == null) {
            errlist = new ErrorList();
        }
        Component cdDelta = (Component)cdChild.extract(cdSuper, this, loader, errlist);
        cdDelta.finalizeExtract(loader, errlist);
        if (errlist.isSevere()) {
            errlist.print();
            throw new ComponentException("Component.copyChild:  Serious errors occurred during extraction!");
        }
        cdDelta.clearUID();
        cdDelta.m_sSuper = cdSuper.getQualifiedName();
        cdDelta.m_sName = sChild;
        cdDelta.setExists(2);
        cdDelta.assignUID();
        cdChild = (Component)cdSuper.resolve(cdDelta, this, loader, errlist);
        cdChild.finalizeResolve(loader, errlist);
        if (errlist.isSevere()) {
            errlist.print();
            throw new ComponentException("Component.copyChild:  Serious errors occurred during resolution!");
        }
        return this.addChild(cdChild, fVetoable);
    }

    public boolean isChildMoveable(Component cdSuper, String sChild, Component cdChild) {
        if (!this.isChildCopyable(cdSuper, sChild, cdChild)) {
            return false;
        }
        if (!this.isRelative(cdChild)) {
            return false;
        }
        if (!cdChild.isDeclaredAtThisLevel()) {
            return false;
        }
        Component cdParent = cdChild.getParent();
        return cdParent != null && cdParent.isChildRemovable(cdChild.getName());
    }

    public Component moveChild(Component cdSuper, String sChild, Component cdChild, Loader loader, ErrorList errlist) throws ComponentException, PropertyVetoException {
        return this.moveChild(cdSuper, sChild, cdChild, loader, errlist, true);
    }

    protected Component moveChild(Component cdSuper, String sChild, Component cdChild, Loader loader, ErrorList errlist, boolean fVetoable) throws ComponentException, PropertyVetoException {
        if (fVetoable && !this.isChildMoveable(cdSuper, sChild, cdChild)) {
            this.subNotAddable(ATTR_CHILD, sChild);
        }
        if (errlist == null) {
            errlist = new ErrorList();
        }
        Component cdDelta = (Component)cdChild.extract(cdSuper, this, loader, errlist);
        cdDelta.finalizeExtract(loader, errlist);
        if (errlist.isSevere()) {
            errlist.print();
            throw new ComponentException("Component.moveChild:  Serious errors occurred during extraction!");
        }
        cdDelta.m_sSuper = cdSuper.getQualifiedName();
        cdDelta.m_sName = sChild;
        cdDelta.setExists(2);
        Component cdNewChild = (Component)cdSuper.resolve(cdDelta, this, loader, errlist);
        cdNewChild.finalizeResolve(loader, errlist);
        if (errlist.isSevere()) {
            errlist.print();
            throw new ComponentException("Component.moveChild:  Serious errors occurred during resolution!");
        }
        cdChild.getParent().removeChild(cdChild, fVetoable);
        return this.addChild(cdNewChild, fVetoable);
    }

    public boolean isChildUnremovable(String sChild) {
        Component cd = (Component)this.m_tblChildren.get(sChild);
        return this.isModifiable() && cd != null && (cd.m_nFlags & 6) == 4;
    }

    public Component unremoveChild(String sChild) throws PropertyVetoException {
        if (!this.isChildUnremovable(sChild)) {
            this.subNotUnremovable(ATTR_CHILD, sChild);
        }
        return this.unremoveChild((Component)this.m_tblChildren.get(sChild), true);
    }

    protected synchronized Component unremoveChild(Component cd, boolean fVetoable) throws PropertyVetoException {
        if ((cd.m_nFlags & 6) != 4) {
            return cd;
        }
        if (fVetoable) {
            this.fireVetoableSubChange(cd, 3);
        }
        cd.m_nFlags = cd.m_nFlags & 0xFFFFFFF9 | 0;
        this.fireSubChange(cd, 3);
        return cd;
    }

    protected void renameChild(String sOld, String sNew) {
        this.m_tblChildren.put(sNew, this.m_tblChildren.remove(sOld));
    }

    public Component replaceChildSuper(String sChild, Component cdOldSuper, Component cdNewSuper, Loader loader, ErrorList errlist) throws ComponentException, PropertyVetoException {
        return this.replaceChildSuper(sChild, cdOldSuper, cdNewSuper, loader, errlist, true);
    }

    public Component replaceChildSuper(String sChild, Component cdOldSuper, Component cdNewSuper, Loader loader, ErrorList errlist, boolean fVetoable) throws ComponentException, PropertyVetoException {
        Component cdChild = (Component)this.m_tblChildren.get(sChild);
        if (fVetoable) {
            if (!(this.isChildRemovable(sChild) && cdChild.isDeclaredAtThisLevel() && cdChild.isDerivedFrom(cdOldSuper.getQualifiedName()))) {
                this.subNotRemovable(ATTR_CHILD, sChild);
            }
            if (cdOldSuper == null || cdNewSuper == null || cdNewSuper.getMode() != 1) {
                this.subNotAddable(ATTR_CHILD, sChild);
            }
            this.fireVetoableSubChange(cdChild, 0);
        }
        if (errlist == null) {
            errlist = new ErrorList();
        }
        Component cdDelta = (Component)cdChild.extract(cdOldSuper, this, loader, errlist);
        cdDelta.finalizeExtract(loader, errlist);
        if (errlist.isSevere()) {
            errlist.print();
            throw new ComponentException("Component.replaceChildSuper:  Serious errors occurred during extraction!");
        }
        if (!cdDelta.m_sName.equals(sChild) || !cdDelta.getUID().equals(cdChild.getUID()) || cdDelta.getExists() != 2) {
            throw new ComponentException("Component.replaceChildSuper:  Critical attributes have changed during extraction!");
        }
        cdDelta.m_sSuper = cdNewSuper.getQualifiedName();
        cdChild = (Component)cdNewSuper.resolve(cdDelta, this, loader, errlist);
        cdChild.finalizeResolve(loader, errlist);
        if (errlist.isSevere()) {
            errlist.print();
            throw new ComponentException("Component.replaceChildSuper:  Serious errors occurred during resolution!");
        }
        this.m_tblChildren.put(sChild, cdChild);
        this.fireSubChange(cdChild, 0);
        return cdChild;
    }

    public void addJcsImplementations(ClassFile clz, String sJava) {
        if (!this.isSignature()) {
            throw new IllegalStateException();
        }
        Map map = Collections.EMPTY_MAP;
        if (sJava != null && sJava.length() > 0) {
            ScriptParser parser = new ScriptParser();
            map = parser.parse(sJava);
        }
        Enumeration enmr = this.m_tblBehavior.elements();
        while (enmr.hasMoreElements()) {
            CodeAttribute code;
            String sSig;
            Method method;
            Behavior beh = (Behavior)enmr.nextElement();
            String sLang = null;
            String sScript = null;
            if (!map.isEmpty()) {
                StringBuffer sb = new StringBuffer(this.getName());
                sb.append('.').append(beh.getName()).append('(');
                DataType[] adt = beh.getParameterTypes();
                int c = adt.length;
                for (int i = 0; i < c; ++i) {
                    if (i > 0) {
                        sb.append(',');
                    }
                    sb.append(Component.toSimpleSignature(adt[i].getType()));
                }
                sb.append(')');
                sLang = "Java (Original)";
                sScript = (String)map.get(sb.toString());
            }
            if (sScript == null && clz != null && (method = clz.getMethod(sSig = beh.getName() + beh.getJVMSignature())) != null && (code = (CodeAttribute)method.getAttribute("Code")) != null) {
                sLang = "Jasm (Original)";
                sScript = code.toJasm();
                String sClass = this.getName();
                String sSuper = this.getSuperName();
                int ofPkg = sClass.lastIndexOf(46);
                sScript = Component.replace(sScript, " " + sSuper + ".", " super.");
                if (ofPkg > 0) {
                    String sPackage = sClass.substring(0, ofPkg + 1);
                    sScript = Component.replace(sScript, " " + sPackage, " ");
                }
            }
            if (sScript == null) continue;
            beh.setJcsImplementation(sLang, sScript);
        }
    }

    protected static String toSimpleSignature(Type type) {
        if (type instanceof ArrayType) {
            return Component.toSimpleSignature(((ArrayType)type).getElementType()) + "[]";
        }
        if (type instanceof ClassType) {
            return ((ClassType)type).getShortName();
        }
        return type.toString();
    }

    public void removeJcsImplementations() {
        if (!this.isSignature()) {
            throw new IllegalStateException();
        }
        Enumeration enmr = this.m_tblBehavior.elements();
        while (enmr.hasMoreElements()) {
            Behavior beh = (Behavior)enmr.nextElement();
            beh.removeJcsImplementation();
        }
    }

    public CompilePlan getCompilePlan(Loader loader) throws ComponentException {
        return this.getCompilePlan(loader, false);
    }

    public CompilePlan getCompilePlan(Loader loader, boolean fDebug) throws ComponentException {
        if (!this.isGlobal()) {
            throw new IllegalStateException("Component is not global");
        }
        if (fDebug) {
            StringTable tbl = new StringTable();
            this.buildDebugSuperMap(tbl);
            return new CompilePlan(this.getQualifiedName(), tbl, tbl);
        }
        StringTable tblDelta = new StringTable();
        Hashtable tblCache = new Hashtable();
        this.buildDeltaMap(tblDelta, loader, tblCache);
        StringTable tblSuper = new StringTable();
        Hashtable tblDeltas = new Hashtable();
        this.resolveSuperMap(tblSuper, loader, tblCache, tblDeltas);
        return new CompilePlan(this.getQualifiedName(), tblSuper, tblDelta);
    }

    private void buildDebugSuperMap(StringTable tbl) {
        String[] asChildren = this.getChildren();
        for (int i = 0; i < asChildren.length; ++i) {
            Component child = this.getChild(asChildren[i]);
            if (child == null) continue;
            tbl.put(child.getLocalName(), child.getSuperName());
            child.buildDebugSuperMap(tbl);
        }
    }

    private boolean buildDeltaMap(StringTable tblDelta, Loader loader, Hashtable tblCache) throws ComponentException {
        boolean fDelta = false;
        String[] asChildren = this.getChildren();
        block5: for (int i = 0; i < asChildren.length; ++i) {
            Component child = (Component)this.m_tblChildren.get(asChildren[i]);
            if (child == null) continue;
            switch (child.m_nFlags & 6) {
                case 0: 
                case 2: {
                    if (!child.buildDeltaMap(tblDelta, loader, tblCache) && (child.m_nFlags & 6) != 2) continue block5;
                    tblDelta.add(child.getLocalName());
                    fDelta = true;
                    continue block5;
                }
                case 4: {
                    fDelta = true;
                    continue block5;
                }
                case 6: {
                    continue block5;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        if (!fDelta) {
            fDelta = !this.isClassDiscardable(Component.getComponent(this.getSuperName(), loader, tblCache));
        }
        return fDelta;
    }

    private void resolveSuperMap(StringTable tblSuper, Loader loader, Hashtable tblCache, Hashtable tblDeltas) throws ComponentException {
        String[] asChildren = this.getChildren();
        for (int i = 0; i < asChildren.length; ++i) {
            Component child = this.getChild(asChildren[i]);
            if (child == null) continue;
            tblSuper.put(child.getLocalName(), child.resolveSuper(loader, tblCache, tblDeltas));
            child.resolveSuperMap(tblSuper, loader, tblCache, tblDeltas);
        }
    }

    private String resolveSuper(Loader loader, Hashtable tblCache, Hashtable tblDeltas) throws ComponentException {
        String sSuperLocal;
        String sSuper = this.getSuperName();
        if (Component.isGlobal(sSuper)) {
            return sSuper;
        }
        String sSuperGlobal = Component.getGlobalName(sSuper);
        Component cdSuperGlobal = Component.getComponent(sSuperGlobal, loader, tblCache);
        StringTable tblDelta = (StringTable)tblDeltas.get(sSuperGlobal);
        if (tblDelta == null) {
            tblDelta = new StringTable();
            cdSuperGlobal.buildDeltaMap(tblDelta, loader, tblCache);
            tblDeltas.put(sSuperGlobal, tblDelta);
        }
        if (tblDelta.contains(sSuperLocal = Component.getLocalName(sSuper))) {
            return sSuper;
        }
        Component cdSuperLocal = cdSuperGlobal.getLocal(sSuperLocal);
        return cdSuperLocal.resolveSuper(loader, tblCache, tblDeltas);
    }

    private static Component getComponent(String sName, Loader loader, Hashtable tblCache) throws ComponentException {
        String sGlobal = Component.getGlobalName(sName);
        Component cd = null;
        if (tblCache != null) {
            cd = (Component)tblCache.get(sGlobal);
        }
        if (cd == null) {
            ErrorList errlist = new ErrorList();
            try {
                cd = loader.loadComponent(sGlobal, true, errlist);
            }
            catch (ComponentException e) {
                Component.out("Exception loading component " + sGlobal + ":");
                Component.out(e);
                throw e;
            }
            finally {
                if (!errlist.isEmpty()) {
                    Component.out("Errors encountered loading component " + sGlobal + ":");
                    errlist.print();
                }
            }
            if (tblCache != null && cd != null) {
                tblCache.put(sGlobal, cd);
            }
        }
        if (!Component.isGlobal(sName)) {
            cd = cd.getLocal(Component.getLocalName(sName));
        }
        if (cd == null) {
            throw new ComponentException("Component " + sName + " does not exist");
        }
        return cd;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Component) {
            Component that = (Component)obj;
            return this == that || this.m_nType == that.m_nType && this.m_nVersion == 0x4020000 && this.m_nFlags == that.m_nFlags && this.m_nPrevFlags == that.m_nPrevFlags && this.m_fBaseLevel == that.m_fBaseLevel && this.m_sName.equals(that.m_sName) && this.m_sSuper.equals(that.m_sSuper) && (this.m_integration == null ? that.m_integration == null : this.m_integration.equals(that.m_integration)) && this.m_tblImplements.equals(that.m_tblImplements) && this.m_tblDispatches.equals(that.m_tblDispatches) && this.m_tblState.equals(that.m_tblState) && this.m_tblBehavior.equals(that.m_tblBehavior) && this.m_tblCategories.equals(that.m_tblCategories) && this.m_tblChildren.equals(that.m_tblChildren) && super.equals(that);
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        if (this.getParentTrait() != null) {
            throw new CloneNotSupportedException();
        }
        Component cd = new Component(null, this);
        if (cd.getMode() == 1) {
            cd.validate();
        }
        return cd;
    }

    @Override
    public void dump(PrintWriter out, String sIndent) {
        this.dump(out, sIndent, true);
    }

    public void dump(PrintWriter out, String sIndent, boolean fIndentFirstLine) {
        this.toXml().writeXml(out, true);
    }

    public static String getRootName() {
        return "Component";
    }

    public static boolean isSimpleNameLegal(String sName, boolean fGlobal) {
        return sName != null && sName.indexOf(46) < 0 && sName.indexOf(36) < 0 && (!fGlobal || Character.isUpperCase(sName.charAt(0))) && ClassHelper.isSimpleNameLegal(sName);
    }

    public static boolean isQualifiedNameLegal(String sName) {
        int cchRoot;
        String sRoot = Component.getRootName();
        if (sName == null || sName.length() == 0 || !sName.startsWith(sRoot)) {
            return false;
        }
        int cchName = sName.length();
        if (cchName == (cchRoot = sRoot.length())) {
            return true;
        }
        try {
            int ofEnd;
            char ch = sName.charAt(cchRoot);
            if (ch != '.' && ch != '$') {
                return false;
            }
            int ofStart = 0;
            boolean fGlobal = true;
            while ((ofEnd = sName.indexOf(46, ofStart)) > 0) {
                if (!Component.isSimpleNameLegal(sName.substring(ofStart, ofEnd), fGlobal)) {
                    return false;
                }
                ofStart = ofEnd + 1;
            }
            while ((ofEnd = sName.indexOf(36, ofStart)) > 0) {
                if (!Component.isSimpleNameLegal(sName.substring(ofStart, ofEnd), fGlobal)) {
                    return false;
                }
                ofStart = ofEnd + 1;
                fGlobal = false;
            }
            if (!Component.isSimpleNameLegal(sName.substring(ofStart), fGlobal)) {
                return false;
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            return false;
        }
        return true;
    }

    public static boolean isGlobalNameLegal(String sName) {
        return Component.isQualifiedNameLegal(sName) && sName.indexOf(36) < 0;
    }

    public static boolean isGlobal(String sName) {
        return sName.indexOf(36) < 0;
    }

    public static String getGlobalName(String sName) {
        int of = sName.indexOf(36);
        return of < 0 ? sName : sName.substring(0, of);
    }

    public static String getSimpleName(String sName) {
        int of = sName.lastIndexOf(36);
        return of < 0 ? null : sName.substring(of + 1);
    }

    public static String getLocalName(String sName) {
        int of = sName.indexOf(36);
        return of < 0 ? null : sName.substring(of + 1);
    }

    public static boolean isDerivedFrom(String sSub, String sSuper) {
        return Component.isGlobalNameLegal(sSub) && (sSub.equals(sSuper) || sSub.startsWith(sSuper + "."));
    }

    public boolean isDerivedFrom(String sSuperName) {
        String sThisName = this.getQualifiedName();
        String sThatName = sSuperName;
        if (this.isGlobal()) {
            return Component.isDerivedFrom(sThisName, sThatName);
        }
        if (sThisName.equals(sThatName)) {
            return true;
        }
        if (Component.isGlobalNameLegal(sThatName)) {
            return Component.isDerivedFrom(this.getGlobalSuperName(), sThatName);
        }
        int iPos = sThisName.lastIndexOf(36);
        String sThisLocalName = sThisName.substring(iPos + 1);
        String sThisGlobalName = sThisName.substring(0, iPos);
        iPos = sThatName.lastIndexOf(36);
        String sThatLocalName = sThatName.substring(iPos + 1);
        String sThatGlobalName = sThatName.substring(0, iPos);
        return sThisLocalName.equals(sThatLocalName) && Component.isDerivedFrom(sThisGlobalName, sThatGlobalName);
    }

    public boolean isDerivedFrom(Component cdSuper) {
        String sThatName;
        Component that = cdSuper;
        String sThisName = this.getQualifiedName();
        if (sThisName.equals(sThatName = that.getQualifiedName())) {
            return true;
        }
        Component cdThisParent = this.getParent();
        Component cdThatParent = that.getParent();
        if (cdThisParent != null) {
            if (cdThatParent == null) {
                sThisName = this.getGlobalSuperName();
            } else {
                return this.getName().equals(that.getName()) && cdThisParent.isDerivedFrom(cdThatParent);
            }
        }
        return sThisName.equals(sThatName) || sThisName.startsWith(sThatName + ".");
    }

    protected static Collator getDefaultScriptingCollator() {
        Collator collator = Collator.getInstance(Locale.ENGLISH);
        collator.setStrength(1);
        return new CacheCollator(collator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] asArg) {
        int cArg = asArg.length;
        if (cArg < 1) {
            Component.usage();
            return;
        }
        File fileIn = new File(asArg[0]);
        if (!fileIn.isFile()) {
            Component.usage();
            return;
        }
        InputStream in = null;
        OutputStream out = null;
        try {
            Component cd;
            boolean fBin = fileIn.getName().toLowerCase().endsWith(".cdb");
            in = new FileInputStream(fileIn);
            if (cArg > 1) {
                File fileOut = new File(asArg[1]);
                if (fileOut.exists()) {
                    Component.err("Cannot overwrite existing file: " + String.valueOf(fileOut));
                    return;
                }
                out = new FileOutputStream(fileOut);
            } else {
                out = System.out;
            }
            Component component = cd = fBin ? new Component(new DataInputStream(in)) : new Component(XmlHelper.loadXml(in));
            if (fBin) {
                cd.dump(new PrintWriter(out, true), "");
            } else {
                cd.save(new DataOutputStream(out));
            }
        }
        catch (Exception e) {
            Component.err("Error processing: " + String.valueOf(fileIn));
            Component.err(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void usage() {
        Component.out("Usage: Component [CBD or XML input file] (output file)");
    }
}

