/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.component;

import com.tangosol.dev.assembler.ClassFile;
import com.tangosol.dev.component.Component;
import com.tangosol.dev.component.ComponentException;
import com.tangosol.dev.component.Storage;
import com.tangosol.dev.component.Trait;
import com.tangosol.util.Base;
import com.tangosol.util.ErrorList;
import com.tangosol.util.StringTable;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.util.Arrays;

public class ChainStorage
extends Base
implements Storage {
    private static final String CLASS = "ChainStorage";
    private Storage m_base;
    private Storage m_delta;
    private boolean m_fOverride;

    public ChainStorage(Storage base, Storage delta) {
        this(base, delta, false);
    }

    public ChainStorage(Storage base, Storage delta, boolean fOverride) {
        if (base == null || delta == null) {
            throw new IllegalArgumentException("ChainStorageStorage implementations must be non-null!");
        }
        this.m_base = base;
        this.m_delta = delta;
        this.m_fOverride = fOverride;
    }

    @Override
    public Component loadComponent(String sName, boolean fReadOnly, ErrorList errlist) throws ComponentException {
        Component cdResult;
        if (Trait.DEBUG) {
            ChainStorage.out();
            ChainStorage.out("***ChainStorage*** loading: " + sName + " @" + this.toString());
        }
        Component cdBase = this.m_base.loadComponent(sName, true, errlist);
        Component cdDelta = this.m_delta.loadComponent(sName, true, errlist);
        if (this.m_fOverride || cdBase == null) {
            cdResult = cdDelta == null ? cdBase : cdDelta;
        } else {
            if (cdDelta == null) {
                cdDelta = (Component)cdBase.getNullDerivedTrait(null, 3);
            }
            int nModeBase = cdBase.getMode();
            int nModeDelta = cdDelta.getMode();
            switch (nModeDelta) {
                case 2: {
                    if (nModeBase == 1) break;
                    if (nModeBase == 2) {
                        if (cdDelta.isComponent() && !cdDelta.equals(cdBase)) {
                            Component cdDeltaClone;
                            Component cdBaseClone;
                            try {
                                cdBaseClone = (Component)cdBase.clone();
                                cdDeltaClone = (Component)cdDelta.clone();
                            }
                            catch (CloneNotSupportedException e) {
                                throw new WrapperException(e);
                            }
                            cdBaseClone.finalizeResolve(this, null);
                            cdDeltaClone.finalizeResolve(this, null);
                            if (!cdDeltaClone.equals(cdBaseClone)) {
                                String sMsg = "During resolution it was necessary to discard the base Derivation information for \"" + sName + "\" from " + String.valueOf(this.getRightmostStorage(this.m_base)) + " in favor of Derivation information from " + String.valueOf(this.getRightmostStorage(this.m_delta));
                                if (errlist == null) {
                                    ChainStorage.out(sMsg);
                                } else {
                                    errlist.addWarning(sMsg);
                                }
                            }
                        }
                        cdBase = null;
                        break;
                    }
                }
                case 1: {
                    if (nModeBase == 1) {
                        cdBase = null;
                        break;
                    }
                    String sMsg = "During resolution it was necessary to discard the base Derivation information for \"" + sName + "\" from " + String.valueOf(this.getRightmostStorage(this.m_base)) + " in favor of " + (nModeDelta == 2 ? "Derivation" : "Modification") + "  information from " + String.valueOf(this.getRightmostStorage(this.m_delta));
                    if (errlist == null) {
                        ChainStorage.out(sMsg);
                    } else {
                        errlist.addWarning(sMsg);
                    }
                    cdBase = null;
                }
            }
            if (Trait.DEBUG) {
                ChainStorage.out();
                ChainStorage.out("***ChainStorage*** Component Base before resolve:");
                cdBase.dump();
                ChainStorage.out();
                ChainStorage.out("***ChainStorage*** Component Delta before resolve:");
                cdDelta.dump();
            }
            Component component = cdResult = cdBase == null ? cdDelta : cdBase.resolve(cdDelta, this, errlist);
            if (Trait.DEBUG) {
                ChainStorage.out();
                ChainStorage.out("***ChainStorage*** Component Result after resolve:");
                cdResult.dump();
            }
        }
        if (cdResult != null) {
            cdResult.setModifiable(!fReadOnly);
        }
        return cdResult;
    }

    @Override
    public void storeComponent(Component cd, ErrorList errlist) throws ComponentException {
        Component cdDelta;
        if (Trait.DEBUG) {
            ChainStorage.out();
            ChainStorage.out("***ChainStorage*** storing: " + String.valueOf(cd) + " @" + this.toString());
        }
        String sName = cd.getQualifiedName();
        Component cdBase = this.m_base.loadComponent(sName, true, errlist);
        if (this.m_fOverride || cdBase == null) {
            cdDelta = cd;
            if (cdBase != null) {
                try {
                    cd = (Component)cd.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    // empty catch block
                }
                cd.finalizeExtract(this, errlist);
                if (cd.equals(cdBase)) {
                    try {
                        this.m_delta.removeComponent(sName);
                        return;
                    }
                    catch (ComponentException componentException) {}
                }
            }
        } else {
            if (Trait.DEBUG) {
                ChainStorage.out();
                ChainStorage.out("***ChainStorage*** Component Base before extract:");
                cdBase.dump();
                ChainStorage.out();
                ChainStorage.out("***ChainStorage*** Component Passed before extract:");
                cd.dump();
            }
            cdDelta = cd.extract(cdBase, this, errlist);
            if (Trait.DEBUG) {
                ChainStorage.out();
                ChainStorage.out("***ChainStorage*** Component Delta after extract:");
                cdDelta.dump();
            }
        }
        this.m_delta.storeComponent(cdDelta, errlist);
    }

    @Override
    public void removeComponent(String sName) throws ComponentException {
        this.m_delta.removeComponent(sName);
    }

    @Override
    public Component loadSignature(String sName) throws ComponentException {
        Component cdJCS = this.m_delta.loadSignature(sName);
        if (cdJCS == null) {
            cdJCS = this.m_base.loadSignature(sName);
        }
        return cdJCS;
    }

    @Override
    public void storeSignature(Component cdJCS) throws ComponentException {
        String sName = cdJCS.getQualifiedName();
        Component cdJCSBase = null;
        try {
            cdJCSBase = this.m_base.loadSignature(sName);
        }
        catch (ComponentException componentException) {
            // empty catch block
        }
        if (cdJCSBase != null && cdJCSBase.equals(cdJCS)) {
            try {
                if (this.m_delta.loadSignature(sName) == null) {
                    return;
                }
            }
            catch (ComponentException componentException) {
                // empty catch block
            }
        }
        this.m_delta.storeSignature(cdJCS);
    }

    @Override
    public ClassFile loadOriginalClass(String sName) throws ComponentException {
        ClassFile clz = this.m_delta.loadOriginalClass(sName);
        return clz == null ? this.m_base.loadOriginalClass(sName) : clz;
    }

    @Override
    public ClassFile loadClass(String sName) throws ComponentException {
        ClassFile clz = this.m_delta.loadClass(sName);
        return clz == null ? this.m_base.loadClass(sName) : clz;
    }

    @Override
    public void storeClass(ClassFile clz, String sListing) throws ComponentException {
        String sName = clz.getName();
        ClassFile clzBase = null;
        try {
            clzBase = this.m_base.loadClass(sName);
        }
        catch (ComponentException componentException) {
            // empty catch block
        }
        if (clzBase != null && clzBase.equals(clz)) {
            try {
                if (this.m_delta.loadClass(sName) == null) {
                    return;
                }
            }
            catch (ComponentException componentException) {
                // empty catch block
            }
        }
        this.m_delta.storeClass(clz, sListing);
    }

    @Override
    public String loadJava(String sName) throws IOException {
        String sScript = this.m_delta.loadJava(sName);
        return sScript == null ? this.m_base.loadJava(sName) : sScript;
    }

    @Override
    public byte[] loadOriginalResource(String sName) throws IOException {
        byte[] ab = this.m_delta.loadOriginalResource(sName);
        return ab == null ? this.m_base.loadOriginalResource(sName) : ab;
    }

    @Override
    public byte[] loadResourceSignature(String sName) throws IOException {
        byte[] abBase = this.m_base.loadResourceSignature(sName);
        byte[] abDelta = this.m_delta.loadResourceSignature(sName);
        byte[] abResult = this.m_fOverride || abBase == null ? (abDelta == null ? abBase : abDelta) : this.getResourceHandler(sName).resolve(abBase, abDelta);
        return abResult;
    }

    @Override
    public void storeResourceSignature(String sName, byte[] abData) throws IOException {
        byte[] abDelta;
        byte[] abBase = this.m_base.loadResourceSignature(sName);
        if (this.m_fOverride || abBase == null) {
            if (Arrays.equals(abData, abBase)) {
                try {
                    this.m_delta.removeResourceSignature(sName);
                    return;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            abDelta = abData;
        } else {
            abDelta = this.getResourceHandler(sName).extract(abData, abBase);
        }
        this.m_delta.storeResourceSignature(sName, abDelta);
    }

    @Override
    public void removeResourceSignature(String sName) throws IOException {
        this.m_delta.removeResourceSignature(sName);
    }

    @Override
    public byte[] loadResource(String sName) throws IOException {
        byte[] ab = this.m_delta.loadResource(sName);
        return ab == null ? this.m_base.loadResource(sName) : ab;
    }

    @Override
    public void storeResource(String sName, byte[] abData) throws IOException {
        this.m_delta.storeResource(sName, abData);
    }

    @Override
    public StringTable getSubComponents(String sComponent, boolean fQualify) {
        StringTable tblBase = this.m_base.getSubComponents(sComponent, fQualify);
        StringTable tblDelta = this.m_delta.getSubComponents(sComponent, fQualify);
        return this.merge(tblBase, tblDelta);
    }

    @Override
    public StringTable getPackageComponents(String sPackage, boolean fQualify) {
        StringTable tblBase = this.m_base.getPackageComponents(sPackage, fQualify);
        StringTable tblDelta = this.m_delta.getPackageComponents(sPackage, fQualify);
        return this.merge(tblBase, tblDelta);
    }

    @Override
    public StringTable getComponentPackages(String sPackage, boolean fQualify, boolean fSubs) {
        if (fSubs) {
            fQualify = true;
        }
        StringTable tblBase = this.m_base.getComponentPackages(sPackage, fQualify, fSubs);
        StringTable tblDelta = this.m_delta.getComponentPackages(sPackage, fQualify, fSubs);
        return this.merge(tblBase, tblDelta);
    }

    @Override
    public StringTable getPackageSignatures(String sPackage, boolean fQualify) {
        StringTable tblBase = this.m_base.getPackageSignatures(sPackage, fQualify);
        StringTable tblDelta = this.m_delta.getPackageSignatures(sPackage, fQualify);
        return this.merge(tblBase, tblDelta);
    }

    @Override
    public StringTable getSignaturePackages(String sPackage, boolean fQualify, boolean fSubs) {
        if (fSubs) {
            fQualify = true;
        }
        StringTable tblBase = this.m_base.getSignaturePackages(sPackage, fQualify, fSubs);
        StringTable tblDelta = this.m_delta.getSignaturePackages(sPackage, fQualify, fSubs);
        return this.merge(tblBase, tblDelta);
    }

    @Override
    public StringTable getPackageResources(String sPackage, boolean fQualify) {
        StringTable tblBase = this.m_base.getPackageResources(sPackage, fQualify);
        StringTable tblDelta = this.m_delta.getPackageResources(sPackage, fQualify);
        return this.merge(tblBase, tblDelta);
    }

    @Override
    public StringTable getResourcePackages(String sPackage, boolean fQualify, boolean fSubs) {
        if (fSubs) {
            fQualify = true;
        }
        StringTable tblBase = this.m_base.getResourcePackages(sPackage, fQualify, fSubs);
        StringTable tblDelta = this.m_delta.getResourcePackages(sPackage, fQualify, fSubs);
        return this.merge(tblBase, tblDelta);
    }

    public String toString() {
        return "ChainStorage(" + String.valueOf(this.m_base) + (this.m_fOverride ? "," : ":") + String.valueOf(this.m_delta) + ")";
    }

    protected StringTable merge(StringTable tblBase, StringTable tblDelta) {
        if (tblDelta.isEmpty()) {
            return tblBase;
        }
        if (tblBase.isEmpty()) {
            return tblDelta;
        }
        if (tblBase.getSize() > tblDelta.getSize()) {
            tblBase.putAll(tblDelta);
            return tblBase;
        }
        tblDelta.addAll(tblBase);
        return tblDelta;
    }

    private Storage getRightmostStorage(Storage storage) {
        if (storage instanceof ChainStorage) {
            ChainStorage chain = (ChainStorage)storage;
            storage = chain.getRightmostStorage(chain.m_delta);
        }
        return storage;
    }

    protected ResourceHandler getResourceHandler(String sName) {
        return new SimpleHandler();
    }

    public static interface ResourceHandler {
        public byte[] resolve(byte[] var1, byte[] var2) throws IOException;

        public byte[] extract(byte[] var1, byte[] var2) throws IOException;
    }

    public class SimpleHandler
    implements ResourceHandler {
        @Override
        public byte[] resolve(byte[] abBase, byte[] abDelta) {
            return abDelta == null ? abBase : abDelta;
        }

        @Override
        public byte[] extract(byte[] abResult, byte[] abBase) {
            return Arrays.equals(abResult, abBase) ? null : abResult;
        }
    }
}

