/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.compiler.ParsePosition;
import com.tangosol.dev.compiler.Script;
import com.tangosol.dev.compiler.SimpleScript;
import com.tangosol.dev.compiler.java.UnicodeDataFormatException;
import com.tangosol.util.Base;
import java.io.EOFException;

public class UnicodeScript
extends Base
implements Script {
    protected String m_sScript;
    protected char[] m_achScript;
    protected int m_cchScript;
    protected int m_ofCurrent;
    protected int m_iLineInitial;
    protected int m_iLine;
    protected int m_ofInLine;
    protected Skew m_skewNext;
    protected Skew m_skewPrev;
    private boolean m_fInit;
    private boolean m_fUnicodeError;

    public UnicodeScript() {
    }

    public UnicodeScript(String s, int iLine) {
        this.setScript(s);
        this.m_iLine = this.m_iLineInitial = iLine;
    }

    protected UnicodeScript(UnicodeScript that, int of, int cch) {
        this.m_achScript = new char[cch];
        System.arraycopy(that.m_achScript, of, this.m_achScript, 0, cch);
        this.m_cchScript = cch;
        int cchSkewStart = 0;
        int cchSkewEnd = 0;
        Skew skewNext = that.getFirstSkew();
        if (skewNext != null) {
            while (skewNext != null && skewNext.ofInScript < of) {
                cchSkewStart += skewNext.cchSkew;
                skewNext = skewNext.skewNext;
            }
            int ofEnd = of + cch - 1;
            while (skewNext != null && skewNext.ofInScript <= ofEnd) {
                Skew skew = new Skew();
                skew.ofInScript = skewNext.ofInScript - of;
                skew.cchSkew = skewNext.cchSkew;
                skew.skewPrev = this.m_skewPrev;
                if (this.m_skewPrev != null) {
                    this.m_skewPrev.skewNext = skew;
                }
                this.m_skewPrev = skew;
                cchSkewEnd += skewNext.cchSkew;
                skewNext = skewNext.skewNext;
            }
            this.m_skewNext = this.getFirstSkew();
            this.m_skewPrev = null;
        }
        this.m_sScript = that.m_sScript.substring(of += cchSkewStart, of + (cch += cchSkewEnd));
        this.m_fInit = true;
    }

    @Override
    public void setScript(String sScript) {
        if (this.m_achScript != null) {
            throw new IllegalStateException();
        }
        this.m_sScript = sScript;
        this.m_achScript = sScript.toCharArray();
        this.m_cchScript = this.m_achScript.length;
    }

    @Override
    public boolean hasMoreChars() {
        return this.m_ofCurrent < this.m_cchScript;
    }

    @Override
    public char nextChar() throws EOFException, UnicodeDataFormatException {
        boolean fMore;
        if (this.m_ofCurrent >= this.m_cchScript) {
            throw new EOFException();
        }
        if (!this.m_fInit) {
            this.initialize();
        }
        char ch = this.m_achScript[this.m_ofCurrent];
        boolean bl = fMore = this.m_ofCurrent + 1 < this.m_cchScript;
        if (ch == '\u001a' && fMore) {
            throw new EOFException();
        }
        if (this.m_skewNext != null && this.m_skewNext.ofInScript == this.m_ofCurrent) {
            this.m_ofInLine += this.m_skewNext.cchSkew + 1;
            this.m_skewPrev = this.m_skewNext;
            this.m_skewNext = this.m_skewNext.skewNext;
        } else if (ch == '\n' || ch == '\r') {
            if (ch == '\r' && fMore && this.m_achScript[this.m_ofCurrent + 1] == '\n' && (this.m_skewNext == null || this.m_skewNext.ofInScript > this.m_ofCurrent + 1)) {
                ++this.m_ofInLine;
            } else {
                this.m_ofInLine = 0;
                ++this.m_iLine;
            }
        } else {
            ++this.m_ofInLine;
        }
        ++this.m_ofCurrent;
        return ch;
    }

    @Override
    public void putBackChar() {
        char ch = this.m_achScript[--this.m_ofCurrent];
        if (this.m_skewPrev != null && this.m_skewPrev.ofInScript == this.m_ofCurrent) {
            this.m_ofInLine -= this.m_skewPrev.cchSkew + 1;
            this.m_skewNext = this.m_skewPrev;
            this.m_skewPrev = this.m_skewPrev.skewPrev;
        } else if (ch == '\n' || ch == '\r') {
            if (ch == '\r' && this.m_achScript[this.m_ofCurrent + 1] == '\n' && (this.m_skewNext == null || this.m_skewNext.ofInScript > this.m_ofCurrent + 1)) {
                --this.m_ofInLine;
            } else {
                --this.m_iLine;
                this.m_ofInLine = 0;
                Skew skewPrev = this.m_skewPrev;
                for (int of = this.m_ofCurrent - 1; of >= 0; --of) {
                    if (skewPrev != null && skewPrev.ofInScript == of) {
                        this.m_ofInLine += skewPrev.cchSkew + 1;
                        skewPrev = skewPrev.skewPrev;
                        continue;
                    }
                    if (this.m_achScript[of] != '\r' && this.m_achScript[of] != '\n') {
                        ++this.m_ofInLine;
                        continue;
                    }
                    break;
                }
            }
        } else {
            --this.m_ofInLine;
        }
    }

    @Override
    public ParsePosition savePosition() {
        Position pos = new Position();
        pos.script = this;
        pos.fInit = this.m_fInit;
        pos.ofCurrent = this.m_ofCurrent;
        pos.iLine = this.m_iLine;
        pos.ofInLine = this.m_ofInLine;
        pos.skewNext = this.m_skewNext;
        pos.skewPrev = this.m_skewPrev;
        return pos;
    }

    @Override
    public void restorePosition(ParsePosition parsepos) {
        Position pos = (Position)parsepos;
        if (pos.script != this) {
            throw new IllegalArgumentException("Unknown ParsePosition object");
        }
        if (this.m_fInit && pos.fInit) {
            this.m_ofCurrent = pos.ofCurrent;
            this.m_iLine = pos.iLine;
            this.m_ofInLine = pos.ofInLine;
            this.m_skewNext = pos.skewNext;
            this.m_skewPrev = pos.skewPrev;
        } else if (this.m_fInit && !pos.fInit) {
            this.m_ofCurrent = 0;
            this.m_iLine = this.m_iLineInitial;
            this.m_ofInLine = 0;
            this.m_skewNext = this.getFirstSkew();
            this.m_skewPrev = null;
        }
    }

    @Override
    public int getLine() {
        return this.m_iLine;
    }

    @Override
    public int getOffset() {
        return this.m_ofInLine;
    }

    @Override
    public Script subScript(ParsePosition parsepos) {
        Position pos = (Position)parsepos;
        if (pos.script != this) {
            throw new IllegalArgumentException("Unknown ParsePosition object");
        }
        if (!this.m_fInit) {
            return new SimpleScript("");
        }
        int of = pos.ofCurrent;
        int cch = this.m_ofCurrent - of;
        if (cch < 0) {
            throw new IllegalStateException("The starting offset is greater than the current offset");
        }
        return new UnicodeScript(this, of, cch);
    }

    @Override
    public String getText() throws UnicodeDataFormatException {
        this.initialize();
        return new String(this.m_achScript, 0, this.m_cchScript);
    }

    @Override
    public String toString() {
        return this.m_sScript;
    }

    protected void initialize() throws UnicodeDataFormatException {
        if (!this.m_fInit) {
            if (this.m_fUnicodeError) {
                throw new UnicodeDataFormatException();
            }
            try {
                this.processUnicodeEscapes();
            }
            catch (UnicodeDataFormatException e) {
                this.m_fUnicodeError = true;
                throw e;
            }
            this.m_fInit = true;
        }
    }

    protected Skew getFirstSkew() {
        Skew skew;
        Skew skew2 = skew = this.m_skewPrev == null ? this.m_skewNext : this.m_skewPrev;
        if (skew != null) {
            while (skew.skewPrev != null) {
                skew = skew.skewPrev;
            }
        }
        return skew;
    }

    private void processUnicodeEscapes() throws UnicodeDataFormatException {
        int cchRaw = this.m_cchScript;
        int ofRaw = 0;
        int ofDest = 0;
        boolean fEsc = false;
        boolean fSkewed = false;
        Skew skewFirst = null;
        Skew skewLast = null;
        while (ofRaw < cchRaw) {
            char ch = this.m_achScript[ofRaw];
            if (fEsc) {
                if (ch == 'u') {
                    int ofEscape = this.m_ofInLine - 1;
                    int cchSkew = 4;
                    while (ofRaw < cchRaw && this.m_achScript[ofRaw] == 'u') {
                        ++ofRaw;
                        ++cchSkew;
                    }
                    if (ofRaw + 4 > cchRaw) {
                        this.m_ofInLine = ofEscape;
                        throw new UnicodeDataFormatException();
                    }
                    int nCharValue = 0;
                    for (int i = 0; i < 4; ++i) {
                        if (!UnicodeScript.isHex(ch = this.m_achScript[ofRaw++])) {
                            this.m_ofInLine = ofEscape;
                            throw new UnicodeDataFormatException();
                        }
                        nCharValue = (nCharValue << 4) + UnicodeScript.hexValue(ch);
                    }
                    this.m_achScript[ofDest - 1] = (char)nCharValue;
                    Skew skew = new Skew();
                    skew.ofInScript = ofDest - 1;
                    skew.cchSkew = cchSkew;
                    if (skewFirst == null) {
                        skewFirst = skew;
                    }
                    if (skewLast != null) {
                        skewLast.skewNext = skew;
                    }
                    skew.skewPrev = skewLast;
                    skewLast = skew;
                    fSkewed = true;
                    fEsc = false;
                    this.m_ofInLine += cchSkew + 1;
                    continue;
                }
                fEsc = false;
            } else if (ch == '\\') {
                fEsc = true;
            }
            if (ch == '\n' || ch == '\r' && (ofRaw + 1 >= cchRaw || this.m_achScript[ofRaw + 1] != '\n')) {
                this.m_ofInLine = 0;
                ++this.m_iLine;
            } else {
                ++this.m_ofInLine;
            }
            if (fSkewed) {
                this.m_achScript[ofDest] = ch;
            }
            ++ofDest;
            ++ofRaw;
        }
        if (fSkewed) {
            this.m_cchScript -= ofRaw - ofDest;
        }
        this.m_skewNext = skewFirst;
        this.m_iLine = this.m_iLineInitial;
        this.m_ofInLine = 0;
    }

    class Skew {
        int ofInScript;
        int cchSkew;
        Skew skewPrev;
        Skew skewNext;

        Skew() {
        }
    }

    class Position
    implements ParsePosition {
        Script script;
        boolean fInit;
        int ofCurrent;
        int iLine;
        int ofInLine;
        Skew skewNext;
        Skew skewPrev;

        Position() {
        }
    }
}

