/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.assembler.CodeAttribute;
import com.tangosol.dev.compiler.CompilerException;
import com.tangosol.dev.compiler.Context;
import com.tangosol.dev.compiler.Info;
import com.tangosol.dev.compiler.PackageInfo;
import com.tangosol.dev.compiler.TypeInfo;
import com.tangosol.dev.compiler.java.Block;
import com.tangosol.dev.compiler.java.DualSet;
import com.tangosol.dev.compiler.java.Element;
import com.tangosol.dev.compiler.java.Expression;
import com.tangosol.dev.compiler.java.NameExpression;
import com.tangosol.dev.compiler.java.Token;
import com.tangosol.dev.compiler.java.TokenConstants;
import com.tangosol.dev.component.DataType;
import com.tangosol.util.ErrorList;
import java.util.Map;

public class TypeExpression
extends Expression
implements TokenConstants {
    private static final String CLASS = "TypeExpression";
    private static final DataType UNKNOWN = DataType.UNKNOWN;
    private NameExpression exprName;

    public TypeExpression(Block block, Token tokType) {
        super(block, tokType);
        this.setEndToken(tokType);
        this.setType(switch (tokType.getID()) {
            case 3 -> DataType.BOOLEAN;
            case 5 -> DataType.BYTE;
            case 8 -> DataType.CHAR;
            case 36 -> DataType.SHORT;
            case 26 -> DataType.INT;
            case 28 -> DataType.LONG;
            case 19 -> DataType.FLOAT;
            case 14 -> DataType.DOUBLE;
            default -> throw new IllegalStateException();
        });
    }

    public TypeExpression(NameExpression expr) {
        super(expr.getBlock(), expr.getStartToken());
        this.setEndToken(expr.getEndToken());
        this.exprName = expr;
    }

    protected TypeExpression(Block block, Token token, DataType type) {
        super(block, token);
        this.setType(type);
    }

    protected TypeExpression(Block block, Token tokStart, Token tokEnd) {
        super(block, tokStart);
        if (tokStart != tokEnd && tokEnd != null) {
            this.setEndToken(tokEnd);
        }
    }

    @Override
    protected Element precompile(Context ctx, DualSet setUVars, DualSet setFVars, Map mapThrown, ErrorList errlist) throws CompilerException {
        Info type = null;
        DataType dt = this.getType();
        if (dt == UNKNOWN) {
            NameExpression exprName = this.exprName;
            if (!exprName.isQualified()) {
                Token tokName = exprName.getToken(0);
                String sName = tokName.getText();
                dt = ctx.getImport(sName);
                if (dt != null) {
                    type = ctx.getTypeInfo(dt);
                } else {
                    dt = UNKNOWN;
                    type = ctx.getMethodInfo().getTypeInfo();
                    if (!type.getName().equals(sName)) {
                        type = type.getPackageInfo().getTypeInfo(sName);
                    }
                }
            }
            if (type == null && dt == UNKNOWN && (type = ctx.getTypeInfo(exprName.getName())) == null && exprName.isQualified()) {
                String sName = exprName.getName();
                int ofDot = sName.indexOf(46);
                String sBaseName = sName.substring(0, ofDot);
                String sRelName = sName.substring(ofDot);
                DataType dtImport = ctx.getImport(sBaseName);
                if (dtImport == null || !dtImport.isComponent() || (type = ctx.getTypeInfo(dtImport.getComponentName() + sRelName)) == null) {
                    DataType dtThis = ctx.getMethodInfo().getTypeInfo().getDataType();
                    String sThisType = dtThis.isComponent() ? dtThis.getComponentName() : dtThis.getClassName();
                    String sThisPkg = sThisType.substring(0, sThisType.indexOf(46));
                    type = ctx.getTypeInfo(sThisPkg + "." + sName);
                }
            }
            if (type == null) {
                if (dt != UNKNOWN) {
                    exprName.logError(3, "JC-030", new String[]{dt.isComponent() ? dt.getComponentName() : dt.getClassName()}, errlist);
                } else {
                    Token tokName;
                    PackageInfo pkg;
                    int c = exprName.getTokenCount() - 1;
                    if (c > 0) {
                        pkg = ctx.getPackageInfo("");
                        for (int i = 0; i < c; ++i) {
                            tokName = exprName.getToken(i);
                            if ((pkg = pkg.getPackageInfo(tokName.getText())) != null) continue;
                            tokName.logError(3, "JC-056", new String[]{tokName.getText()}, errlist);
                            break;
                        }
                    } else {
                        pkg = ctx.getMethodInfo().getTypeInfo().getPackageInfo();
                    }
                    if (pkg != null) {
                        Object sPkg = "";
                        while (pkg != null) {
                            sPkg = "." + pkg.getName() + (String)sPkg;
                            pkg = pkg.getPackageInfo();
                        }
                        tokName = exprName.getToken(c);
                        tokName.logError(3, "JC-055", new String[]{tokName.getText(), ((String)sPkg).substring(1)}, errlist);
                    }
                }
                dt = UNKNOWN;
            } else {
                dt = type.getDataType();
                if (!type.isAccessible()) {
                    exprName.logError(3, "JC-057", new String[]{dt.isComponent() ? dt.getComponentName() : dt.getClassName()}, errlist);
                    dt = UNKNOWN;
                }
            }
            this.setType(dt);
        }
        this.addDependency(ctx, dt);
        return this;
    }

    protected boolean compileImpl(Context ctx, CodeAttribute code, boolean fReached, ErrorList errlist) throws CompilerException {
        throw new IllegalStateException();
    }

    protected void addDependency(Context ctx, DataType dt) throws CompilerException {
        if (dt.isArray()) {
            dt = dt.getBaseElementType();
        }
        TypeInfo type = null;
        if (dt.isComponent()) {
            type = ctx.getTypeInfo(dt.getComponentName());
        } else if (dt.isClass()) {
            type = ctx.getTypeInfo(dt.getClassName());
        }
        if (type != null) {
            type.addDependency(true, this.getStartLine(), this.getStartOffset(), this.getEndLine(), this.getEndOffset());
        }
    }

    protected NameExpression getNameExpression() {
        return this.exprName;
    }

    @Override
    public String toString() {
        Object s = super.toString();
        DataType type = this.getType();
        if (type != null && (this.exprName == null || type != UNKNOWN)) {
            s = (String)s + " type=" + type.toString();
        } else if (this.exprName != null) {
            s = (String)s + " name=" + this.exprName.getName();
        }
        return s;
    }
}

