/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.assembler.CodeAttribute;
import com.tangosol.dev.assembler.Label;
import com.tangosol.dev.compiler.CompilerException;
import com.tangosol.dev.compiler.Context;
import com.tangosol.dev.compiler.java.Block;
import com.tangosol.dev.compiler.java.Element;
import com.tangosol.dev.compiler.java.Token;
import com.tangosol.util.ErrorList;
import java.util.HashSet;
import java.util.Set;

public abstract class Statement
extends Element {
    private static final String CLASS = "Statement";
    private Statement outer;
    private Statement inner;
    private Statement next;
    private Label labelStart;
    private Label labelCont;
    private Label labelEnd;
    private boolean fCompletable;
    private Set setContinueUVars;
    private Set setBreakUVars;
    private Set setContinueFVars;
    private Set setBreakFVars;

    protected Statement(Statement outer, Token token) {
        super(outer == null || outer instanceof Block ? (Block)outer : outer.getBlock(), token);
        this.outer = outer;
    }

    @Override
    protected final boolean compile(Context ctx, CodeAttribute code, boolean fReached, ErrorList errlist) throws CompilerException {
        if (this.labelStart != null) {
            code.add(this.labelStart);
        }
        if (ctx.isDebug()) {
            code.setLine(this.getStartToken().getLine() + 1);
        }
        boolean fCompletes = this.compileImpl(ctx, code, fReached, errlist);
        if (this.labelEnd != null) {
            code.add(this.labelEnd);
        }
        return fCompletes || this.isCompletable();
    }

    protected abstract boolean compileImpl(Context var1, CodeAttribute var2, boolean var3, ErrorList var4) throws CompilerException;

    public Statement getOuterStatement() {
        return this.outer;
    }

    public void setOuterStatement(Statement outer) {
        this.outer = outer;
    }

    public Statement getInnerStatement() {
        return this.inner;
    }

    protected void setInnerStatement(Statement inner) {
        this.inner = inner;
    }

    public Statement getNextStatement() {
        return this.next;
    }

    protected void setNextStatement(Statement next) {
        this.next = next;
    }

    public Label getStartLabel() {
        if (this.labelStart == null) {
            this.labelStart = new Label();
        }
        return this.labelStart;
    }

    public Label getContinuationLabel() {
        if (this.labelCont == null) {
            this.labelCont = new Label();
        }
        return this.labelCont;
    }

    public Label getEndLabel() {
        if (this.labelEnd == null) {
            this.labelEnd = new Label();
        }
        return this.labelEnd;
    }

    protected boolean isCompletable() {
        return this.fCompletable;
    }

    protected void setCompletable(boolean fCompletable) {
        this.fCompletable = fCompletable;
    }

    protected void addBreakUVars(Set setVars) {
        this.getBreakUVars().addAll(setVars);
    }

    protected Set getBreakUVars() {
        HashSet setVars = this.setBreakUVars;
        if (setVars == null) {
            this.setBreakUVars = setVars = new HashSet();
        }
        return setVars;
    }

    protected void addContinueUVars(Set setVars) {
        this.getContinueUVars().addAll(setVars);
    }

    protected Set getContinueUVars() {
        HashSet setVars = this.setContinueUVars;
        if (setVars == null) {
            this.setContinueUVars = setVars = new HashSet();
        }
        return setVars;
    }

    protected void addBreakFVars(Set setVars) {
        this.getBreakFVars().addAll(setVars);
    }

    protected Set getBreakFVars() {
        HashSet setVars = this.setBreakFVars;
        if (setVars == null) {
            this.setBreakFVars = setVars = new HashSet();
        }
        return setVars;
    }

    protected void addContinueFVars(Set setVars) {
        this.getContinueFVars().addAll(setVars);
    }

    protected Set getContinueFVars() {
        HashSet setVars = this.setContinueFVars;
        if (setVars == null) {
            this.setContinueFVars = setVars = new HashSet();
        }
        return setVars;
    }

    protected void notReached(ErrorList errlist) throws CompilerException {
        this.logError(3, "JC-013", null, errlist);
    }

    @Override
    public void print(String sIndent) {
        Statement.out(sIndent + this.toString());
        if (this.inner != null) {
            Statement.out(sIndent + "  Inner Statements:");
            this.inner.printList(sIndent + "    ");
        }
    }

    public void printList(String sIndent) {
        Statement stmt = this;
        while (stmt != null) {
            stmt.print(sIndent);
            stmt = stmt.next;
        }
    }
}

