/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.compiler.CompilerException;
import com.tangosol.dev.compiler.Context;
import com.tangosol.dev.compiler.java.BinaryExpression;
import com.tangosol.dev.compiler.java.DualSet;
import com.tangosol.dev.compiler.java.Element;
import com.tangosol.dev.compiler.java.Expression;
import com.tangosol.dev.compiler.java.Token;
import com.tangosol.dev.component.DataType;
import com.tangosol.util.ErrorList;
import java.util.Map;

public abstract class ShiftExpression
extends BinaryExpression {
    private static final String CLASS = "ShiftExpression";
    protected static final DataType LONG = DataType.LONG;

    protected ShiftExpression(Expression left, Token operator, Expression right) {
        super(left, operator, right);
    }

    @Override
    protected Element precompile(Context ctx, DualSet setUVars, DualSet setFVars, Map mapThrown, ErrorList errlist) throws CompilerException {
        Expression left = this.getLeftExpression();
        Expression right = this.getRightExpression();
        left = (Expression)left.precompile(ctx, setUVars, setFVars, mapThrown, errlist);
        right = (Expression)right.precompile(ctx, setUVars, setFVars, mapThrown, errlist);
        if (left.checkIntegral(errlist) & right.checkIntegral(errlist)) {
            left = left.promoteNumeric();
            right = right.promoteNumeric();
        }
        this.setLeftExpression(left);
        this.setRightExpression(right);
        this.setType(left.getType());
        return this;
    }
}

