/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.compiler.java.Token;

public class LiteralToken
extends Token {
    protected boolean fStoredNeg;

    public LiteralToken(int iValue, int iLine, int ofInLine, int cchToken) {
        super(3, 1, 100, iValue, null, iLine, ofInLine, cchToken);
    }

    public LiteralToken(int iValue, boolean bStoredNeg, int iLine, int ofInLine, int cchToken) {
        super(3, 1, 100, iValue, null, iLine, ofInLine, cchToken);
        this.fStoredNeg = bStoredNeg;
    }

    public LiteralToken(long lValue, int iLine, int ofInLine, int cchToken) {
        super(3, 2, 101, lValue, null, iLine, ofInLine, cchToken);
    }

    public LiteralToken(long lValue, boolean bStoredNeg, int iLine, int ofInLine, int cchToken) {
        super(3, 2, 101, lValue, null, iLine, ofInLine, cchToken);
        this.fStoredNeg = bStoredNeg;
    }

    public LiteralToken(float flValue, int iLine, int ofInLine, int cchToken) {
        super(3, 3, 102, Float.valueOf(flValue), null, iLine, ofInLine, cchToken);
    }

    public LiteralToken(double dflValue, int iLine, int ofInLine, int cchToken) {
        super(3, 4, 103, dflValue, null, iLine, ofInLine, cchToken);
    }

    public LiteralToken(char chValue, int iLine, int ofInLine, int cchToken) {
        super(3, 6, 99, Character.valueOf(chValue), null, iLine, ofInLine, cchToken);
    }

    public LiteralToken(String sValue, int iLine, int ofInLine, int cchToken) {
        super(3, 7, 104, sValue, null, iLine, ofInLine, cchToken);
    }

    public LiteralToken(LiteralToken that, int iLine, int ofInLine, int cchToken) {
        super(that, iLine, ofInLine, cchToken);
        this.fStoredNeg = that.fStoredNeg;
    }

    @Override
    public Object getValue() {
        Object value = this.value;
        if (this.fStoredNeg) {
            switch (this.subcat) {
                case 1: {
                    if (this.isOutOfRange()) {
                        value = 0;
                        break;
                    }
                    value = -((Number)value).intValue();
                    break;
                }
                case 2: {
                    value = this.isOutOfRange() ? Long.valueOf(0L) : Long.valueOf(-((Number)value).longValue());
                }
            }
        }
        return value;
    }

    @Override
    public String getText() {
        if (this.text == null) {
            switch (this.subcat) {
                case 1: {
                    if (this.isOutOfRange()) {
                        this.text = "0";
                        break;
                    }
                    if (this.fStoredNeg) {
                        int i = (Integer)this.value;
                        this.text = Integer.toString(-i);
                        break;
                    }
                    this.text = ((Integer)this.value).toString();
                    break;
                }
                case 2: {
                    if (this.isOutOfRange()) {
                        this.text = "0";
                        break;
                    }
                    if (this.fStoredNeg) {
                        long l = (Long)this.value;
                        this.text = Long.toString(-l);
                        break;
                    }
                    this.text = ((Long)this.value).toString();
                    break;
                }
                case 3: {
                    this.text = ((Float)this.value).toString() + "F";
                    break;
                }
                case 4: {
                    this.text = ((Double)this.value).toString();
                    break;
                }
                case 6: {
                    this.text = LiteralToken.printableChar(this.charValue());
                    break;
                }
                case 7: {
                    this.text = LiteralToken.printableString(this.stringValue());
                }
            }
        }
        return this.text;
    }

    public int intValue() {
        int iValue = switch (this.subcat) {
            case 6 -> ((Character)this.value).charValue();
            case 7 -> Integer.decode((String)this.value);
            default -> ((Number)this.value).intValue();
        };
        return this.fStoredNeg ? -iValue : iValue;
    }

    public long longValue() {
        long lValue = switch (this.subcat) {
            case 6 -> ((Character)this.value).charValue();
            case 7 -> Long.decode((String)this.value);
            default -> ((Number)this.value).longValue();
        };
        return this.fStoredNeg ? -lValue : lValue;
    }

    public float floatValue() {
        float flValue = switch (this.subcat) {
            case 6 -> ((Character)this.value).charValue();
            case 7 -> Float.valueOf((String)this.value).floatValue();
            default -> ((Number)this.value).floatValue();
        };
        return this.fStoredNeg ? -flValue : flValue;
    }

    public double doubleValue() {
        double dflValue = switch (this.subcat) {
            case 6 -> ((Character)this.value).charValue();
            case 7 -> Double.valueOf((String)this.value);
            default -> ((Number)this.value).doubleValue();
        };
        return this.fStoredNeg ? -dflValue : dflValue;
    }

    public char charValue() {
        return switch (this.subcat) {
            case 6 -> ((Character)this.value).charValue();
            case 7 -> {
                String sValue = (String)this.value;
                yield sValue.length() > 0 ? sValue.charAt(0) : (char)'\u0000';
            }
            default -> {
                int iValue = ((Number)this.value).intValue();
                yield (char)(this.fStoredNeg ? -iValue : iValue);
            }
        };
    }

    public String stringValue() {
        return this.value.toString();
    }

    public void negate() {
        this.fStoredNeg = !this.fStoredNeg;
        this.text = null;
    }

    public boolean isOutOfRange() {
        switch (this.subcat) {
            case 1: {
                int iValue = (Integer)this.value;
                return this.fStoredNeg && iValue == Integer.MIN_VALUE;
            }
            case 2: {
                long lValue = (Long)this.value;
                return this.fStoredNeg && lValue == Long.MIN_VALUE;
            }
        }
        return false;
    }

    public static String printableChar(char ch) {
        return LiteralToken.toQuotedCharEscape(ch);
    }

    public static String printableString(String s) {
        return LiteralToken.toQuotedStringEscape(s);
    }
}

