/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.assembler.Aaload;
import com.tangosol.dev.assembler.Aastore;
import com.tangosol.dev.assembler.Baload;
import com.tangosol.dev.assembler.Bastore;
import com.tangosol.dev.assembler.Caload;
import com.tangosol.dev.assembler.Castore;
import com.tangosol.dev.assembler.CodeAttribute;
import com.tangosol.dev.assembler.Daload;
import com.tangosol.dev.assembler.Dastore;
import com.tangosol.dev.assembler.Faload;
import com.tangosol.dev.assembler.Fastore;
import com.tangosol.dev.assembler.FieldConstant;
import com.tangosol.dev.assembler.Getfield;
import com.tangosol.dev.assembler.Getstatic;
import com.tangosol.dev.assembler.Iaload;
import com.tangosol.dev.assembler.Iastore;
import com.tangosol.dev.assembler.InterfaceConstant;
import com.tangosol.dev.assembler.Invokeinterface;
import com.tangosol.dev.assembler.Invokespecial;
import com.tangosol.dev.assembler.Invokestatic;
import com.tangosol.dev.assembler.Invokevirtual;
import com.tangosol.dev.assembler.Laload;
import com.tangosol.dev.assembler.Lastore;
import com.tangosol.dev.assembler.MethodConstant;
import com.tangosol.dev.assembler.Op;
import com.tangosol.dev.assembler.Pop;
import com.tangosol.dev.assembler.Pop2;
import com.tangosol.dev.assembler.Putfield;
import com.tangosol.dev.assembler.Putstatic;
import com.tangosol.dev.assembler.Saload;
import com.tangosol.dev.assembler.Sastore;
import com.tangosol.dev.compiler.CompilerException;
import com.tangosol.dev.compiler.Context;
import com.tangosol.dev.compiler.FieldInfo;
import com.tangosol.dev.compiler.Info;
import com.tangosol.dev.compiler.MethodInfo;
import com.tangosol.dev.compiler.TypeInfo;
import com.tangosol.dev.compiler.java.DualSet;
import com.tangosol.dev.compiler.java.Element;
import com.tangosol.dev.compiler.java.Expression;
import com.tangosol.dev.compiler.java.SuperExpression;
import com.tangosol.dev.compiler.java.ThisExpression;
import com.tangosol.dev.compiler.java.Token;
import com.tangosol.dev.compiler.java.TypeExpression;
import com.tangosol.dev.compiler.java.UnaryExpression;
import com.tangosol.dev.compiler.java.VariableExpression;
import com.tangosol.dev.component.Behavior;
import com.tangosol.dev.component.DataType;
import com.tangosol.util.ChainedEnumerator;
import com.tangosol.util.ErrorList;
import com.tangosol.util.SimpleEnumerator;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class InvocationExpression
extends UnaryExpression {
    private static final String CLASS = "InvocationExpression";
    private static final DataType VOID = DataType.VOID;
    private static final DataType INT = DataType.INT;
    private static final DataType LONG = DataType.LONG;
    private static final DataType DOUBLE = DataType.DOUBLE;
    private static final DataType OBJECT = DataType.OBJECT;
    private static final DataType UNKNOWN = DataType.UNKNOWN;
    private Token m_tokName;
    private Expression[] m_aexprParams;
    private MethodInfo m_method;
    private boolean m_fSuper;

    public InvocationExpression(Expression expr, Token tokName, Token tokLeft, Expression[] params, Token tokRight) {
        super(tokLeft, expr);
        this.setStartToken(expr.getStartToken());
        this.setEndToken(tokRight);
        this.m_tokName = tokName;
        this.m_aexprParams = params;
    }

    @Override
    protected Element precompile(Context ctx, DualSet setUVars, DualSet setFVars, Map mapThrown, ErrorList errlist) throws CompilerException {
        boolean fRef;
        Expression expr = this.getExpression();
        Token tokName = this.m_tokName;
        String sName = tokName.getText();
        if (expr instanceof SuperExpression) {
            if (sName.equals(ctx.getMethodInfo().getName())) {
                this.m_fSuper = true;
                ((SuperExpression)expr).allowSuper();
            } else {
                expr.logError(3, "JC-064", null, errlist);
                Token tokThis = new Token(Token.TOK_THIS, tokName.getLine(), tokName.getOffset(), 0);
                expr = new ThisExpression(this.getBlock(), tokThis);
            }
        }
        expr = (Expression)expr.precompile(ctx, setUVars, setFVars, mapThrown, errlist);
        this.setExpression(expr);
        boolean fSkip = false;
        boolean bl = fRef = !(expr instanceof TypeExpression);
        if (expr.getType() == UNKNOWN) {
            fSkip = true;
        } else {
            if (expr instanceof SuperExpression) {
                throw new IllegalStateException();
            }
            if (fRef) {
                fSkip = !expr.checkReference(false, errlist);
            }
        }
        Expression[] aexpr = this.m_aexprParams;
        int cexpr = aexpr.length;
        for (int i = 0; i < cexpr; ++i) {
            Expression param = (Expression)aexpr[i].precompile(ctx, setUVars, setFVars, mapThrown, errlist);
            if (param.getType() == UNKNOWN || !param.checkValue(errlist)) {
                fSkip = true;
            }
            aexpr[i] = param;
        }
        Info method = null;
        if (!fSkip) {
            if (this.m_fSuper) {
                method = ctx.getSuperInfo();
                if (method == null) {
                    expr.logError(3, "JC-065", new String[]{sName}, errlist);
                } else if (method.getParamCount() != cexpr) {
                    expr.logError(3, "JC-066", new String[]{"" + cexpr, "" + method.getParamCount()}, errlist);
                } else {
                    for (int i = 0; i < cexpr; ++i) {
                        aexpr[i].checkInvocationAssignable(ctx, method.getParamInfo(i).getDataType(), errlist);
                    }
                }
            } else {
                TypeInfo typeRef = ctx.getTypeInfo(expr.getType());
                if (typeRef == null) {
                    throw new IllegalStateException("Missing type: " + String.valueOf(expr.getType()));
                }
                TypeInfo typeObj = ctx.getTypeInfo(OBJECT);
                boolean fInterface = typeRef.isInterface();
                DataType[] adtParam = new DataType[cexpr];
                for (int i = 0; i < cexpr; ++i) {
                    adtParam[i] = aexpr[i].getType();
                }
                method = typeRef.getMethodInfo(sName, adtParam);
                if (method == null && fInterface) {
                    method = typeObj.getMethodInfo(sName, adtParam);
                }
                if (method != null && !method.isAccessible()) {
                    method = null;
                }
                if (method == null) {
                    ArrayList<Info> list = new ArrayList<Info>();
                    Enumeration<Object> enmr = typeRef.paramTypes(sName, cexpr);
                    if (fInterface) {
                        Hashtable<String, DataType[]> tbl = new Hashtable<String, DataType[]>();
                        enmr = new ChainedEnumerator(enmr, typeObj.paramTypes(sName, cexpr));
                        while (enmr.hasMoreElements()) {
                            DataType[] adt = (DataType[])enmr.nextElement();
                            tbl.put(Behavior.getSignature("", adt), adt);
                        }
                        enmr = tbl.elements();
                    }
                    block8: while (enmr.hasMoreElements()) {
                        DataType[] adt = (DataType[])enmr.nextElement();
                        method = typeRef.getMethodInfo(sName, adt);
                        if (method == null) {
                            method = typeObj.getMethodInfo(sName, adt);
                        }
                        if (!method.isAccessible()) continue;
                        for (int i = 0; i < cexpr; ++i) {
                            if (!InvocationExpression.isAssignable(ctx, adtParam[i], adt[i], errlist)) continue block8;
                        }
                        list.add(method);
                    }
                    switch (list.size()) {
                        case 0: {
                            this.logError(3, "JC-067", new String[]{sName, expr.getType().toString()}, errlist);
                            method = null;
                            break;
                        }
                        case 1: {
                            method = (MethodInfo)list.get(0);
                            break;
                        }
                        default: {
                            enmr = new SimpleEnumerator<Object>(list.toArray());
                            while (enmr.hasMoreElements()) {
                                MethodInfo methodT = (MethodInfo)enmr.nextElement();
                                if (!list.contains(methodT)) continue;
                                Iterator iter = list.iterator();
                                block11: while (iter.hasNext()) {
                                    MethodInfo methodU = (MethodInfo)iter.next();
                                    if (methodT == methodU || !InvocationExpression.isAssignable(ctx, methodT.getTypeInfo().getDataType(), methodU.getTypeInfo().getDataType(), errlist)) continue;
                                    for (int i = 0; i < cexpr; ++i) {
                                        if (!InvocationExpression.isAssignable(ctx, methodT.getParamInfo(i).getDataType(), methodU.getParamInfo(i).getDataType(), errlist)) continue block11;
                                    }
                                    iter.remove();
                                }
                            }
                            if (list.size() == 1) {
                                method = (MethodInfo)list.get(0);
                                break;
                            }
                            method = null;
                            this.logError(3, "JC-068", new String[]{sName, expr.getType().toString()}, errlist);
                        }
                    }
                }
            }
        }
        if (method != null) {
            if (!(method.isStatic() || fRef || sName.equals("<init>"))) {
                this.logError(3, "JC-063", new String[]{sName}, errlist);
            }
            if (!method.isAccessible()) {
                this.logError(3, "JC-059", new String[]{sName, expr.getType().toString()}, errlist);
            }
            Enumeration enmr = method.exceptionTypes();
            while (enmr.hasMoreElements()) {
                this.checkThrownException(ctx, (DataType)enmr.nextElement(), mapThrown, errlist);
            }
            this.setType(method.getDataType());
            for (int i = 0; i < cexpr; ++i) {
                aexpr[i] = aexpr[i].convertAssignable(ctx, method.getParamInfo(i).getDataType());
            }
            this.addDependency((MethodInfo)method, false);
        }
        this.m_method = method;
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean compile(Context ctx, CodeAttribute code, boolean fReached, ErrorList errlist) throws CompilerException {
        Expression expr = this.getExpression();
        boolean fStatic = this.isStatic();
        boolean fOmitRef = false;
        MethodInfo method = this.m_method;
        Expression[] aexpr = this.m_aexprParams;
        int cexpr = aexpr.length;
        String sName = this.m_tokName.getText();
        if (sName.equals("<init>")) {
            fOmitRef = true;
        } else if (fStatic && (expr.isConstant() || expr instanceof TypeExpression || expr instanceof VariableExpression || expr instanceof ThisExpression)) {
            fOmitRef = true;
        }
        if (!fOmitRef) {
            expr.compile(ctx, code, fReached, errlist);
            if (fStatic) {
                code.add(new Pop());
            }
        }
        if (method.isInlined() || !ctx.isDebug() && method.isInlineable()) {
            FieldInfo field = method.getFieldInfo();
            this.addDependency(field, false);
            if (field.isInlined() || !ctx.isDebug() && field.isInlineable()) {
                if (!fOmitRef) {
                    code.add(new Pop());
                }
                if (field.getDataType() != VOID) {
                    super.compile(ctx, code, fReached, errlist);
                }
                if (cexpr == 1 && aexpr[0].getType() == INT && field.getDataType().isArray() && field.getDataType().getElementType() == method.getDataType()) {
                    aexpr[0].compile(ctx, code, fReached, errlist);
                    code.add(InvocationExpression.arrayLoad(this.getType()));
                } else if (cexpr > 0) {
                    for (int i = 0; i < cexpr; ++i) {
                        Expression exprParam = aexpr[i];
                        if (exprParam.isConstant() || exprParam instanceof TypeExpression || exprParam instanceof VariableExpression || exprParam instanceof ThisExpression) continue;
                        exprParam.compile(ctx, code, fReached, errlist);
                        DataType dt = exprParam.getType();
                        code.add(dt == LONG || dt == DOUBLE ? new Pop2() : new Pop());
                    }
                }
            } else {
                this.addDependency(field, true);
                FieldConstant constant = (FieldConstant)field.getConstant();
                sName = method.getName();
                if (sName.startsWith("is") || sName.startsWith("get")) {
                    code.add(fStatic ? new Getstatic(constant) : new Getfield(constant));
                    if (cexpr == 1 && aexpr[0].getType() == INT) {
                        aexpr[0].compile(ctx, code, fReached, errlist);
                        code.add(InvocationExpression.arrayLoad(this.getType()));
                    } else if (cexpr != 0) {
                        throw new IllegalStateException();
                    }
                } else {
                    if (!sName.startsWith("set")) throw new IllegalStateException();
                    if (cexpr == 1) {
                        aexpr[0].compile(ctx, code, fReached, errlist);
                        code.add(fStatic ? new Putstatic(constant) : new Putfield(constant));
                    } else {
                        if (cexpr != 2 || aexpr[0].getType() != INT) throw new IllegalStateException();
                        code.add(fStatic ? new Getstatic(constant) : new Getfield(constant));
                        aexpr[0].compile(ctx, code, fReached, errlist);
                        aexpr[1].compile(ctx, code, fReached, errlist);
                        code.add(InvocationExpression.arrayStore(aexpr[1].getType()));
                    }
                }
            }
        } else {
            for (int i = 0; i < cexpr; ++i) {
                aexpr[i].compile(ctx, code, fReached, errlist);
            }
            MethodConstant constant = (MethodConstant)method.getConstant();
            if (constant instanceof InterfaceConstant) {
                if (this.m_fSuper) {
                    expr.logError(3, "JC-076", null, errlist);
                } else if (method.isStatic()) {
                    expr.logError(3, "JC-077", null, errlist);
                } else {
                    code.add(new Invokeinterface((InterfaceConstant)constant));
                }
            } else if (fStatic) {
                code.add(new Invokestatic(constant));
            } else if (method.isPrivate() || this.m_fSuper || method.getName().equals("<init>")) {
                code.add(new Invokespecial(constant));
            } else {
                code.add(new Invokevirtual(constant));
            }
            this.addDependency(method, true);
        }
        if (!this.isDiscarded()) return fReached;
        switch (this.getType().getTypeString().charAt(0)) {
            default: {
                code.add(new Pop());
                return fReached;
            }
            case 'D': 
            case 'J': {
                code.add(new Pop2());
            }
            case 'V': 
        }
        return fReached;
    }

    protected void addDependency(MethodInfo method, boolean fRuntime) throws CompilerException {
        Token tokMethod = this.m_tokName;
        method.addDependency(fRuntime, tokMethod.getLine(), tokMethod.getOffset(), tokMethod.getLine(), tokMethod.getOffset() + tokMethod.getLength());
    }

    protected void addDependency(FieldInfo field, boolean fRuntime) throws CompilerException {
        Token tokField = this.m_tokName;
        field.addDependency(fRuntime, tokField.getLine(), tokField.getOffset(), tokField.getLine(), tokField.getOffset() + tokField.getLength());
    }

    private static Op arrayLoad(DataType dt) {
        return switch (dt.getTypeString().charAt(0)) {
            case 'B', 'Z' -> new Baload();
            case 'C' -> new Caload();
            case 'S' -> new Saload();
            case 'I' -> new Iaload();
            case 'J' -> new Laload();
            case 'F' -> new Faload();
            case 'D' -> new Daload();
            case 'L', 'N', 'R' -> new Aaload();
            default -> throw new IllegalStateException();
        };
    }

    private static Op arrayStore(DataType dt) {
        return switch (dt.getTypeString().charAt(0)) {
            case 'B', 'Z' -> new Bastore();
            case 'C' -> new Castore();
            case 'S' -> new Sastore();
            case 'I' -> new Iastore();
            case 'J' -> new Lastore();
            case 'F' -> new Fastore();
            case 'D' -> new Dastore();
            case 'L', 'N', 'R' -> new Aastore();
            default -> throw new IllegalStateException();
        };
    }

    public String getName() {
        return this.m_tokName.getText();
    }

    public MethodConstant getMethodConstant() {
        MethodInfo method = this.m_method;
        return method == null ? null : (MethodConstant)this.m_method.getConstant();
    }

    public boolean isStatic() {
        MethodInfo method = this.m_method;
        return method != null && method.isStatic();
    }

    @Override
    public Object getValue() {
        return this.m_method.getFieldInfo().getValue();
    }

    @Override
    public void print(String sIndent) {
        super.print(sIndent);
        InvocationExpression.out(sIndent + "  parameters:");
        Expression[] aexpr = this.m_aexprParams;
        int cexpr = aexpr.length;
        for (int i = 0; i < cexpr; ++i) {
            aexpr[i].print(sIndent + "    ");
        }
    }
}

