/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.compiler.CompilerException;
import com.tangosol.dev.compiler.java.Statement;
import com.tangosol.dev.compiler.java.Token;
import com.tangosol.dev.compiler.java.Variable;
import com.tangosol.util.NullImplementation;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public abstract class Block
extends Statement {
    private static final String CLASS = "Block";
    private Statement last;
    private final Map mapVars = new HashMap();
    private Set SET_VARS;

    protected Block(Statement outer, Token token) {
        super(outer, token);
    }

    public void addStatement(Statement stmt) {
        if (this.last == null) {
            this.setInnerStatement(stmt);
        } else {
            this.last.setNextStatement(stmt);
        }
        this.last = stmt;
    }

    protected boolean registerVariable(Variable var) throws CompilerException {
        String sName = var.getName();
        boolean fHides = this.getVariable(sName) != null;
        this.mapVars.put(sName, var);
        return !fHides;
    }

    protected Variable getVariable(String sName) {
        Block block;
        Variable var = (Variable)this.mapVars.get(sName);
        if (var == null && (block = this.getBlock()) != null) {
            var = this.getBlock().getVariable(sName);
        }
        return var;
    }

    protected Set getVariables() {
        if (this.SET_VARS == null) {
            Block block = this.getBlock();
            Set setOuter = block == null ? NullImplementation.getSet() : block.getVariables();
            this.SET_VARS = new VariableSet(this.mapVars, setOuter);
        }
        return this.SET_VARS;
    }

    private static class VariableSet
    extends AbstractSet {
        private Map mapVars;
        private Set setOuter;

        public VariableSet(Map mapVars, Set setOuter) {
            this.mapVars = mapVars;
            this.setOuter = setOuter;
        }

        @Override
        public Iterator iterator() {
            VariableIterator iter = this.setOuter.iterator();
            if (!this.mapVars.isEmpty()) {
                iter = new VariableIterator(this.mapVars.values().iterator(), iter);
            }
            return iter;
        }

        @Override
        public int size() {
            return this.mapVars.size() + this.setOuter.size();
        }

        @Override
        public boolean contains(Object o) {
            try {
                return o == this.mapVars.get(((Variable)o).getName()) || this.setOuter.contains(o);
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        private static class VariableIterator
        implements Iterator {
            private Iterator iterVars;
            private Iterator iterOuter;

            protected VariableIterator(Iterator iterCurrent, Iterator iterOuter) {
                this.iterVars = iterCurrent;
                this.iterOuter = iterOuter;
            }

            @Override
            public boolean hasNext() {
                boolean fNext = this.iterVars.hasNext();
                if (!fNext && this.iterOuter != null) {
                    this.iterVars = this.iterOuter;
                    this.iterOuter = null;
                    fNext = this.iterVars.hasNext();
                }
                return fNext;
            }

            public Object next() {
                try {
                    return this.iterVars.next();
                }
                catch (NoSuchElementException e) {
                    if (this.hasNext()) {
                        return this.next();
                    }
                    throw e;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

