/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.assembler.CodeAttribute;
import com.tangosol.dev.assembler.Iand;
import com.tangosol.dev.assembler.Land;
import com.tangosol.dev.compiler.CompilerException;
import com.tangosol.dev.compiler.Context;
import com.tangosol.dev.compiler.java.BitwiseExpression;
import com.tangosol.dev.compiler.java.DualSet;
import com.tangosol.dev.compiler.java.Element;
import com.tangosol.dev.compiler.java.Expression;
import com.tangosol.dev.compiler.java.Token;
import com.tangosol.dev.component.DataType;
import com.tangosol.util.ErrorList;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;

public class BitAndExpression
extends BitwiseExpression {
    private static final String CLASS = "BitAndExpression";

    public BitAndExpression(Expression left, Token operator, Expression right) {
        super(left, operator, right);
    }

    @Override
    protected Element precompile(Context ctx, DualSet setUVars, DualSet setFVars, Map mapThrown, ErrorList errlist) throws CompilerException {
        Expression left = this.getLeftExpression();
        Expression right = this.getRightExpression();
        DualSet setULeft = new DualSet(setUVars);
        DualSet setFLeft = new DualSet(setFVars);
        left = (Expression)left.precompile(ctx, setULeft, setFLeft, mapThrown, errlist);
        DualSet setURight = new DualSet(setULeft);
        DualSet setFRight = new DualSet(setFLeft);
        right = (Expression)right.precompile(ctx, setURight, setFRight, mapThrown, errlist);
        if (left.getType() == BOOLEAN && right.getType() == BOOLEAN) {
            if (setULeft.isModified() || setURight.isModified()) {
                Set setRemovedTrue = setULeft.getTrueSet().getRemoved();
                setRemovedTrue.addAll(setURight.getTrueSet().getRemoved());
                setUVars.getTrueSet().removeAll(setRemovedTrue);
                Set setRemovedFalse = setULeft.getFalseSet().getRemoved();
                setRemovedFalse.retainAll(setURight.getFalseSet().getRemoved());
                setUVars.getFalseSet().removeAll(setRemovedFalse);
            }
            if (setFLeft.isModified()) {
                setFVars.getFalseSet().addAll(setFLeft.getAdded());
                setFVars.getTrueSet().addAll(setFLeft.getTrueSet().getAdded());
            }
            if (setFRight.isModified()) {
                setFVars.getFalseSet().addAll(setFRight.getAdded());
                setFVars.getTrueSet().addAll(setFRight.getTrueSet().getAdded());
            }
            this.setType(BOOLEAN);
        } else if (left.checkIntegral(errlist) & right.checkIntegral(errlist)) {
            setURight.resolve();
            setFRight.resolve();
            setULeft.resolve();
            setFLeft.resolve();
            left = left.promoteNumeric(right);
            right = right.promoteNumeric(left);
            this.setType(left.getType());
        } else {
            this.setType(INT);
        }
        this.setLeftExpression(left);
        this.setRightExpression(right);
        return this;
    }

    @Override
    protected boolean compile(Context ctx, CodeAttribute code, boolean fReached, ErrorList errlist) throws CompilerException {
        if (!ctx.isDebug() && this.isConstant()) {
            return super.compile(ctx, code, fReached, errlist);
        }
        this.getLeftExpression().compile(ctx, code, fReached, errlist);
        this.getRightExpression().compile(ctx, code, fReached, errlist);
        if (this.getType() == DataType.LONG) {
            code.add(new Land());
        } else {
            code.add(new Iand());
        }
        return fReached;
    }

    @Override
    public Object getValue() {
        Object oLeft = this.getLeftExpression().getValue();
        Object oRight = this.getRightExpression().getValue();
        DataType dt = this.getType();
        Serializable oVal = dt == BOOLEAN ? (Serializable)Boolean.valueOf((Boolean)oLeft & (Boolean)oRight) : (Serializable)(dt == LONG ? (Number)(((Number)oLeft).longValue() & ((Number)oRight).longValue()) : (Number)(((Number)oLeft).intValue() & ((Number)oRight).intValue()));
        return oVal;
    }
}

