/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.compiler.java.Expression;
import com.tangosol.dev.compiler.java.Token;

public abstract class BinaryExpression
extends Expression {
    private static final String CLASS = "BinaryExpression";
    private Expression left;
    private Token operator;
    private Expression right;

    protected BinaryExpression(Expression left, Token operator, Expression right) {
        super(left.getBlock(), left.getStartToken(), right.getEndToken());
        this.left = left;
        this.operator = operator;
        this.right = right;
    }

    @Override
    public boolean isConstant() {
        return this.left.isConstant() && this.right.isConstant();
    }

    @Override
    public void print(String sIndent) {
        Expression left = this.getLeftExpression();
        Expression right = this.getRightExpression();
        BinaryExpression.out((String)sIndent + this.toString());
        sIndent = (String)sIndent + "  ";
        BinaryExpression.out((String)sIndent + "Left:");
        left.print((String)sIndent + "  ");
        BinaryExpression.out((String)sIndent + "Operator:  " + this.operator.toString());
        BinaryExpression.out((String)sIndent + "Right:");
        right.print((String)sIndent + "  ");
    }

    public Expression getLeftExpression() {
        return this.left;
    }

    protected void setLeftExpression(Expression left) {
        this.left = left;
    }

    public Token getOperator() {
        return this.operator;
    }

    public Expression getRightExpression() {
        return this.right;
    }

    protected void setRightExpression(Expression right) {
        this.right = right;
    }
}

