/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.assembler.Aastore;
import com.tangosol.dev.assembler.Astore;
import com.tangosol.dev.assembler.Avar;
import com.tangosol.dev.assembler.Bastore;
import com.tangosol.dev.assembler.Castore;
import com.tangosol.dev.assembler.CodeAttribute;
import com.tangosol.dev.assembler.Dastore;
import com.tangosol.dev.assembler.Dstore;
import com.tangosol.dev.assembler.Dup;
import com.tangosol.dev.assembler.Dup2;
import com.tangosol.dev.assembler.Dup2_x1;
import com.tangosol.dev.assembler.Dup2_x2;
import com.tangosol.dev.assembler.Dup_x1;
import com.tangosol.dev.assembler.Dup_x2;
import com.tangosol.dev.assembler.Dvar;
import com.tangosol.dev.assembler.Fastore;
import com.tangosol.dev.assembler.FieldConstant;
import com.tangosol.dev.assembler.Fstore;
import com.tangosol.dev.assembler.Fvar;
import com.tangosol.dev.assembler.Iastore;
import com.tangosol.dev.assembler.Istore;
import com.tangosol.dev.assembler.Ivar;
import com.tangosol.dev.assembler.Lastore;
import com.tangosol.dev.assembler.Lstore;
import com.tangosol.dev.assembler.Lvar;
import com.tangosol.dev.assembler.Op;
import com.tangosol.dev.assembler.OpDeclare;
import com.tangosol.dev.assembler.OpStore;
import com.tangosol.dev.assembler.Putfield;
import com.tangosol.dev.assembler.Putstatic;
import com.tangosol.dev.assembler.Sastore;
import com.tangosol.dev.compiler.CompilerException;
import com.tangosol.dev.compiler.Context;
import com.tangosol.dev.compiler.java.ArrayAccessExpression;
import com.tangosol.dev.compiler.java.BinaryExpression;
import com.tangosol.dev.compiler.java.DualSet;
import com.tangosol.dev.compiler.java.Element;
import com.tangosol.dev.compiler.java.Expression;
import com.tangosol.dev.compiler.java.FieldAccessExpression;
import com.tangosol.dev.compiler.java.Token;
import com.tangosol.dev.compiler.java.TokenConstants;
import com.tangosol.dev.compiler.java.Variable;
import com.tangosol.dev.compiler.java.VariableExpression;
import com.tangosol.util.ErrorList;
import java.util.Map;

public class AssignExpression
extends BinaryExpression
implements TokenConstants {
    private static final String CLASS = "AssignExpression";

    public AssignExpression(Expression left, Token operator, Expression right) {
        super(left, operator, right);
    }

    @Override
    protected Element precompile(Context ctx, DualSet setUVars, DualSet setFVars, Map mapThrown, ErrorList errlist) throws CompilerException {
        return this.precompile(ctx, setUVars, setFVars, mapThrown, errlist, false);
    }

    protected Element precompile(Context ctx, DualSet setUVars, DualSet setFVars, Map mapThrown, ErrorList errlist, boolean fLeftDone) throws CompilerException {
        Expression left = this.getLeftExpression();
        Expression right = this.getRightExpression();
        if (!fLeftDone) {
            left.checkAssignable(errlist);
            left = (Expression)left.precompile(ctx, setUVars, setFVars, mapThrown, errlist);
        }
        if ((right = (Expression)right.precompile(ctx, setUVars, setFVars, mapThrown, errlist)).checkAssignable(ctx, left.getType(), errlist)) {
            right = right.convertAssignable(ctx, left.getType());
        }
        this.setLeftExpression(left);
        this.setRightExpression(right);
        this.setType(left.getType());
        if (left instanceof VariableExpression) {
            Variable var = ((VariableExpression)left).getVariable();
            setUVars.remove(var);
            if (var.isFinal()) {
                setFVars.add(var);
            }
        }
        return this;
    }

    @Override
    protected boolean compile(Context ctx, CodeAttribute code, boolean fReached, ErrorList errlist) throws CompilerException {
        Expression left = this.getLeftExpression();
        Expression right = this.getRightExpression();
        if (left instanceof VariableExpression) {
            Variable var = ((VariableExpression)left).getVariable();
            char chType = var.getType().getTypeString().charAt(0);
            right.compile(ctx, code, fReached, errlist);
            if (!this.isDiscarded()) {
                switch (chType) {
                    default: {
                        code.add(new Dup());
                        break;
                    }
                    case 'D': 
                    case 'J': {
                        code.add(new Dup2());
                    }
                }
            }
            OpDeclare opVar = var.getOp();
            OpStore opStore = null;
            switch (chType) {
                case 'B': 
                case 'C': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    opStore = new Istore((Ivar)opVar);
                    break;
                }
                case 'J': {
                    opStore = new Lstore((Lvar)opVar);
                    break;
                }
                case 'F': {
                    opStore = new Fstore((Fvar)opVar);
                    break;
                }
                case 'D': {
                    opStore = new Dstore((Dvar)opVar);
                    break;
                }
                case 'L': 
                case 'N': 
                case 'R': 
                case '[': {
                    opStore = new Astore((Avar)opVar);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            code.add(opStore);
        } else if (left instanceof ArrayAccessExpression) {
            ArrayAccessExpression exprElement = (ArrayAccessExpression)left;
            char chType = exprElement.getType().getTypeString().charAt(0);
            exprElement.getArray().compile(ctx, code, fReached, errlist);
            exprElement.getIndex().compile(ctx, code, fReached, errlist);
            right.compile(ctx, code, fReached, errlist);
            if (!this.isDiscarded()) {
                switch (chType) {
                    default: {
                        code.add(new Dup_x2());
                        break;
                    }
                    case 'D': 
                    case 'J': {
                        code.add(new Dup2_x2());
                    }
                }
            }
            Op opStore = null;
            switch (chType) {
                case 'B': 
                case 'Z': {
                    opStore = new Bastore();
                    break;
                }
                case 'C': {
                    opStore = new Castore();
                    break;
                }
                case 'S': {
                    opStore = new Sastore();
                    break;
                }
                case 'I': {
                    opStore = new Iastore();
                    break;
                }
                case 'J': {
                    opStore = new Lastore();
                    break;
                }
                case 'F': {
                    opStore = new Fastore();
                    break;
                }
                case 'D': {
                    opStore = new Dastore();
                    break;
                }
                case 'L': 
                case 'N': 
                case 'R': 
                case '[': {
                    opStore = new Aastore();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            code.add(opStore);
        } else if (left instanceof FieldAccessExpression) {
            FieldAccessExpression exprField = (FieldAccessExpression)left;
            boolean fStatic = exprField.isStatic();
            char chType = exprField.getType().getTypeString().charAt(0);
            if (!fStatic) {
                exprField.getExpression().compile(ctx, code, fReached, errlist);
            }
            right.compile(ctx, code, fReached, errlist);
            if (!this.isDiscarded()) {
                switch (chType) {
                    default: {
                        code.add(fStatic ? new Dup() : new Dup_x1());
                        break;
                    }
                    case 'D': 
                    case 'J': {
                        code.add(fStatic ? new Dup2() : new Dup2_x1());
                    }
                }
            }
            FieldConstant field = exprField.getFieldConstant();
            code.add(fStatic ? new Putstatic(field) : new Putfield(field));
        } else {
            throw new IllegalStateException();
        }
        return fReached;
    }

    @Override
    public boolean isConstant() {
        return false;
    }
}

