/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.assembler.ClassConstant;
import com.tangosol.dev.assembler.CodeAttribute;
import com.tangosol.dev.assembler.Dadd;
import com.tangosol.dev.assembler.Dup;
import com.tangosol.dev.assembler.Fadd;
import com.tangosol.dev.assembler.Iadd;
import com.tangosol.dev.assembler.Invokespecial;
import com.tangosol.dev.assembler.Invokestatic;
import com.tangosol.dev.assembler.Invokevirtual;
import com.tangosol.dev.assembler.Ladd;
import com.tangosol.dev.assembler.MethodConstant;
import com.tangosol.dev.assembler.New;
import com.tangosol.dev.compiler.CompilerException;
import com.tangosol.dev.compiler.Context;
import com.tangosol.dev.compiler.java.AdditiveExpression;
import com.tangosol.dev.compiler.java.DualSet;
import com.tangosol.dev.compiler.java.Element;
import com.tangosol.dev.compiler.java.Expression;
import com.tangosol.dev.compiler.java.Token;
import com.tangosol.dev.component.DataType;
import com.tangosol.util.ErrorList;
import java.util.Map;

public class AddExpression
extends AdditiveExpression {
    private static final String CLASS = "AddExpression";
    private static final DataType STRING = DataType.STRING;
    private static final DataType UNKNOWN = DataType.UNKNOWN;
    private static final String STRINGBUILDER = "java/lang/StringBuilder";
    private static final ClassConstant CLZ_STRINGBUFFER = new ClassConstant("java/lang/StringBuilder");
    private static final MethodConstant INIT_STRINGBUFFER = new MethodConstant("java/lang/StringBuilder", "<init>", "(Ljava/lang/String;)V");
    private static final MethodConstant STRINGBUFFER_TOSTRING = new MethodConstant("java/lang/StringBuilder", "toString", "()Ljava/lang/String;");

    public AddExpression(Expression left, Token operator, Expression right) {
        super(left, operator, right);
    }

    @Override
    protected Element precompile(Context ctx, DualSet setUVars, DualSet setFVars, Map mapThrown, ErrorList errlist) throws CompilerException {
        Expression left = this.getLeftExpression();
        Expression right = this.getRightExpression();
        left = (Expression)left.precompile(ctx, setUVars, setFVars, mapThrown, errlist);
        right = (Expression)right.precompile(ctx, setUVars, setFVars, mapThrown, errlist);
        if (left.getType() != UNKNOWN && right.getType() != UNKNOWN) {
            if (left.getType() == STRING || right.getType() == STRING) {
                this.setType(STRING);
            } else if (left.checkNumeric(errlist) & right.checkNumeric(errlist)) {
                left = left.promoteNumeric(right);
                right = right.promoteNumeric(left);
                this.setType(left.getType());
            }
        }
        this.setLeftExpression(left);
        this.setRightExpression(right);
        return this;
    }

    @Override
    protected boolean compile(Context ctx, CodeAttribute code, boolean fReached, ErrorList errlist) throws CompilerException {
        if (!ctx.isDebug() && this.isConstant()) {
            return super.compile(ctx, code, fReached, errlist);
        }
        if (this.getType() == STRING) {
            this.compileConcatenation(ctx, code, fReached, errlist);
            code.add(new Invokevirtual(STRINGBUFFER_TOSTRING));
            return fReached;
        }
        this.getLeftExpression().compile(ctx, code, fReached, errlist);
        this.getRightExpression().compile(ctx, code, fReached, errlist);
        switch (this.getType().getTypeString().charAt(0)) {
            case 'I': {
                code.add(new Iadd());
                break;
            }
            case 'J': {
                code.add(new Ladd());
                break;
            }
            case 'F': {
                code.add(new Fadd());
                break;
            }
            case 'D': {
                code.add(new Dadd());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return fReached;
    }

    protected boolean compileConcatenation(Context ctx, CodeAttribute code, boolean fReached, ErrorList errlist) throws CompilerException {
        Expression left = this.getLeftExpression();
        Expression right = this.getRightExpression();
        if (left instanceof AddExpression && left.getType() == STRING && (ctx.isDebug() || !left.isConstant())) {
            ((AddExpression)left).compileConcatenation(ctx, code, fReached, errlist);
        } else {
            code.add(new New(CLZ_STRINGBUFFER));
            code.add(new Dup());
            left.compile(ctx, code, fReached, errlist);
            if (ctx.isDebug() || left.getType() != STRING || !left.isConstant() || left.getValue() == null) {
                code.add(new Invokestatic(left.getConvertMethod()));
            }
            code.add(new Invokespecial(INIT_STRINGBUFFER));
        }
        right.compile(ctx, code, fReached, errlist);
        code.add(new Invokevirtual(right.getAppendMethod()));
        return fReached;
    }

    @Override
    public Object getValue() {
        Expression left = this.getLeftExpression();
        Expression right = this.getRightExpression();
        Object oLeft = left.getValue();
        Object oRight = right.getValue();
        switch (this.getType().getTypeString().charAt(0)) {
            case 'I': {
                return ((Number)oLeft).intValue() + ((Number)oRight).intValue();
            }
            case 'J': {
                return ((Number)oLeft).longValue() + ((Number)oRight).longValue();
            }
            case 'F': {
                return Float.valueOf(((Number)oLeft).floatValue() + ((Number)oRight).floatValue());
            }
            case 'D': {
                return ((Number)oLeft).doubleValue() + ((Number)oRight).doubleValue();
            }
            case 'L': {
                return left.getStringValue() + right.getStringValue();
            }
        }
        throw new IllegalStateException();
    }
}

