/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.Annotation;
import com.tangosol.dev.assembler.ConstantPool;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.VMStructure;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;

public class TypeAnnotation
extends Annotation {
    protected AbstractTarget m_target;
    protected TypePath m_typePath;

    @Override
    protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
        this.m_target = AbstractTarget.loadTarget(stream, pool);
        this.m_typePath = new TypePath();
        this.m_typePath.disassemble(stream, pool);
        super.disassemble(stream, pool);
    }

    @Override
    protected void preassemble(ConstantPool pool) {
        super.preassemble(pool);
    }

    @Override
    protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
        this.m_target.assemble(stream, pool);
        this.m_typePath.assemble(stream, pool);
        super.assemble(stream, pool);
    }

    @Override
    public int getSize() {
        return this.m_target.getSize() + this.m_typePath.getSize() + super.getSize();
    }

    public static abstract class AbstractTarget
    extends VMStructure
    implements Constants {
        public static final byte TARGET_CLASS = 0;
        public static final byte TARGET_METHOD = 1;
        public static final byte TARGET_EXT_IMPL = 16;
        public static final byte TARGET_PARAM_BOUND_CLASS = 17;
        public static final byte TARGET_PARAM_BOUND_METHOD = 18;
        public static final byte TARGET_FIELD = 19;
        public static final byte TARGET_METHOD_RETURN = 20;
        public static final byte TARGET_METHOD_RECEIVER = 21;
        public static final byte TARGET_METHOD_PARAM = 22;
        public static final byte TARGET_METHOD_THROWS = 23;
        public static final byte TARGET_CODE_LOCAL_VAR = 64;
        public static final byte TARGET_CODE_RESOURCE_VAR = 65;
        public static final byte TARGET_CODE_EXCEPTION_PARAM = 66;
        public static final byte TARGET_CODE_INSTANCEOF = 67;
        public static final byte TARGET_CODE_NEW = 68;
        public static final byte TARGET_CODE_METHOD_REF_NEW = 69;
        public static final byte TARGET_CODE_METHOD_REF = 70;
        public static final byte TARGET_CODE_CAST = 71;
        public static final byte TARGET_CODE_CONSTRUCTOR = 72;
        public static final byte TARGET_CODE_METHOD = 73;
        public static final byte TARGET_CODE_METHOD_REF_NEW_ARG = 74;
        public static final byte TARGET_CODE_METHOD_REF_ARG = 75;
        protected byte m_bType;

        protected AbstractTarget(byte bType) {
            this.m_bType = bType;
        }

        protected int getSize() {
            return 1;
        }

        public static AbstractTarget loadTarget(DataInput stream, ConstantPool pool) throws IOException {
            byte bType = stream.readByte();
            AbstractTarget target = switch (bType) {
                case 0, 1 -> new TypeParameterTarget(bType);
                case 16 -> new SuperTypeTarget(bType);
                case 17, 18 -> new TypeParameterBoundTarget(bType);
                case 19, 20, 21 -> new EmptyTarget(bType);
                case 22 -> new FormalParameterTarget(bType);
                case 23 -> new ThrowsTarget(bType);
                case 64, 65 -> new LocalVariableTarget(bType);
                case 66 -> new CatchTarget(bType);
                case 67, 68, 69, 70 -> new OffsetTarget(bType);
                case 71, 72, 73, 74, 75 -> new TypeArgumentTarget(bType);
                default -> throw new IllegalStateException("Unexpected target type: " + String.format("%X", bType));
            };
            target.disassemble(stream, pool);
            return target;
        }

        @Override
        protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
            stream.writeByte(this.m_bType);
        }
    }

    protected static class TypePath
    extends VMStructure
    implements Constants {
        public static final byte PATH_KIND_ARRAY = 0;
        public static final byte PATH_KIND_NESTED = 1;
        public static final byte PATH_KIND_BOUND = 2;
        public static final byte PATH_KIND_TYPE = 3;
        private static final byte PATH_KIND_MASK = 3;
        private static final char NO_PATH = '\u8000';
        protected int m_cPath;
        protected char[] m_achPath = new char[0];

        protected TypePath() {
        }

        @Override
        protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
            int cPath = this.m_cPath = stream.readUnsignedByte();
            char[] acPath = this.m_achPath;
            if (cPath > 0) {
                acPath = this.m_achPath = new char[cPath];
            }
            for (int i = 0; i < cPath; ++i) {
                acPath[i] = TypePath.toChar(stream.readUnsignedByte(), stream.readUnsignedByte());
            }
        }

        @Override
        protected void preassemble(ConstantPool pool) {
        }

        @Override
        protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
            int cPath = this.m_cPath;
            stream.writeByte(cPath);
            for (int i = 0; i < cPath; ++i) {
                stream.writeByte(this.getPathKind(i));
                stream.writeByte(this.getArgumentIndex(i));
            }
        }

        public void addPath(int nPathKind, int iArgument, int iPath) {
            if ((nPathKind & 0xFFFFFFFC) != 0) {
                throw new IllegalArgumentException("Invalid type_path_kind value: " + nPathKind);
            }
            if ((iArgument & 0xFFFFFF00) != 0) {
                throw new IllegalArgumentException("Invalid type_argument_index provided: " + iArgument);
            }
            int cPathUsed = this.size();
            if (iPath == -1) {
                iPath = cPathUsed;
            }
            if (iPath >= this.m_achPath.length) {
                this.grow();
            }
            if ((this.m_achPath[iPath] & 0xFF00) != 32768) {
                if (this.m_achPath.length == cPathUsed) {
                    this.grow();
                }
                char[] acPath = this.m_achPath;
                for (int i = cPathUsed - 1; i >= iPath; --i) {
                    acPath[i + 1] = acPath[i];
                }
            }
            this.m_achPath[iPath] = TypePath.toChar(nPathKind, iArgument);
            ++this.m_cPath;
        }

        public void removePath(int iPath) {
            int cPath = this.size();
            if (iPath < 0) {
                iPath = cPath;
            }
            char[] achPath = this.m_achPath;
            for (int i = iPath; i < cPath; ++i) {
                achPath[i] = achPath[i + 1];
            }
            achPath[cPath - 1] = 32768;
            --this.m_cPath;
        }

        public int size() {
            return this.m_cPath;
        }

        public int getPathKind(int iPath) {
            char chPath = this.m_achPath[iPath];
            return chPath == '\u8000' ? -1 : chPath >> 8;
        }

        public int getArgumentIndex(int iPath) {
            char chPath = this.m_achPath[iPath];
            return chPath == '\u8000' ? -1 : chPath & 0xFF;
        }

        protected int getSize() {
            return 1 + 2 * this.size();
        }

        protected void grow() {
            char[] acOld = this.m_achPath;
            int cPath = acOld.length;
            char[] acNew = new char[cPath + Math.min(Math.max(cPath >> 1, 4), 16)];
            Arrays.fill(acNew, Math.max(cPath - 1, 0), acNew.length, '\u8000');
            System.arraycopy(acOld, 0, acNew, 0, cPath);
        }

        protected static char toChar(int nPathKind, int iArgument) {
            return (char)(nPathKind << 8 | iArgument);
        }
    }

    protected static class TypeArgumentTarget
    extends AbstractTarget {
        protected int m_iCodeArray;
        protected int m_iTypeArgument;

        protected TypeArgumentTarget(byte bType) {
            super(bType);
        }

        @Override
        protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
            this.m_iCodeArray = stream.readUnsignedShort();
            this.m_iTypeArgument = stream.readUnsignedByte();
        }

        @Override
        protected void preassemble(ConstantPool pool) {
        }

        @Override
        protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
            super.assemble(stream, pool);
            stream.writeShort(this.m_iCodeArray);
            stream.writeByte(this.m_iTypeArgument);
        }

        @Override
        protected int getSize() {
            return super.getSize() + 3;
        }

        public int getCodeArrayIndex() {
            return this.m_iCodeArray;
        }

        public void setCodeArrayIndex(int iCodeArray) {
            if ((iCodeArray & 0xFFFF0000) != 0) {
                throw new IllegalArgumentException("Index into the code array must be in the range 0-65535");
            }
            this.m_iCodeArray = iCodeArray;
        }

        public int getTypeIndex() {
            return this.m_iTypeArgument;
        }

        public void setTypeIndex(int iType) {
            if ((iType & 0xFFFFFF00) != 0) {
                throw new IllegalArgumentException("Index to the type in a cast expression  or explicit type argument list must be in the range 0-255");
            }
            this.m_iTypeArgument = iType;
        }
    }

    protected static class OffsetTarget
    extends AbstractTarget {
        protected int m_iCodeArray;

        protected OffsetTarget(byte bType) {
            super(bType);
        }

        @Override
        protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
            this.m_iCodeArray = stream.readUnsignedShort();
        }

        @Override
        protected void preassemble(ConstantPool pool) {
        }

        @Override
        protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
            super.assemble(stream, pool);
            stream.writeShort(this.m_iCodeArray);
        }

        @Override
        protected int getSize() {
            return super.getSize() + 2;
        }

        public int getCodeArrayIndex() {
            return this.m_iCodeArray;
        }

        public void setCodeArrayIndex(int iCodeArray) {
            if ((iCodeArray & 0xFFFF0000) != 0) {
                throw new IllegalArgumentException("Index into the code array must be in the range 0-65535");
            }
            this.m_iCodeArray = iCodeArray;
        }
    }

    protected static class CatchTarget
    extends AbstractTarget {
        protected int m_iExceptionTable;

        protected CatchTarget(byte bType) {
            super(bType);
        }

        @Override
        protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
            this.m_iExceptionTable = stream.readUnsignedShort();
        }

        @Override
        protected void preassemble(ConstantPool pool) {
        }

        @Override
        protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
            super.assemble(stream, pool);
            stream.writeShort(this.m_iExceptionTable);
        }

        @Override
        protected int getSize() {
            return super.getSize() + 2;
        }

        public int getExceptionTableIndex() {
            return this.m_iExceptionTable;
        }

        public void setExceptionTableIndex(int iExceptionTable) {
            if ((iExceptionTable & 0xFFFF0000) != 0) {
                throw new IllegalArgumentException("Index into the exception_table must be in the range 0-65535");
            }
            this.m_iExceptionTable = iExceptionTable;
        }
    }

    protected static class LocalVariableTarget
    extends AbstractTarget {
        protected int m_cRange;
        protected LiveRange m_firstRange;

        protected LocalVariableTarget(byte bType) {
            super(bType);
        }

        @Override
        protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
            int cRange = this.m_cRange = stream.readUnsignedShort();
            LiveRange rangePrev = null;
            for (int i = 0; i < cRange; ++i) {
                LiveRange range = new LiveRange();
                range.disassemble(stream, pool);
                if (rangePrev == null) {
                    this.m_firstRange = range;
                } else {
                    rangePrev.m_next = range;
                }
                rangePrev = range;
            }
        }

        @Override
        protected void preassemble(ConstantPool pool) {
        }

        @Override
        protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
            super.assemble(stream, pool);
            int cRange = this.m_cRange;
            stream.writeShort(cRange);
            LiveRange range = this.m_firstRange;
            while (range != null) {
                range.assemble(stream, pool);
                range = range.m_next;
                --cRange;
            }
            assert (cRange == 0);
        }

        @Override
        protected int getSize() {
            return super.getSize() + 2 + this.m_cRange * LiveRange.getSize();
        }

        public void addLiveRange(int of, int cLength, int iCurrentFrame) {
            LiveRange range = new LiveRange();
            range.setVariableLiveRange(of, cLength);
            range.setCurrentFrameIndex(iCurrentFrame);
            if (this.m_firstRange == null) {
                this.m_firstRange = range;
            } else {
                LiveRange rangeLast = this.m_firstRange;
                while (rangeLast.m_next != null) {
                    rangeLast = rangeLast.m_next;
                }
                rangeLast.m_next = range;
            }
            ++this.m_cRange;
        }

        public static class LiveRange
        extends VMStructure
        implements Constants {
            protected int m_iStartPC;
            protected int m_cLength;
            protected int m_iCurrentFrame;
            protected LiveRange m_next;

            @Override
            protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
                this.m_iStartPC = stream.readUnsignedShort();
                this.m_cLength = stream.readUnsignedShort();
                this.m_iCurrentFrame = stream.readUnsignedShort();
            }

            @Override
            protected void preassemble(ConstantPool pool) {
            }

            @Override
            protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
                stream.writeShort(this.m_iStartPC);
                stream.writeShort(this.m_cLength);
                stream.writeShort(this.m_iCurrentFrame);
            }

            public int getCodeOffset() {
                return this.m_iStartPC;
            }

            public int getLength() {
                return this.m_cLength;
            }

            public void setVariableLiveRange(int of, int cLength) {
                this.m_iStartPC = of;
                this.m_cLength = cLength;
            }

            public int getCurrentFrameIndex() {
                return this.m_iCurrentFrame;
            }

            public void setCurrentFrameIndex(int iCurrentFrame) {
                this.m_iCurrentFrame = iCurrentFrame;
            }

            protected static int getSize() {
                return 6;
            }
        }
    }

    protected static class ThrowsTarget
    extends AbstractTarget {
        protected int m_iThrowsClause;

        protected ThrowsTarget(byte bType) {
            super(bType);
        }

        @Override
        protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
            this.m_iThrowsClause = stream.readUnsignedShort();
        }

        @Override
        protected void preassemble(ConstantPool pool) {
        }

        @Override
        protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
            super.assemble(stream, pool);
            stream.writeShort(this.m_iThrowsClause);
        }

        @Override
        protected int getSize() {
            return super.getSize() + 2;
        }

        public int getThrowsClauseIndex() {
            return this.m_iThrowsClause;
        }

        public void setThrowsClauseIndex(int iThrowsClause) {
            if ((iThrowsClause & 0xFFFF0000) != 0) {
                throw new IllegalArgumentException("Method or constructor throws clause index must be in the range 0-65535");
            }
            this.m_iThrowsClause = iThrowsClause;
        }
    }

    protected static class FormalParameterTarget
    extends AbstractTarget {
        protected int m_iFormalTypeParam;

        protected FormalParameterTarget(byte bType) {
            super(bType);
        }

        @Override
        protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
            this.m_iFormalTypeParam = stream.readUnsignedByte();
        }

        @Override
        protected void preassemble(ConstantPool pool) {
        }

        @Override
        protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
            super.assemble(stream, pool);
            stream.writeByte(this.m_iFormalTypeParam);
        }

        @Override
        protected int getSize() {
            return super.getSize() + 1;
        }

        public int getFormalTypeParamIndex() {
            return this.m_iFormalTypeParam;
        }

        public void setFormalTypeParamIndex(int iFormalTypeParam) {
            if ((iFormalTypeParam & 0xFFFFFF00) != 0) {
                throw new IllegalArgumentException("Type Parameter index must be in the range 0-255");
            }
            this.m_iFormalTypeParam = iFormalTypeParam;
        }
    }

    protected static class EmptyTarget
    extends AbstractTarget {
        protected EmptyTarget(byte bType) {
            super(bType);
        }

        @Override
        protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
        }

        @Override
        protected void preassemble(ConstantPool pool) {
        }

        @Override
        protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
            super.assemble(stream, pool);
        }
    }

    protected static class TypeParameterBoundTarget
    extends TypeParameterTarget {
        protected int m_iBound;

        protected TypeParameterBoundTarget(byte bType) {
            super(bType);
        }

        @Override
        protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
            super.disassemble(stream, pool);
            this.m_iBound = stream.readUnsignedByte();
        }

        @Override
        protected void preassemble(ConstantPool pool) {
        }

        @Override
        protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
            super.assemble(stream, pool);
            stream.writeByte(this.m_iBound);
        }

        @Override
        protected int getSize() {
            return super.getSize() + 2;
        }

        public int getBoundIndex() {
            return this.m_iBound;
        }

        public void setBoundIndex(int iBound) {
            if ((iBound & 0xFFFFFF00) != 0) {
                throw new IllegalArgumentException("Bound index must be in the range 0-255");
            }
            this.m_iBound = iBound;
        }
    }

    protected static class SuperTypeTarget
    extends AbstractTarget {
        protected int m_iSuperType;

        protected SuperTypeTarget(byte bType) {
            super(bType);
        }

        @Override
        protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
            this.m_iSuperType = stream.readUnsignedShort();
        }

        @Override
        protected void preassemble(ConstantPool pool) {
        }

        @Override
        protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
            super.assemble(stream, pool);
            stream.writeShort(this.m_iSuperType);
        }

        @Override
        protected int getSize() {
            return super.getSize() + 2;
        }

        public int getSuperParameterIndex() {
            return this.m_iSuperType;
        }

        public void setSuperTypeIndex(int iSuperType) {
            if ((iSuperType & 0xFFFF0000) != 0) {
                throw new IllegalArgumentException("Super Type (extends or implements) index must be in the range 0-65535");
            }
            this.m_iSuperType = iSuperType;
        }
    }

    protected static class TypeParameterTarget
    extends AbstractTarget {
        protected int m_iTypeParameter;

        protected TypeParameterTarget(byte bType) {
            super(bType);
        }

        @Override
        protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
            this.m_iTypeParameter = stream.readUnsignedByte();
        }

        @Override
        protected void preassemble(ConstantPool pool) {
        }

        @Override
        protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
            super.assemble(stream, pool);
            stream.writeByte(this.m_iTypeParameter);
        }

        @Override
        protected int getSize() {
            return super.getSize() + 1;
        }

        public int getTypeParameterIndex() {
            return this.m_iTypeParameter;
        }

        public void setTypeParameterIndex(int iTypeParameter) {
            if ((iTypeParameter & 0xFFFFFF00) != 0) {
                throw new IllegalArgumentException("Type Parameter index must be in the range 0-255");
            }
            this.m_iTypeParameter = iTypeParameter;
        }
    }
}

