/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.Constant;
import com.tangosol.dev.assembler.ConstantPool;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.UtfConstant;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class SignatureConstant
extends Constant
implements Constants {
    private static final String CLASS = "SignatureConstant";
    private UtfConstant m_utfName;
    private UtfConstant m_utfType;
    private int m_iRefName;
    private int m_iRefType;

    protected SignatureConstant() {
        super(12);
    }

    public SignatureConstant(String sName, String sType) {
        this(new UtfConstant(sName), new UtfConstant(sType.replace('.', '/')));
    }

    public SignatureConstant(UtfConstant constantName, UtfConstant constantType) {
        this();
        if (constantName == null || constantType == null) {
            throw new IllegalArgumentException("SignatureConstant:  Values cannot be null!");
        }
        this.m_utfName = constantName;
        this.m_utfType = constantType;
    }

    @Override
    protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
        this.m_iRefName = stream.readUnsignedShort();
        this.m_iRefType = stream.readUnsignedShort();
    }

    @Override
    protected void postdisassemble(ConstantPool pool) {
        UtfConstant constName = this.m_utfName;
        UtfConstant constType = this.m_utfType;
        if (constName == null || constType == null) {
            constName = this.m_utfName = (UtfConstant)pool.getConstant(this.m_iRefName);
            constType = this.m_utfType = (UtfConstant)pool.getConstant(this.m_iRefType);
            constName.postdisassemble(pool);
            constType.postdisassemble(pool);
        }
    }

    @Override
    protected void preassemble(ConstantPool pool) {
        pool.registerConstant(this.m_utfName);
        pool.registerConstant(this.m_utfType);
    }

    @Override
    protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
        super.assemble(stream, pool);
        stream.writeShort(pool.findConstant(this.m_utfName));
        stream.writeShort(pool.findConstant(this.m_utfType));
    }

    @Override
    public int compareTo(Object obj) {
        SignatureConstant that = (SignatureConstant)obj;
        int nResult = this.m_utfName.compareTo(that.m_utfName);
        if (nResult == 0) {
            nResult = this.m_utfType.compareTo(that.m_utfType);
        }
        return nResult;
    }

    @Override
    public String toString() {
        return "(Signature)->" + (String)(this.m_utfName == null ? "[" + this.m_iRefName + "]" : this.m_utfName.toString()) + ", " + (String)(this.m_utfType == null ? "[" + this.m_iRefType + "]" : this.m_utfType.toString());
    }

    @Override
    public String format() {
        String sName = this.m_utfName.format();
        String sType = this.m_utfType.format();
        if (sType.charAt(0) == '(') {
            return sName + sType;
        }
        return sName;
    }

    @Override
    public boolean equals(Object obj) {
        try {
            SignatureConstant that = (SignatureConstant)obj;
            return this == that || this.getClass() == that.getClass() && this.m_utfName.equals(that.m_utfName) && this.m_utfType.equals(that.m_utfType);
        }
        catch (NullPointerException e) {
            return false;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public String getName() {
        return this.m_utfName.getValue();
    }

    public String getType() {
        return this.m_utfType.getValue();
    }

    public UtfConstant getNameConstant() {
        return this.m_utfName;
    }

    public UtfConstant getTypeConstant() {
        return this.m_utfType;
    }
}

