/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.ConstantPool;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.Op;
import com.tangosol.dev.assembler.OpDeclare;
import com.tangosol.dev.assembler.OpVariable;
import com.tangosol.dev.assembler.Rvar;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;

public class Ret
extends Op
implements Constants,
OpVariable {
    private static final String CLASS = "Ret";
    private Rvar m_var;
    private HashSet m_setVars;

    public Ret(Rvar var) {
        super(169);
        this.m_var = var;
        if (var == null) {
            throw new IllegalArgumentException("Ret:  Variable must not be null!");
        }
    }

    @Override
    public String toString() {
        return Ret.format(null, this.getName() + " " + this.m_var.format(), null);
    }

    @Override
    public String toJasm() {
        return this.getName() + " " + this.m_var.format();
    }

    @Override
    protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
        int n = this.m_var.getSlot();
        if (n <= 255) {
            stream.writeByte(169);
            stream.writeByte(n);
        } else {
            stream.writeByte(196);
            stream.writeByte(169);
            stream.writeShort(n);
        }
    }

    @Override
    protected void calculateSize(ConstantPool pool) {
        this.setSize(this.m_var.getSlot() <= 255 ? 2 : 4);
    }

    @Override
    public OpDeclare getVariable() {
        return this.m_var;
    }

    protected HashSet getVariables() {
        return this.m_setVars;
    }

    protected void setVariables(HashSet setVars) {
        this.m_setVars = setVars;
    }
}

