/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.Constant;
import com.tangosol.dev.assembler.ConstantPool;
import com.tangosol.dev.assembler.UtfConstant;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class PackageConstant
extends Constant {
    private int m_nNameIndex;
    private UtfConstant m_name;

    protected PackageConstant() {
        super(20);
    }

    @Override
    protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
        this.m_nNameIndex = stream.readUnsignedShort();
    }

    @Override
    protected void postdisassemble(ConstantPool pool) {
        this.m_name = (UtfConstant)pool.getConstant(this.m_nNameIndex);
    }

    @Override
    protected void preassemble(ConstantPool pool) {
        pool.registerConstant(this.m_name);
    }

    @Override
    protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
        super.assemble(stream, pool);
        stream.writeShort(pool.findConstant(this.m_name));
    }

    @Override
    public int compareTo(Object obj) {
        return obj instanceof PackageConstant ? this.m_name.compareTo(((PackageConstant)obj).m_name) : 1;
    }

    @Override
    public String toString() {
        return "(Package)->[name = " + String.valueOf(this.m_name) + "]";
    }

    @Override
    public String format() {
        return this.m_name.format();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof PackageConstant && this.m_name.equals(((PackageConstant)obj).m_name);
    }

    public UtfConstant getName() {
        return this.m_name;
    }

    public void setName(UtfConstant name) {
        this.m_name = name;
    }
}

