/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.Constant;
import com.tangosol.dev.assembler.ConstantPool;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.Op;
import java.io.DataOutput;
import java.io.IOException;

public abstract class OpConst
extends Op
implements Constants {
    private static final String CLASS = "OpConst";
    private Constant m_constant;

    public OpConst(int iOp, Constant constant) {
        super(iOp);
        this.m_constant = constant;
        if (constant == null) {
            throw new IllegalArgumentException("OpConst:  Constant must not be null!");
        }
    }

    @Override
    public String toString() {
        return OpConst.format(null, this.getName() + " " + this.m_constant.format(), null);
    }

    @Override
    public String toJasm() {
        return this.getName() + " " + this.m_constant.format();
    }

    @Override
    protected void preassemble(ConstantPool pool) {
        pool.registerConstant(this.m_constant);
    }

    @Override
    protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
        int iOp = super.getValue();
        int iConst = pool.findConstant(this.m_constant);
        stream.writeByte(iOp);
        stream.writeShort(iConst);
    }

    @Override
    protected void calculateSize(ConstantPool pool) {
        this.setSize(3);
    }

    public Constant getConstant() {
        return this.m_constant;
    }
}

