/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.ConstantPool;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.Label;
import com.tangosol.dev.assembler.Op;
import java.io.DataOutput;
import java.io.IOException;

public abstract class OpBranch
extends Op
implements Constants {
    private static final String CLASS = "OpBranch";
    private Label m_label;

    protected OpBranch(int iOp, Label label) {
        super(iOp);
        this.m_label = label;
        if (label == null) {
            throw new IllegalArgumentException("OpBranch:  Label must not be null!");
        }
    }

    @Override
    public String toString() {
        return OpBranch.format(null, this.getName() + " " + this.m_label.format(), null);
    }

    @Override
    public String toJasm() {
        return this.getName() + " goto " + this.m_label.getOffset();
    }

    @Override
    protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
        int iOp = super.getValue();
        int ofBranch = this.m_label.getOffset() - this.getOffset();
        if (ofBranch < Short.MIN_VALUE || ofBranch > Short.MAX_VALUE) {
            throw new IllegalStateException("OpBranch.assemble:  Branch offset out of range!");
        }
        stream.writeByte(iOp);
        stream.writeShort(ofBranch);
    }

    @Override
    protected void calculateSize(ConstantPool pool) {
        this.setSize(3);
    }

    public Label getLabel() {
        return this.m_label;
    }
}

