/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.Constant;
import com.tangosol.dev.assembler.ConstantPool;
import com.tangosol.dev.assembler.UtfConstant;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class MethodTypeConstant
extends Constant {
    private int m_nDescriptorIndex;
    private UtfConstant m_descriptor;

    protected MethodTypeConstant() {
        super(16);
    }

    @Override
    protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
        this.m_nDescriptorIndex = stream.readUnsignedShort();
    }

    @Override
    protected void postdisassemble(ConstantPool pool) {
        this.m_descriptor = (UtfConstant)pool.getConstant(this.m_nDescriptorIndex);
    }

    @Override
    protected void preassemble(ConstantPool pool) {
        pool.registerConstant(this.m_descriptor);
    }

    @Override
    protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
        super.assemble(stream, pool);
        stream.writeShort(pool.findConstant(this.m_descriptor));
    }

    @Override
    public int compareTo(Object obj) {
        return obj instanceof MethodTypeConstant ? this.m_descriptor.compareTo(((MethodTypeConstant)obj).m_descriptor) : 1;
    }

    @Override
    public String toString() {
        return "(MethodType)->[descriptor = " + String.valueOf(this.m_descriptor) + "]";
    }

    @Override
    public String format() {
        return this.m_descriptor.format();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof MethodTypeConstant ? this.m_descriptor.equals(((MethodTypeConstant)obj).m_descriptor) : false;
    }

    public UtfConstant getDescriptor() {
        return this.m_descriptor;
    }

    public void setDescriptor(UtfConstant descriptor) {
        this.m_descriptor = descriptor;
    }
}

