/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.Attribute;
import com.tangosol.dev.assembler.ConstantPool;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.Method;
import com.tangosol.dev.assembler.UtfConstant;
import com.tangosol.dev.assembler.VMStructure;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class MethodParametersAttribute
extends Attribute
implements Constants {
    protected MethodParameter[] m_aParam;

    protected MethodParametersAttribute(VMStructure context) {
        super(context, "MethodParameters");
    }

    @Override
    protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
        stream.readInt();
        int cParam = stream.readUnsignedByte();
        MethodParameter[] aParam = this.ensureMethodParams(cParam);
        for (int i = 0; i < cParam; ++i) {
            MethodParameter param = new MethodParameter(i);
            param.disassemble(stream, pool);
            aParam[i] = param;
        }
    }

    @Override
    protected void preassemble(ConstantPool pool) {
        super.preassemble(pool);
        MethodParameter[] aParam = this.m_aParam;
        int cParam = aParam.length;
        for (int i = 0; i < cParam; ++i) {
            if (aParam[i] != null) continue;
            throw new IllegalStateException("Either all parameters or none should be described");
        }
    }

    @Override
    protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
        stream.writeShort(pool.findConstant(super.getNameConstant()));
        MethodParameter[] aParam = this.m_aParam;
        int cParam = aParam.length;
        stream.writeInt(4 * cParam);
        stream.writeByte(cParam);
        for (int i = 0; i < cParam; ++i) {
            aParam[i].assemble(stream, pool);
        }
    }

    public boolean addParameter(int iParam, String sName, int nFlags) {
        MethodParameter[] aParam = this.m_aParam;
        if (aParam == null || iParam >= aParam.length) {
            return false;
        }
        MethodParameter param = aParam[iParam];
        if (param == null) {
            param = aParam[iParam] = new MethodParameter(iParam);
        }
        param.setParameterName(sName);
        param.setAccessFlags(nFlags);
        return true;
    }

    public void setParameterCount(int cParam) {
        this.ensureMethodParams(cParam);
    }

    protected MethodParameter[] ensureMethodParams(int cParam) {
        MethodParameter[] aParam = this.m_aParam;
        if (aParam == null) {
            this.m_aParam = new MethodParameter[cParam];
            aParam = this.m_aParam;
        }
        return aParam;
    }

    protected class MethodParameter
    extends VMStructure
    implements Constants {
        public static final int ACC_FINAL = 16;
        public static final int ACC_SYNTHETIC = 4096;
        public static final int ACC_MANDATED = 32768;
        protected UtfConstant m_name;
        protected int m_nFlags;
        protected int m_iParam;

        protected MethodParameter(int iParam) {
            this.m_iParam = iParam;
        }

        @Override
        protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
            int iName = stream.readUnsignedShort();
            if (iName > 0) {
                this.m_name = (UtfConstant)pool.getConstant(iName);
            }
            this.m_nFlags = stream.readUnsignedShort();
        }

        @Override
        protected void preassemble(ConstantPool pool) {
            if (this.m_name != null) {
                pool.registerConstant(this.m_name);
            }
        }

        @Override
        protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
            stream.writeShort(pool.findConstant(this.m_name));
            stream.writeShort(this.m_nFlags);
        }

        public String getParameterName() {
            return this.m_name.getValue();
        }

        public void setParameterName(String sName) {
            this.m_name = new UtfConstant(sName);
        }

        public boolean isFinal() {
            return (this.m_nFlags & 0x10) == 16;
        }

        public void setFinal(boolean fFinal) {
            this.m_nFlags = fFinal ? this.m_nFlags | 0x10 : this.m_nFlags & 0xFFFFFFEF;
        }

        public boolean isSynthetic() {
            return (this.m_nFlags & 0x1000) == 4096;
        }

        public void setSynthetic(boolean fSynthetic) {
            this.m_nFlags = fSynthetic ? this.m_nFlags | 0x1000 : this.m_nFlags & 0xFFFFEFFF;
        }

        public boolean isMandated() {
            return (this.m_nFlags & 0x8000) == 32768;
        }

        public void setMandated(boolean fMandated) {
            this.m_nFlags = fMandated ? this.m_nFlags | 0x8000 : this.m_nFlags & 0xFFFF7FFF;
        }

        public void setAccessFlags(int nFlags) {
            if ((nFlags & 0xFFFF6FEF) != 0) {
                throw new IllegalArgumentException("Invalid access flag set; only final, synthetic or mandated are permitted");
            }
            this.m_nFlags = nFlags;
        }

        public String getType() {
            Method method = (Method)MethodParametersAttribute.this.getContext();
            return method.getTypes()[this.m_iParam + 1];
        }
    }
}

