/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.AbstractLocalVariableTableAttribute;
import com.tangosol.dev.assembler.AccessFlags;
import com.tangosol.dev.assembler.Attribute;
import com.tangosol.dev.assembler.CodeAttribute;
import com.tangosol.dev.assembler.ConstantPool;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.DeprecatedAttribute;
import com.tangosol.dev.assembler.ExceptionsAttribute;
import com.tangosol.dev.assembler.Field;
import com.tangosol.dev.assembler.LocalVariableTableAttribute;
import com.tangosol.dev.assembler.MethodParametersAttribute;
import com.tangosol.dev.assembler.RuntimeInvisibleAnnotationsAttribute;
import com.tangosol.dev.assembler.RuntimeInvisibleParameterAnnotationsAttribute;
import com.tangosol.dev.assembler.RuntimeInvisibleTypeAnnotationsAttribute;
import com.tangosol.dev.assembler.RuntimeVisibleAnnotationsAttribute;
import com.tangosol.dev.assembler.RuntimeVisibleParameterAnnotationsAttribute;
import com.tangosol.dev.assembler.RuntimeVisibleTypeAnnotationsAttribute;
import com.tangosol.dev.assembler.SignatureAttribute;
import com.tangosol.dev.assembler.SyntheticAttribute;
import com.tangosol.dev.assembler.UtfConstant;
import com.tangosol.dev.assembler.VMStructure;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.StringTable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class Method
extends VMStructure
implements Constants {
    private static final String CLASS = "Method";
    public static final int ACC_METHOD = 7679;
    private final boolean f_fInterface;
    private String m_sClass;
    private UtfConstant m_utfName;
    private UtfConstant m_utfSig;
    private AccessFlags m_flags = new AccessFlags(){

        @Override
        protected void preassemble(ConstantPool pool) {
            if (Method.this.f_fInterface) {
                if (this.isMaskSet(308)) {
                    throw new IllegalStateException("Interface method " + String.valueOf(this) + " can not be protected, final, synchronized, or native");
                }
                if (pool.getClassFile().getMajorVersion() < 52) {
                    this.setPublic();
                    this.setAbstract(true);
                } else if (!this.isPublic() && !this.isPrivate()) {
                    throw new IllegalStateException("Interface method " + String.valueOf(this) + " must be either public or private");
                }
            }
            if (this.isAbstract() && this.isMaskSet(2362)) {
                throw new IllegalStateException("Abstract Method " + String.valueOf(this) + " can not be private, static, final, synchronized, native, or strict");
            }
            super.preassemble(pool);
        }
    };
    private StringTable m_tblAttribute = new StringTable();
    private boolean m_fModified;

    protected Method(String sClass, boolean fInterface) {
        this.m_sClass = sClass;
        this.f_fInterface = fInterface;
    }

    protected Method(String sName, String sSig, boolean fInterface) {
        this(new UtfConstant(sName), new UtfConstant(sSig.replace('.', '/')), fInterface);
    }

    protected Method(UtfConstant constantName, UtfConstant constantSig, boolean fInterface) {
        if (constantName == null || constantSig == null) {
            throw new IllegalArgumentException("Method:  Values cannot be null!");
        }
        this.m_utfName = constantName;
        this.m_utfSig = constantSig;
        this.f_fInterface = fInterface;
    }

    @Override
    protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
        this.m_flags.disassemble(stream, pool);
        this.m_utfName = (UtfConstant)pool.getConstant(stream.readUnsignedShort());
        this.m_utfSig = (UtfConstant)pool.getConstant(stream.readUnsignedShort());
        this.m_tblAttribute.clear();
        int cAttr = stream.readUnsignedShort();
        for (int i = 0; i < cAttr; ++i) {
            Attribute attr = Attribute.loadAttribute(this, stream, pool);
            this.m_tblAttribute.put(attr.getIdentity(), attr);
        }
    }

    @Override
    protected void preassemble(ConstantPool pool) {
        pool.registerConstant(this.m_utfName);
        pool.registerConstant(this.m_utfSig);
        this.m_flags.preassemble(pool);
        Enumeration enmr = this.m_tblAttribute.elements();
        while (enmr.hasMoreElements()) {
            Attribute attr = (Attribute)enmr.nextElement();
            try {
                attr.preassemble(pool);
            }
            catch (Throwable e) {
                if (attr.getName().equals("Code")) {
                    Method.out("Code pre-assembly error in:  " + this.toString());
                    ((CodeAttribute)attr).print();
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw (Error)e;
            }
        }
    }

    @Override
    protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
        this.m_flags.assemble(stream, pool);
        stream.writeShort(pool.findConstant(this.m_utfName));
        stream.writeShort(pool.findConstant(this.m_utfSig));
        stream.writeShort(this.m_tblAttribute.getSize());
        Enumeration enmr = this.m_tblAttribute.elements();
        while (enmr.hasMoreElements()) {
            Attribute attr = (Attribute)enmr.nextElement();
            try {
                attr.assemble(stream, pool);
            }
            catch (Throwable e) {
                if (attr.getName().equals("Code")) {
                    Method.out("Code assembly error in:  " + this.toString());
                    ((CodeAttribute)attr).print();
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw (Error)e;
            }
        }
    }

    @Override
    public String getIdentity() {
        return this.m_utfName.getValue() + this.m_utfSig.getValue();
    }

    @Override
    public boolean isModified() {
        if (this.m_fModified || this.m_flags.isModified()) {
            return true;
        }
        Enumeration enmr = this.m_tblAttribute.elements();
        while (enmr.hasMoreElements()) {
            Attribute attr = (Attribute)enmr.nextElement();
            if (!attr.isModified()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void resetModified() {
        this.m_flags.resetModified();
        Enumeration enmr = this.m_tblAttribute.elements();
        while (enmr.hasMoreElements()) {
            ((Attribute)enmr.nextElement()).resetModified();
        }
        this.m_fModified = false;
    }

    public int compareTo(Object obj) {
        Method that = (Method)obj;
        int nResult = this.m_utfName.compareTo(that.m_utfName);
        if (nResult == 0) {
            nResult = this.m_utfSig.compareTo(that.m_utfSig);
        }
        return nResult;
    }

    public String toString() {
        String sMods = this.m_flags.toString(7679);
        String sName = this.m_utfName.getValue();
        String[] asType = Method.toTypeStrings(this.m_utfSig.getValue());
        int cType = asType.length;
        StringBuffer sb = new StringBuffer();
        if (sMods.length() > 0) {
            sb.append(sMods).append(' ');
        }
        sb.append(asType[0]).append(' ').append(sName).append('(');
        for (int i = 1; i < cType; ++i) {
            if (i > 1) {
                sb.append(", ");
            }
            sb.append(asType[i]);
        }
        sb.append(')');
        return sb.toString();
    }

    public boolean equals(Object obj) {
        try {
            Method that = (Method)obj;
            return this == that || this.getClass() == that.getClass() && this.m_utfName.equals(that.m_utfName) && this.m_utfSig.equals(that.m_utfSig) && this.m_flags.equals(that.m_flags) && this.m_tblAttribute.equals(that.m_tblAttribute);
        }
        catch (NullPointerException e) {
            return false;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public boolean addParameter(int iParam, String sName, int nFlags) {
        String[] asTypes = this.getTypes();
        int cParams = asTypes.length - 1;
        if (iParam > cParams) {
            return false;
        }
        MethodParametersAttribute attrParams = this.ensureMethodParameters(cParams);
        return attrParams.addParameter(iParam, sName, nFlags);
    }

    public static String[] toTypeStrings(String sSig) {
        String[] asType = Method.toTypes(sSig);
        int cTypes = asType.length;
        for (int i = 0; i < cTypes; ++i) {
            asType[i] = Field.toTypeString(asType[i]);
        }
        return asType;
    }

    public static String[] toTypes(String sSig) {
        char[] ach = sSig.toCharArray();
        if (ach[0] != '(') {
            throw new IllegalArgumentException("JVM Method Signature must start with '('");
        }
        Vector<String> vect = new Vector<String>();
        vect.addElement(null);
        int of = 1;
        while (ach[of] != ')') {
            int cch = Method.getTypeLength(ach, of);
            vect.addElement(new String(ach, of, cch));
            of += cch;
        }
        vect.setElementAt(new String(ach, ++of, ach.length - of), 0);
        Object[] asSig = new String[vect.size()];
        vect.copyInto(asSig);
        return asSig;
    }

    private static int getTypeLength(char[] ach, int of) {
        switch (ach[of]) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'V': 
            case 'Z': {
                return 1;
            }
            case '[': {
                int cch = 1;
                while (Method.isDecimal(ach[++of])) {
                    ++cch;
                }
                return cch + Method.getTypeLength(ach, of);
            }
            case 'L': {
                int cch = 2;
                while (ach[++of] != ';') {
                    ++cch;
                }
                return cch;
            }
        }
        throw new IllegalArgumentException("JVM Type Signature cannot start with '" + ach[of] + "'");
    }

    public String getName() {
        return this.m_utfName.getValue();
    }

    public String getType() {
        return this.m_utfSig.getValue();
    }

    public String[] getTypes() {
        return Method.toTypes(this.m_utfSig.getValue());
    }

    public String[] getTypeStrings() {
        return Method.toTypeStrings(this.m_utfSig.getValue());
    }

    public String[] getNames() {
        LocalVariableTableAttribute vars;
        String[] as = this.getTypes();
        int c = as.length;
        CodeAttribute code = (CodeAttribute)this.m_tblAttribute.get("Code");
        if (code != null && (vars = (LocalVariableTableAttribute)code.getAttribute("LocalVariableTable")) != null) {
            int cwBase;
            int cwParams = cwBase = this.isStatic() ? 0 : 1;
            block6: for (int i = 1; i < c; ++i) {
                switch (as[i].charAt(0)) {
                    default: {
                        ++cwParams;
                        continue block6;
                    }
                    case 'D': 
                    case 'J': {
                        cwParams += 2;
                    }
                }
            }
            int[] aiSlotToParam = new int[cwParams];
            cwParams = cwBase;
            for (int i = 1; i < c; ++i) {
                aiSlotToParam[cwParams] = i;
                switch (as[i].charAt(0)) {
                    default: {
                        ++cwParams;
                        break;
                    }
                    case 'D': 
                    case 'J': {
                        cwParams += 2;
                    }
                }
                as[i] = null;
            }
            as[0] = null;
            Enumeration enmr = vars.ranges();
            while (enmr.hasMoreElements()) {
                int i;
                AbstractLocalVariableTableAttribute.Range range = (AbstractLocalVariableTableAttribute.Range)enmr.nextElement();
                if (range.getSlot() >= cwParams || (i = aiSlotToParam[range.getSlot()]) <= 0 || as[i] != null) continue;
                as[i] = range.getVariableName();
            }
            return as;
        }
        for (int i = 0; i < c; ++i) {
            as[i] = null;
        }
        return as;
    }

    public UtfConstant getNameConstant() {
        return this.m_utfName;
    }

    public UtfConstant getTypeConstant() {
        return this.m_utfSig;
    }

    public int getAccess() {
        return this.m_flags.getAccess();
    }

    public void setAccess(int nAccess) {
        this.m_flags.setAccess(nAccess);
    }

    public boolean isPublic() {
        return this.m_flags.isPublic();
    }

    public void setPublic() {
        this.m_flags.setPublic();
    }

    public boolean isProtected() {
        return this.m_flags.isProtected();
    }

    public void setProtected() {
        this.m_flags.setProtected();
    }

    public boolean isPackage() {
        return this.m_flags.isPackage();
    }

    public void setPackage() {
        this.m_flags.setPackage();
    }

    public boolean isPrivate() {
        return this.m_flags.isPrivate();
    }

    public void setPrivate() {
        this.m_flags.setPrivate();
    }

    public boolean isStatic() {
        return this.m_flags.isStatic();
    }

    public void setStatic(boolean fStatic) {
        this.m_flags.setStatic(fStatic);
    }

    public boolean isFinal() {
        return this.m_flags.isFinal();
    }

    public void setFinal(boolean fFinal) {
        this.m_flags.setFinal(fFinal);
    }

    public boolean isSynchronized() {
        return this.m_flags.isSynchronized();
    }

    public void setSynchronized(boolean fSynchronized) {
        this.m_flags.setSynchronized(fSynchronized);
    }

    public boolean isNative() {
        return this.m_flags.isNative();
    }

    public void setNative(boolean fNative) {
        this.m_flags.setNative(fNative);
    }

    public boolean isAbstract() {
        return this.m_flags.isAbstract();
    }

    public void setAbstract(boolean fAbstract) {
        this.m_flags.setAbstract(fAbstract);
    }

    public boolean isBridge() {
        return this.m_flags.isBridge();
    }

    public void setBridge(boolean fBridge) {
        this.m_flags.setBridge(fBridge);
    }

    public boolean isVarArgs() {
        return this.m_flags.isVarArgs();
    }

    public void setVarArgs(boolean fVarArgs) {
        this.m_flags.setVarArgs(fVarArgs);
    }

    public boolean isStrict() {
        return this.m_flags.isStrict();
    }

    public void setStrict(boolean fStrict) {
        this.m_flags.setStrict(fStrict);
    }

    public Attribute getAttribute(String sName) {
        return (Attribute)this.m_tblAttribute.get(sName);
    }

    public Attribute addAttribute(String sName) {
        Attribute attribute = sName.equals("Code") ? new CodeAttribute(this) : (sName.equals("Exceptions") ? new ExceptionsAttribute(this) : (sName.equals("Deprecated") ? new DeprecatedAttribute(this) : (sName.equals("Synthetic") ? new SyntheticAttribute(this) : (sName.equals("Signature") ? new SignatureAttribute(this) : (sName.equals("RuntimeVisibleAnnotations") ? new RuntimeVisibleAnnotationsAttribute(this) : (sName.equals("RuntimeInvisibleAnnotations") ? new RuntimeInvisibleAnnotationsAttribute(this) : (sName.equals("RuntimeVisibleParameterAnnotations") ? new RuntimeVisibleParameterAnnotationsAttribute(this) : (sName.equals("RuntimeInvisibleParameterAnnotations") ? new RuntimeInvisibleParameterAnnotationsAttribute(this) : (sName.equals("RuntimeVisibleTypeAnnotations") ? new RuntimeVisibleTypeAnnotationsAttribute(this) : (sName.equals("RuntimeInvisibleTypeAnnotations") ? new RuntimeInvisibleTypeAnnotationsAttribute(this) : (sName.equals("MethodParameters") ? new MethodParametersAttribute(this) : new Attribute((VMStructure)this, sName))))))))))));
        this.m_tblAttribute.put(attribute.getIdentity(), attribute);
        this.m_fModified = true;
        return attribute;
    }

    public void removeAttribute(String sName) {
        this.m_tblAttribute.remove(sName);
        this.m_fModified = true;
    }

    public Enumeration getAttributes() {
        return this.m_tblAttribute.elements();
    }

    public CodeAttribute getCode() {
        CodeAttribute attr = (CodeAttribute)this.m_tblAttribute.get("Code");
        return attr == null ? (CodeAttribute)this.addAttribute("Code") : attr;
    }

    public boolean isDeprecated() {
        return this.m_tblAttribute.contains("Deprecated");
    }

    public void setDeprecated(boolean fDeprecated) {
        if (fDeprecated) {
            this.addAttribute("Deprecated");
        } else {
            this.removeAttribute("Deprecated");
        }
    }

    public boolean isSynthetic() {
        return this.m_tblAttribute.contains("Synthetic") || this.m_flags.isSynthetic();
    }

    public void setSynthetic(boolean fSynthetic) {
        if (fSynthetic) {
            this.addAttribute("Synthetic");
        } else {
            this.removeAttribute("Synthetic");
        }
    }

    public void addException(String sClz) {
        ExceptionsAttribute attr = (ExceptionsAttribute)this.getAttribute("Exceptions");
        if (attr == null) {
            attr = (ExceptionsAttribute)this.addAttribute("Exceptions");
        }
        attr.addException(sClz);
    }

    public void removeException(String sClz) {
        ExceptionsAttribute attr = (ExceptionsAttribute)this.m_tblAttribute.get("Exceptions");
        if (attr != null) {
            attr.removeException(sClz);
        }
    }

    public Enumeration getExceptions() {
        ExceptionsAttribute attr = (ExceptionsAttribute)this.getAttribute("Exceptions");
        return attr == null ? NullImplementation.getEnumeration() : attr.getExceptions();
    }

    protected String getClassName() {
        return this.m_sClass;
    }

    protected MethodParametersAttribute ensureMethodParameters(int cParams) {
        MethodParametersAttribute attrParams = (MethodParametersAttribute)this.getAttribute("MethodParameters");
        if (attrParams == null) {
            attrParams = (MethodParametersAttribute)this.addAttribute("MethodParameters");
            attrParams.setParameterCount(cParams);
        }
        return attrParams;
    }
}

