/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.Constant;
import com.tangosol.dev.assembler.ConstantPool;
import com.tangosol.dev.assembler.Constants;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class LongConstant
extends Constant
implements Constants {
    private static final String CLASS = "LongConstant";
    private long m_lVal;

    protected LongConstant() {
        super(5);
    }

    public LongConstant(long lVal) {
        this();
        this.m_lVal = lVal;
    }

    @Override
    protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
        this.m_lVal = stream.readLong();
    }

    @Override
    protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
        super.assemble(stream, pool);
        stream.writeLong(this.m_lVal);
    }

    @Override
    public int compareTo(Object obj) {
        LongConstant that = (LongConstant)obj;
        long lThis = this.m_lVal;
        long lThat = that.m_lVal;
        return lThis < lThat ? -1 : (lThis > lThat ? 1 : 0);
    }

    @Override
    public String toString() {
        return "(Long) " + this.m_lVal;
    }

    @Override
    public String format() {
        return String.valueOf(this.m_lVal) + "L";
    }

    @Override
    public boolean equals(Object obj) {
        try {
            LongConstant that = (LongConstant)obj;
            return this == that || this.getClass() == that.getClass() && this.m_lVal == that.m_lVal;
        }
        catch (NullPointerException e) {
            return false;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public long getValue() {
        return this.m_lVal;
    }
}

