/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.AccessFlags;
import com.tangosol.dev.assembler.ClassConstant;
import com.tangosol.dev.assembler.ConstantPool;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.UtfConstant;
import com.tangosol.dev.assembler.VMStructure;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class InnerClass
extends VMStructure
implements Constants,
Comparable {
    private static final String CLASS = "InnerClass";
    private ClassConstant m_clzInner;
    private ClassConstant m_clzOuter;
    private UtfConstant m_utfInner;
    private AccessFlags m_flags = new AccessFlags();
    private boolean m_fModified;

    protected InnerClass() {
    }

    protected InnerClass(ClassConstant clzInner) {
        this.m_clzInner = clzInner;
    }

    @Override
    protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
        this.m_clzInner = (ClassConstant)pool.getConstant(stream.readUnsignedShort());
        this.m_clzOuter = (ClassConstant)pool.getConstant(stream.readUnsignedShort());
        this.m_utfInner = (UtfConstant)pool.getConstant(stream.readUnsignedShort());
        this.m_flags.disassemble(stream, pool);
    }

    @Override
    protected void preassemble(ConstantPool pool) {
        pool.registerConstant(this.m_clzInner);
        pool.registerConstant(this.m_clzOuter);
        pool.registerConstant(this.m_utfInner);
        this.m_flags.preassemble(pool);
    }

    @Override
    protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
        stream.writeShort(pool.findConstant(this.m_clzInner));
        stream.writeShort(pool.findConstant(this.m_clzOuter));
        stream.writeShort(pool.findConstant(this.m_utfInner));
        this.m_flags.assemble(stream, pool);
    }

    @Override
    public String getIdentity() {
        return this.m_clzInner.getValue();
    }

    @Override
    public boolean isModified() {
        return this.m_fModified || this.m_flags.isModified();
    }

    @Override
    protected void resetModified() {
        this.m_flags.resetModified();
        this.m_fModified = false;
    }

    public int compareTo(Object obj) {
        InnerClass that = (InnerClass)obj;
        return this.m_clzInner.compareTo(that.m_clzInner);
    }

    public String toString() {
        return "(InnerClass)->" + this.m_clzInner.toString();
    }

    public boolean equals(Object obj) {
        try {
            InnerClass that = (InnerClass)obj;
            return this == that || this.getClass() == that.getClass() && this.m_clzInner.equals(that.m_clzInner) && (this.m_clzOuter == null ? that.m_clzOuter == null : this.m_clzOuter.equals(that.m_clzOuter)) && (this.m_utfInner == null ? that.m_utfInner == null : this.m_utfInner.equals(that.m_utfInner)) && this.m_flags.equals(that.m_flags);
        }
        catch (NullPointerException e) {
            return false;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public String getInnerClass() {
        return this.m_clzInner.getValue();
    }

    protected ClassConstant getInnerClassConstant() {
        return this.m_clzInner;
    }

    public String getOuterClass() {
        return this.m_clzOuter != null ? this.m_clzOuter.getValue() : null;
    }

    protected ClassConstant getOuterClassConstant() {
        return this.m_clzOuter;
    }

    public void setOuterClass(String sOuter) {
        this.m_clzOuter = sOuter != null ? new ClassConstant(sOuter) : null;
    }

    protected void setOuterClassConstant(ClassConstant clzOuter) {
        this.m_clzOuter = clzOuter;
    }

    public String getInnerName() {
        return this.m_utfInner != null ? this.m_utfInner.getValue() : null;
    }

    protected UtfConstant getInnerNameConstant() {
        return this.m_utfInner;
    }

    public void setInnerName(String sInner) {
        this.m_utfInner = sInner != null ? new UtfConstant(sInner) : null;
    }

    protected void setInnerNameConstant(UtfConstant utfInner) {
        this.m_utfInner = utfInner;
    }

    public AccessFlags getAccessFlags() {
        return this.m_flags;
    }
}

