/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.ConstantPool;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.IntConstant;
import com.tangosol.dev.assembler.Op;
import java.io.DataOutput;
import java.io.IOException;

public class Iconst
extends Op
implements Constants {
    private static final String CLASS = "Iconst";
    private IntConstant m_constant;

    public Iconst(int n) {
        this(new IntConstant(n));
    }

    public Iconst(IntConstant constant) {
        super(229);
        this.m_constant = constant;
        if (constant == null) {
            throw new IllegalArgumentException("Iconst:  Constant must not be null!");
        }
    }

    @Override
    public String toString() {
        return Iconst.format(null, this.getName() + " " + this.m_constant.format(), null);
    }

    @Override
    public String toJasm() {
        return this.getName() + " " + this.m_constant.format();
    }

    @Override
    protected void preassemble(ConstantPool pool) {
        IntConstant constant = this.m_constant;
        int n = constant.getValue();
        if (n < Short.MIN_VALUE || n > Short.MAX_VALUE) {
            pool.registerConstant(constant);
        }
    }

    @Override
    protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
        IntConstant constant = this.m_constant;
        int n = constant.getValue();
        if (n >= -1 && n <= 5) {
            stream.writeByte(3 + n);
        } else if (n >= -128 && n <= 127) {
            stream.writeByte(16);
            stream.writeByte(n);
        } else if (n >= Short.MIN_VALUE && n <= Short.MAX_VALUE) {
            stream.writeByte(17);
            stream.writeShort(n);
        } else {
            int iConst = pool.findConstant(constant);
            if (iConst <= 255) {
                stream.writeByte(18);
                stream.writeByte(iConst);
            } else {
                stream.writeByte(19);
                stream.writeShort(iConst);
            }
        }
    }

    @Override
    protected void calculateSize(ConstantPool pool) {
        IntConstant constant = this.m_constant;
        int n = constant.getValue();
        if (n >= -1 && n <= 5) {
            this.setSize(1);
        } else if (n >= -128 && n <= 127) {
            this.setSize(2);
        } else if (n >= Short.MIN_VALUE && n <= Short.MAX_VALUE) {
            this.setSize(3);
        } else if (pool.findConstant(constant) <= 255) {
            this.setSize(2);
        } else {
            this.setSize(3);
        }
    }
}

