/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.ClassConstant;
import com.tangosol.dev.assembler.ClassFile;
import com.tangosol.dev.assembler.ConstantPool;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.DoubleConstant;
import com.tangosol.dev.assembler.DynamicConstant;
import com.tangosol.dev.assembler.FieldConstant;
import com.tangosol.dev.assembler.FloatConstant;
import com.tangosol.dev.assembler.IntConstant;
import com.tangosol.dev.assembler.InterfaceConstant;
import com.tangosol.dev.assembler.InvokeDynamicConstant;
import com.tangosol.dev.assembler.LongConstant;
import com.tangosol.dev.assembler.MethodConstant;
import com.tangosol.dev.assembler.MethodHandleConstant;
import com.tangosol.dev.assembler.MethodTypeConstant;
import com.tangosol.dev.assembler.ModuleConstant;
import com.tangosol.dev.assembler.PackageConstant;
import com.tangosol.dev.assembler.SignatureConstant;
import com.tangosol.dev.assembler.StringConstant;
import com.tangosol.dev.assembler.UtfConstant;
import com.tangosol.dev.assembler.VMStructure;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public abstract class Constant
extends VMStructure
implements Constants,
Comparable {
    private static final String CLASS = "Constant";
    private int m_nTag;
    protected transient int m_iLastKnownLocation;

    protected Constant(int nTag) {
        this.m_nTag = nTag;
    }

    protected static Constant loadConstant(DataInput stream, ConstantPool pool) throws IOException {
        int nTag = stream.readUnsignedByte();
        Constant constant = switch (nTag) {
            case 1 -> new UtfConstant();
            case 3 -> new IntConstant();
            case 4 -> new FloatConstant();
            case 5 -> new LongConstant();
            case 6 -> new DoubleConstant();
            case 7 -> new ClassConstant();
            case 8 -> new StringConstant();
            case 9 -> new FieldConstant();
            case 10 -> new MethodConstant();
            case 11 -> new InterfaceConstant();
            case 12 -> new SignatureConstant();
            case 15 -> {
                ClassFile cf = pool.getClassFile();
                yield new MethodHandleConstant(cf != null && cf.getMajorVersion() >= 52);
            }
            case 16 -> new MethodTypeConstant();
            case 17 -> new DynamicConstant();
            case 18 -> new InvokeDynamicConstant();
            case 19 -> new ModuleConstant();
            case 20 -> new PackageConstant();
            default -> throw new IOException("Invalid constant tag " + nTag);
        };
        constant.disassemble(stream, pool);
        return constant;
    }

    public final int getTag() {
        return this.m_nTag;
    }

    protected final int getElementSize() {
        return CONSTANT_SIZE[this.m_nTag];
    }

    @Override
    protected abstract void disassemble(DataInput var1, ConstantPool var2) throws IOException;

    protected void postdisassemble(ConstantPool pool) {
    }

    @Override
    protected void preassemble(ConstantPool pool) {
    }

    @Override
    protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
        stream.writeByte(this.m_nTag);
    }

    public abstract int compareTo(Object var1);

    public abstract String toString();

    public abstract String format();

    public abstract boolean equals(Object var1);
}

