/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.ClassConstant;
import com.tangosol.dev.assembler.ConstantPool;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.Label;
import com.tangosol.dev.assembler.Op;
import com.tangosol.dev.assembler.Try;

public class Catch
extends Op
implements Constants {
    private static final String CLASS = "Catch";
    private Try m_opTry;
    private ClassConstant m_clz;
    private Label m_label;

    public Catch(Try opTry, ClassConstant clz, Label label) {
        super(255);
        if (opTry == null || label == null) {
            throw new IllegalArgumentException("Catch:  The Try op and exception handler label arguments are required!");
        }
        this.m_opTry = opTry;
        this.m_clz = clz;
        this.m_label = label;
        opTry.addCatch(this);
    }

    @Override
    public String toString() {
        String sName = this.getName();
        String sExcept = this.m_clz == null ? "*" : this.m_clz.format();
        String sLabel = this.m_label.format();
        return Catch.format(null, sName + " " + sExcept + " " + sLabel, null);
    }

    @Override
    public String toJasm() {
        String sName = this.getName();
        String sExcept = this.m_clz == null ? "*" : this.m_clz.format();
        String sLabel = String.valueOf(this.m_label.getOffset());
        return sName + " " + sExcept + " goto " + sLabel;
    }

    @Override
    protected void preassemble(ConstantPool pool) {
        pool.registerConstant(this.m_clz);
    }

    @Override
    protected boolean isReachable() {
        return this.m_opTry.isReachable();
    }

    public Try getTry() {
        return this.m_opTry;
    }

    public ClassConstant getExceptionClass() {
        return this.m_clz;
    }

    public Label getLabel() {
        return this.m_label;
    }
}

