/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.Attribute;
import com.tangosol.dev.assembler.Constant;
import com.tangosol.dev.assembler.ConstantPool;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.MethodHandleConstant;
import com.tangosol.dev.assembler.VMStructure;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class BootstrapMethodsAttribute
extends Attribute
implements Constants {
    private List<BootstrapMethod> m_listMethods = new LinkedList<BootstrapMethod>();

    protected BootstrapMethodsAttribute(VMStructure context) {
        super(context, "BootstrapMethods");
    }

    @Override
    protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
        stream.readInt();
        this.m_listMethods = new LinkedList<BootstrapMethod>();
        LinkedList<BootstrapMethod> listMethods = this.m_listMethods;
        int cMethods = stream.readUnsignedShort();
        for (int i = 0; i < cMethods; ++i) {
            BootstrapMethod method = new BootstrapMethod();
            method.disassemble(stream, pool);
            listMethods.add(method);
        }
    }

    @Override
    protected void preassemble(ConstantPool pool) {
        super.preassemble(pool);
        for (BootstrapMethod method : this.m_listMethods) {
            method.preassemble(pool);
        }
    }

    @Override
    protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
        stream.writeShort(pool.findConstant(super.getNameConstant()));
        List<BootstrapMethod> listMethods = this.m_listMethods;
        int cLength = 2;
        for (BootstrapMethod method : listMethods) {
            cLength += method.size();
        }
        stream.writeInt(cLength);
        stream.writeShort(listMethods.size());
        for (BootstrapMethod method : listMethods) {
            method.assemble(stream, pool);
        }
    }

    public List<BootstrapMethod> getBootstrapMethods() {
        return this.m_listMethods;
    }

    public BootstrapMethod addBootstrapMethod(MethodHandleConstant methHandleConstant) {
        BootstrapMethod method = new BootstrapMethod(methHandleConstant);
        this.m_listMethods.add(method);
        return method;
    }

    public class BootstrapMethod
    extends VMStructure
    implements Constants {
        private MethodHandleConstant m_method;
        private List<Constant> m_listArgs = new LinkedList<Constant>();

        protected BootstrapMethod() {
        }

        public BootstrapMethod(MethodHandleConstant methHandleConstant) {
            this(methHandleConstant, null);
        }

        public BootstrapMethod(MethodHandleConstant methHandleConstant, List<Constant> listArgs) {
            this.m_method = methHandleConstant;
            this.m_listArgs = listArgs == null ? this.m_listArgs : listArgs;
        }

        @Override
        protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
            this.m_method = (MethodHandleConstant)pool.getConstant(stream.readUnsignedShort());
            List<Constant> listArgs = this.m_listArgs;
            int cArgs = stream.readUnsignedShort();
            for (int i = 0; i < cArgs; ++i) {
                listArgs.add(pool.getConstant(stream.readUnsignedShort()));
            }
        }

        @Override
        protected void preassemble(ConstantPool pool) {
            pool.registerConstant(this.m_method);
            for (Constant arg : this.m_listArgs) {
                pool.registerConstant(arg);
            }
        }

        @Override
        protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
            int iCP = pool.findConstant(this.m_method);
            stream.writeShort(iCP);
            List<Constant> listArgs = this.m_listArgs;
            stream.writeShort(listArgs.size());
            for (Constant arg : listArgs) {
                stream.writeShort(pool.findConstant(arg));
            }
        }

        public MethodHandleConstant getBootstrapMethod() {
            return this.m_method;
        }

        public void setBootstrapMethod(MethodHandleConstant method) {
            int nRefKind = method.getKind();
            if (nRefKind != 6 && nRefKind != 8) {
                throw new IllegalArgumentException("Bootstrap method should be either invokeStatic or newInvokeSpecial");
            }
            this.m_method = method;
        }

        public List<Constant> getArguments() {
            return this.m_listArgs;
        }

        public int size() {
            return 4 + 2 * this.m_listArgs.size();
        }
    }
}

