/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.Constant;
import com.tangosol.dev.assembler.ConstantPool;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.UtfConstant;
import com.tangosol.dev.assembler.VMStructure;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class Annotation
extends VMStructure
implements Constants {
    private static final String CLASS = "Annotation";
    private UtfConstant m_utfType;
    private HashMap m_mapElementValue = new HashMap();
    private boolean m_fModified;

    @Override
    protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
        this.m_utfType = (UtfConstant)pool.getConstant(stream.readUnsignedShort());
        int cElementValue = stream.readUnsignedShort();
        for (int i = 0; i < cElementValue; ++i) {
            UtfConstant utfElementName = (UtfConstant)pool.getConstant(stream.readUnsignedShort());
            AbstractElementValue elementValue = AbstractElementValue.loadElementValue(stream, pool);
            this.m_mapElementValue.put(utfElementName, elementValue);
        }
    }

    @Override
    protected void preassemble(ConstantPool pool) {
        pool.registerConstant(this.m_utfType);
        for (Map.Entry entry : this.m_mapElementValue.entrySet()) {
            ((UtfConstant)entry.getKey()).preassemble(pool);
            ((AbstractElementValue)entry.getValue()).preassemble(pool);
        }
    }

    @Override
    protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
        stream.writeShort(pool.findConstant(this.m_utfType));
        stream.writeShort(this.m_mapElementValue.size());
        for (Map.Entry entry : this.m_mapElementValue.entrySet()) {
            stream.writeShort(pool.findConstant((UtfConstant)entry.getKey()));
            ((AbstractElementValue)entry.getValue()).assemble(stream, pool);
        }
    }

    @Override
    public boolean isModified() {
        Iterator iter = this.m_mapElementValue.values().iterator();
        while (iter.hasNext()) {
            if (!((AbstractElementValue)iter.next()).isModified()) continue;
            return true;
        }
        return this.m_fModified;
    }

    @Override
    protected void resetModified() {
        this.m_fModified = false;
    }

    public int getSize() {
        int cBytes = 0;
        cBytes += 2;
        cBytes += 2;
        Iterator iter = this.m_mapElementValue.values().iterator();
        while (iter.hasNext()) {
            cBytes += 2;
            cBytes += ((AbstractElementValue)iter.next()).getSize();
        }
        return cBytes;
    }

    public UtfConstant getAnnotationType() {
        return this.m_utfType;
    }

    public void setAnnotationType(UtfConstant utfType) {
        this.m_utfType = utfType;
        this.m_fModified = true;
    }

    public void setElementValue(UtfConstant utfElementName, AbstractElementValue elementValue) {
        this.m_mapElementValue.put(utfElementName, elementValue);
        this.m_fModified = true;
    }

    public AbstractElementValue getElementValue(UtfConstant utfElementName) {
        return (AbstractElementValue)this.m_mapElementValue.get(utfElementName);
    }

    public Iterator getElementNames() {
        return this.m_mapElementValue.keySet().iterator();
    }

    public void clearElementValues() {
        this.m_mapElementValue.clear();
        this.m_fModified = true;
    }

    public static abstract class AbstractElementValue
    extends VMStructure
    implements Constants {
        public static final char TAGTYPE_BYTE = 'B';
        public static final char TAGTYPE_CHAR = 'C';
        public static final char TAGTYPE_DOUBLE = 'D';
        public static final char TAGTYPE_FLOAT = 'F';
        public static final char TAGTYPE_INT = 'I';
        public static final char TAGTYPE_LONG = 'J';
        public static final char TAGTYPE_SHORT = 'S';
        public static final char TAGTYPE_BOOLEAN = 'Z';
        public static final char TAGTYPE_STRING = 's';
        public static final char TAGTYPE_ENUM = 'e';
        public static final char TAGTYPE_CLASS = 'c';
        public static final char TAGTYPE_ANNOTATION = '@';
        public static final char TAGTYPE_ARRAY = '[';
        protected boolean m_fModified;
        private char m_cTag;

        protected AbstractElementValue(char cTag) {
            this.m_cTag = cTag;
        }

        protected static AbstractElementValue loadElementValue(DataInput stream, ConstantPool pool) throws IOException {
            AbstractElementValue elementValue = null;
            char cTag = (char)stream.readByte();
            switch (cTag) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'Z': 
                case 's': {
                    elementValue = new ConstantElementValue(cTag);
                    break;
                }
                case 'e': {
                    elementValue = new EnumElementValue();
                    break;
                }
                case 'c': {
                    elementValue = new ClassElementValue();
                    break;
                }
                case '@': {
                    elementValue = new AnnotationElementValue();
                    break;
                }
                case '[': {
                    elementValue = new ArrayElementValue();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Annotation.loadElementValue: unknown ElementValue tag type " + cTag);
                }
            }
            elementValue.disassemble(stream, pool);
            return elementValue;
        }

        @Override
        protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
            stream.writeByte((byte)this.m_cTag);
        }

        @Override
        public boolean isModified() {
            return this.m_fModified;
        }

        @Override
        protected void resetModified() {
            this.m_fModified = false;
        }

        protected int getSize() {
            return 1;
        }
    }

    public static class ArrayElementValue
    extends AbstractElementValue {
        private Vector m_listElement = new Vector();

        protected ArrayElementValue() {
            super('[');
        }

        public ArrayElementValue(List listElement) {
            super('[');
            this.m_listElement = new Vector(listElement);
        }

        public Iterator getElements() {
            return this.m_listElement.iterator();
        }

        public void add(AbstractElementValue elementValue) {
            this.m_listElement.addElement(elementValue);
            this.m_fModified = true;
        }

        public void clear() {
            this.m_listElement.clear();
            this.m_fModified = true;
        }

        public void setElements(List listElement) {
            this.m_listElement.clear();
            this.m_listElement.addAll(listElement);
            this.m_fModified = true;
        }

        @Override
        protected int getSize() {
            int cBytes = super.getSize();
            cBytes += 2;
            Iterator iter = this.m_listElement.iterator();
            while (iter.hasNext()) {
                cBytes += ((AbstractElementValue)iter.next()).getSize();
            }
            return cBytes;
        }

        @Override
        public boolean isModified() {
            Iterator iter = this.m_listElement.iterator();
            while (iter.hasNext()) {
                if (!((AbstractElementValue)iter.next()).isModified()) continue;
                return true;
            }
            return super.isModified();
        }

        @Override
        protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
            int cElement = stream.readUnsignedShort();
            for (int i = 0; i < cElement; ++i) {
                AbstractElementValue elementValue = AbstractElementValue.loadElementValue(stream, pool);
                this.m_listElement.addElement(elementValue);
            }
        }

        @Override
        protected void preassemble(ConstantPool pool) {
            Iterator iter = this.m_listElement.iterator();
            while (iter.hasNext()) {
                ((AbstractElementValue)iter.next()).preassemble(pool);
            }
        }

        @Override
        protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
            super.assemble(stream, pool);
            stream.writeShort(this.m_listElement.size());
            Iterator iter = this.m_listElement.iterator();
            while (iter.hasNext()) {
                ((AbstractElementValue)iter.next()).assemble(stream, pool);
            }
        }
    }

    public static class AnnotationElementValue
    extends AbstractElementValue {
        private Annotation m_annotationValue;

        protected AnnotationElementValue() {
            super('@');
        }

        public AnnotationElementValue(Annotation annotationValue) {
            super('@');
            this.m_annotationValue = annotationValue;
        }

        public Annotation getAnnotation() {
            return this.m_annotationValue;
        }

        public void setAnnotation(Annotation annotationValue) {
            this.m_annotationValue = annotationValue;
            this.m_fModified = true;
        }

        @Override
        protected int getSize() {
            return this.m_annotationValue.getSize() + super.getSize();
        }

        @Override
        public boolean isModified() {
            return super.isModified() || this.m_annotationValue.isModified();
        }

        @Override
        protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
            this.m_annotationValue = new Annotation();
            this.m_annotationValue.disassemble(stream, pool);
        }

        @Override
        protected void preassemble(ConstantPool pool) {
            this.m_annotationValue.preassemble(pool);
        }

        @Override
        protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
            super.assemble(stream, pool);
            this.m_annotationValue.assemble(stream, pool);
        }
    }

    public static class EnumElementValue
    extends AbstractElementValue {
        private UtfConstant m_utfEnumName;
        private UtfConstant m_utfEnumType;

        protected EnumElementValue() {
            super('e');
        }

        public EnumElementValue(UtfConstant utfEnumName, UtfConstant utfEnumType) {
            super('e');
            this.m_utfEnumName = utfEnumName;
            this.m_utfEnumType = utfEnumType;
        }

        public UtfConstant getEnumName() {
            return this.m_utfEnumName;
        }

        public void setEnumName(UtfConstant utfEnumName) {
            this.m_utfEnumName = utfEnumName;
            this.m_fModified = true;
        }

        public UtfConstant getEnumType() {
            return this.m_utfEnumType;
        }

        public void setEnumType(UtfConstant utfEnumType) {
            this.m_utfEnumType = utfEnumType;
            this.m_fModified = true;
        }

        @Override
        protected int getSize() {
            return 4 + super.getSize();
        }

        @Override
        protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
            this.m_utfEnumType = (UtfConstant)pool.getConstant(stream.readUnsignedShort());
            this.m_utfEnumName = (UtfConstant)pool.getConstant(stream.readUnsignedShort());
        }

        @Override
        protected void preassemble(ConstantPool pool) {
            pool.registerConstant(this.m_utfEnumType);
            pool.registerConstant(this.m_utfEnumName);
        }

        @Override
        protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
            super.assemble(stream, pool);
            stream.writeShort(pool.findConstant(this.m_utfEnumType));
            stream.writeShort(pool.findConstant(this.m_utfEnumName));
        }
    }

    public static class ClassElementValue
    extends AbstractElementValue {
        private UtfConstant m_utfClassType;

        protected ClassElementValue() {
            super('c');
        }

        public ClassElementValue(UtfConstant utfClassType) {
            super('c');
            this.m_utfClassType = utfClassType;
        }

        public UtfConstant getClassType() {
            return this.m_utfClassType;
        }

        public void setClassType(UtfConstant utfClassType) {
            this.m_utfClassType = utfClassType;
            this.m_fModified = true;
        }

        @Override
        protected int getSize() {
            return 2 + super.getSize();
        }

        @Override
        protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
            this.m_utfClassType = (UtfConstant)pool.getConstant(stream.readUnsignedShort());
        }

        @Override
        protected void preassemble(ConstantPool pool) {
            pool.registerConstant(this.m_utfClassType);
        }

        @Override
        protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
            super.assemble(stream, pool);
            stream.writeShort(pool.findConstant(this.m_utfClassType));
        }
    }

    public static class ConstantElementValue
    extends AbstractElementValue {
        private Constant m_constValue;

        protected ConstantElementValue(char cType) {
            super(cType);
        }

        public ConstantElementValue(char cType, Constant constValue) {
            super(cType);
            this.m_constValue = constValue;
        }

        public Constant getConstantValue() {
            return this.m_constValue;
        }

        public void setConstantValue(Constant constValue) {
            this.m_constValue = constValue;
            this.m_fModified = true;
        }

        @Override
        protected int getSize() {
            return 2 + super.getSize();
        }

        @Override
        protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
            this.m_constValue = pool.getConstant(stream.readUnsignedShort());
        }

        @Override
        protected void preassemble(ConstantPool pool) {
            pool.registerConstant(this.m_constValue);
        }

        @Override
        protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
            super.assemble(stream, pool);
            stream.writeShort(pool.findConstant(this.m_constValue));
        }
    }
}

