/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.ClassConstant;
import com.tangosol.dev.assembler.Constant;
import com.tangosol.dev.assembler.ConstantPool;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.Op;
import com.tangosol.dev.assembler.StringConstant;
import java.io.DataOutput;
import java.io.IOException;

public class Aconst
extends Op
implements Constants {
    private static final String CLASS = "Aconst";
    private Constant m_constant;

    public Aconst() {
        super(233);
    }

    public Aconst(String s) {
        this(s == null ? null : new StringConstant(s));
    }

    public Aconst(ClassConstant constant) {
        super(233);
        this.m_constant = constant;
    }

    public Aconst(StringConstant constant) {
        super(233);
        this.m_constant = constant;
    }

    @Override
    public String toString() {
        String sConst = this.m_constant == null ? "null" : this.m_constant.format();
        return Aconst.format(null, this.getName() + " " + sConst, null);
    }

    @Override
    public String toJasm() {
        String sConst = this.m_constant == null ? "null" : this.m_constant.format();
        return this.getName() + " " + sConst;
    }

    @Override
    protected void preassemble(ConstantPool pool) {
        Constant constant = this.m_constant;
        if (constant != null) {
            pool.registerConstant(constant);
        }
    }

    @Override
    protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
        Constant constant = this.m_constant;
        if (constant == null) {
            stream.writeByte(1);
        } else {
            int iConst = pool.findConstant(constant);
            if (iConst <= 255) {
                stream.writeByte(18);
                stream.writeByte(iConst);
            } else {
                stream.writeByte(19);
                stream.writeShort(iConst);
            }
        }
    }

    @Override
    protected void calculateSize(ConstantPool pool) {
        Constant constant = this.m_constant;
        if (constant == null) {
            this.setSize(1);
        } else if (pool.findConstant(constant) <= 255) {
            this.setSize(2);
        } else {
            this.setSize(3);
        }
    }
}

