/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.Annotation;
import com.tangosol.dev.assembler.Attribute;
import com.tangosol.dev.assembler.ConstantPool;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.VMStructure;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;

public abstract class AbstractParameterAnnotationsAttribute
extends Attribute
implements Constants {
    private Vector m_listParameter = new Vector();
    private boolean m_fModified;

    protected AbstractParameterAnnotationsAttribute(VMStructure context, String sAttr) {
        super(context, sAttr);
    }

    @Override
    protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
        stream.readInt();
        int cParam = stream.readUnsignedByte();
        for (int i = 0; i < cParam; ++i) {
            Parameter parameter = new Parameter();
            parameter.disassemble(stream, pool);
            this.m_listParameter.addElement(parameter);
        }
    }

    @Override
    protected void preassemble(ConstantPool pool) {
        pool.registerConstant(super.getNameConstant());
        Iterator iter = this.m_listParameter.iterator();
        while (iter.hasNext()) {
            ((Parameter)iter.next()).preassemble(pool);
        }
    }

    @Override
    protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
        stream.writeShort(pool.findConstant(super.getNameConstant()));
        int cBytes = 1;
        Iterator iter = this.m_listParameter.iterator();
        while (iter.hasNext()) {
            cBytes += ((Parameter)iter.next()).getSize();
        }
        stream.writeInt(cBytes);
        stream.writeByte((byte)this.m_listParameter.size());
        iter = this.m_listParameter.iterator();
        while (iter.hasNext()) {
            ((Parameter)iter.next()).assemble(stream, pool);
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName() + " for " + this.getContext().getIdentity());
        sb.append("\n{");
        Iterator iter = this.getParameters();
        while (iter.hasNext()) {
            sb.append("\n  ").append(iter.next());
        }
        sb.append("\n}");
        return sb.toString();
    }

    public Iterator getParameters() {
        return this.m_listParameter.iterator();
    }

    public void addParameter(Parameter parameter) {
        this.m_listParameter.addElement(parameter);
        this.m_fModified = true;
    }

    public void clearParameters() {
        this.m_listParameter.clear();
        this.m_fModified = true;
    }

    @Override
    public boolean isModified() {
        Iterator iter = this.m_listParameter.iterator();
        while (iter.hasNext()) {
            if (!((Parameter)iter.next()).isModified()) continue;
            return true;
        }
        return this.m_fModified;
    }

    @Override
    protected void resetModified() {
        this.m_fModified = false;
    }

    public static class Parameter
    extends VMStructure
    implements Constants {
        private Vector m_listAnnotation = new Vector();
        private boolean m_fModified;

        protected Parameter() {
        }

        @Override
        protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
            int cAnnotation = stream.readUnsignedShort();
            for (int i = 0; i < cAnnotation; ++i) {
                Annotation annotation = new Annotation();
                annotation.disassemble(stream, pool);
                this.m_listAnnotation.addElement(annotation);
            }
        }

        @Override
        protected void preassemble(ConstantPool pool) {
            Iterator iter = this.m_listAnnotation.iterator();
            while (iter.hasNext()) {
                ((Annotation)iter.next()).preassemble(pool);
            }
        }

        @Override
        protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
            stream.writeShort(this.m_listAnnotation.size());
            Iterator iter = this.m_listAnnotation.iterator();
            while (iter.hasNext()) {
                ((Annotation)iter.next()).assemble(stream, pool);
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("  ").append("Parameter");
            sb.append("\n  {");
            Iterator iter = this.getAnnotations();
            while (iter.hasNext()) {
                sb.append("\n   ").append(iter.next());
            }
            sb.append("\n  }");
            return sb.toString();
        }

        public Iterator getAnnotations() {
            return this.m_listAnnotation.iterator();
        }

        public void addAnnotation(Annotation annotation) {
            this.m_listAnnotation.addElement(annotation);
            this.m_fModified = true;
        }

        public void clearAnnotations() {
            this.m_listAnnotation.clear();
            this.m_fModified = true;
        }

        @Override
        public boolean isModified() {
            Iterator iter = this.m_listAnnotation.iterator();
            while (iter.hasNext()) {
                if (!((Annotation)iter.next()).isModified()) continue;
                return true;
            }
            return this.m_fModified;
        }

        @Override
        protected void resetModified() {
            this.m_fModified = false;
        }

        protected int getSize() {
            int cBytes = 2;
            Iterator iter = this.m_listAnnotation.iterator();
            while (iter.hasNext()) {
                cBytes += ((Annotation)iter.next()).getSize();
            }
            return cBytes;
        }
    }
}

