/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.config.xml;

import com.tangosol.config.ConfigurationException;
import com.tangosol.config.xml.DocumentPreprocessor;
import com.tangosol.config.xml.ProcessingContext;
import com.tangosol.run.xml.XmlElement;
import java.util.ArrayList;
import java.util.List;

public class DocumentElementPreprocessor
implements DocumentPreprocessor {
    private ArrayList<ElementPreprocessor> m_lstElementPreprocessors = new ArrayList();

    public DocumentElementPreprocessor addElementPreprocessor(ElementPreprocessor preprocessor) {
        this.m_lstElementPreprocessors.add(preprocessor);
        return this;
    }

    private boolean preprocess(ProcessingContext context, XmlElement xmlElement, ElementPreprocessor preprocessor) {
        if (xmlElement == null || preprocessor == null) {
            return false;
        }
        boolean fRevisit = preprocessor.preprocess(context, xmlElement);
        List lstElements = xmlElement.getElementList();
        if (lstElements.size() > 0) {
            for (XmlElement xmlChild : lstElements) {
                fRevisit = fRevisit || this.preprocess(context, xmlChild, preprocessor);
            }
        }
        return fRevisit;
    }

    @Override
    public boolean preprocess(ProcessingContext context, XmlElement xmlElement) throws ConfigurationException {
        boolean fRevisit;
        if (xmlElement == null || this.m_lstElementPreprocessors.isEmpty()) {
            return false;
        }
        boolean fRevisited = false;
        block0: do {
            fRevisit = false;
            for (ElementPreprocessor preprocessor : this.m_lstElementPreprocessors) {
                if (!(fRevisit = fRevisit || this.preprocess(context, xmlElement, preprocessor))) continue;
                fRevisited = true;
                continue block0;
            }
        } while (fRevisit);
        return fRevisited;
    }

    public static interface ElementPreprocessor {
        public boolean preprocess(ProcessingContext var1, XmlElement var2) throws ConfigurationException;
    }
}

