/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.config.xml;

import com.tangosol.config.ConfigurationException;
import com.tangosol.config.annotation.Injectable;
import com.tangosol.config.expression.Expression;
import com.tangosol.config.expression.ExpressionParser;
import com.tangosol.config.expression.LiteralExpression;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.config.expression.Value;
import com.tangosol.config.xml.AttributeProcessor;
import com.tangosol.config.xml.ConditionalElementProcessor;
import com.tangosol.config.xml.DocumentPreprocessor;
import com.tangosol.config.xml.DocumentProcessor;
import com.tangosol.config.xml.ElementProcessor;
import com.tangosol.config.xml.NamespaceHandler;
import com.tangosol.config.xml.ProcessingContext;
import com.tangosol.config.xml.SimpleAttributeProcessor;
import com.tangosol.config.xml.SimpleElementProcessor;
import com.tangosol.run.xml.QualifiedName;
import com.tangosol.run.xml.SimpleAttribute;
import com.tangosol.run.xml.XmlAttribute;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.run.xml.XmlValue;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.ResourceRegistry;
import com.tangosol.util.UUID;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class DefaultProcessingContext
implements ProcessingContext,
AutoCloseable {
    private final DocumentProcessor.Dependencies m_dependencies;
    private DefaultProcessingContext m_ctxParent;
    private final HashMap<Class<?>, AttributeProcessor<?>> m_mapAttributeProcessorsByType;
    private final HashMap<Class<?>, HashMap<String, Object>> m_mapCookiesByType;
    private final HashMap<Class<?>, ElementProcessor<?>> m_mapElementProcessorsByType;
    private final LinkedHashMap<URI, NamespaceHandler> m_mapNamespaceHandlersByURI;
    private final LinkedHashMap<String, URI> m_mapNamespaceURIsByPrefix;
    private final HashMap<String, String> m_mapPropertyPaths;
    private final HashSet<XmlElement> m_setProcessedChildElements;
    private XmlElement m_xmlElement;

    public DefaultProcessingContext() {
        this((DocumentProcessor.Dependencies)null);
    }

    public DefaultProcessingContext(DocumentProcessor.Dependencies dependencies) {
        this.m_dependencies = dependencies == null ? new DocumentProcessor.DefaultDependencies() : dependencies;
        this.m_ctxParent = null;
        this.m_xmlElement = null;
        this.m_mapNamespaceURIsByPrefix = new LinkedHashMap();
        this.m_mapNamespaceHandlersByURI = new LinkedHashMap();
        this.m_mapCookiesByType = new HashMap();
        this.m_mapPropertyPaths = new HashMap();
        this.m_mapAttributeProcessorsByType = new HashMap();
        this.m_mapElementProcessorsByType = new HashMap();
        this.m_setProcessedChildElements = new HashSet();
    }

    public DefaultProcessingContext(XmlElement xmlElement) {
        this(new DocumentProcessor.DefaultDependencies());
        this.m_ctxParent = null;
        this.m_xmlElement = xmlElement;
    }

    public DefaultProcessingContext(DefaultProcessingContext ctxParent, XmlElement xmlElement) {
        this(ctxParent.getDependencies());
        this.m_ctxParent = ctxParent;
        this.m_xmlElement = xmlElement;
    }

    public DefaultProcessingContext(DocumentProcessor.Dependencies dependencies, XmlElement xmlElement) {
        this(dependencies);
        this.m_ctxParent = null;
        this.m_xmlElement = xmlElement;
        if (this.m_xmlElement != null) {
            this.loadNamespaceHandlers(this.m_xmlElement);
        }
    }

    @Override
    public <R> R getResource(Class<R> clsResource) {
        R resource = this.getCookie(clsResource);
        if (resource == null && this.getResourceRegistry() != null) {
            resource = this.getResourceRegistry().getResource(clsResource);
        }
        return resource;
    }

    @Override
    public <R> R getResource(Class<R> clsResource, String sResourceName) {
        R resource = this.getCookie(clsResource, sResourceName);
        if (resource == null && this.getResourceRegistry() != null) {
            resource = this.getResourceRegistry().getResource(clsResource, sResourceName);
        }
        return resource;
    }

    @Override
    public ResourceRegistry getResourceRegistry() {
        return this.m_dependencies.getResourceRegistry();
    }

    @Override
    public ParameterResolver getDefaultParameterResolver() {
        return this.m_dependencies.getDefaultParameterResolver();
    }

    @Override
    public ClassLoader getContextClassLoader() {
        return this.m_dependencies.getContextClassLoader();
    }

    @Override
    public <T> void addCookie(Class<T> clzCookie, String sName, T value) {
        HashMap mapCookiesByName = this.m_mapCookiesByType.computeIfAbsent(clzCookie, k -> new HashMap());
        mapCookiesByName.put(sName, value);
    }

    @Override
    public <T> void addCookie(Class<T> clzCookie, T cookie) {
        this.addCookie(clzCookie, clzCookie.getName(), cookie);
    }

    @Override
    public <T> T getCookie(Class<T> clzCookie, String sName) {
        Object cookie;
        HashMap<String, Object> mapCookiesByName = this.m_mapCookiesByType.get(clzCookie);
        Object object = cookie = mapCookiesByName == null ? null : mapCookiesByName.get(sName);
        return (T)(cookie == null ? (this.isRootContext() ? null : this.m_ctxParent.getCookie(clzCookie, sName)) : cookie);
    }

    @Override
    public <T> T getCookie(Class<T> clzCookie) {
        return clzCookie == null ? null : (T)this.getCookie(clzCookie, clzCookie.getName());
    }

    @Override
    public void definePropertyPath(String sBeanPropertyName, String sXmlPath) {
        this.m_mapPropertyPaths.put(sBeanPropertyName, sXmlPath);
    }

    @Override
    public <T> void registerProcessor(Class<T> clzType, AttributeProcessor<T> processor) {
        this.m_mapAttributeProcessorsByType.put(clzType, processor);
    }

    @Override
    public <T> void registerProcessor(Class<T> clzType, ElementProcessor<T> processor) {
        this.m_mapElementProcessorsByType.put(clzType, processor);
    }

    @Override
    public <T> void registerAttributeType(Class<T> clzType) {
        this.registerProcessor(clzType, new SimpleAttributeProcessor<T>(clzType));
    }

    @Override
    public <T> void registerElementType(Class<T> clzType) {
        this.registerProcessor(clzType, new SimpleElementProcessor<T>(clzType));
    }

    @Override
    public ExpressionParser getExpressionParser() {
        return this.m_dependencies.getExpressionParser();
    }

    @Override
    public Object processDocument(XmlElement xmlElement) throws ConfigurationException {
        return this.processElement(xmlElement);
    }

    @Override
    public Object processDocumentAt(URI uri) throws ConfigurationException {
        return this.processDocument(XmlHelper.loadFileOrResource(uri.toString(), "cache configuration", this.m_dependencies.getContextClassLoader()));
    }

    @Override
    public Object processDocumentAt(String sLocation) throws ConfigurationException {
        return this.processDocument(XmlHelper.loadFileOrResource(sLocation, "cache configuration", this.m_dependencies.getContextClassLoader()));
    }

    @Override
    public Object processDocument(String sXml) throws ConfigurationException {
        return this.processDocument(XmlHelper.loadXml(sXml));
    }

    @Override
    public Object processElement(XmlElement xmlElement) throws ConfigurationException {
        ConditionalElementProcessor procConditional;
        QualifiedName qnElement;
        NamespaceHandler namespaceHandler;
        ElementProcessor<?> procElement;
        Object qnAttribute;
        Object oResult = null;
        ArrayList<SimpleAttribute> lstAttributes = new ArrayList<SimpleAttribute>(xmlElement.getAttributeMap().size());
        for (String sAttributeName : xmlElement.getAttributeMap().keySet()) {
            lstAttributes.add(new SimpleAttribute(xmlElement, sAttributeName, xmlElement.getAttribute(sAttributeName)));
        }
        boolean fElementRequiresPreprocessing = this.isRootContext() || xmlElement.getParent() == null;
        DefaultProcessingContext context = new DefaultProcessingContext(this, xmlElement);
        for (XmlAttribute xmlAttribute : lstAttributes) {
            qnAttribute = xmlAttribute.getQualifiedName();
            if (!((QualifiedName)qnAttribute).getLocalName().equals("xmlns")) continue;
            String sURI = xmlAttribute.getXmlValue().getString();
            try {
                context.ensureNamespaceHandler(((QualifiedName)qnAttribute).getPrefix(), new URI(sURI));
                fElementRequiresPreprocessing = true;
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new ConfigurationException(String.format("Invalid URI '%s' specified for Xml Namespace '%s'", sURI, ((QualifiedName)qnAttribute).getPrefix()), "You must specify a valid URI for the Xml Namespace.", uRISyntaxException);
            }
        }
        if (fElementRequiresPreprocessing) {
            boolean bl;
            Iterable<NamespaceHandler> namespaceHandlers = context.getNamespaceHandlers();
            do {
                Object namespaceHandler2;
                DocumentPreprocessor documentPreprocessor;
                bl = false;
                qnAttribute = namespaceHandlers.iterator();
                while (qnAttribute.hasNext() && ((documentPreprocessor = (namespaceHandler2 = (NamespaceHandler)qnAttribute.next()).getDocumentPreprocessor()) == null || !(bl = bl || documentPreprocessor.preprocess(context, xmlElement)))) {
                }
            } while (bl);
        }
        ElementProcessor<?> elementProcessor = procElement = (namespaceHandler = context.getNamespaceHandler((qnElement = xmlElement.getQualifiedName()).getPrefix())) == null ? null : namespaceHandler.getElementProcessor(xmlElement);
        if (namespaceHandler == null) {
            throw new ConfigurationException(String.format("A NamespaceHandler could not be located for the namespace [%s] in the element [%s]", qnElement.getPrefix(), xmlElement), "A NamespaceHandler implementation for the namespace must be defined.");
        }
        if (procElement == null) {
            throw new ConfigurationException(String.format("An ElementProcessor could not be located for the element [%s]", qnElement), "The specified element is unknown to the NamespaceHandler implementation. Perhaps the xml element is foreign to the Xml Namespace?");
        }
        for (XmlAttribute xmlAttribute : lstAttributes) {
            AttributeProcessor<?> procAttribute;
            QualifiedName qnAttribute2 = xmlAttribute.getQualifiedName();
            NamespaceHandler nsAttribute = qnAttribute2.hasPrefix() ? this.getNamespaceHandler(qnAttribute2.getPrefix()) : namespaceHandler;
            AttributeProcessor<?> attributeProcessor = procAttribute = nsAttribute == null ? null : nsAttribute.getAttributeProcessor(xmlAttribute);
            if (nsAttribute == null || procAttribute == null) continue;
            procAttribute.process(context, xmlAttribute);
        }
        ConditionalElementProcessor conditionalElementProcessor = procConditional = procElement instanceof ConditionalElementProcessor ? (ConditionalElementProcessor)procElement : null;
        if (procConditional == null || procConditional.accepts(context, xmlElement)) {
            oResult = procElement.process(context, xmlElement);
        }
        context.terminate();
        this.m_setProcessedChildElements.add(xmlElement);
        return oResult;
    }

    @Override
    public Object processElement(String sXml) throws ConfigurationException {
        return this.processElement(XmlHelper.loadXml(sXml));
    }

    @Override
    public <T> T processOnlyElementOf(XmlElement xmlElement) throws ConfigurationException {
        if (xmlElement.getElementList().size() == 1) {
            return (T)this.processElement((XmlElement)xmlElement.getElementList().get(0));
        }
        throw new ConfigurationException(String.format("Only a single element is permitted in the %s element.", xmlElement), String.format("Please consult the documentation regarding use of the '%s' namespace", new QualifiedName(xmlElement).getPrefix()));
    }

    @Override
    public Map<String, ?> processElementsOf(XmlElement xmlElement) throws ConfigurationException {
        LinkedHashMap<String, Object> mapResult = new LinkedHashMap<String, Object>();
        for (XmlElement xmlChild : xmlElement.getElementList()) {
            String sId;
            String string = sId = xmlChild.getAttributeMap().containsKey("id") ? xmlChild.getAttribute("id").getString() : new UUID().toString();
            if (sId.trim().length() == 0) {
                sId = new UUID().toString();
            }
            mapResult.put(sId, this.processElement(xmlChild));
        }
        return mapResult;
    }

    @Override
    public Map<String, ?> processForeignElementsOf(XmlElement xmlElement) throws ConfigurationException {
        String sPrefix = xmlElement.getQualifiedName().getPrefix();
        LinkedHashMap<String, Object> mapResult = new LinkedHashMap<String, Object>();
        for (XmlElement xmlChild : xmlElement.getElementList()) {
            String sId;
            if (xmlChild.getQualifiedName().getPrefix().equals(sPrefix)) continue;
            String string = sId = xmlChild.getAttributeMap().containsKey("id") ? xmlChild.getAttribute("id").getString() : new UUID().toString();
            if (sId.trim().length() == 0) {
                sId = new UUID().toString();
            }
            mapResult.put(sId, this.processElement(xmlChild));
        }
        return mapResult;
    }

    @Override
    public Map<String, ?> processRemainingElementsOf(XmlElement xmlElement) throws ConfigurationException {
        LinkedHashMap<String, Object> mapResult = new LinkedHashMap<String, Object>();
        for (XmlElement xmlChild : xmlElement.getElementList()) {
            String sId;
            if (this.m_setProcessedChildElements.contains(xmlChild)) continue;
            String string = sId = xmlChild.getAttributeMap().containsKey("id") ? xmlChild.getAttribute("id").getString() : new UUID().toString();
            if (sId.trim().length() == 0) {
                sId = new UUID().toString();
            }
            mapResult.put(sId, this.processElement(xmlChild));
        }
        return mapResult;
    }

    @Override
    public <T> T processRemainingElementOf(XmlElement xmlElement) throws ConfigurationException {
        Map<String, ?> mapResults = this.processRemainingElementsOf(xmlElement);
        int cSize = mapResults.size();
        if (cSize == 1) {
            return (T)mapResults.values().iterator().next();
        }
        throw new ConfigurationException(String.format("Expected a single remaining element to process in %s after processing the elements %s but there were %d elements remaining", xmlElement, xmlElement.getQualifiedName(), this.m_setProcessedChildElements.size()), String.format("The ElementProcessor implementation for %s makes an incorrect assumption about the number of remaining elements.", xmlElement.getQualifiedName()));
    }

    @Override
    public boolean isPropertyDefined(String sPropertyName, XmlElement xmlParent) throws ConfigurationException {
        if (sPropertyName == null || xmlParent == null) {
            return false;
        }
        boolean fPropertyFound = sPropertyName.equals(".");
        if (!fPropertyFound) {
            boolean bl = fPropertyFound = this.getPropertyAttribute(xmlParent, sPropertyName) != null;
        }
        if (!fPropertyFound) {
            fPropertyFound = this.getPropertyElement(xmlParent, sPropertyName) != null;
        }
        return fPropertyFound;
    }

    @Override
    public <B> B inject(B bean, XmlElement xmlElement) throws ConfigurationException {
        for (Method method : bean.getClass().getMethods()) {
            Type typeProperty;
            String sPropertyName;
            Value value;
            Type[] aParameterTypes = method.getGenericParameterTypes();
            Injectable annInjectable = method.getAnnotation(Injectable.class);
            if (annInjectable == null) continue;
            if (aParameterTypes.length == 0 && !method.getReturnType().equals(Void.TYPE)) {
                Object oInjectable = null;
                try {
                    XmlElement xmlProperty;
                    oInjectable = method.invoke(bean, new Object[0]);
                    if (oInjectable == null || oInjectable == bean) continue;
                    String sPropertyName2 = annInjectable.value();
                    if (sPropertyName2.isEmpty()) {
                        sPropertyName2 = this.getPropertyName(method);
                    }
                    if ((xmlProperty = sPropertyName2.equals(".") ? xmlElement : this.getPropertyElement(xmlElement, sPropertyName2)) == null) continue;
                    this.inject(oInjectable, xmlProperty);
                    continue;
                }
                catch (ConfigurationException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new ConfigurationException(String.format("Could not inject a value into the instance '%s' using reflection  produced by the annotated method '%s' of '%s'", oInjectable, method, bean.getClass().getName()), "Please resolve the causing exception.", e);
                }
            }
            if (aParameterTypes.length != 1 || (value = this.getPropertyValue(sPropertyName = this.getPropertyName(method), typeProperty = aParameterTypes[0], xmlElement, false)) == null) continue;
            Object oPropertyValue = value.get();
            try {
                method.invoke(bean, oPropertyValue);
            }
            catch (Exception e) {
                throw new ConfigurationException(String.format("Could not inject the property '%s' using reflection with the annotated method '%s' of '%s'", sPropertyName, method, bean.getClass().getName()), "Please resolve the causing exception.", e);
            }
        }
        return bean;
    }

    @Override
    public <T> T getMandatoryProperty(String sPath, Type typeProperty, XmlElement xmlParent) throws ConfigurationException {
        Value value = this.getPropertyValue(sPath, typeProperty, xmlParent, true);
        if (value == null) {
            throw new ConfigurationException(String.format("The expected property [%s] is not defined in element [%s].", sPath, xmlParent), String.format("Please consult the documentation for the use of the %s namespace", this.m_xmlElement.getQualifiedName().getPrefix()));
        }
        return (T)value.get();
    }

    @Override
    public <T> T getOptionalProperty(String sPropertyName, Type typeProperty, T defaultValue, XmlElement xmlElement) throws ConfigurationException {
        Value value = this.getPropertyValue(sPropertyName, typeProperty, xmlElement, true);
        if (value == null) {
            return defaultValue;
        }
        return (T)value.get();
    }

    @Override
    public void loadNamespaceHandlers(XmlElement xmlElement) {
        int cAttribute = xmlElement.getAttributeMap().size();
        if (cAttribute == 0) {
            return;
        }
        ArrayList<SimpleAttribute> lstAttributes = new ArrayList<SimpleAttribute>(cAttribute);
        for (String string : xmlElement.getAttributeMap().keySet()) {
            lstAttributes.add(new SimpleAttribute(xmlElement, string, xmlElement.getAttribute(string)));
        }
        for (XmlAttribute xmlAttribute : lstAttributes) {
            QualifiedName qnAttribute = xmlAttribute.getQualifiedName();
            if (!qnAttribute.getLocalName().equals("xmlns")) continue;
            String sURI = xmlAttribute.getXmlValue().getString();
            try {
                this.ensureNamespaceHandler(qnAttribute.getPrefix(), new URI(sURI));
            }
            catch (URISyntaxException uriSyntaxException) {
                throw new ConfigurationException(String.format("Invalid URI '%s' specified for Xml Namespace '%s'", sURI, qnAttribute.getPrefix()), "You must specify a valid URI for the Xml Namespace.", uriSyntaxException);
            }
        }
    }

    @Override
    public NamespaceHandler ensureNamespaceHandler(String sPrefix, NamespaceHandler handler) throws ConfigurationException {
        URI uri = this.m_mapNamespaceURIsByPrefix.get(sPrefix);
        if (uri == null) {
            try {
                uri = new URI("class://" + handler.getClass().getName());
            }
            catch (URISyntaxException e) {
                throw new ConfigurationException(String.format("Failed to create a valid URI for the specified namespace class [%s] with prefix [%s]", handler.getClass().getName(), sPrefix), "The implemented URI encoding is invalid", e);
            }
            this.m_mapNamespaceURIsByPrefix.put(sPrefix, uri);
            this.m_mapNamespaceHandlersByURI.put(uri, handler);
            handler.onStartNamespace(this, this.m_xmlElement, sPrefix, uri);
            return handler;
        }
        return this.m_mapNamespaceHandlersByURI.get(uri);
    }

    @Override
    public NamespaceHandler ensureNamespaceHandler(String sPrefix, URI uri) throws ConfigurationException {
        NamespaceHandler namespaceHandler = this.getNamespaceHandler(uri);
        if (namespaceHandler == null || !this.getNamespaceURI(sPrefix).equals(uri)) {
            String sScheme = uri.getScheme();
            if (this.m_mapNamespaceURIsByPrefix.containsKey(sPrefix)) {
                throw new ConfigurationException(String.format("Duplicate definition for the namespace prefix [%s] and URI [%s] encountered in the element [%s]", sPrefix, uri, this.m_xmlElement), "Duplicate definitions of namespaces is not permitted.");
            }
            if (sScheme.equals("class")) {
                String sClassName = uri.getHost() == null ? uri.getSchemeSpecificPart() : uri.getHost();
                try {
                    Class clzNamespaceHandler = ExternalizableHelper.loadClass(sClassName, this.m_dependencies.getContextClassLoader(), null);
                    if (NamespaceHandler.class.isAssignableFrom(clzNamespaceHandler)) {
                        try {
                            Constructor constructor = clzNamespaceHandler.getConstructor(new Class[0]);
                            namespaceHandler = (NamespaceHandler)constructor.newInstance(new Object[0]);
                            this.m_mapNamespaceHandlersByURI.put(uri, namespaceHandler);
                            this.m_mapNamespaceURIsByPrefix.put(sPrefix, uri);
                            namespaceHandler.onStartNamespace(this, this.m_xmlElement, sPrefix, uri);
                            return namespaceHandler;
                        }
                        catch (Exception exception) {
                            throw new ConfigurationException(String.format("Can't instantiate the NamespaceHandler [%s]\n", sClassName), "Please ensure that the specified class is public and has a no-args constructor", exception);
                        }
                    }
                    throw new ConfigurationException(String.format("The declared class [%s] does not implement the %s interface", sClassName, NamespaceHandler.class.getName()), "To use a class as a NamespaceHandler it must implement the appropriate interface.");
                }
                catch (ClassNotFoundException e) {
                    throw new ConfigurationException(String.format("Can't instantiate the NamespaceHandler [%s] as the class is not found\n", sClassName), "Please ensure that the specified class is an instance of NamespaceHandler interface", e);
                }
            }
            if (sScheme.equalsIgnoreCase("http") || sScheme.equalsIgnoreCase("https")) {
                return this.getNamespaceHandler(sPrefix);
            }
            throw new ConfigurationException(String.format("Can't instantiate a suitable NamespaceHandler as the URI [%s] scheme is unknown.\n", uri), "Please ensure that the specified URI refers to a class that implements the NamespaceHandler interface");
        }
        return namespaceHandler;
    }

    @Override
    public NamespaceHandler getNamespaceHandler(String sPrefix) {
        URI uri = this.getNamespaceURI(sPrefix);
        return uri == null ? null : this.getNamespaceHandler(uri);
    }

    @Override
    public NamespaceHandler getNamespaceHandler(URI uri) {
        NamespaceHandler namespaceHandler = this.m_mapNamespaceHandlersByURI.get(uri);
        return namespaceHandler == null ? (this.isRootContext() ? null : this.m_ctxParent.getNamespaceHandler(uri)) : namespaceHandler;
    }

    @Override
    public URI getNamespaceURI(String sPrefix) {
        URI uri = this.m_mapNamespaceURIsByPrefix.get(sPrefix);
        return uri == null ? (this.isRootContext() ? null : this.m_ctxParent.getNamespaceURI(sPrefix)) : uri;
    }

    @Override
    public Iterable<NamespaceHandler> getNamespaceHandlers() {
        LinkedHashMap<URI, NamespaceHandler> mapNamespaceHandlersByURI = new LinkedHashMap<URI, NamespaceHandler>();
        DefaultProcessingContext ctx = this;
        while (ctx != null) {
            for (Map.Entry<URI, NamespaceHandler> e : ctx.m_mapNamespaceHandlersByURI.entrySet()) {
                if (mapNamespaceHandlersByURI.containsKey(e.getKey())) continue;
                mapNamespaceHandlersByURI.put(e.getKey(), e.getValue());
            }
            ctx = ctx.m_ctxParent;
        }
        return mapNamespaceHandlersByURI.values();
    }

    public DocumentProcessor.Dependencies getDependencies() {
        return this.m_dependencies;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Value getPropertyValue(String sPropertyName, Type typeProperty, XmlElement xmlParent, boolean fOnlyUsePropertyName) throws ConfigurationException {
        ResourceRegistry resourceRegistry;
        XmlAttribute xmlAttribute;
        if (sPropertyName == null) {
            throw new NullPointerException("Property Name can't be null");
        }
        if (typeProperty == null) {
            throw new NullPointerException("Property Type can't be null");
        }
        if (xmlParent == null) {
            throw new NullPointerException("XmlElement in which to locate a property can't be null");
        }
        Object oValue = null;
        boolean fValueResolved = false;
        Class<?> clzProperty = ClassHelper.getClass(typeProperty);
        if (!sPropertyName.equals(".") && (xmlAttribute = this.getPropertyAttribute(xmlParent, sPropertyName)) != null) {
            AttributeProcessor<?> procAttribute;
            fValueResolved = true;
            NamespaceHandler nsAttribute = this.getNamespaceHandler(xmlAttribute.getQualifiedName().getPrefix());
            AttributeProcessor<?> attributeProcessor = procAttribute = nsAttribute == null ? null : nsAttribute.getAttributeProcessor(xmlAttribute);
            if (procAttribute == null) {
                procAttribute = this.getAttributeProcessor(clzProperty);
            }
            oValue = procAttribute == null ? xmlAttribute.getXmlValue().getString() : procAttribute.process(this, xmlAttribute);
        }
        if (!fValueResolved) {
            XmlElement xmlElement;
            XmlElement xmlElement2 = xmlElement = sPropertyName.equals(".") ? xmlParent : this.getPropertyElement(xmlParent, sPropertyName);
            if (xmlElement != null) {
                NamespaceHandler nsElement;
                ElementProcessor<?> procElement;
                if (xmlElement != xmlParent) {
                    this.m_setProcessedChildElements.add(xmlElement);
                }
                ElementProcessor<?> elementProcessor = procElement = (nsElement = this.getNamespaceHandler(xmlElement.getQualifiedName().getPrefix())) == null ? null : nsElement.getElementProcessor(xmlElement);
                if (procElement == null) {
                    procElement = this.getElementProcessor(clzProperty);
                }
                if (procElement == null) {
                    Class<?> clzComponent = ClassHelper.getComponentType(typeProperty);
                    int cChildren = xmlElement.getElementList().size();
                    if (clzComponent == null) {
                        if (cChildren == 0) {
                            if (!XmlHelper.isEmpty(xmlElement)) {
                                oValue = xmlElement.getString();
                                fValueResolved = true;
                            }
                        } else if (cChildren == 1) {
                            oValue = this.processOnlyElementOf(xmlElement);
                            fValueResolved = true;
                        } else {
                            oValue = xmlElement;
                            fValueResolved = true;
                        }
                    } else {
                        fValueResolved = true;
                        boolean fArray = clzProperty.isArray();
                        if (fArray) {
                            oValue = Array.newInstance(clzComponent, cChildren);
                        } else if (clzProperty.isInterface()) {
                            if (clzProperty.equals(List.class)) {
                                oValue = new ArrayList(cChildren);
                            } else if (clzProperty.equals(Set.class)) {
                                oValue = new LinkedHashSet(cChildren);
                            } else if (clzProperty.equals(Queue.class)) {
                                oValue = new ArrayDeque(cChildren);
                            } else {
                                if (!clzProperty.equals(SortedSet.class)) throw new ConfigurationException(String.format("Unsupported collection type [%s] encountered with the property [%s] in [%s]", typeProperty, sPropertyName, xmlElement), "The specified interface type is not supported. Please use a more specific type.");
                                oValue = new TreeSet();
                            }
                        } else {
                            try {
                                oValue = clzProperty.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            }
                            catch (Exception e) {
                                throw new ConfigurationException(String.format("Failed to instantiate the required type [%s] for the property [%s] in [%s]", typeProperty, sPropertyName, xmlElement), "Ensure that the specified type has a public no-args constructor", e);
                            }
                        }
                        int idx = 0;
                        for (XmlElement xmlChild : xmlElement.getElementList()) {
                            Object oChild = this.processElement(xmlChild);
                            if (!clzComponent.isInstance(oChild)) throw new ConfigurationException(String.format("Incompatible typesThe value [%s] is not assignable to a collection of type [%s]as expected by the property [%s] in [%s]", oChild, clzComponent, sPropertyName, xmlElement), "Please ensure assignment compatible values are provided");
                            if (fArray) {
                                ((Object[])oValue)[idx] = oChild;
                            } else {
                                ((Collection)oValue).add(oChild);
                            }
                            ++idx;
                        }
                    }
                } else {
                    ConditionalElementProcessor procConditional = procElement instanceof ConditionalElementProcessor ? (ConditionalElementProcessor)procElement : null;
                    DefaultProcessingContext ctxValue = new DefaultProcessingContext(this, xmlElement);
                    if (procConditional == null || procConditional.accepts(ctxValue, xmlElement)) {
                        oValue = procElement.process(ctxValue, xmlElement);
                        fValueResolved = true;
                    }
                    ctxValue.terminate();
                }
            }
        }
        if (!fValueResolved) {
            oValue = this.getCookie(clzProperty, sPropertyName);
            if (oValue == null && !fOnlyUsePropertyName) {
                oValue = this.getCookie(clzProperty);
            }
            boolean bl = fValueResolved = oValue != null;
        }
        if (!fValueResolved && (resourceRegistry = this.getResourceRegistry()) != null) {
            oValue = resourceRegistry.getResource(clzProperty, sPropertyName);
            if (oValue == null && !fOnlyUsePropertyName) {
                oValue = resourceRegistry.getResource(clzProperty);
            }
            if (oValue == null) return null;
            boolean bl = true;
            fValueResolved = bl;
        }
        if (!fValueResolved) return null;
        if (oValue == null) {
            return new Value();
        }
        if (clzProperty.isInstance(oValue)) {
            return new Value(oValue);
        }
        if (clzProperty.equals(Expression.class)) {
            ParameterizedType typeParameterized;
            Type typeRaw;
            Class<Object> clazz = Object.class;
            if (typeProperty instanceof ParameterizedType && (typeRaw = (typeParameterized = (ParameterizedType)typeProperty).getRawType()) instanceof Class) {
                Class<?> clazz2 = ClassHelper.getClass(typeParameterized.getActualTypeArguments()[0]);
            }
            if (!(oValue instanceof String)) return new Value(new LiteralExpression<String>((String)oValue));
            ExpressionParser parser = this.m_dependencies.getExpressionParser();
            if (parser == null) {
                throw new ConfigurationException(String.format("Failed to parse the expression [%s] defined for the property [%s] in [%s] as an ExpressionParser is not defined.", oValue, sPropertyName, xmlParent), "An ExpressionParser must be set for the DocumentProcessor.");
            }
            try {
                void var8_15;
                return new Value(parser.parse((String)oValue, var8_15));
            }
            catch (ParseException e) {
                throw new ConfigurationException(String.format("Failed to parse the expression [%s] defined for the property [%s] in [%s].", oValue, sPropertyName, xmlParent), "Please correct the expression syntax error.", e);
            }
        }
        try {
            Value value = oValue instanceof Value ? (Value)oValue : new Value(oValue);
            return new Value(value.as(clzProperty));
        }
        catch (Exception exception) {
            throw new ConfigurationException(String.format("Failed to convert the property [%s] value [%s] into the required type [%s] in [%s].", sPropertyName, oValue, typeProperty, xmlParent), "The namespace implementation for the property will need to programmatically configure the said property.", exception);
        }
    }

    private XmlElement getElementAt(XmlElement xmlElement, String sPath, String sPrefix) {
        sPath = sPath == null ? "" : sPath.trim();
        XmlElement xml = sPath.startsWith("/") ? xmlElement.getRoot() : xmlElement;
        StringTokenizer tokens = new StringTokenizer(sPath, "/");
        while (xml != null && tokens.hasMoreTokens()) {
            String sName = tokens.nextToken().trim();
            if (sName.equals("..")) {
                xml = xml.getParent();
                continue;
            }
            QualifiedName qName = sName.contains(":") ? new QualifiedName(sName) : new QualifiedName(sPrefix, sName);
            xml = xml.getElement(qName.getName());
        }
        return xml;
    }

    private XmlAttribute getPropertyAttribute(XmlElement xmlElement, String sPath) {
        XmlElement xmlParent;
        String sAttributeName;
        String string = sPath = sPath == null ? null : sPath.trim();
        if (sPath == null || sPath.isEmpty()) {
            return null;
        }
        int iAttribute = Math.max(sPath.lastIndexOf("/"), sPath.lastIndexOf(".."));
        if (iAttribute >= 0) {
            sAttributeName = sPath.substring(iAttribute + (sPath.charAt(iAttribute) == '/' ? 1 : 2));
            sPath = sPath.substring(0, iAttribute);
            xmlParent = this.getElementAt(xmlElement, sPath.substring(0, iAttribute), xmlElement.getQualifiedName().getPrefix());
        } else {
            sAttributeName = sPath;
            xmlParent = this.m_xmlElement;
        }
        XmlValue value = xmlParent == null ? null : xmlParent.getAttribute(sAttributeName);
        return value == null ? null : new SimpleAttribute(xmlParent, sAttributeName, value);
    }

    private XmlElement getPropertyElement(XmlElement xmlElement, String sPath) {
        String sPrefix = xmlElement.getQualifiedName().getPrefix();
        XmlElement element = this.getElementAt(xmlElement, sPath, sPrefix);
        if (element == null && sPrefix != null && !sPrefix.isEmpty()) {
            element = this.getElementAt(xmlElement, sPath, "");
        }
        return element;
    }

    <T> AttributeProcessor<T> getAttributeProcessor(Class<T> clzType) {
        AttributeProcessor<?> procAttribute = this.m_mapAttributeProcessorsByType.get(clzType);
        if (procAttribute == null) {
            return this.isRootContext() ? null : this.m_ctxParent.getAttributeProcessor(clzType);
        }
        return procAttribute;
    }

    <T> ElementProcessor<T> getElementProcessor(Class<T> clzType) {
        ElementProcessor<?> procElement = this.m_mapElementProcessorsByType.get(clzType);
        if (procElement == null) {
            return this.isRootContext() ? null : this.m_ctxParent.getElementProcessor(clzType);
        }
        return procElement;
    }

    public boolean isRootContext() {
        return this.m_ctxParent == null;
    }

    String getPropertyName(Method method) {
        StringBuilder sbPropertyName = new StringBuilder();
        if (method.isAnnotationPresent(Injectable.class) && !method.getAnnotation(Injectable.class).value().isEmpty()) {
            sbPropertyName.append(method.getAnnotation(Injectable.class).value());
        } else {
            String sn = method.getName().substring("set".length());
            if (!sn.isEmpty()) {
                sbPropertyName.append(sn.substring(0, 1).toLowerCase());
            }
            for (int i = 1; i < sn.length(); ++i) {
                char ch = sn.charAt(i);
                if (Character.isUpperCase(ch)) {
                    sbPropertyName.append("-");
                    sbPropertyName.append(Character.toLowerCase(ch));
                    continue;
                }
                sbPropertyName.append(ch);
            }
        }
        String sName = sbPropertyName.toString();
        String sPropertyPath = this.m_mapPropertyPaths.get(sName);
        return sPropertyPath == null ? sName : sPropertyPath;
    }

    void terminate() {
        for (String sPrefix : this.m_mapNamespaceURIsByPrefix.keySet()) {
            URI uri = this.m_mapNamespaceURIsByPrefix.get(sPrefix);
            NamespaceHandler handler = this.m_mapNamespaceHandlersByURI.get(uri);
            if (handler == null) continue;
            handler.onEndNamespace(this, this.m_xmlElement, sPrefix, uri);
        }
    }

    @Override
    public void close() {
        this.terminate();
    }
}

