/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.config.xml;

import com.tangosol.config.xml.AttributeProcessor;
import com.tangosol.config.xml.DocumentPreprocessor;
import com.tangosol.config.xml.ElementProcessor;
import com.tangosol.config.xml.NamespaceHandler;
import com.tangosol.config.xml.ProcessingContext;
import com.tangosol.config.xml.SimpleAttributeProcessor;
import com.tangosol.config.xml.SimpleElementProcessor;
import com.tangosol.config.xml.XmlSimpleName;
import com.tangosol.run.xml.XmlAttribute;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.HashMap;

public abstract class AbstractNamespaceHandler
implements NamespaceHandler {
    private DocumentPreprocessor m_documentPreprocessor = null;
    private HashMap<String, AttributeProcessor<?>> m_mapAttributeProcessors;
    private HashMap<String, ElementProcessor<?>> m_mapElementProcessors = new HashMap();

    public AbstractNamespaceHandler() {
        this.m_mapAttributeProcessors = new HashMap();
        this.autoRegisterInnerClassProcessors();
    }

    @Override
    public DocumentPreprocessor getDocumentPreprocessor() {
        return this.m_documentPreprocessor;
    }

    @Override
    public AttributeProcessor<?> getAttributeProcessor(XmlAttribute attribute) {
        AttributeProcessor<?> processor = this.m_mapAttributeProcessors.get(attribute.getQualifiedName().getLocalName());
        return processor == null ? this.onUnknownAttribute(attribute) : processor;
    }

    @Override
    public ElementProcessor<?> getElementProcessor(XmlElement element) {
        ElementProcessor<?> processor = this.m_mapElementProcessors.get(element.getQualifiedName().getLocalName());
        return processor == null ? this.onUnknownElement(element) : processor;
    }

    @Override
    public void onStartNamespace(ProcessingContext context, XmlElement element, String prefix, URI uri) {
    }

    @Override
    public void onEndNamespace(ProcessingContext context, XmlElement element, String prefix, URI uri) {
    }

    public void setDocumentPreprocessor(DocumentPreprocessor preprocessor) {
        this.m_documentPreprocessor = preprocessor;
    }

    public void registerProcessor(Class<?> clzProcessor) {
        if (clzProcessor.isAnnotationPresent(XmlSimpleName.class) && (ElementProcessor.class.isAssignableFrom(clzProcessor) || AttributeProcessor.class.isAssignableFrom(clzProcessor))) {
            try {
                String sLocalName = clzProcessor.getAnnotation(XmlSimpleName.class).value();
                Object oProcessor = clzProcessor.newInstance();
                if (oProcessor instanceof ElementProcessor) {
                    this.registerProcessor(sLocalName, (ElementProcessor)oProcessor);
                }
                if (oProcessor instanceof AttributeProcessor) {
                    this.registerProcessor(sLocalName, (AttributeProcessor)oProcessor);
                }
            }
            catch (InstantiationException e) {
                Base.ensureRuntimeException(e, "Specified processor class requires a no-args constructor.");
            }
            catch (IllegalAccessException e) {
                Base.ensureRuntimeException(e);
            }
        }
    }

    public void registerProcessor(String sLocalName, ElementProcessor<?> processor) {
        this.m_mapElementProcessors.put(sLocalName, processor);
    }

    public void registerProcessor(String sLocalName, AttributeProcessor<?> processor) {
        this.m_mapAttributeProcessors.put(sLocalName, processor);
    }

    public <T> void registerElementType(String sLocalName, Class<T> clzType) {
        if (ElementProcessor.class.isAssignableFrom(clzType)) {
            try {
                ElementProcessor processor = (ElementProcessor)clzType.newInstance();
                this.registerProcessor(sLocalName, processor);
            }
            catch (Exception exception) {
                throw new RuntimeException(String.format("Can't instantiate the ElementProcessor [%s]\n", clzType), exception);
            }
        } else {
            this.registerProcessor(sLocalName, new SimpleElementProcessor<T>(clzType));
        }
    }

    public <T> void registerAttributeType(String sLocalName, Class<T> clzType) {
        if (AttributeProcessor.class.isAssignableFrom(clzType)) {
            try {
                AttributeProcessor processor = (AttributeProcessor)clzType.newInstance();
                this.registerProcessor(sLocalName, processor);
            }
            catch (Exception exception) {
                throw new RuntimeException(String.format("Can't instantiate the AttributeProcessor [%s]\n", clzType), exception);
            }
        } else {
            this.registerProcessor(sLocalName, new SimpleAttributeProcessor<T>(clzType));
        }
    }

    protected AttributeProcessor<?> onUnknownAttribute(XmlAttribute attribute) {
        return null;
    }

    protected ElementProcessor<?> onUnknownElement(XmlElement element) {
        return null;
    }

    public AttributeProcessor<?> getAttributeProcessor(String localName) {
        return this.m_mapAttributeProcessors.get(localName);
    }

    public ElementProcessor<?> getElementProcessor(String localName) {
        return this.m_mapElementProcessors.get(localName);
    }

    void autoRegisterInnerClassProcessors() {
        for (Class<?> clzDeclared : this.getClass().getDeclaredClasses()) {
            String sProcessorName;
            if (clzDeclared.isInterface() || clzDeclared.isAnnotation() || (sProcessorName = this.getProcessorName(clzDeclared)) == null || sProcessorName.isEmpty() || !ElementProcessor.class.isAssignableFrom(clzDeclared) && !AttributeProcessor.class.isAssignableFrom(clzDeclared)) continue;
            try {
                Object oProcessor;
                if (Modifier.isStatic(clzDeclared.getModifiers())) {
                    oProcessor = clzDeclared.newInstance();
                } else {
                    Constructor<?> constructor = clzDeclared.getConstructor(this.getClass());
                    oProcessor = constructor.newInstance(this);
                }
                if (ElementProcessor.class.isAssignableFrom(clzDeclared)) {
                    this.registerProcessor(sProcessorName, (ElementProcessor)oProcessor);
                }
                if (!AttributeProcessor.class.isAssignableFrom(clzDeclared)) continue;
                this.registerProcessor(sProcessorName, (AttributeProcessor)oProcessor);
            }
            catch (Exception exception) {
                throw new RuntimeException(String.format("Can't instantiate the Processor [%s]\n", clzDeclared), exception);
            }
        }
    }

    String getProcessorName(Class<?> clzProcessor) {
        if (clzProcessor != null && clzProcessor.isAnnotationPresent(XmlSimpleName.class)) {
            String sProcessorName = clzProcessor.getAnnotation(XmlSimpleName.class).value();
            int nModifiers = clzProcessor.getModifiers();
            if (Modifier.isAbstract(nModifiers) || clzProcessor.isAnnotation() || clzProcessor.isInterface()) {
                return null;
            }
            return sProcessorName;
        }
        return null;
    }
}

