/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.config.expression;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.config.expression.Expression;
import com.tangosol.config.expression.Parameter;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ValueMacroExpression
implements Expression<String>,
ExternalizableLite,
PortableObject {
    public static int MAX_MACRO_EXPANSIONS = 20;
    public static final String PARAMETER_PREFIX = "${";
    public static final Character PARAMETER_SUFFIX = Character.valueOf('}');
    public static final String SUBSTRING_OFFSET_LENGTH_EXPANSION = ":";
    private static Map<String, MacroExpansionProcessor> s_mapRegistry = new HashMap<String, MacroExpansionProcessor>();
    private static final MacroExpansionProcessor NO_DELIMITER_MACRO_EXPANSION_PROCESSOR = new MacroExpansionProcessor();
    private String m_sValue;

    public ValueMacroExpression() {
    }

    public ValueMacroExpression(String value) {
        this.m_sValue = value;
    }

    @Override
    public String evaluate(ParameterResolver resolver) {
        String sValue = this.m_sValue;
        try {
            return this.substitute(sValue, resolver, 1).toString();
        }
        catch (IllegalStateException e) {
            Logger.config("macro parameter value expansion failure expanding " + sValue + " cause: " + e.getMessage());
            return sValue;
        }
        catch (StringIndexOutOfBoundsException e) {
            Logger.config("macro parameter value expansion failure expanding " + sValue + " cause:" + e.getMessage());
            return sValue;
        }
    }

    protected String substitute(String sValue, ParameterResolver resolver, int cDepth) {
        boolean fLogged = false;
        if (sValue != null) {
            int ofEnd;
            int ofStart = sValue.indexOf(PARAMETER_PREFIX);
            while (ofStart >= 0 && (ofEnd = sValue.indexOf(PARAMETER_SUFFIX.charValue(), ofStart)) != -1) {
                int ofNext = sValue.indexOf(PARAMETER_PREFIX, ofStart + 1);
                if (ofNext != -1 && ofNext < ofEnd) {
                    int ofNextEnd = ValueMacroExpression.indexOfMatchingPropertyClose(sValue, ofNext);
                    if (ofNextEnd == -1) break;
                    String sNestedMacro = this.substitute(sValue.substring(ofNext, ofNextEnd + 1), resolver, cDepth + 1);
                    sValue = ValueMacroExpression.replaceMacroParameter(sValue, ofNext, ofNextEnd + 1, sNestedMacro);
                    ofEnd = ValueMacroExpression.indexOfMatchingPropertyClose(sValue, ofStart);
                }
                int ofStartMacro = ofStart;
                int ofEndMacro = ofEnd + 1;
                String sMacro = sValue.substring(ofStartMacro, ofEndMacro);
                String sPropValue = this.processRegisteredMacroExpansions(sMacro, resolver, cDepth);
                sValue = ValueMacroExpression.replaceMacroParameter(sValue, ofStartMacro, ofEndMacro, sPropValue);
                ++cDepth;
                ofStart = sValue.indexOf(PARAMETER_PREFIX);
            }
        }
        return sValue;
    }

    protected String processRegisteredMacroExpansions(String sMacro, ParameterResolver resolver, int cDepth) {
        String sPropValue = sMacro;
        for (Map.Entry<String, MacroExpansionProcessor> entry : s_mapRegistry.entrySet()) {
            MacroExpansionProcessor processor = entry.getValue();
            if (!processor.canProcess(sMacro)) continue;
            return processor.process(sPropValue, resolver, cDepth);
        }
        if (NO_DELIMITER_MACRO_EXPANSION_PROCESSOR.canProcess(sMacro)) {
            return NO_DELIMITER_MACRO_EXPANSION_PROCESSOR.process(sMacro, resolver, cDepth);
        }
        return sPropValue;
    }

    public boolean containsMacro() {
        return ValueMacroExpression.containsMacro(this.m_sValue);
    }

    static String replaceMacroParameter(String sValue, int ofStart, int ofEnd, String sReplacement) {
        return sValue.substring(0, ofStart) + sReplacement + (ofEnd + 1 > sValue.length() ? "" : sValue.substring(ofEnd));
    }

    static int indexOfMatchingPropertyClose(String sValue, int ofPropertyStart) {
        int ofCur = ofPropertyStart + 1;
        int nNested = 0;
        while (ofCur < sValue.length()) {
            if (sValue.regionMatches(ofCur, PARAMETER_PREFIX, 0, PARAMETER_PREFIX.length())) {
                ++nNested;
                ofCur += PARAMETER_PREFIX.length();
                continue;
            }
            if (sValue.charAt(ofCur) == PARAMETER_SUFFIX.charValue()) {
                if (nNested == 0) {
                    return ofCur;
                }
                --nNested;
                ++ofCur;
                continue;
            }
            ++ofCur;
        }
        return -1;
    }

    public static boolean containsMacro(String sValue) {
        if (sValue == null) {
            return false;
        }
        int ofStart = sValue.indexOf(PARAMETER_PREFIX);
        return ofStart >= 0 && sValue.indexOf(PARAMETER_SUFFIX.charValue(), ofStart) > 0;
    }

    protected static boolean containsRegisteredDelimiter(String sMacro) {
        for (String sDelimter : s_mapRegistry.keySet()) {
            if (!sMacro.contains(sDelimter)) continue;
            return true;
        }
        return false;
    }

    static void register(String sDelimiter, MacroExpansionProcessor processor) {
        s_mapRegistry.put(sDelimiter, processor);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_sValue = (String)ExternalizableHelper.readObject(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject(out, this.m_sValue);
    }

    @Override
    public void readExternal(PofReader reader) throws IOException {
        this.m_sValue = (String)reader.readObject(0);
    }

    @Override
    public void writeExternal(PofWriter writer) throws IOException {
        writer.writeObject(0, this.m_sValue);
    }

    public String toString() {
        return String.format("ValueMacroExpression[value=%s]", this.m_sValue);
    }

    static {
        ValueMacroExpression.register(SUBSTRING_OFFSET_LENGTH_EXPANSION, new OffsetLengthSubstringExpansionProcessor());
        ValueMacroExpression.register(":-", new DefaultDelimiterExpansionProcessor(":-"));
        ValueMacroExpression.register(":+", new DefaultDelimiterExpansionProcessor(":+"));
        ValueMacroExpression.register(" ", new SpaceDefaultDelimiterExpansionProcessor());
    }

    protected static class MacroExpansionProcessor {
        protected MacroExpansionProcessor() {
        }

        public String process(String sMacro, ParameterResolver resolver, int cDepth) {
            String sDefault = "";
            String sProp = sMacro.substring(ValueMacroExpression.PARAMETER_PREFIX.length(), sMacro.length() - 1);
            try {
                Parameter param = resolver.resolve(sProp);
                String sPropValue = param == null ? sDefault : param.evaluate(resolver).as(String.class);
                return this.validateMacroExpansion(sProp, sPropValue, sDefault, cDepth) ? sPropValue : sDefault;
            }
            catch (Exception e) {
                return sDefault;
            }
        }

        public boolean canProcess(String sMacro) {
            return sMacro.startsWith(ValueMacroExpression.PARAMETER_PREFIX);
        }

        public String getDelimiter() {
            return "";
        }

        public boolean validateMacroExpansion(String sProp, String sPropValue, String sDefault, int cDepth) {
            if (sPropValue.contains(ValueMacroExpression.PARAMETER_PREFIX + sProp) && sPropValue.contains(PARAMETER_SUFFIX.toString()) || cDepth > MAX_MACRO_EXPANSIONS) {
                Logger.err("SystemPropertyPreprocessor: using default value of \"" + sDefault + "\", detected recursive macro definition in property " + sProp + " with the value of \"" + sPropValue + "\" ");
                return false;
            }
            return true;
        }
    }

    protected static class OffsetLengthSubstringExpansionProcessor
    extends MacroExpansionProcessor {
        protected OffsetLengthSubstringExpansionProcessor() {
        }

        @Override
        public String getDelimiter() {
            return ValueMacroExpression.SUBSTRING_OFFSET_LENGTH_EXPANSION;
        }

        @Override
        public boolean canProcess(String sMacro) {
            return super.canProcess(sMacro) && sMacro.contains(this.getDelimiter()) && !sMacro.contains(":-");
        }

        @Override
        public String process(String sMacro, ParameterResolver resolver, int cDepth) {
            int sLen = sMacro.length();
            int ofSuffix = sMacro.indexOf(this.getDelimiter());
            int ofMacroClose = sMacro.indexOf(PARAMETER_SUFFIX.charValue());
            int ofParsed = Integer.MAX_VALUE;
            int cLength = Integer.MAX_VALUE;
            int ofEnd = 0;
            if (ofSuffix > 0 && ofSuffix + 1 < sLen) {
                String sProp;
                Parameter param;
                char c = sMacro.charAt(ofSuffix + 1);
                if (c == '+' || c == '-') {
                    return sMacro;
                }
                int ofLengthSuffix = sMacro.indexOf(58, ofSuffix + 1);
                try {
                    ofEnd = ofLengthSuffix > 0 ? ofLengthSuffix : ofMacroClose;
                    ofParsed = Integer.parseInt(sMacro.substring(ofSuffix + 1, ofEnd).trim());
                }
                catch (NumberFormatException e) {
                    throw new IllegalStateException("parsing error processing integer offset " + sMacro.substring(ofSuffix + 1, ofEnd) + " within macro " + sMacro, e);
                }
                if (ofLengthSuffix != -1) {
                    try {
                        cLength = Integer.parseInt(sMacro.substring(ofLengthSuffix + 1, ofMacroClose).trim());
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalStateException("parsing error processing integer length  " + sMacro.substring(ofLengthSuffix + 1, ofMacroClose) + " within macro " + sMacro, e);
                    }
                }
                String sPropValue = (param = resolver.resolve(sProp = sMacro.substring(ValueMacroExpression.PARAMETER_PREFIX.length(), ofSuffix))) == null ? null : param.evaluate(resolver).as(String.class);
                cLength = cLength == Integer.MAX_VALUE ? sPropValue.length() : cLength;
                int ofComputedEnd = (cLength += cLength < 0 ? sPropValue.length() : (ofParsed += ofParsed < 0 ? sPropValue.length() : 0)) > sPropValue.length() ? sPropValue.length() : cLength;
                return ofParsed < 0 ? "" : sPropValue.substring(ofParsed, ofComputedEnd);
            }
            return sMacro;
        }
    }

    protected static class DefaultDelimiterExpansionProcessor
    extends MacroExpansionProcessor {
        private final String f_sDefaultDelimiter;
        private final boolean f_fUseDefaultIfPropertySet;

        public DefaultDelimiterExpansionProcessor(String sDefaultDelimiter) {
            this.f_sDefaultDelimiter = sDefaultDelimiter;
            this.f_fUseDefaultIfPropertySet = this.f_sDefaultDelimiter.equals(":+");
        }

        @Override
        public String getDelimiter() {
            return this.f_sDefaultDelimiter;
        }

        @Override
        public boolean canProcess(String sMacro) {
            return super.canProcess(sMacro) && sMacro.contains(this.f_sDefaultDelimiter);
        }

        @Override
        public String process(String sMacro, ParameterResolver resolver, int cDepth) {
            int ofStart = sMacro.indexOf(this.f_sDefaultDelimiter);
            if (ofStart > 0) {
                String sDefault = sMacro.substring(ofStart + this.f_sDefaultDelimiter.length(), sMacro.length() - 1).trim();
                String sProp = sMacro.substring(ValueMacroExpression.PARAMETER_PREFIX.length(), ofStart);
                try {
                    Parameter param = resolver.resolve(sProp);
                    String sPropValue = param == null ? null : param.evaluate(resolver).as(String.class);
                    sPropValue = sPropValue == null && !this.f_fUseDefaultIfPropertySet || sPropValue != null && this.f_fUseDefaultIfPropertySet ? sDefault : sPropValue;
                    return this.validateMacroExpansion(sProp, sPropValue, sDefault, cDepth) ? sPropValue : sDefault;
                }
                catch (Exception e) {
                    return sDefault;
                }
            }
            return sMacro;
        }
    }

    protected static class SpaceDefaultDelimiterExpansionProcessor
    extends DefaultDelimiterExpansionProcessor {
        public SpaceDefaultDelimiterExpansionProcessor() {
            super(" ");
        }

        @Override
        public boolean canProcess(String sMacro) {
            String NEGATIVE_OFFSET_OR_LENGTH = ": -";
            return super.canProcess(sMacro) && !sMacro.contains(": -") && sMacro.contains(this.getDelimiter());
        }

        @Override
        public String process(String sMacro, ParameterResolver resolver, int cDepth) {
            return super.process(sMacro, resolver, cDepth);
        }
    }
}

