/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.config.expression;

import com.oracle.coherence.common.base.Converter;
import com.tangosol.run.xml.XmlValue;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.UnknownFormatConversionException;

public final class Value {
    private static final HashMap<Class<?>, Converter<?, ?>> s_mapTypeConvertersByClass = new HashMap<Class<?>, Converter<?, ?>>(){
        {
            this.put(BigDecimal.class, new BigDecimalConverter());
            this.put(Boolean.class, new BooleanConverter());
            this.put(Boolean.TYPE, new BooleanConverter());
            this.put(Byte.class, new ByteConverter());
            this.put(Byte.TYPE, new ByteConverter());
            this.put(Double.class, new DoubleConverter());
            this.put(Double.TYPE, new DoubleConverter());
            this.put(Float.class, new FloatConverter());
            this.put(Float.TYPE, new FloatConverter());
            this.put(Integer.class, new IntegerConverter());
            this.put(Integer.TYPE, new IntegerConverter());
            this.put(Long.class, new LongConverter());
            this.put(Long.TYPE, new LongConverter());
            this.put(Short.class, new ShortConverter());
            this.put(Short.TYPE, new ShortConverter());
            this.put(String.class, new StringConverter());
        }
    };
    private final Object m_oValue;

    public Value() {
        this.m_oValue = null;
    }

    public Value(Object oValue) {
        this.m_oValue = oValue;
    }

    public Value(String sValue) {
        this.m_oValue = sValue == null ? null : sValue.trim();
    }

    public Value(Value value) {
        this.m_oValue = value.m_oValue;
    }

    public Value(XmlValue value) {
        this.m_oValue = value == null ? null : value.getString().trim();
    }

    public boolean isNull() {
        return this.m_oValue == null;
    }

    public Object get() {
        return this.m_oValue;
    }

    public boolean supports(Class<?> clzType) {
        boolean fSupported;
        boolean bl = fSupported = clzType.isEnum() || clzType.isAssignableFrom(this.m_oValue.getClass()) || clzType.isAssignableFrom(this.getClass()) || s_mapTypeConvertersByClass.containsKey(clzType);
        if (!fSupported && this.m_oValue != null) {
            try {
                fSupported = clzType.getConstructor(this.m_oValue.getClass()) != null;
            }
            catch (Exception e) {
                try {
                    fSupported = clzType.getConstructor(String.class) != null;
                }
                catch (Exception e1) {
                    fSupported = false;
                }
            }
        }
        return fSupported;
    }

    public <T> T as(Class<T> clzType) throws ClassCastException, UnknownFormatConversionException, NumberFormatException {
        if (this.isNull()) {
            return null;
        }
        if (clzType.isInstance(this.m_oValue)) {
            return (T)this.m_oValue;
        }
        if (clzType.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        if (clzType.isEnum()) {
            String sValue = this.m_oValue.toString();
            try {
                return Enum.valueOf(clzType, sValue);
            }
            catch (Exception exception) {
                throw new ClassCastException(String.format("The specified Enum value '%s' is unknown.", sValue));
            }
        }
        Converter<?, ?> converter = s_mapTypeConvertersByClass.get(clzType);
        if (converter == null) {
            try {
                Constructor<T> constructor = clzType.getConstructor(this.m_oValue.getClass());
                return constructor.newInstance(this.m_oValue);
            }
            catch (Exception e1) {
                try {
                    Constructor<T> constructor = clzType.getConstructor(String.class);
                    return constructor.newInstance(this.m_oValue);
                }
                catch (Exception e2) {
                    throw new ClassCastException(String.format("Can't convert [%s] into a [%s].", this.m_oValue, clzType.toString()));
                }
            }
        }
        return (T)converter.convert(this.m_oValue);
    }

    public String toString() {
        return String.format("Value{%s}", this.m_oValue);
    }

    private static class StringConverter
    implements Converter<Object, String> {
        private StringConverter() {
        }

        @Override
        public String convert(Object oValue) {
            if (oValue == null || oValue instanceof String) {
                return (String)oValue;
            }
            return oValue.toString();
        }
    }

    private static class ShortConverter
    implements Converter<Object, Short> {
        private ShortConverter() {
        }

        @Override
        public Short convert(Object oValue) {
            if (oValue == null || oValue instanceof Short) {
                return (Short)oValue;
            }
            return Short.parseShort(oValue.toString());
        }
    }

    private static class LongConverter
    implements Converter<Object, Long> {
        private LongConverter() {
        }

        @Override
        public Long convert(Object oValue) {
            if (oValue == null || oValue instanceof Long) {
                return (Long)oValue;
            }
            return Long.parseLong(oValue.toString());
        }
    }

    private static class IntegerConverter
    implements Converter<Object, Integer> {
        private IntegerConverter() {
        }

        @Override
        public Integer convert(Object oValue) {
            if (oValue == null || oValue instanceof Integer) {
                return (Integer)oValue;
            }
            return Integer.parseInt(oValue.toString());
        }
    }

    private static class FloatConverter
    implements Converter<Object, Float> {
        private FloatConverter() {
        }

        @Override
        public Float convert(Object oValue) {
            if (oValue == null || oValue instanceof Float) {
                return (Float)oValue;
            }
            return Float.valueOf(Float.parseFloat(oValue.toString()));
        }
    }

    private static class DoubleConverter
    implements Converter<Object, Double> {
        private DoubleConverter() {
        }

        @Override
        public Double convert(Object oValue) {
            if (oValue == null || oValue instanceof Double) {
                return (Double)oValue;
            }
            return Double.parseDouble(oValue.toString());
        }
    }

    private static class ByteConverter
    implements Converter<Object, Byte> {
        private ByteConverter() {
        }

        @Override
        public Byte convert(Object oValue) {
            if (oValue == null || oValue instanceof Byte) {
                return (Byte)oValue;
            }
            return Byte.parseByte(oValue.toString());
        }
    }

    private static class BooleanConverter
    implements Converter<Object, Boolean> {
        private BooleanConverter() {
        }

        @Override
        public Boolean convert(Object oValue) {
            if (oValue == null || oValue instanceof Boolean) {
                return (Boolean)oValue;
            }
            String sBoolean = oValue instanceof String ? (String)oValue : oValue.toString();
            if ((sBoolean = sBoolean.trim()).equalsIgnoreCase("true") || sBoolean.equalsIgnoreCase("yes") || sBoolean.equalsIgnoreCase("on")) {
                return true;
            }
            if (sBoolean.equalsIgnoreCase("false") || sBoolean.equalsIgnoreCase("no") || sBoolean.equalsIgnoreCase("off")) {
                return false;
            }
            throw new IllegalArgumentException(String.format("The value [%s] is not a boolean (true, yes, on, false, no, off)", sBoolean));
        }
    }

    private static class BigDecimalConverter
    implements Converter<Object, BigDecimal> {
        private BigDecimalConverter() {
        }

        @Override
        public BigDecimal convert(Object oValue) {
            if (oValue == null || oValue instanceof BigDecimal) {
                return (BigDecimal)oValue;
            }
            return new BigDecimal(oValue.toString());
        }
    }
}

