/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.config.expression;

import com.tangosol.coherence.config.ResolvableParameterList;
import com.tangosol.config.expression.Parameter;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import jakarta.json.bind.annotation.JsonbProperty;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ScopedParameterResolver
implements ParameterResolver,
ExternalizableLite,
PortableObject {
    @JsonbProperty(value="innerResolver")
    private ParameterResolver m_innerResolver;
    @JsonbProperty(value="outerResolver")
    private ResolvableParameterList m_outerResolver;

    public ScopedParameterResolver() {
        this.m_innerResolver = new ResolvableParameterList();
        this.m_outerResolver = new ResolvableParameterList();
    }

    public ScopedParameterResolver(ParameterResolver resolver) {
        this.m_innerResolver = resolver == null ? new ResolvableParameterList() : resolver;
        this.m_outerResolver = new ResolvableParameterList();
    }

    @Override
    public Parameter resolve(String sName) {
        Parameter param = this.m_outerResolver.resolve(sName);
        return param == null ? this.m_innerResolver.resolve(sName) : param;
    }

    public void add(Parameter parameter) {
        this.m_outerResolver.add(parameter);
    }

    protected String getDescription() {
        return "Outer Resolver=" + String.valueOf(this.m_outerResolver) + ", Inner Resolver=" + String.valueOf(this.m_innerResolver);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_innerResolver = (ParameterResolver)ExternalizableHelper.readObject(in);
        this.m_outerResolver = (ResolvableParameterList)ExternalizableHelper.readObject(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject(out, this.m_innerResolver);
        ExternalizableHelper.writeObject(out, this.m_outerResolver);
    }

    @Override
    public void readExternal(PofReader reader) throws IOException {
        this.m_innerResolver = (ParameterResolver)reader.readObject(0);
        this.m_outerResolver = (ResolvableParameterList)reader.readObject(1);
    }

    @Override
    public void writeExternal(PofWriter writer) throws IOException {
        writer.writeObject(0, this.m_innerResolver);
        writer.writeObject(1, this.m_outerResolver);
    }
}

