/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.reporter.extractor;

import com.tangosol.util.Base;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.extractor.MultiExtractor;

public class DivideExtractor
extends MultiExtractor {
    public DivideExtractor(ValueExtractor[] aExtractor) {
        super(aExtractor);
        Base.azzert(aExtractor.length == 2, "Report division requires two and only two arguments.");
    }

    @Override
    public Object extract(Object oTarget) {
        ImmutableArrayList arResults = (ImmutableArrayList)super.extract(oTarget);
        if (arResults.size() > 1) {
            Object o1 = arResults.get(0);
            Object o2 = arResults.get(1);
            if (o2 == null || ((Number)o2).doubleValue() == 0.0) {
                return null;
            }
            if (o1 instanceof Number && o2 instanceof Number) {
                return ((Number)o1).doubleValue() / ((Number)o2).doubleValue();
            }
        }
        return null;
    }
}

