/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.reporter;

import com.tangosol.coherence.reporter.QueryExpFilter;
import com.tangosol.net.management.MBeanHelper;
import com.tangosol.util.Base;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.ValueUpdater;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class MBeanQuery {
    protected String m_sPattern;
    protected Set m_setResults;
    protected Filter m_filter;
    protected MBeanServer f_mbs;

    public MBeanQuery(String sPattern) {
        this(sPattern, MBeanHelper.findMBeanServer());
    }

    public MBeanQuery(String sPattern, MBeanServer server) {
        this.setPattern(sPattern);
        this.f_mbs = server;
    }

    protected void refreshKeys(Filter filter) {
        try {
            TreeSet<Entry> setResults = new TreeSet<Entry>((o, o1) -> {
                ObjectName on = (ObjectName)((Entry)o).getKey();
                ObjectName on1 = (ObjectName)((Entry)o1).getKey();
                String s = on.getKeyPropertyListString();
                String s1 = on1.getKeyPropertyListString();
                return s.compareTo(s1);
            });
            Set<ObjectName> setMBeans = this.f_mbs.queryNames(new ObjectName(this.m_sPattern), new QueryExpFilter(filter));
            Iterator<ObjectName> iter = setMBeans.iterator();
            while (iter.hasNext()) {
                setResults.add(new Entry(iter.next()));
            }
            this.m_setResults = setResults;
            this.m_filter = filter;
        }
        catch (MalformedObjectNameException e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    public void setPattern(String sPattern) {
        this.m_sPattern = sPattern;
    }

    public int size() {
        return this.m_setResults == null ? 0 : this.m_setResults.size();
    }

    public void clear() {
        this.m_setResults.clear();
    }

    public boolean isEmpty() {
        return this.m_setResults.isEmpty();
    }

    public Set entrySet() {
        return this.keySet();
    }

    public Set keySet() {
        this.refreshKeys(null);
        return this.m_setResults;
    }

    public Set keySet(Filter filter) {
        this.refreshKeys(filter);
        return this.m_setResults;
    }

    public Set entrySet(Filter filter) {
        return this.keySet(filter);
    }

    public Map invokeAll(Collection collKeys, InvocableMap.EntryProcessor agent) {
        HashMap mRet = new HashMap();
        for (Entry oKey : collKeys) {
            mRet.put(oKey.getKey(), agent.process(oKey));
        }
        return mRet;
    }

    public Object aggregate(Collection collKeys, InvocableMap.EntryAggregator agent) {
        return agent.aggregate((Set)collKeys);
    }

    public Object aggregate(Filter filter, InvocableMap.EntryAggregator agent) {
        return agent.aggregate(this.keySet(filter));
    }

    public static class Entry
    implements InvocableMap.Entry,
    Map.Entry {
        protected Object m_Key;

        Entry(Object Key2) {
            this.m_Key = Key2;
        }

        public Object getKey() {
            return this.m_Key;
        }

        public Object getValue() {
            return this.m_Key;
        }

        public Object setValue(Object oValue) {
            throw new UnsupportedOperationException();
        }

        public void setValue(Object oValue, boolean fSynthetic) {
            throw new UnsupportedOperationException();
        }

        public void update(ValueUpdater updater, Object oValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        @Override
        public boolean isSynthetic() {
            return false;
        }

        @Override
        public void remove(boolean fSynthetic) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object extract(ValueExtractor extractor) {
            return extractor.extract(this.m_Key);
        }
    }
}

