/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.reporter;

import com.tangosol.coherence.reporter.Constants;
import com.tangosol.coherence.reporter.JMXQueryHandler;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.Filter;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.extractor.ComparisonValueExtractor;
import com.tangosol.util.filter.AndFilter;
import com.tangosol.util.filter.EqualsFilter;
import com.tangosol.util.filter.GreaterFilter;
import com.tangosol.util.filter.LessFilter;
import com.tangosol.util.filter.NotFilter;
import com.tangosol.util.filter.OrFilter;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class FilterFactory
implements Constants {
    protected XmlElement m_xmlFilters;
    protected JMXQueryHandler m_query;

    public FilterFactory(JMXQueryHandler query, XmlElement xmlFilters) {
        this.m_query = query;
        this.m_xmlFilters = xmlFilters;
    }

    public Filter getFilter(XmlElement xmlConfig) {
        String sType = xmlConfig.getSafeElement("type").getString();
        if (sType.equals("and") || sType.equals("or") || sType.equals("not")) {
            List listRef = xmlConfig.getSafeElement("params").getElementList();
            if (listRef.size() == 2) {
                Iterator i = listRef.iterator();
                XmlElement xmlRef = (XmlElement)i.next();
                String sId = xmlRef.getString();
                Filter filterRight = this.getFilter(sId);
                xmlRef = (XmlElement)i.next();
                sId = xmlRef.getString();
                Filter filterLeft = this.getFilter(sId);
                if (sType.equals("and")) {
                    return new AndFilter(filterLeft, filterRight);
                }
                return new OrFilter(filterLeft, filterRight);
            }
            if (listRef.size() == 1) {
                Iterator i = listRef.iterator();
                XmlElement xmlRef = (XmlElement)i.next();
                String sId = xmlRef.getString();
                Filter filter = this.getFilter(sId);
                return new NotFilter(filter);
            }
            Base.log("FilterFactory: Invalid Filter Definition:" + xmlConfig.toString());
            return null;
        }
        List listRef = xmlConfig.getSafeElement("params").getElementList();
        if (listRef.size() == 2) {
            Iterator iter = listRef.iterator();
            XmlElement xmlRef = (XmlElement)iter.next();
            String sId = xmlRef.getString();
            ValueExtractor ve1 = this.m_query.ensureExtractor(sId);
            xmlRef = (XmlElement)iter.next();
            sId = xmlRef.getString();
            ValueExtractor ve2 = this.m_query.ensureExtractor(sId);
            if (sType.equals("greater")) {
                return new GreaterFilter(new ComparisonValueExtractor(ve1, ve2, new NumericComparator()), Integer.valueOf(0));
            }
            if (sType.equals("less")) {
                return new LessFilter(new ComparisonValueExtractor(ve1, ve2, new NumericComparator()), Integer.valueOf(0));
            }
            if (sType.equals("equals")) {
                return new EqualsFilter(new ComparisonValueExtractor(ve1, ve2, new NumericComparator()), Integer.valueOf(0));
            }
            Base.log("FilterFactory: Invalid Filter Definition:" + xmlConfig.toString());
            return null;
        }
        Base.log("FilterFactory: Invalid Filter Definition:" + xmlConfig.toString());
        return null;
    }

    public Filter getFilter(String sId) {
        return this.getFilter(this.getFilterXmlByRef(sId));
    }

    public XmlElement getFilterXmlByRef(String sRef) {
        XmlElement xmlFilters = this.m_xmlFilters;
        if (xmlFilters != null) {
            List listXml = xmlFilters.getElementList();
            for (XmlElement xmlSub : listXml) {
                String sTemp = xmlSub.getSafeAttribute("id").getString();
                if (!sTemp.equals(sRef) || xmlSub.getElementList() == null) continue;
                return xmlSub;
            }
        }
        return null;
    }

    protected static XmlElement getReportXml(XmlElement xml) {
        XmlElement xmlTemp = xml;
        while (xmlTemp.getElement("report") == null) {
            if ((xmlTemp = xmlTemp.getParent()) != null) continue;
            return null;
        }
        return xmlTemp.getElement("report");
    }

    protected static class NumericComparator
    implements Comparator {
        protected NumericComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof Number && o2 instanceof Number) {
                double d2;
                double d1 = ((Number)o1).doubleValue();
                if (d1 == (d2 = ((Number)o2).doubleValue())) {
                    return 0;
                }
                if (d1 < d2) {
                    return -1;
                }
                return 1;
            }
            if (o1 instanceof Comparable && o2 instanceof Comparable && o1.getClass().getName().equals(o2.getClass().getName())) {
                return ((Comparable)o1).compareTo(o2);
            }
            throw new IllegalArgumentException("NumericComparator only accepts Numeric Objects");
        }
    }
}

