/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.reporter;

import com.tangosol.coherence.reporter.Collection;
import com.tangosol.coherence.reporter.MBeanQuery;
import com.tangosol.net.management.MBeanHelper;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.aggregator.CompositeAggregator;
import com.tangosol.util.aggregator.GroupAggregator;
import com.tangosol.util.extractor.IdentityExtractor;
import com.tangosol.util.extractor.MultiExtractor;
import com.tangosol.util.processor.ExtractorProcessor;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class DataSource {
    protected List m_listVE = new LinkedList();
    protected List m_listScalar;
    protected List m_listAgg = new LinkedList();
    protected Map m_mapExtractionResults;
    protected Map m_mapGroup;
    protected ImmutableArrayList m_ialAgg;
    protected Map m_mapScalar;
    protected List m_listGroup = new LinkedList();
    protected boolean m_fGroupBy;
    protected Map m_mapIndex;
    protected MBeanServer m_mbs;

    public DataSource() {
        this.m_listScalar = new LinkedList();
    }

    public int addExtractor(ValueExtractor extractor) {
        int cSize = this.m_listVE.size();
        this.m_listVE.add(new Collection(extractor));
        return cSize;
    }

    public int addScalar(ValueExtractor extractor) {
        List listScalar = this.m_listScalar;
        int cSize = listScalar.size();
        listScalar.add(extractor);
        return cSize;
    }

    public int addAggregator(InvocableMap.EntryAggregator aggregator) {
        List list = this.m_fGroupBy ? this.m_listVE : this.m_listAgg;
        int cSize = list.size();
        list.add(aggregator);
        return cSize;
    }

    public int addGroupBy(ValueExtractor extractor) {
        List listGroup = this.m_listGroup;
        int cGroups = listGroup.size();
        listGroup.add(extractor);
        return cGroups;
    }

    public void execute(MBeanQuery mBeanQuery, Set setMBeans) {
        if (this.m_listGroup.size() == 0) {
            this.m_listGroup.add(new IdentityExtractor());
        }
        this.m_ialAgg = this.getAggregates(mBeanQuery, setMBeans, this.m_listAgg);
        this.m_mapGroup = this.getDetail(mBeanQuery, setMBeans, this.m_listGroup);
        this.m_mapExtractionResults = this.getAggregates(mBeanQuery, setMBeans, this.m_listVE, this.m_listGroup);
        this.m_mapScalar = this.getScalar(this.m_mapExtractionResults, this.m_listScalar);
    }

    protected Map getScalar(Map mapResults, List listVE) {
        int cVE = listVE.size();
        int cResults = mapResults.size();
        if (cVE > 0 && cResults > 0) {
            ValueExtractor[] aVE = listVE.toArray(new ValueExtractor[cVE]);
            MultiExtractor extractor = new MultiExtractor(aVE);
            SafeHashMap mapScalars = new SafeHashMap();
            for (Object oKey : mapResults.keySet()) {
                mapScalars.put(oKey, extractor.extract(oKey));
            }
            return mapScalars;
        }
        return null;
    }

    protected Map getDetail(MBeanQuery mBeanQuery, Set setMBeans, List listGBE) {
        int cSize = listGBE.size();
        if (cSize > 0) {
            ValueExtractor[] aVE = listGBE.toArray(new ValueExtractor[cSize]);
            return mBeanQuery.invokeAll(setMBeans, new ExtractorProcessor(new MultiExtractor(aVE)));
        }
        return null;
    }

    protected ImmutableArrayList getAggregates(MBeanQuery mBeanQuery, Set setMBeans, List listAgg) {
        int cSize = listAgg.size();
        if (cSize > 0) {
            InvocableMap.EntryAggregator[] aVE = listAgg.toArray(new InvocableMap.EntryAggregator[cSize]);
            CompositeAggregator aggComp = CompositeAggregator.createInstance(aVE);
            return (ImmutableArrayList)mBeanQuery.aggregate(setMBeans, (InvocableMap.EntryAggregator)aggComp);
        }
        return null;
    }

    protected Map getAggregates(MBeanQuery mBeanQuery, Set setMBeans, List listAgg, List listBy) {
        int cAgg = listAgg.size();
        int cBy = listBy.size();
        if (cAgg > 0 && cBy > 0) {
            InvocableMap.EntryAggregator[] aEA = listAgg.toArray(new InvocableMap.EntryAggregator[cAgg]);
            ValueExtractor[] aVE = listBy.toArray(new ValueExtractor[cBy]);
            CompositeAggregator CA = CompositeAggregator.createInstance(aEA);
            MultiExtractor ME = new MultiExtractor(aVE);
            GroupAggregator ga = GroupAggregator.createInstance(ME, CA);
            return (Map)mBeanQuery.aggregate(setMBeans, ga);
        }
        return Collections.emptyMap();
    }

    public Object getAggValue(Object oKey, int nPos) {
        return this.m_fGroupBy ? this.getValue(oKey, nPos) : this.m_ialAgg.get(nPos);
    }

    protected ImmutableArrayList convertObjectName(ObjectName oKey) {
        int nSize = this.m_listGroup.size();
        Object[] ao = new Object[nSize];
        for (int i = 0; i < nSize; ++i) {
            ao[i] = ((ImmutableArrayList)this.m_mapGroup.get(oKey)).get(i);
        }
        return new ImmutableArrayList(ao);
    }

    public Object getValue(Object oKey, int nPos) {
        Object oValKey = oKey instanceof ObjectName ? this.convertObjectName((ObjectName)oKey) : oKey;
        return ((ImmutableArrayList)this.m_mapExtractionResults.get(oValKey)).get(nPos);
    }

    public Object getScalarValue(Object oKey, int nPos) {
        Object oValKey = oKey instanceof ObjectName ? this.convertObjectName((ObjectName)oKey) : oKey;
        return ((ImmutableArrayList)this.m_mapScalar.get(oValKey)).get(nPos);
    }

    public Object getGroupValue(Object oKey, int nPos) {
        return this.getAggValue(oKey, nPos);
    }

    public void setGroupBy(boolean fGroupBy) {
        this.m_fGroupBy = fGroupBy;
    }

    public boolean isGroupBy() {
        return this.m_fGroupBy;
    }

    public Set getGroupKeys() {
        TreeMap setResults = new TreeMap(new Comparator(){

            public int compare(Object o, Object o1) {
                ImmutableArrayList ial = (ImmutableArrayList)o;
                ImmutableArrayList ial1 = (ImmutableArrayList)o1;
                int cThis = ial.size();
                int cThat = ial1.size();
                int c = Math.min(cThis, cThat);
                for (int i = 0; i < c; ++i) {
                    int nResult;
                    Object oThis = ial.get(i);
                    Object oThat = ial1.get(i);
                    if (oThis == null || oThat == null) {
                        nResult = oThis == null ? (oThat == null ? 0 : -1) : 1;
                    } else if (oThis instanceof ObjectName && oThat instanceof ObjectName) {
                        String s = ((ObjectName)oThis).getKeyPropertyListString();
                        String s1 = ((ObjectName)oThat).getKeyPropertyListString();
                        nResult = s.compareTo(s1);
                    } else {
                        nResult = ((Comparable)oThis).compareTo(oThat);
                    }
                    if (nResult == 0) continue;
                    return nResult;
                }
                return cThis - cThat;
            }
        });
        Iterator iter = this.m_mapExtractionResults.keySet().iterator();
        while (iter.hasNext()) {
            setResults.put(iter.next(), null);
        }
        return setResults.keySet();
    }

    public void postProcess() {
        this.m_listVE.clear();
        this.m_listAgg.clear();
        this.m_listGroup.clear();
        this.m_listScalar.clear();
        if (this.m_mapExtractionResults != null) {
            this.m_mapExtractionResults.clear();
        }
        if (this.m_mapGroup != null) {
            this.m_mapGroup.clear();
        }
        if (this.m_mapIndex != null) {
            this.m_mapIndex.clear();
        }
        if (this.m_mapScalar != null) {
            this.m_mapScalar.clear();
        }
    }

    public MBeanServer getMBeanServer() {
        MBeanServer mbs = this.m_mbs;
        if (mbs == null) {
            mbs = this.m_mbs = MBeanHelper.findMBeanServer();
        }
        return mbs;
    }
}

