/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.memcached.server;

import com.oracle.coherence.common.base.Continuation;
import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.common.io.BufferManager;
import com.oracle.coherence.common.io.BufferManagers;
import com.oracle.coherence.common.net.SafeSelectionHandler;
import com.oracle.coherence.common.net.SelectionService;
import com.oracle.coherence.common.net.SelectionServices;
import com.oracle.coherence.common.net.SocketProvider;
import com.tangosol.coherence.memcached.DefaultRequestHandler;
import com.tangosol.coherence.memcached.Request;
import com.tangosol.coherence.memcached.RequestHandler;
import com.tangosol.coherence.memcached.server.Connection;
import com.tangosol.coherence.memcached.server.ConnectionFactory;
import com.tangosol.coherence.memcached.server.Task;
import com.tangosol.net.Service;
import com.tangosol.net.security.IdentityAsserter;
import com.tangosol.util.Base;
import java.io.IOException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.List;
import java.util.concurrent.Executor;

public class MemcachedServer {
    protected SelectionService m_selectionService;
    protected ServerSocketChannel m_srvrChannel;
    protected Service m_parentService;
    protected String m_sCacheName;
    protected boolean m_fBinaryPassThru;
    protected String m_sAuthMethod;
    protected String m_sAddr;
    protected int m_nPort;
    protected SocketProvider m_provider;
    protected Executor m_executor;
    protected IdentityAsserter m_identityAsserter;
    protected BufferManager m_bufferManager = BufferManagers.getHeapManager();

    public void setSocketProvider(SocketProvider provider) {
        this.m_provider = provider;
    }

    public void setCacheName(String sCacheName) {
        this.m_sCacheName = sCacheName;
    }

    public void setBinaryPassthru(boolean fBinaryPassThru) {
        this.m_fBinaryPassThru = fBinaryPassThru;
    }

    public void setLocalAddress(String sAddr) {
        this.m_sAddr = sAddr;
    }

    public void setLocalPort(int nPort) {
        this.m_nPort = nPort;
    }

    public void setExecutor(Executor executor) {
        this.m_executor = executor;
    }

    public void setBufferManager(BufferManager manager) {
        this.m_bufferManager = manager;
    }

    public void setAuthMethod(String sAuthMethod) {
        this.m_sAuthMethod = sAuthMethod;
    }

    public void setParentService(Service service) {
        this.m_parentService = service;
    }

    public void setIdentityAsserter(IdentityAsserter asserter) {
        this.m_identityAsserter = asserter;
    }

    public void start() throws IOException {
        ServerSocketChannel srvrChannel = this.m_srvrChannel = this.m_provider.openServerSocketChannel();
        srvrChannel.configureBlocking(false);
        srvrChannel.socket().bind(this.m_provider.resolveAddress(this.m_sAddr + ":" + this.m_nPort));
        SelectionService selectionService = this.m_selectionService = SelectionServices.getDefaultService();
        selectionService.register(srvrChannel, new AcceptHandler(srvrChannel, new ConnectionFactory(this.m_bufferManager, true)));
    }

    public void stop() throws IOException {
        if (this.m_srvrChannel != null) {
            this.m_srvrChannel.close();
        }
    }

    protected class AcceptHandler
    extends SafeSelectionHandler<ServerSocketChannel> {
        protected ConnectionFactory m_connFactory;

        protected AcceptHandler(ServerSocketChannel srvrChannel, ConnectionFactory connFactory) {
            super(srvrChannel);
            this.m_connFactory = connFactory;
        }

        @Override
        protected int onReadySafe(int nOps) throws IOException {
            SocketChannel chan = null;
            try {
                chan = ((ServerSocketChannel)this.getChannel()).accept();
                if (chan != null) {
                    chan.configureBlocking(false);
                    Connection conn = this.m_connFactory.createConnection(chan);
                    MessageHandler msgHandler = new MessageHandler(conn, MemcachedServer.this.m_executor);
                    DefaultRequestHandler reqHandler = new DefaultRequestHandler(MemcachedServer.this.m_sCacheName, MemcachedServer.this.m_parentService, MemcachedServer.this.m_sAuthMethod, MemcachedServer.this.m_fBinaryPassThru, MemcachedServer.this.m_identityAsserter, MemcachedServer.this.m_executor, msgHandler);
                    msgHandler.setRequestHandler(reqHandler);
                    conn.setFlowControl(msgHandler);
                    MemcachedServer.this.m_selectionService.register(chan, msgHandler);
                }
            }
            catch (IOException e) {
                if (chan == null) {
                    MemcachedServer.this.m_executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            throw Base.ensureRuntimeException(e);
                        }
                    });
                    throw new RuntimeException(e);
                }
                try {
                    chan.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return 16;
        }
    }

    protected class MessageHandler
    extends SafeSelectionHandler<SocketChannel>
    implements Connection.ConnectionFlowControl {
        protected Connection m_conn;
        protected RequestHandler m_handler;
        protected Executor m_executor;
        protected volatile int m_nOpRead;

        protected MessageHandler(Connection conn, Executor executor) {
            super(conn.getChannel());
            this.m_nOpRead = 1;
            this.m_conn = conn;
            this.m_executor = executor;
        }

        public void setRequestHandler(RequestHandler handler) {
            this.m_handler = handler;
        }

        @Override
        protected int onReadySafe(int nOps) throws IOException {
            int nFlag = this.m_nOpRead;
            if ((nOps & nFlag) != 0) {
                nFlag = this.handleRead();
            }
            if ((nOps & 4) != 0) {
                nFlag |= this.handleWrite();
            }
            return nFlag;
        }

        @Override
        public void resumeWrites() {
            SocketChannel channel = (SocketChannel)this.getChannel();
            try {
                MemcachedServer.this.m_selectionService.register(channel, this);
            }
            catch (IOException ioe) {
                Logger.err("Failed to resume writes. Closing channel.");
                this.closeChannel(channel);
            }
        }

        @Override
        public void pauseReads() {
            this.m_nOpRead = 0;
        }

        @Override
        public void resumeReads() {
            SocketChannel channel = (SocketChannel)this.getChannel();
            try {
                this.m_nOpRead = 1;
                MemcachedServer.this.m_selectionService.register(channel, this);
            }
            catch (IOException ioe) {
                Logger.err("Failed to resume read. Closing channel.");
                this.closeChannel(channel);
            }
        }

        @Override
        public boolean isReadPaused() {
            return this.m_nOpRead == 0;
        }

        protected int handleRead() throws IOException {
            BacklogEndedContinuation backlogContinuation;
            List<Request> requestList = this.m_conn.read();
            for (Request request : requestList) {
                this.onRequest(request);
            }
            RequestHandler handler = this.m_handler;
            handler.flush();
            if (handler.checkBacklog(null) && handler.checkBacklog(backlogContinuation = new BacklogEndedContinuation())) {
                backlogContinuation.pause();
            }
            return this.m_nOpRead;
        }

        protected int handleWrite() throws IOException {
            return this.m_conn.write();
        }

        protected void onRequest(Request request) {
            new Task(request, this.m_handler).run();
        }

        protected void closeChannel(SocketChannel channel) {
            try {
                channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        protected class BacklogEndedContinuation
        implements Continuation<Void> {
            protected volatile boolean m_fResumed = false;

            protected BacklogEndedContinuation() {
            }

            @Override
            public void proceed(Void r) {
                this.m_fResumed = true;
                MessageHandler.this.resumeReads();
            }

            public void pause() {
                MessageHandler.this.pauseReads();
                if (this.m_fResumed) {
                    MessageHandler.this.resumeReads();
                }
            }
        }
    }
}

