/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.memcached.processor;

import com.tangosol.coherence.memcached.Response;
import com.tangosol.coherence.memcached.server.MemcachedHelper;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.processor.AbstractProcessor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class TouchProcessor
extends AbstractProcessor
implements ExternalizableLite,
PortableObject {
    protected int m_nExpiry;
    protected boolean m_fBlind;
    protected boolean m_fBinaryPassThru;

    public TouchProcessor() {
    }

    public TouchProcessor(int nExpiry, boolean fBlind, boolean fBinaryPassThru) {
        this.m_nExpiry = nExpiry;
        this.m_fBlind = fBlind;
        this.m_fBinaryPassThru = fBinaryPassThru;
    }

    @Override
    public Object process(InvocableMap.Entry entry) {
        BinaryEntry binaryEntry = MemcachedHelper.getBinaryEntry(entry);
        Binary binValue = binaryEntry.getBinaryValue();
        if (binValue == null) {
            return Response.ResponseCode.KEYNF;
        }
        if (this.m_nExpiry >= 0) {
            binaryEntry.expire(this.m_nExpiry);
        }
        BackingMapManagerContext mgrCtx = binaryEntry.getBackingMapContext().getManagerContext();
        return this.m_fBlind ? null : MemcachedHelper.convertToDataHolder(binValue, mgrCtx, this.m_fBinaryPassThru);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_nExpiry = in.readInt();
        this.m_fBlind = in.readBoolean();
        this.m_fBinaryPassThru = in.readBoolean();
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        out.writeInt(this.m_nExpiry);
        out.writeBoolean(this.m_fBlind);
        out.writeBoolean(this.m_fBinaryPassThru);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_nExpiry = in.readInt(0);
        this.m_fBlind = in.readBoolean(1);
        this.m_fBinaryPassThru = in.readBoolean(2);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeInt(0, this.m_nExpiry);
        out.writeBoolean(1, this.m_fBlind);
        out.writeBoolean(2, this.m_fBinaryPassThru);
    }
}

