/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.memcached.processor;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.coherence.memcached.Request;
import com.tangosol.coherence.memcached.RequestHandler;
import com.tangosol.coherence.memcached.Response;
import com.tangosol.coherence.memcached.server.Task;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.processor.AsynchronousProcessor;
import java.util.Iterator;
import java.util.Map;

public class MemcachedAsyncProcessor
extends AsynchronousProcessor {
    protected RequestHandler m_handler;
    protected Request m_request;
    protected Response m_response;

    public MemcachedAsyncProcessor(RequestHandler handler, Request request, Response response, InvocableMap.EntryProcessor processor) {
        super(processor, (Integer)request.getAssociatedKey());
        this.m_handler = handler;
        this.m_request = request;
        this.m_response = response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onComplete() {
        super.onComplete();
        RequestHandler handler = this.m_handler;
        Request request = this.m_request;
        Response response = this.m_response;
        boolean fQuiet = false;
        try {
            Object oReturn = this.getReturnValue();
            switch (this.m_request.getOpCode()) {
                case 0: {
                    handler.onGetComplete(request, response, oReturn);
                    return;
                }
                case 1: {
                    handler.onSetComplete(request, response, oReturn);
                    return;
                }
                case 2: {
                    handler.onAddComplete(request, response, oReturn);
                    return;
                }
                case 3: {
                    handler.onReplaceComplete(request, response, oReturn);
                    return;
                }
                case 4: {
                    handler.onDeleteComplete(request, response, oReturn);
                    return;
                }
                case 5: {
                    handler.onIncrementComplete(request, response, oReturn);
                    return;
                }
                case 6: {
                    handler.onDecrementComplete(request, response, oReturn);
                    return;
                }
                case 8: {
                    handler.onFlushComplete(request, response, oReturn);
                    return;
                }
                case 9: {
                    handler.onGetComplete(request, response, oReturn);
                    if (response.getResponseCode() != Response.ResponseCode.KEYNF.getCode()) return;
                    fQuiet = true;
                    return;
                }
                case 10: {
                    response.setResponseCode(Response.ResponseCode.OK.getCode());
                    return;
                }
                case 12: {
                    response.setKey(request.getKey());
                    handler.onGetComplete(request, response, oReturn);
                    return;
                }
                case 13: {
                    response.setKey(request.getKey());
                    handler.onGetComplete(request, response, oReturn);
                    if (response.getResponseCode() != Response.ResponseCode.KEYNF.getCode()) return;
                    fQuiet = true;
                    return;
                }
                case 14: {
                    handler.onAppendComplete(request, response, oReturn);
                    return;
                }
                case 15: {
                    handler.onPrependComplete(request, response, oReturn);
                    return;
                }
                case 17: {
                    handler.onSetComplete(request, response, oReturn);
                    fQuiet = response.getResponseCode() == Response.ResponseCode.OK.getCode();
                    return;
                }
                case 18: {
                    handler.onAddComplete(request, response, oReturn);
                    fQuiet = response.getResponseCode() == Response.ResponseCode.OK.getCode();
                    return;
                }
                case 19: {
                    handler.onReplaceComplete(request, response, oReturn);
                    fQuiet = response.getResponseCode() == Response.ResponseCode.OK.getCode();
                    return;
                }
                case 20: {
                    handler.onDeleteComplete(request, response, oReturn);
                    fQuiet = response.getResponseCode() == Response.ResponseCode.OK.getCode();
                    return;
                }
                case 21: {
                    handler.onIncrementComplete(request, response, oReturn);
                    fQuiet = response.getResponseCode() == Response.ResponseCode.OK.getCode();
                    return;
                }
                case 22: {
                    handler.onDecrementComplete(request, response, oReturn);
                    fQuiet = response.getResponseCode() == Response.ResponseCode.OK.getCode();
                    return;
                }
                case 24: {
                    handler.onFlushComplete(request, response, oReturn);
                    fQuiet = response.getResponseCode() == Response.ResponseCode.OK.getCode();
                    return;
                }
                case 25: {
                    handler.onAppendComplete(request, response, oReturn);
                    fQuiet = response.getResponseCode() == Response.ResponseCode.OK.getCode();
                    return;
                }
                case 26: {
                    handler.onPrependComplete(request, response, oReturn);
                    fQuiet = response.getResponseCode() == Response.ResponseCode.OK.getCode();
                    return;
                }
                case 28: {
                    handler.onTouchComplete(request, response, oReturn);
                    return;
                }
                case 29: {
                    handler.onGATComplete(request, response, oReturn);
                    return;
                }
                case 30: {
                    handler.onGATComplete(request, response, oReturn);
                    fQuiet = response.getResponseCode() == Response.ResponseCode.OK.getCode();
                    return;
                }
                default: {
                    Logger.err("Memcached adapter received unknown request in EP response: " + request.getOpCode());
                    response.setResponseCode(Response.ResponseCode.INTERNAL_ERROR.getCode());
                    return;
                }
            }
        }
        catch (Throwable thr) {
            Logger.err("Exception in handling memcached async response:", thr);
            response.setResponseCode(Response.ResponseCode.INTERNAL_ERROR.getCode());
            fQuiet = false;
            return;
        }
        finally {
            Task.flush(response, fQuiet);
        }
    }

    protected Object getReturnValue() throws Exception {
        Map map = (Map)this.get();
        if (map != null) {
            Iterator itr = map.values().iterator();
            return itr.hasNext() ? itr.next() : null;
        }
        return null;
    }
}

