/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.memcached.processor;

import com.tangosol.coherence.memcached.Response;
import com.tangosol.coherence.memcached.processor.PutProcessor;
import com.tangosol.coherence.memcached.server.DataHolder;
import com.tangosol.coherence.memcached.server.MemcachedHelper;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.InvocableMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class IncrDecrProcessor
extends PutProcessor
implements ExternalizableLite,
PortableObject {
    protected long m_lInitial;
    protected long m_lIncr;
    protected boolean m_fIncr;

    public IncrDecrProcessor() {
    }

    public IncrDecrProcessor(long lInitial, long lIncr, boolean fIncr, long lVersion, int nExpiry, boolean fBinaryPassThru) {
        super(null, 0, lVersion, nExpiry, fBinaryPassThru);
        this.m_lInitial = lInitial;
        this.m_lIncr = lIncr;
        this.m_fIncr = fIncr;
    }

    @Override
    public Object process(InvocableMap.Entry entry) {
        BinaryEntry binaryEntry = MemcachedHelper.getBinaryEntry(entry);
        Binary binValue = binaryEntry.getBinaryValue();
        BackingMapManagerContext mgrCtx = binaryEntry.getBackingMapContext().getManagerContext();
        try {
            if (binValue == null) {
                if (this.m_nExpiry == -1) {
                    return Response.ResponseCode.KEYNF;
                }
                this.m_abValue = String.valueOf(this.m_lInitial).getBytes("utf-8");
            } else {
                DataHolder holder = MemcachedHelper.convertToDataHolder(binValue, mgrCtx, this.m_fBinaryPassThru);
                long lValue = IncrDecrProcessor.getLong(holder.getValue());
                this.m_nFlag = holder.getFlag();
                this.m_abValue = String.valueOf(this.calculateNewValue(lValue)).getBytes();
            }
            Object oReturn = super.process(entry);
            return oReturn instanceof Response.ResponseCode ? oReturn : MemcachedHelper.convertToDataHolder(binaryEntry.getBinaryValue(), mgrCtx, this.m_fBinaryPassThru);
        }
        catch (Exception ex) {
            return Response.ResponseCode.NAN;
        }
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        super.readExternal(in);
        this.m_lInitial = in.readLong();
        this.m_lIncr = in.readLong();
        this.m_fIncr = in.readBoolean();
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        super.writeExternal(out);
        out.writeLong(this.m_lInitial);
        out.writeLong(this.m_lIncr);
        out.writeBoolean(this.m_fIncr);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        super.readExternal(in);
        this.m_lInitial = in.readLong(10);
        this.m_lIncr = in.readLong(11);
        this.m_fIncr = in.readBoolean(12);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        super.writeExternal(out);
        out.writeLong(10, this.m_lInitial);
        out.writeLong(11, this.m_lIncr);
        out.writeBoolean(12, this.m_fIncr);
    }

    protected long calculateNewValue(long lValueOld) {
        return this.m_fIncr ? lValueOld + this.m_lIncr : Math.max(0L, lValueOld - this.m_lIncr);
    }

    public static Long getLong(byte[] abValue) {
        return Long.valueOf(MemcachedHelper.getString(abValue));
    }
}

