/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.memcached.processor;

import com.tangosol.coherence.memcached.Response;
import com.tangosol.coherence.memcached.processor.PutProcessor;
import com.tangosol.coherence.memcached.server.MemcachedHelper;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.InvocableMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class AddReplaceProcessor
extends PutProcessor
implements ExternalizableLite,
PortableObject {
    protected boolean m_fAllowInsert;

    public AddReplaceProcessor() {
    }

    public AddReplaceProcessor(byte[] abValue, int nFlag, long lVersion, int nExpiry, boolean fAllowInsert, boolean fBinaryPassThru) {
        super(abValue, nFlag, lVersion, nExpiry, fBinaryPassThru);
        this.m_fAllowInsert = fAllowInsert;
    }

    @Override
    public Object process(InvocableMap.Entry entry) {
        BinaryEntry binaryEntry = MemcachedHelper.getBinaryEntry(entry);
        Binary binValue = binaryEntry.getBinaryValue();
        if (!this.m_fAllowInsert && binValue == null) {
            return Response.ResponseCode.KEYNF;
        }
        if (this.m_fAllowInsert && binValue != null) {
            return Response.ResponseCode.KEYEXISTS;
        }
        return super.process(entry);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        super.readExternal(in);
        this.m_fAllowInsert = in.readBoolean();
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        super.writeExternal(out);
        out.writeBoolean(this.m_fAllowInsert);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        super.readExternal(in);
        this.m_fAllowInsert = in.readBoolean(10);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        super.writeExternal(out);
        out.writeBoolean(10, this.m_fAllowInsert);
    }
}

