/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.http;

import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsParameters;
import com.sun.net.httpserver.HttpsServer;
import com.tangosol.coherence.http.AbstractGenericHttpServer;
import com.tangosol.coherence.http.BasicAuthenticationHandler;
import com.tangosol.coherence.http.BasicStatisticsHandler;
import com.tangosol.internal.http.ServiceAwareHandler;
import com.tangosol.util.DaemonThreadFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.Executors;
import javax.net.ssl.SSLParameters;

public class JavaHttpServer
extends AbstractGenericHttpServer<HttpHandler> {
    protected HttpServer m_server;
    protected String m_sListenAddress;
    protected int m_nListenPort;

    @Override
    public Class<HttpHandler> getResourceType() {
        return HttpHandler.class;
    }

    @Override
    protected void startInternal() throws IOException {
        this.m_mapResourceConfig.values().stream().filter(h -> h instanceof ServiceAwareHandler).map(ServiceAwareHandler.class::cast).forEach(h -> h.setService(this.m_serviceParent));
        System.setProperty("sun.net.httpserver.nodelay", "true");
        HttpServer server = this.createHttpServer();
        server.start();
        this.m_server = server;
        this.resetStats();
    }

    @Override
    protected void stopInternal() throws IOException {
        this.m_server.stop(0);
        this.m_server = null;
    }

    @Override
    public String getListenAddress() {
        if (this.m_sListenAddress == null) {
            this.m_sListenAddress = this.m_server.getAddress().getHostString();
        }
        return this.m_sListenAddress;
    }

    @Override
    public int getListenPort() {
        if (this.m_nListenPort == 0) {
            this.m_nListenPort = this.m_server.getAddress().getPort();
        }
        return this.m_nListenPort;
    }

    @Override
    protected Object createContainer(HttpHandler resourceConfig) {
        return resourceConfig;
    }

    protected HttpServer createHttpServer() throws IOException {
        HttpServer server;
        InetSocketAddress addr = new InetSocketAddress(this.getLocalAddress(), this.getLocalPort());
        if (this.isSecure()) {
            HttpsServer sslServer = HttpsServer.create(addr, 0);
            final SSLParameters sslParams = this.getSSLParameters();
            sslServer.setHttpsConfigurator(new HttpsConfigurator(this.getSSLContext()){

                @Override
                public void configure(HttpsParameters params) {
                    params.setSSLParameters(sslParams);
                    params.setNeedClientAuth(JavaHttpServer.this.isAuthMethodCert());
                }
            });
            server = sslServer;
        } else {
            server = HttpServer.create(addr, 0);
        }
        server.setExecutor(Executors.newCachedThreadPool(new DaemonThreadFactory("DefaultHttpServerThread-")));
        for (Map.Entry entry : this.getResourceConfig().entrySet()) {
            HttpHandler handler = (HttpHandler)this.createContainer((HttpHandler)entry.getValue());
            if (this.isAuthMethodBasic()) {
                handler = new BasicAuthenticationHandler(handler, this);
            }
            handler = new BasicStatisticsHandler(handler, this);
            server.createContext(entry.getKey(), handler);
        }
        return server;
    }
}

