/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.http;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.tangosol.coherence.http.AbstractGenericHttpServer;
import com.tangosol.util.Base;
import java.io.IOException;

class BasicStatisticsHandler
implements HttpHandler {
    private final HttpHandler f_handler;
    private final AbstractGenericHttpServer<?> f_server;

    public BasicStatisticsHandler(HttpHandler handler, AbstractGenericHttpServer<?> server) {
        this.f_handler = handler;
        this.f_server = server;
    }

    @Override
    public void handle(HttpExchange exchange) throws IOException {
        long ldtStart = Base.getLastSafeTimeMillis();
        this.f_handler.handle(exchange);
        int nResponseCode = exchange.getResponseCode();
        this.f_server.logRequestTime(ldtStart);
        this.f_server.incrementRequestCount();
        this.f_server.logStatusCount(nResponseCode);
        if (nResponseCode == 500) {
            this.f_server.incrementErrors();
        }
    }
}

