/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.http;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.tangosol.coherence.http.AbstractGenericHttpServer;
import java.io.IOException;
import javax.security.auth.Subject;

class BasicAuthenticationHandler
implements HttpHandler {
    private final HttpHandler f_handler;
    private final AbstractGenericHttpServer<?> f_server;

    public BasicAuthenticationHandler(HttpHandler handler, AbstractGenericHttpServer<?> server) {
        this.f_handler = handler;
        this.f_server = server;
    }

    @Override
    public void handle(HttpExchange exchange) throws IOException {
        String sAuth = exchange.getRequestHeaders().getFirst("Authorization");
        Subject subject = this.f_server.authenticate(sAuth);
        if (subject == null) {
            exchange.getResponseHeaders().set("WWW-Authenticate", "Basic realm=\"Coherence REST\"");
            exchange.sendResponseHeaders(401, -1L);
        } else {
            exchange.setAttribute("__SUBJECT", subject);
            this.f_handler.handle(exchange);
        }
    }
}

