/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.http;

import com.tangosol.coherence.http.AbstractGenericHttpServer;
import com.tangosol.coherence.http.HttpServer;
import com.tangosol.net.Service;
import com.tangosol.net.Session;
import jakarta.ws.rs.core.SecurityContext;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.DynamicConfigurationService;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.ServiceLocatorFactory;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ResourceConfig;

public abstract class AbstractHttpServer
extends AbstractGenericHttpServer<ResourceConfig>
implements HttpServer {
    protected abstract Object instantiateContainer(ResourceConfig var1, ServiceLocator var2);

    @Override
    protected Object createContainer(ResourceConfig resourceConfig) {
        ServiceLocatorFactory factory = ServiceLocatorFactory.getInstance();
        ServiceLocator locator = factory.create(this.getClass().getName());
        DynamicConfiguration config = ((DynamicConfigurationService)locator.getService(DynamicConfigurationService.class, new Annotation[0])).createDynamicConfiguration();
        if (this.getParentService() != null) {
            config.bind((Descriptor)BuilderHelper.createConstantDescriptor((Object)this.getParentService(), null, (Type[])new Type[]{Service.class}));
        }
        config.bind((Descriptor)BuilderHelper.createConstantDescriptor((Object)this.getSession(), null, (Type[])new Type[]{Session.class}));
        config.commit();
        return this.instantiateContainer(resourceConfig, locator);
    }

    protected void handleRequest(final ApplicationHandler app, final ContainerRequest request, Subject subject) throws IOException {
        if (subject == null) {
            app.handle(request);
        } else {
            try {
                Subject.doAs(subject, new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws IOException {
                        app.handle(request);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception cause = e.getException();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw (IOException)cause;
            }
        }
    }

    @Override
    public String getLocalAddress() {
        return this.m_sAddr;
    }

    @Override
    public int getLocalPort() {
        return this.m_nPort;
    }

    public static class SimpleSecurityContext
    implements SecurityContext {
        private String m_sAuthScheme;
        private Principal m_principal;
        private boolean m_fSecure;

        public SimpleSecurityContext(String sAuthScheme, Principal principal, boolean fSecure) {
            this.m_sAuthScheme = sAuthScheme;
            this.m_principal = principal;
            this.m_fSecure = fSecure;
        }

        public String getAuthenticationScheme() {
            return this.m_sAuthScheme;
        }

        public Principal getUserPrincipal() {
            return this.m_principal;
        }

        public boolean isSecure() {
            return this.m_fSecure;
        }

        public boolean isUserInRole(String sRole) {
            return false;
        }
    }
}

